// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateContainerRecipeRequest private constructor(builder: Builder) {
    /**
     * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see [Ensuring idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html) in the *Amazon EC2 API Reference*.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * Components for build and test that are included in the container recipe. Recipes require a minimum of one build component, and can have a maximum of 20 build and test components in any combination.
     */
    public val components: List<ComponentConfiguration>? = builder.components
    /**
     * The type of container to create.
     */
    public val containerType: aws.sdk.kotlin.services.imagebuilder.model.ContainerType? = builder.containerType
    /**
     * The description of the container recipe.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The Dockerfile template used to build your image as an inline data blob.
     */
    public val dockerfileTemplateData: kotlin.String? = builder.dockerfileTemplateData
    /**
     * The Amazon S3 URI for the Dockerfile that will be used to build your container image.
     */
    public val dockerfileTemplateUri: kotlin.String? = builder.dockerfileTemplateUri
    /**
     * Specifies the operating system version for the base image.
     */
    public val imageOsVersionOverride: kotlin.String? = builder.imageOsVersionOverride
    /**
     * A group of options that can be used to configure an instance for building and testing container images.
     */
    public val instanceConfiguration: aws.sdk.kotlin.services.imagebuilder.model.InstanceConfiguration? = builder.instanceConfiguration
    /**
     * Identifies which KMS key is used to encrypt the container image.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The name of the container recipe.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The base image for the container recipe.
     */
    public val parentImage: kotlin.String? = builder.parentImage
    /**
     * Specifies the operating system platform when you use a custom base image.
     */
    public val platformOverride: aws.sdk.kotlin.services.imagebuilder.model.Platform? = builder.platformOverride
    /**
     * The semantic version of the container recipe. This version follows the semantic version syntax.
     *
     * The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You can assign values for the first three, and can filter on all of them.
     *
     * **Assignment:** For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.
     *
     * **Patterns:** You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.
     */
    public val semanticVersion: kotlin.String? = builder.semanticVersion
    /**
     * Tags that are attached to the container recipe.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The destination repository for the container image.
     */
    public val targetRepository: aws.sdk.kotlin.services.imagebuilder.model.TargetContainerRepository? = builder.targetRepository
    /**
     * The working directory for use during build and test workflows.
     */
    public val workingDirectory: kotlin.String? = builder.workingDirectory

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.CreateContainerRecipeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateContainerRecipeRequest(")
        append("clientToken=$clientToken,")
        append("components=$components,")
        append("containerType=$containerType,")
        append("description=$description,")
        append("dockerfileTemplateData=$dockerfileTemplateData,")
        append("dockerfileTemplateUri=$dockerfileTemplateUri,")
        append("imageOsVersionOverride=$imageOsVersionOverride,")
        append("instanceConfiguration=$instanceConfiguration,")
        append("kmsKeyId=$kmsKeyId,")
        append("name=$name,")
        append("parentImage=$parentImage,")
        append("platformOverride=$platformOverride,")
        append("semanticVersion=$semanticVersion,")
        append("tags=$tags,")
        append("targetRepository=$targetRepository,")
        append("workingDirectory=$workingDirectory")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (components?.hashCode() ?: 0)
        result = 31 * result + (containerType?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (dockerfileTemplateData?.hashCode() ?: 0)
        result = 31 * result + (dockerfileTemplateUri?.hashCode() ?: 0)
        result = 31 * result + (imageOsVersionOverride?.hashCode() ?: 0)
        result = 31 * result + (instanceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (parentImage?.hashCode() ?: 0)
        result = 31 * result + (platformOverride?.hashCode() ?: 0)
        result = 31 * result + (semanticVersion?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetRepository?.hashCode() ?: 0)
        result = 31 * result + (workingDirectory?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateContainerRecipeRequest

        if (clientToken != other.clientToken) return false
        if (components != other.components) return false
        if (containerType != other.containerType) return false
        if (description != other.description) return false
        if (dockerfileTemplateData != other.dockerfileTemplateData) return false
        if (dockerfileTemplateUri != other.dockerfileTemplateUri) return false
        if (imageOsVersionOverride != other.imageOsVersionOverride) return false
        if (instanceConfiguration != other.instanceConfiguration) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (name != other.name) return false
        if (parentImage != other.parentImage) return false
        if (platformOverride != other.platformOverride) return false
        if (semanticVersion != other.semanticVersion) return false
        if (tags != other.tags) return false
        if (targetRepository != other.targetRepository) return false
        if (workingDirectory != other.workingDirectory) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.CreateContainerRecipeRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see [Ensuring idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html) in the *Amazon EC2 API Reference*.
         */
        public var clientToken: kotlin.String? = null
        /**
         * Components for build and test that are included in the container recipe. Recipes require a minimum of one build component, and can have a maximum of 20 build and test components in any combination.
         */
        public var components: List<ComponentConfiguration>? = null
        /**
         * The type of container to create.
         */
        public var containerType: aws.sdk.kotlin.services.imagebuilder.model.ContainerType? = null
        /**
         * The description of the container recipe.
         */
        public var description: kotlin.String? = null
        /**
         * The Dockerfile template used to build your image as an inline data blob.
         */
        public var dockerfileTemplateData: kotlin.String? = null
        /**
         * The Amazon S3 URI for the Dockerfile that will be used to build your container image.
         */
        public var dockerfileTemplateUri: kotlin.String? = null
        /**
         * Specifies the operating system version for the base image.
         */
        public var imageOsVersionOverride: kotlin.String? = null
        /**
         * A group of options that can be used to configure an instance for building and testing container images.
         */
        public var instanceConfiguration: aws.sdk.kotlin.services.imagebuilder.model.InstanceConfiguration? = null
        /**
         * Identifies which KMS key is used to encrypt the container image.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The name of the container recipe.
         */
        public var name: kotlin.String? = null
        /**
         * The base image for the container recipe.
         */
        public var parentImage: kotlin.String? = null
        /**
         * Specifies the operating system platform when you use a custom base image.
         */
        public var platformOverride: aws.sdk.kotlin.services.imagebuilder.model.Platform? = null
        /**
         * The semantic version of the container recipe. This version follows the semantic version syntax.
         *
         * The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You can assign values for the first three, and can filter on all of them.
         *
         * **Assignment:** For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.
         *
         * **Patterns:** You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.
         */
        public var semanticVersion: kotlin.String? = null
        /**
         * Tags that are attached to the container recipe.
         */
        public var tags: Map<String, String>? = null
        /**
         * The destination repository for the container image.
         */
        public var targetRepository: aws.sdk.kotlin.services.imagebuilder.model.TargetContainerRepository? = null
        /**
         * The working directory for use during build and test workflows.
         */
        public var workingDirectory: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.CreateContainerRecipeRequest) : this() {
            this.clientToken = x.clientToken
            this.components = x.components
            this.containerType = x.containerType
            this.description = x.description
            this.dockerfileTemplateData = x.dockerfileTemplateData
            this.dockerfileTemplateUri = x.dockerfileTemplateUri
            this.imageOsVersionOverride = x.imageOsVersionOverride
            this.instanceConfiguration = x.instanceConfiguration
            this.kmsKeyId = x.kmsKeyId
            this.name = x.name
            this.parentImage = x.parentImage
            this.platformOverride = x.platformOverride
            this.semanticVersion = x.semanticVersion
            this.tags = x.tags
            this.targetRepository = x.targetRepository
            this.workingDirectory = x.workingDirectory
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.CreateContainerRecipeRequest = CreateContainerRecipeRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.InstanceConfiguration] inside the given [block]
         */
        public fun instanceConfiguration(block: aws.sdk.kotlin.services.imagebuilder.model.InstanceConfiguration.Builder.() -> kotlin.Unit) {
            this.instanceConfiguration = aws.sdk.kotlin.services.imagebuilder.model.InstanceConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.TargetContainerRepository] inside the given [block]
         */
        public fun targetRepository(block: aws.sdk.kotlin.services.imagebuilder.model.TargetContainerRepository.Builder.() -> kotlin.Unit) {
            this.targetRepository = aws.sdk.kotlin.services.imagebuilder.model.TargetContainerRepository.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
