// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The defining characteristics of a specific version of an Amazon Web Services TOE component.
 */
public class ComponentVersion private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the component.
     *
     * Semantic versioning is included in each object's Amazon Resource Name (ARN), at the level that applies to that object as follows:
     * + Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are either left off entirely, or they are specified as wildcards, for example: x.x.x.
     * + Version ARNs have only the first three nodes: <major>.<minor>.<patch>
     * + Build version ARNs have all four nodes, and point to a specific build for a specific version of an object.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The date that the component was created.
     */
    public val dateCreated: kotlin.String? = builder.dateCreated
    /**
     * The description of the component.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the component.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The owner of the component.
     */
    public val owner: kotlin.String? = builder.owner
    /**
     * The platform of the component.
     */
    public val platform: aws.sdk.kotlin.services.imagebuilder.model.Platform? = builder.platform
    /**
     * he operating system (OS) version supported by the component. If the OS information is available, a prefix match is performed against the base image OS version during image recipe creation.
     */
    public val supportedOsVersions: List<String>? = builder.supportedOsVersions
    /**
     * The type of the component denotes whether the component is used to build the image or only to test it.
     */
    public val type: aws.sdk.kotlin.services.imagebuilder.model.ComponentType? = builder.type
    /**
     * The semantic version of the component.
     *
     * The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You can assign values for the first three, and can filter on all of them.
     *
     * **Assignment:** For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.
     *
     * **Patterns:** You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.
     *
     * **Filtering:** With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.ComponentVersion = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ComponentVersion(")
        append("arn=$arn,")
        append("dateCreated=$dateCreated,")
        append("description=$description,")
        append("name=$name,")
        append("owner=$owner,")
        append("platform=$platform,")
        append("supportedOsVersions=$supportedOsVersions,")
        append("type=$type,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (dateCreated?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (supportedOsVersions?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ComponentVersion

        if (arn != other.arn) return false
        if (dateCreated != other.dateCreated) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (owner != other.owner) return false
        if (platform != other.platform) return false
        if (supportedOsVersions != other.supportedOsVersions) return false
        if (type != other.type) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.ComponentVersion = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the component.
         *
         * Semantic versioning is included in each object's Amazon Resource Name (ARN), at the level that applies to that object as follows:
         * + Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are either left off entirely, or they are specified as wildcards, for example: x.x.x.
         * + Version ARNs have only the first three nodes: <major>.<minor>.<patch>
         * + Build version ARNs have all four nodes, and point to a specific build for a specific version of an object.
         */
        public var arn: kotlin.String? = null
        /**
         * The date that the component was created.
         */
        public var dateCreated: kotlin.String? = null
        /**
         * The description of the component.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the component.
         */
        public var name: kotlin.String? = null
        /**
         * The owner of the component.
         */
        public var owner: kotlin.String? = null
        /**
         * The platform of the component.
         */
        public var platform: aws.sdk.kotlin.services.imagebuilder.model.Platform? = null
        /**
         * he operating system (OS) version supported by the component. If the OS information is available, a prefix match is performed against the base image OS version during image recipe creation.
         */
        public var supportedOsVersions: List<String>? = null
        /**
         * The type of the component denotes whether the component is used to build the image or only to test it.
         */
        public var type: aws.sdk.kotlin.services.imagebuilder.model.ComponentType? = null
        /**
         * The semantic version of the component.
         *
         * The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You can assign values for the first three, and can filter on all of them.
         *
         * **Assignment:** For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.
         *
         * **Patterns:** You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.
         *
         * **Filtering:** With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.ComponentVersion) : this() {
            this.arn = x.arn
            this.dateCreated = x.dateCreated
            this.description = x.description
            this.name = x.name
            this.owner = x.owner
            this.platform = x.platform
            this.supportedOsVersions = x.supportedOsVersions
            this.type = x.type
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.ComponentVersion = ComponentVersion(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
