// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.serde

import aws.sdk.kotlin.services.imagebuilder.model.ImagebuilderException
import aws.sdk.kotlin.services.imagebuilder.model.ListWorkflowStepExecutionsResponse
import aws.sdk.kotlin.services.imagebuilder.model.WorkflowStepMetadata
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListWorkflowStepExecutionsOperationDeserializer: HttpDeserialize<ListWorkflowStepExecutionsResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ListWorkflowStepExecutionsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListWorkflowStepExecutionsError(context, call)
        }
        val builder = ListWorkflowStepExecutionsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListWorkflowStepExecutionsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwListWorkflowStepExecutionsError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ImagebuilderException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CallRateLimitExceededException" -> CallRateLimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidPaginationTokenException" -> InvalidPaginationTokenExceptionDeserializer().deserialize(context, wrappedCall)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        "ClientException" -> ClientExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ImagebuilderException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListWorkflowStepExecutionsOperationBody(builder: ListWorkflowStepExecutionsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val IMAGEBUILDVERSIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("imageBuildVersionArn"))
    val MESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("message"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val REQUESTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("requestId"))
    val STEPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("steps"))
    val WORKFLOWBUILDVERSIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("workflowBuildVersionArn"))
    val WORKFLOWEXECUTIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("workflowExecutionId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(IMAGEBUILDVERSIONARN_DESCRIPTOR)
        field(MESSAGE_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(REQUESTID_DESCRIPTOR)
        field(STEPS_DESCRIPTOR)
        field(WORKFLOWBUILDVERSIONARN_DESCRIPTOR)
        field(WORKFLOWEXECUTIONID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                IMAGEBUILDVERSIONARN_DESCRIPTOR.index -> builder.imageBuildVersionArn = deserializeString()
                MESSAGE_DESCRIPTOR.index -> builder.message = deserializeString()
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                REQUESTID_DESCRIPTOR.index -> builder.requestId = deserializeString()
                STEPS_DESCRIPTOR.index -> builder.steps =
                    deserializer.deserializeList(STEPS_DESCRIPTOR) {
                        val col0 = mutableListOf<WorkflowStepMetadata>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeWorkflowStepMetadataDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                WORKFLOWBUILDVERSIONARN_DESCRIPTOR.index -> builder.workflowBuildVersionArn = deserializeString()
                WORKFLOWEXECUTIONID_DESCRIPTOR.index -> builder.workflowExecutionId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
