// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.serde

import aws.sdk.kotlin.services.imagebuilder.model.GetWorkflowStepExecutionResponse
import aws.sdk.kotlin.services.imagebuilder.model.ImagebuilderException
import aws.sdk.kotlin.services.imagebuilder.model.WorkflowStepExecutionRollbackStatus
import aws.sdk.kotlin.services.imagebuilder.model.WorkflowStepExecutionStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetWorkflowStepExecutionOperationDeserializer: HttpDeserialize<GetWorkflowStepExecutionResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetWorkflowStepExecutionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetWorkflowStepExecutionError(context, call)
        }
        val builder = GetWorkflowStepExecutionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetWorkflowStepExecutionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetWorkflowStepExecutionError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ImagebuilderException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CallRateLimitExceededException" -> CallRateLimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        "ClientException" -> ClientExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ImagebuilderException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetWorkflowStepExecutionOperationBody(builder: GetWorkflowStepExecutionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("action"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("endTime"))
    val IMAGEBUILDVERSIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("imageBuildVersionArn"))
    val INPUTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("inputs"))
    val MESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("message"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val ONFAILURE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("onFailure"))
    val OUTPUTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("outputs"))
    val REQUESTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("requestId"))
    val ROLLBACKSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("rollbackStatus"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("startTime"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val STEPEXECUTIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("stepExecutionId"))
    val TIMEOUTSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("timeoutSeconds"))
    val WORKFLOWBUILDVERSIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("workflowBuildVersionArn"))
    val WORKFLOWEXECUTIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("workflowExecutionId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTION_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ENDTIME_DESCRIPTOR)
        field(IMAGEBUILDVERSIONARN_DESCRIPTOR)
        field(INPUTS_DESCRIPTOR)
        field(MESSAGE_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(ONFAILURE_DESCRIPTOR)
        field(OUTPUTS_DESCRIPTOR)
        field(REQUESTID_DESCRIPTOR)
        field(ROLLBACKSTATUS_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STEPEXECUTIONID_DESCRIPTOR)
        field(TIMEOUTSECONDS_DESCRIPTOR)
        field(WORKFLOWBUILDVERSIONARN_DESCRIPTOR)
        field(WORKFLOWEXECUTIONID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACTION_DESCRIPTOR.index -> builder.action = deserializeString()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                ENDTIME_DESCRIPTOR.index -> builder.endTime = deserializeString()
                IMAGEBUILDVERSIONARN_DESCRIPTOR.index -> builder.imageBuildVersionArn = deserializeString()
                INPUTS_DESCRIPTOR.index -> builder.inputs = deserializeString()
                MESSAGE_DESCRIPTOR.index -> builder.message = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                ONFAILURE_DESCRIPTOR.index -> builder.onFailure = deserializeString()
                OUTPUTS_DESCRIPTOR.index -> builder.outputs = deserializeString()
                REQUESTID_DESCRIPTOR.index -> builder.requestId = deserializeString()
                ROLLBACKSTATUS_DESCRIPTOR.index -> builder.rollbackStatus = deserializeString().let { WorkflowStepExecutionRollbackStatus.fromValue(it) }
                STARTTIME_DESCRIPTOR.index -> builder.startTime = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { WorkflowStepExecutionStatus.fromValue(it) }
                STEPEXECUTIONID_DESCRIPTOR.index -> builder.stepExecutionId = deserializeString()
                TIMEOUTSECONDS_DESCRIPTOR.index -> builder.timeoutSeconds = deserializeInt()
                WORKFLOWBUILDVERSIONARN_DESCRIPTOR.index -> builder.workflowBuildVersionArn = deserializeString()
                WORKFLOWEXECUTIONID_DESCRIPTOR.index -> builder.workflowExecutionId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
