// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.serde

import aws.sdk.kotlin.services.imagebuilder.model.GetWorkflowExecutionResponse
import aws.sdk.kotlin.services.imagebuilder.model.ImagebuilderException
import aws.sdk.kotlin.services.imagebuilder.model.WorkflowExecutionStatus
import aws.sdk.kotlin.services.imagebuilder.model.WorkflowType
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetWorkflowExecutionOperationDeserializer: HttpDeserialize<GetWorkflowExecutionResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetWorkflowExecutionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetWorkflowExecutionError(context, call)
        }
        val builder = GetWorkflowExecutionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetWorkflowExecutionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetWorkflowExecutionError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ImagebuilderException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CallRateLimitExceededException" -> CallRateLimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        "ClientException" -> ClientExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ImagebuilderException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetWorkflowExecutionOperationBody(builder: GetWorkflowExecutionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("endTime"))
    val IMAGEBUILDVERSIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("imageBuildVersionArn"))
    val MESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("message"))
    val REQUESTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("requestId"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("startTime"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val TOTALSTEPCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("totalStepCount"))
    val TOTALSTEPSFAILED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("totalStepsFailed"))
    val TOTALSTEPSSKIPPED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("totalStepsSkipped"))
    val TOTALSTEPSSUCCEEDED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("totalStepsSucceeded"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("type"))
    val WORKFLOWBUILDVERSIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("workflowBuildVersionArn"))
    val WORKFLOWEXECUTIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("workflowExecutionId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENDTIME_DESCRIPTOR)
        field(IMAGEBUILDVERSIONARN_DESCRIPTOR)
        field(MESSAGE_DESCRIPTOR)
        field(REQUESTID_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TOTALSTEPCOUNT_DESCRIPTOR)
        field(TOTALSTEPSFAILED_DESCRIPTOR)
        field(TOTALSTEPSSKIPPED_DESCRIPTOR)
        field(TOTALSTEPSSUCCEEDED_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
        field(WORKFLOWBUILDVERSIONARN_DESCRIPTOR)
        field(WORKFLOWEXECUTIONID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ENDTIME_DESCRIPTOR.index -> builder.endTime = deserializeString()
                IMAGEBUILDVERSIONARN_DESCRIPTOR.index -> builder.imageBuildVersionArn = deserializeString()
                MESSAGE_DESCRIPTOR.index -> builder.message = deserializeString()
                REQUESTID_DESCRIPTOR.index -> builder.requestId = deserializeString()
                STARTTIME_DESCRIPTOR.index -> builder.startTime = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { WorkflowExecutionStatus.fromValue(it) }
                TOTALSTEPCOUNT_DESCRIPTOR.index -> builder.totalStepCount = deserializeInt()
                TOTALSTEPSFAILED_DESCRIPTOR.index -> builder.totalStepsFailed = deserializeInt()
                TOTALSTEPSSKIPPED_DESCRIPTOR.index -> builder.totalStepsSkipped = deserializeInt()
                TOTALSTEPSSUCCEEDED_DESCRIPTOR.index -> builder.totalStepsSucceeded = deserializeInt()
                TYPE_DESCRIPTOR.index -> builder.type = deserializeString().let { WorkflowType.fromValue(it) }
                WORKFLOWBUILDVERSIONARN_DESCRIPTOR.index -> builder.workflowBuildVersionArn = deserializeString()
                WORKFLOWEXECUTIONID_DESCRIPTOR.index -> builder.workflowExecutionId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
