// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.serde

import aws.sdk.kotlin.services.imagebuilder.model.ContainerRecipe
import aws.sdk.kotlin.services.imagebuilder.model.GetContainerRecipeResponse
import aws.sdk.kotlin.services.imagebuilder.model.ImagebuilderException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetContainerRecipeOperationDeserializer: HttpDeserialize<GetContainerRecipeResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetContainerRecipeResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetContainerRecipeError(context, call)
        }
        val builder = GetContainerRecipeResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetContainerRecipeOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetContainerRecipeError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ImagebuilderException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CallRateLimitExceededException" -> CallRateLimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        "ClientException" -> ClientExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ImagebuilderException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetContainerRecipeOperationBody(builder: GetContainerRecipeResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONTAINERRECIPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("containerRecipe"))
    val REQUESTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("requestId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONTAINERRECIPE_DESCRIPTOR)
        field(REQUESTID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONTAINERRECIPE_DESCRIPTOR.index -> builder.containerRecipe = deserializeContainerRecipeDocument(deserializer)
                REQUESTID_DESCRIPTOR.index -> builder.requestId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
