// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.paginators

import aws.sdk.kotlin.services.imagebuilder.ImagebuilderClient
import aws.sdk.kotlin.services.imagebuilder.model.ComponentSummary
import aws.sdk.kotlin.services.imagebuilder.model.ComponentVersion
import aws.sdk.kotlin.services.imagebuilder.model.ContainerRecipeSummary
import aws.sdk.kotlin.services.imagebuilder.model.DistributionConfigurationSummary
import aws.sdk.kotlin.services.imagebuilder.model.ImagePackage
import aws.sdk.kotlin.services.imagebuilder.model.ImagePipeline
import aws.sdk.kotlin.services.imagebuilder.model.ImageRecipeSummary
import aws.sdk.kotlin.services.imagebuilder.model.ImageScanFinding
import aws.sdk.kotlin.services.imagebuilder.model.ImageScanFindingAggregation
import aws.sdk.kotlin.services.imagebuilder.model.ImageSummary
import aws.sdk.kotlin.services.imagebuilder.model.ImageVersion
import aws.sdk.kotlin.services.imagebuilder.model.InfrastructureConfigurationSummary
import aws.sdk.kotlin.services.imagebuilder.model.LifecycleExecution
import aws.sdk.kotlin.services.imagebuilder.model.LifecycleExecutionResource
import aws.sdk.kotlin.services.imagebuilder.model.LifecyclePolicySummary
import aws.sdk.kotlin.services.imagebuilder.model.ListComponentBuildVersionsRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListComponentBuildVersionsResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListComponentsRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListComponentsResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListContainerRecipesRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListContainerRecipesResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListDistributionConfigurationsRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListDistributionConfigurationsResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListImageBuildVersionsRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListImageBuildVersionsResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListImagePackagesRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListImagePackagesResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListImagePipelineImagesRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListImagePipelineImagesResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListImagePipelinesRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListImagePipelinesResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListImageRecipesRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListImageRecipesResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListImageScanFindingAggregationsRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListImageScanFindingAggregationsResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListImageScanFindingsRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListImageScanFindingsResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListImagesRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListImagesResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListInfrastructureConfigurationsRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListInfrastructureConfigurationsResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListLifecycleExecutionResourcesRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListLifecycleExecutionResourcesResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListLifecycleExecutionsRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListLifecycleExecutionsResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListLifecyclePoliciesRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListLifecyclePoliciesResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListWorkflowExecutionsRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListWorkflowExecutionsResponse
import aws.sdk.kotlin.services.imagebuilder.model.ListWorkflowStepExecutionsRequest
import aws.sdk.kotlin.services.imagebuilder.model.ListWorkflowStepExecutionsResponse
import aws.sdk.kotlin.services.imagebuilder.model.WorkflowExecutionMetadata
import aws.sdk.kotlin.services.imagebuilder.model.WorkflowStepMetadata
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListComponentBuildVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListComponentBuildVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListComponentBuildVersionsResponse]
 */
public fun ImagebuilderClient.listComponentBuildVersionsPaginated(initialRequest: ListComponentBuildVersionsRequest): Flow<ListComponentBuildVersionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listComponentBuildVersionsPaginated.listComponentBuildVersions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListComponentBuildVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListComponentBuildVersionsResponse]
 */
public fun ImagebuilderClient.listComponentBuildVersionsPaginated(block: ListComponentBuildVersionsRequest.Builder.() -> Unit): Flow<ListComponentBuildVersionsResponse> =
    listComponentBuildVersionsPaginated(ListComponentBuildVersionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listComponentBuildVersionsPaginated]
 * to access the nested member [ComponentSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ComponentSummary]
 */
@JvmName("listComponentBuildVersionsResponseComponentSummary")
public fun Flow<ListComponentBuildVersionsResponse>.componentSummaryList(): Flow<ComponentSummary> =
    transform() { response ->
        response.componentSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListComponentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListComponentsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListComponentsResponse]
 */
public fun ImagebuilderClient.listComponentsPaginated(initialRequest: ListComponentsRequest = ListComponentsRequest { }): Flow<ListComponentsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listComponentsPaginated.listComponents(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListComponentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListComponentsResponse]
 */
public fun ImagebuilderClient.listComponentsPaginated(block: ListComponentsRequest.Builder.() -> Unit): Flow<ListComponentsResponse> =
    listComponentsPaginated(ListComponentsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listComponentsPaginated]
 * to access the nested member [ComponentVersion]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ComponentVersion]
 */
@JvmName("listComponentsResponseComponentVersion")
public fun Flow<ListComponentsResponse>.componentVersionList(): Flow<ComponentVersion> =
    transform() { response ->
        response.componentVersionList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListContainerRecipesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListContainerRecipesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListContainerRecipesResponse]
 */
public fun ImagebuilderClient.listContainerRecipesPaginated(initialRequest: ListContainerRecipesRequest = ListContainerRecipesRequest { }): Flow<ListContainerRecipesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listContainerRecipesPaginated.listContainerRecipes(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListContainerRecipesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListContainerRecipesResponse]
 */
public fun ImagebuilderClient.listContainerRecipesPaginated(block: ListContainerRecipesRequest.Builder.() -> Unit): Flow<ListContainerRecipesResponse> =
    listContainerRecipesPaginated(ListContainerRecipesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listContainerRecipesPaginated]
 * to access the nested member [ContainerRecipeSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ContainerRecipeSummary]
 */
@JvmName("listContainerRecipesResponseContainerRecipeSummary")
public fun Flow<ListContainerRecipesResponse>.containerRecipeSummaryList(): Flow<ContainerRecipeSummary> =
    transform() { response ->
        response.containerRecipeSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDistributionConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDistributionConfigurationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDistributionConfigurationsResponse]
 */
public fun ImagebuilderClient.listDistributionConfigurationsPaginated(initialRequest: ListDistributionConfigurationsRequest = ListDistributionConfigurationsRequest { }): Flow<ListDistributionConfigurationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDistributionConfigurationsPaginated.listDistributionConfigurations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDistributionConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDistributionConfigurationsResponse]
 */
public fun ImagebuilderClient.listDistributionConfigurationsPaginated(block: ListDistributionConfigurationsRequest.Builder.() -> Unit): Flow<ListDistributionConfigurationsResponse> =
    listDistributionConfigurationsPaginated(ListDistributionConfigurationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDistributionConfigurationsPaginated]
 * to access the nested member [DistributionConfigurationSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DistributionConfigurationSummary]
 */
@JvmName("listDistributionConfigurationsResponseDistributionConfigurationSummary")
public fun Flow<ListDistributionConfigurationsResponse>.distributionConfigurationSummaryList(): Flow<DistributionConfigurationSummary> =
    transform() { response ->
        response.distributionConfigurationSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListImageBuildVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListImageBuildVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImageBuildVersionsResponse]
 */
public fun ImagebuilderClient.listImageBuildVersionsPaginated(initialRequest: ListImageBuildVersionsRequest): Flow<ListImageBuildVersionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listImageBuildVersionsPaginated.listImageBuildVersions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListImageBuildVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImageBuildVersionsResponse]
 */
public fun ImagebuilderClient.listImageBuildVersionsPaginated(block: ListImageBuildVersionsRequest.Builder.() -> Unit): Flow<ListImageBuildVersionsResponse> =
    listImageBuildVersionsPaginated(ListImageBuildVersionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listImageBuildVersionsPaginated]
 * to access the nested member [ImageSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ImageSummary]
 */
@JvmName("listImageBuildVersionsResponseImageSummary")
public fun Flow<ListImageBuildVersionsResponse>.imageSummaryList(): Flow<ImageSummary> =
    transform() { response ->
        response.imageSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListImagePackagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListImagePackagesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImagePackagesResponse]
 */
public fun ImagebuilderClient.listImagePackagesPaginated(initialRequest: ListImagePackagesRequest): Flow<ListImagePackagesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listImagePackagesPaginated.listImagePackages(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListImagePackagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImagePackagesResponse]
 */
public fun ImagebuilderClient.listImagePackagesPaginated(block: ListImagePackagesRequest.Builder.() -> Unit): Flow<ListImagePackagesResponse> =
    listImagePackagesPaginated(ListImagePackagesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listImagePackagesPaginated]
 * to access the nested member [ImagePackage]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ImagePackage]
 */
@JvmName("listImagePackagesResponseImagePackage")
public fun Flow<ListImagePackagesResponse>.imagePackageList(): Flow<ImagePackage> =
    transform() { response ->
        response.imagePackageList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListImagePipelineImagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListImagePipelineImagesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImagePipelineImagesResponse]
 */
public fun ImagebuilderClient.listImagePipelineImagesPaginated(initialRequest: ListImagePipelineImagesRequest): Flow<ListImagePipelineImagesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listImagePipelineImagesPaginated.listImagePipelineImages(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListImagePipelineImagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImagePipelineImagesResponse]
 */
public fun ImagebuilderClient.listImagePipelineImagesPaginated(block: ListImagePipelineImagesRequest.Builder.() -> Unit): Flow<ListImagePipelineImagesResponse> =
    listImagePipelineImagesPaginated(ListImagePipelineImagesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listImagePipelineImagesPaginated]
 * to access the nested member [ImageSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ImageSummary]
 */
@JvmName("listImagePipelineImagesResponseImageSummary")
public fun Flow<ListImagePipelineImagesResponse>.imageSummaryList(): Flow<ImageSummary> =
    transform() { response ->
        response.imageSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListImagePipelinesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListImagePipelinesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImagePipelinesResponse]
 */
public fun ImagebuilderClient.listImagePipelinesPaginated(initialRequest: ListImagePipelinesRequest = ListImagePipelinesRequest { }): Flow<ListImagePipelinesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listImagePipelinesPaginated.listImagePipelines(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListImagePipelinesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImagePipelinesResponse]
 */
public fun ImagebuilderClient.listImagePipelinesPaginated(block: ListImagePipelinesRequest.Builder.() -> Unit): Flow<ListImagePipelinesResponse> =
    listImagePipelinesPaginated(ListImagePipelinesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listImagePipelinesPaginated]
 * to access the nested member [ImagePipeline]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ImagePipeline]
 */
@JvmName("listImagePipelinesResponseImagePipeline")
public fun Flow<ListImagePipelinesResponse>.imagePipelineList(): Flow<ImagePipeline> =
    transform() { response ->
        response.imagePipelineList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListImageRecipesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListImageRecipesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImageRecipesResponse]
 */
public fun ImagebuilderClient.listImageRecipesPaginated(initialRequest: ListImageRecipesRequest = ListImageRecipesRequest { }): Flow<ListImageRecipesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listImageRecipesPaginated.listImageRecipes(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListImageRecipesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImageRecipesResponse]
 */
public fun ImagebuilderClient.listImageRecipesPaginated(block: ListImageRecipesRequest.Builder.() -> Unit): Flow<ListImageRecipesResponse> =
    listImageRecipesPaginated(ListImageRecipesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listImageRecipesPaginated]
 * to access the nested member [ImageRecipeSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ImageRecipeSummary]
 */
@JvmName("listImageRecipesResponseImageRecipeSummary")
public fun Flow<ListImageRecipesResponse>.imageRecipeSummaryList(): Flow<ImageRecipeSummary> =
    transform() { response ->
        response.imageRecipeSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListImagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListImagesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImagesResponse]
 */
public fun ImagebuilderClient.listImagesPaginated(initialRequest: ListImagesRequest = ListImagesRequest { }): Flow<ListImagesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listImagesPaginated.listImages(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListImagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImagesResponse]
 */
public fun ImagebuilderClient.listImagesPaginated(block: ListImagesRequest.Builder.() -> Unit): Flow<ListImagesResponse> =
    listImagesPaginated(ListImagesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listImagesPaginated]
 * to access the nested member [ImageVersion]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ImageVersion]
 */
@JvmName("listImagesResponseImageVersion")
public fun Flow<ListImagesResponse>.imageVersionList(): Flow<ImageVersion> =
    transform() { response ->
        response.imageVersionList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListImageScanFindingAggregationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListImageScanFindingAggregationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImageScanFindingAggregationsResponse]
 */
public fun ImagebuilderClient.listImageScanFindingAggregationsPaginated(initialRequest: ListImageScanFindingAggregationsRequest = ListImageScanFindingAggregationsRequest { }): Flow<ListImageScanFindingAggregationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listImageScanFindingAggregationsPaginated.listImageScanFindingAggregations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListImageScanFindingAggregationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImageScanFindingAggregationsResponse]
 */
public fun ImagebuilderClient.listImageScanFindingAggregationsPaginated(block: ListImageScanFindingAggregationsRequest.Builder.() -> Unit): Flow<ListImageScanFindingAggregationsResponse> =
    listImageScanFindingAggregationsPaginated(ListImageScanFindingAggregationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listImageScanFindingAggregationsPaginated]
 * to access the nested member [ImageScanFindingAggregation]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ImageScanFindingAggregation]
 */
@JvmName("listImageScanFindingAggregationsResponseImageScanFindingAggregation")
public fun Flow<ListImageScanFindingAggregationsResponse>.responses(): Flow<ImageScanFindingAggregation> =
    transform() { response ->
        response.responses?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListImageScanFindingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListImageScanFindingsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImageScanFindingsResponse]
 */
public fun ImagebuilderClient.listImageScanFindingsPaginated(initialRequest: ListImageScanFindingsRequest = ListImageScanFindingsRequest { }): Flow<ListImageScanFindingsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listImageScanFindingsPaginated.listImageScanFindings(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListImageScanFindingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImageScanFindingsResponse]
 */
public fun ImagebuilderClient.listImageScanFindingsPaginated(block: ListImageScanFindingsRequest.Builder.() -> Unit): Flow<ListImageScanFindingsResponse> =
    listImageScanFindingsPaginated(ListImageScanFindingsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listImageScanFindingsPaginated]
 * to access the nested member [ImageScanFinding]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ImageScanFinding]
 */
@JvmName("listImageScanFindingsResponseImageScanFinding")
public fun Flow<ListImageScanFindingsResponse>.findings(): Flow<ImageScanFinding> =
    transform() { response ->
        response.findings?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListInfrastructureConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListInfrastructureConfigurationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInfrastructureConfigurationsResponse]
 */
public fun ImagebuilderClient.listInfrastructureConfigurationsPaginated(initialRequest: ListInfrastructureConfigurationsRequest = ListInfrastructureConfigurationsRequest { }): Flow<ListInfrastructureConfigurationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listInfrastructureConfigurationsPaginated.listInfrastructureConfigurations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListInfrastructureConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInfrastructureConfigurationsResponse]
 */
public fun ImagebuilderClient.listInfrastructureConfigurationsPaginated(block: ListInfrastructureConfigurationsRequest.Builder.() -> Unit): Flow<ListInfrastructureConfigurationsResponse> =
    listInfrastructureConfigurationsPaginated(ListInfrastructureConfigurationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listInfrastructureConfigurationsPaginated]
 * to access the nested member [InfrastructureConfigurationSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [InfrastructureConfigurationSummary]
 */
@JvmName("listInfrastructureConfigurationsResponseInfrastructureConfigurationSummary")
public fun Flow<ListInfrastructureConfigurationsResponse>.infrastructureConfigurationSummaryList(): Flow<InfrastructureConfigurationSummary> =
    transform() { response ->
        response.infrastructureConfigurationSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListLifecycleExecutionResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListLifecycleExecutionResourcesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLifecycleExecutionResourcesResponse]
 */
public fun ImagebuilderClient.listLifecycleExecutionResourcesPaginated(initialRequest: ListLifecycleExecutionResourcesRequest): Flow<ListLifecycleExecutionResourcesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listLifecycleExecutionResourcesPaginated.listLifecycleExecutionResources(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListLifecycleExecutionResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLifecycleExecutionResourcesResponse]
 */
public fun ImagebuilderClient.listLifecycleExecutionResourcesPaginated(block: ListLifecycleExecutionResourcesRequest.Builder.() -> Unit): Flow<ListLifecycleExecutionResourcesResponse> =
    listLifecycleExecutionResourcesPaginated(ListLifecycleExecutionResourcesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listLifecycleExecutionResourcesPaginated]
 * to access the nested member [LifecycleExecutionResource]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [LifecycleExecutionResource]
 */
@JvmName("listLifecycleExecutionResourcesResponseLifecycleExecutionResource")
public fun Flow<ListLifecycleExecutionResourcesResponse>.resources(): Flow<LifecycleExecutionResource> =
    transform() { response ->
        response.resources?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListLifecycleExecutionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListLifecycleExecutionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLifecycleExecutionsResponse]
 */
public fun ImagebuilderClient.listLifecycleExecutionsPaginated(initialRequest: ListLifecycleExecutionsRequest): Flow<ListLifecycleExecutionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listLifecycleExecutionsPaginated.listLifecycleExecutions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListLifecycleExecutionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLifecycleExecutionsResponse]
 */
public fun ImagebuilderClient.listLifecycleExecutionsPaginated(block: ListLifecycleExecutionsRequest.Builder.() -> Unit): Flow<ListLifecycleExecutionsResponse> =
    listLifecycleExecutionsPaginated(ListLifecycleExecutionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listLifecycleExecutionsPaginated]
 * to access the nested member [LifecycleExecution]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [LifecycleExecution]
 */
@JvmName("listLifecycleExecutionsResponseLifecycleExecution")
public fun Flow<ListLifecycleExecutionsResponse>.lifecycleExecutions(): Flow<LifecycleExecution> =
    transform() { response ->
        response.lifecycleExecutions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListLifecyclePoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListLifecyclePoliciesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLifecyclePoliciesResponse]
 */
public fun ImagebuilderClient.listLifecyclePoliciesPaginated(initialRequest: ListLifecyclePoliciesRequest = ListLifecyclePoliciesRequest { }): Flow<ListLifecyclePoliciesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listLifecyclePoliciesPaginated.listLifecyclePolicies(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListLifecyclePoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLifecyclePoliciesResponse]
 */
public fun ImagebuilderClient.listLifecyclePoliciesPaginated(block: ListLifecyclePoliciesRequest.Builder.() -> Unit): Flow<ListLifecyclePoliciesResponse> =
    listLifecyclePoliciesPaginated(ListLifecyclePoliciesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listLifecyclePoliciesPaginated]
 * to access the nested member [LifecyclePolicySummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [LifecyclePolicySummary]
 */
@JvmName("listLifecyclePoliciesResponseLifecyclePolicySummary")
public fun Flow<ListLifecyclePoliciesResponse>.lifecyclePolicySummaryList(): Flow<LifecyclePolicySummary> =
    transform() { response ->
        response.lifecyclePolicySummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListWorkflowExecutionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListWorkflowExecutionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkflowExecutionsResponse]
 */
public fun ImagebuilderClient.listWorkflowExecutionsPaginated(initialRequest: ListWorkflowExecutionsRequest): Flow<ListWorkflowExecutionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listWorkflowExecutionsPaginated.listWorkflowExecutions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListWorkflowExecutionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkflowExecutionsResponse]
 */
public fun ImagebuilderClient.listWorkflowExecutionsPaginated(block: ListWorkflowExecutionsRequest.Builder.() -> Unit): Flow<ListWorkflowExecutionsResponse> =
    listWorkflowExecutionsPaginated(ListWorkflowExecutionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listWorkflowExecutionsPaginated]
 * to access the nested member [WorkflowExecutionMetadata]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [WorkflowExecutionMetadata]
 */
@JvmName("listWorkflowExecutionsResponseWorkflowExecutionMetadata")
public fun Flow<ListWorkflowExecutionsResponse>.workflowExecutions(): Flow<WorkflowExecutionMetadata> =
    transform() { response ->
        response.workflowExecutions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListWorkflowStepExecutionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListWorkflowStepExecutionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkflowStepExecutionsResponse]
 */
public fun ImagebuilderClient.listWorkflowStepExecutionsPaginated(initialRequest: ListWorkflowStepExecutionsRequest): Flow<ListWorkflowStepExecutionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listWorkflowStepExecutionsPaginated.listWorkflowStepExecutions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListWorkflowStepExecutionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkflowStepExecutionsResponse]
 */
public fun ImagebuilderClient.listWorkflowStepExecutionsPaginated(block: ListWorkflowStepExecutionsRequest.Builder.() -> Unit): Flow<ListWorkflowStepExecutionsResponse> =
    listWorkflowStepExecutionsPaginated(ListWorkflowStepExecutionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listWorkflowStepExecutionsPaginated]
 * to access the nested member [WorkflowStepMetadata]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [WorkflowStepMetadata]
 */
@JvmName("listWorkflowStepExecutionsResponseWorkflowStepMetadata")
public fun Flow<ListWorkflowStepExecutionsResponse>.steps(): Flow<WorkflowStepMetadata> =
    transform() { response ->
        response.steps?.forEach {
            emit(it)
        }
    }
