// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains a summary of lifecycle policy resources.
 */
public class LifecyclePolicySummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the lifecycle policy summary resource.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The timestamp when Image Builder created the lifecycle policy resource.
     */
    public val dateCreated: aws.smithy.kotlin.runtime.time.Instant? = builder.dateCreated
    /**
     * The timestamp for the last time Image Builder ran the lifecycle policy.
     */
    public val dateLastRun: aws.smithy.kotlin.runtime.time.Instant? = builder.dateLastRun
    /**
     * The timestamp when Image Builder updated the lifecycle policy resource.
     */
    public val dateUpdated: aws.smithy.kotlin.runtime.time.Instant? = builder.dateUpdated
    /**
     * Optional description for the lifecycle policy.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the IAM role that Image Builder uses to run the lifecycle policy.
     */
    public val executionRole: kotlin.String? = builder.executionRole
    /**
     * The name of the lifecycle policy.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The type of resources the lifecycle policy targets.
     */
    public val resourceType: aws.sdk.kotlin.services.imagebuilder.model.LifecyclePolicyResourceType? = builder.resourceType
    /**
     * The lifecycle policy resource status.
     */
    public val status: aws.sdk.kotlin.services.imagebuilder.model.LifecyclePolicyStatus? = builder.status
    /**
     * To help manage your lifecycle policy resources, you can assign your own metadata to each resource in the form of tags. Each tag consists of a key and an optional value, both of which you define.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.LifecyclePolicySummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LifecyclePolicySummary(")
        append("arn=$arn,")
        append("dateCreated=$dateCreated,")
        append("dateLastRun=$dateLastRun,")
        append("dateUpdated=$dateUpdated,")
        append("description=$description,")
        append("executionRole=$executionRole,")
        append("name=$name,")
        append("resourceType=$resourceType,")
        append("status=$status,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (dateCreated?.hashCode() ?: 0)
        result = 31 * result + (dateLastRun?.hashCode() ?: 0)
        result = 31 * result + (dateUpdated?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (executionRole?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LifecyclePolicySummary

        if (arn != other.arn) return false
        if (dateCreated != other.dateCreated) return false
        if (dateLastRun != other.dateLastRun) return false
        if (dateUpdated != other.dateUpdated) return false
        if (description != other.description) return false
        if (executionRole != other.executionRole) return false
        if (name != other.name) return false
        if (resourceType != other.resourceType) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.LifecyclePolicySummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the lifecycle policy summary resource.
         */
        public var arn: kotlin.String? = null
        /**
         * The timestamp when Image Builder created the lifecycle policy resource.
         */
        public var dateCreated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The timestamp for the last time Image Builder ran the lifecycle policy.
         */
        public var dateLastRun: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The timestamp when Image Builder updated the lifecycle policy resource.
         */
        public var dateUpdated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Optional description for the lifecycle policy.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the IAM role that Image Builder uses to run the lifecycle policy.
         */
        public var executionRole: kotlin.String? = null
        /**
         * The name of the lifecycle policy.
         */
        public var name: kotlin.String? = null
        /**
         * The type of resources the lifecycle policy targets.
         */
        public var resourceType: aws.sdk.kotlin.services.imagebuilder.model.LifecyclePolicyResourceType? = null
        /**
         * The lifecycle policy resource status.
         */
        public var status: aws.sdk.kotlin.services.imagebuilder.model.LifecyclePolicyStatus? = null
        /**
         * To help manage your lifecycle policy resources, you can assign your own metadata to each resource in the form of tags. Each tag consists of a key and an optional value, both of which you define.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.LifecyclePolicySummary) : this() {
            this.arn = x.arn
            this.dateCreated = x.dateCreated
            this.dateLastRun = x.dateLastRun
            this.dateUpdated = x.dateUpdated
            this.description = x.description
            this.executionRole = x.executionRole
            this.name = x.name
            this.resourceType = x.resourceType
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.LifecyclePolicySummary = LifecyclePolicySummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
