// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



/**
 * Defines filters that the lifecycle policy uses to determine impacted resource.
 */
public class LifecyclePolicyDetailFilter private constructor(builder: Builder) {
    /**
     * For age-based filters, this is the number of resources to keep on hand after the lifecycle `DELETE` action is applied. Impacted resources are only deleted if you have more than this number of resources. If you have fewer resources than this number, the impacted resource is not deleted.
     */
    public val retainAtLeast: kotlin.Int? = builder.retainAtLeast
    /**
     * Filter resources based on either `age` or `count`.
     */
    public val type: aws.sdk.kotlin.services.imagebuilder.model.LifecyclePolicyDetailFilterType = requireNotNull(builder.type) { "A non-null value must be provided for type" }
    /**
     * Defines the unit of time that the lifecycle policy uses to determine impacted resources. This is required for age-based rules.
     */
    public val unit: aws.sdk.kotlin.services.imagebuilder.model.LifecyclePolicyTimeUnit? = builder.unit
    /**
     * The number of units for the time period or for the count. For example, a value of `6` might refer to six months or six AMIs.
     *
     * For count-based filters, this value represents the minimum number of resources to keep on hand. If you have fewer resources than this number, the resource is excluded from lifecycle actions.
     */
    public val value: kotlin.Int = requireNotNull(builder.value) { "A non-null value must be provided for value" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.LifecyclePolicyDetailFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LifecyclePolicyDetailFilter(")
        append("retainAtLeast=$retainAtLeast,")
        append("type=$type,")
        append("unit=$unit,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = retainAtLeast ?: 0
        result = 31 * result + (type.hashCode())
        result = 31 * result + (unit?.hashCode() ?: 0)
        result = 31 * result + (value)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LifecyclePolicyDetailFilter

        if (retainAtLeast != other.retainAtLeast) return false
        if (type != other.type) return false
        if (unit != other.unit) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.LifecyclePolicyDetailFilter = Builder(this).apply(block).build()

    public class Builder {
        /**
         * For age-based filters, this is the number of resources to keep on hand after the lifecycle `DELETE` action is applied. Impacted resources are only deleted if you have more than this number of resources. If you have fewer resources than this number, the impacted resource is not deleted.
         */
        public var retainAtLeast: kotlin.Int? = null
        /**
         * Filter resources based on either `age` or `count`.
         */
        public var type: aws.sdk.kotlin.services.imagebuilder.model.LifecyclePolicyDetailFilterType? = null
        /**
         * Defines the unit of time that the lifecycle policy uses to determine impacted resources. This is required for age-based rules.
         */
        public var unit: aws.sdk.kotlin.services.imagebuilder.model.LifecyclePolicyTimeUnit? = null
        /**
         * The number of units for the time period or for the count. For example, a value of `6` might refer to six months or six AMIs.
         *
         * For count-based filters, this value represents the minimum number of resources to keep on hand. If you have fewer resources than this number, the resource is excluded from lifecycle actions.
         */
        public var value: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.LifecyclePolicyDetailFilter) : this() {
            this.retainAtLeast = x.retainAtLeast
            this.type = x.type
            this.unit = x.unit
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.LifecyclePolicyDetailFilter = LifecyclePolicyDetailFilter(this)

        internal fun correctErrors(): Builder {
            if (type == null) type = LifecyclePolicyDetailFilterType.SdkUnknown("no value provided")
            if (value == null) value = 0
            return this
        }
    }
}
