// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



/**
 * Contains details for a resource that the runtime instance of the lifecycle policy identified for action.
 */
public class LifecycleExecutionResource private constructor(builder: Builder) {
    /**
     * The account that owns the impacted resource.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The action to take for the identified resource.
     */
    public val action: aws.sdk.kotlin.services.imagebuilder.model.LifecycleExecutionResourceAction? = builder.action
    /**
     * For an impacted container image, this identifies a list of URIs for associated container images distributed to ECR repositories.
     */
    public val imageUris: List<String>? = builder.imageUris
    /**
     * The Amazon Web Services Region where the lifecycle execution resource is stored.
     */
    public val region: kotlin.String? = builder.region
    /**
     * Identifies the impacted resource. The resource ID depends on the type of resource, as follows.
     * + Image Builder image resources: Amazon Resource Name (ARN)
     * + Distributed AMIs: AMI ID
     * + Container images distributed to an ECR repository: image URI or SHA Digest
     */
    public val resourceId: kotlin.String? = builder.resourceId
    /**
     * A list of associated resource snapshots for the impacted resource if it’s an AMI.
     */
    public val snapshots: List<LifecycleExecutionSnapshotResource>? = builder.snapshots
    /**
     * The runtime state for the lifecycle execution.
     */
    public val state: aws.sdk.kotlin.services.imagebuilder.model.LifecycleExecutionResourceState? = builder.state

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.LifecycleExecutionResource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LifecycleExecutionResource(")
        append("accountId=$accountId,")
        append("action=$action,")
        append("imageUris=$imageUris,")
        append("region=$region,")
        append("resourceId=$resourceId,")
        append("snapshots=$snapshots,")
        append("state=$state")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (action?.hashCode() ?: 0)
        result = 31 * result + (imageUris?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (snapshots?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LifecycleExecutionResource

        if (accountId != other.accountId) return false
        if (action != other.action) return false
        if (imageUris != other.imageUris) return false
        if (region != other.region) return false
        if (resourceId != other.resourceId) return false
        if (snapshots != other.snapshots) return false
        if (state != other.state) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.LifecycleExecutionResource = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The account that owns the impacted resource.
         */
        public var accountId: kotlin.String? = null
        /**
         * The action to take for the identified resource.
         */
        public var action: aws.sdk.kotlin.services.imagebuilder.model.LifecycleExecutionResourceAction? = null
        /**
         * For an impacted container image, this identifies a list of URIs for associated container images distributed to ECR repositories.
         */
        public var imageUris: List<String>? = null
        /**
         * The Amazon Web Services Region where the lifecycle execution resource is stored.
         */
        public var region: kotlin.String? = null
        /**
         * Identifies the impacted resource. The resource ID depends on the type of resource, as follows.
         * + Image Builder image resources: Amazon Resource Name (ARN)
         * + Distributed AMIs: AMI ID
         * + Container images distributed to an ECR repository: image URI or SHA Digest
         */
        public var resourceId: kotlin.String? = null
        /**
         * A list of associated resource snapshots for the impacted resource if it’s an AMI.
         */
        public var snapshots: List<LifecycleExecutionSnapshotResource>? = null
        /**
         * The runtime state for the lifecycle execution.
         */
        public var state: aws.sdk.kotlin.services.imagebuilder.model.LifecycleExecutionResourceState? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.LifecycleExecutionResource) : this() {
            this.accountId = x.accountId
            this.action = x.action
            this.imageUris = x.imageUris
            this.region = x.region
            this.resourceId = x.resourceId
            this.snapshots = x.snapshots
            this.state = x.state
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.LifecycleExecutionResource = LifecycleExecutionResource(this)

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.LifecycleExecutionResourceAction] inside the given [block]
         */
        public fun action(block: aws.sdk.kotlin.services.imagebuilder.model.LifecycleExecutionResourceAction.Builder.() -> kotlin.Unit) {
            this.action = aws.sdk.kotlin.services.imagebuilder.model.LifecycleExecutionResourceAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.LifecycleExecutionResourceState] inside the given [block]
         */
        public fun state(block: aws.sdk.kotlin.services.imagebuilder.model.LifecycleExecutionResourceState.Builder.() -> kotlin.Unit) {
            this.state = aws.sdk.kotlin.services.imagebuilder.model.LifecycleExecutionResourceState.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
