// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



/**
 * The instance metadata options that apply to the HTTP requests that pipeline builds use to launch EC2 build and test instances. For more information about instance metadata options, see [Configure the instance metadata options](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-instance-metadata-options.html) in the **Amazon EC2 User Guide** for Linux instances, or [Configure the instance metadata options](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/configuring-instance-metadata-options.html) in the **Amazon EC2 Windows Guide** for Windows instances.
 */
public class InstanceMetadataOptions private constructor(builder: Builder) {
    /**
     * Limit the number of hops that an instance metadata request can traverse to reach its destination. The default is one hop. However, if HTTP tokens are required, container image builds need a minimum of two hops.
     */
    public val httpPutResponseHopLimit: kotlin.Int? = builder.httpPutResponseHopLimit
    /**
     * Indicates whether a signed token header is required for instance metadata retrieval requests. The values affect the response as follows:
     * + **required** – When you retrieve the IAM role credentials, version 2.0 credentials are returned in all cases.
     * + **optional** – You can include a signed token header in your request to retrieve instance metadata, or you can leave it out. If you include it, version 2.0 credentials are returned for the IAM role. Otherwise, version 1.0 credentials are returned.
     *
     * The default setting is **optional**.
     */
    public val httpTokens: kotlin.String? = builder.httpTokens

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.InstanceMetadataOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceMetadataOptions(")
        append("httpPutResponseHopLimit=$httpPutResponseHopLimit,")
        append("httpTokens=$httpTokens")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = httpPutResponseHopLimit ?: 0
        result = 31 * result + (httpTokens?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceMetadataOptions

        if (httpPutResponseHopLimit != other.httpPutResponseHopLimit) return false
        if (httpTokens != other.httpTokens) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.InstanceMetadataOptions = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Limit the number of hops that an instance metadata request can traverse to reach its destination. The default is one hop. However, if HTTP tokens are required, container image builds need a minimum of two hops.
         */
        public var httpPutResponseHopLimit: kotlin.Int? = null
        /**
         * Indicates whether a signed token header is required for instance metadata retrieval requests. The values affect the response as follows:
         * + **required** – When you retrieve the IAM role credentials, version 2.0 credentials are returned in all cases.
         * + **optional** – You can include a signed token header in your request to retrieve instance metadata, or you can leave it out. If you include it, version 2.0 credentials are returned for the IAM role. Otherwise, version 1.0 credentials are returned.
         *
         * The default setting is **optional**.
         */
        public var httpTokens: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.InstanceMetadataOptions) : this() {
            this.httpPutResponseHopLimit = x.httpPutResponseHopLimit
            this.httpTokens = x.httpTokens
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.InstanceMetadataOptions = InstanceMetadataOptions(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
