// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



/**
 * Define and configure faster launching for output Windows AMIs.
 */
public class FastLaunchConfiguration private constructor(builder: Builder) {
    /**
     * The owner account ID for the fast-launch enabled Windows AMI.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * A Boolean that represents the current state of faster launching for the Windows AMI. Set to `true` to start using Windows faster launching, or `false` to stop using it.
     */
    public val enabled: kotlin.Boolean = builder.enabled
    /**
     * The launch template that the fast-launch enabled Windows AMI uses when it launches Windows instances to create pre-provisioned snapshots.
     */
    public val launchTemplate: aws.sdk.kotlin.services.imagebuilder.model.FastLaunchLaunchTemplateSpecification? = builder.launchTemplate
    /**
     * The maximum number of parallel instances that are launched for creating resources.
     */
    public val maxParallelLaunches: kotlin.Int? = builder.maxParallelLaunches
    /**
     * Configuration settings for managing the number of snapshots that are created from pre-provisioned instances for the Windows AMI when faster launching is enabled.
     */
    public val snapshotConfiguration: aws.sdk.kotlin.services.imagebuilder.model.FastLaunchSnapshotConfiguration? = builder.snapshotConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.FastLaunchConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FastLaunchConfiguration(")
        append("accountId=$accountId,")
        append("enabled=$enabled,")
        append("launchTemplate=$launchTemplate,")
        append("maxParallelLaunches=$maxParallelLaunches,")
        append("snapshotConfiguration=$snapshotConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (enabled.hashCode())
        result = 31 * result + (launchTemplate?.hashCode() ?: 0)
        result = 31 * result + (maxParallelLaunches ?: 0)
        result = 31 * result + (snapshotConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FastLaunchConfiguration

        if (accountId != other.accountId) return false
        if (enabled != other.enabled) return false
        if (launchTemplate != other.launchTemplate) return false
        if (maxParallelLaunches != other.maxParallelLaunches) return false
        if (snapshotConfiguration != other.snapshotConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.FastLaunchConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The owner account ID for the fast-launch enabled Windows AMI.
         */
        public var accountId: kotlin.String? = null
        /**
         * A Boolean that represents the current state of faster launching for the Windows AMI. Set to `true` to start using Windows faster launching, or `false` to stop using it.
         */
        public var enabled: kotlin.Boolean = false
        /**
         * The launch template that the fast-launch enabled Windows AMI uses when it launches Windows instances to create pre-provisioned snapshots.
         */
        public var launchTemplate: aws.sdk.kotlin.services.imagebuilder.model.FastLaunchLaunchTemplateSpecification? = null
        /**
         * The maximum number of parallel instances that are launched for creating resources.
         */
        public var maxParallelLaunches: kotlin.Int? = null
        /**
         * Configuration settings for managing the number of snapshots that are created from pre-provisioned instances for the Windows AMI when faster launching is enabled.
         */
        public var snapshotConfiguration: aws.sdk.kotlin.services.imagebuilder.model.FastLaunchSnapshotConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.FastLaunchConfiguration) : this() {
            this.accountId = x.accountId
            this.enabled = x.enabled
            this.launchTemplate = x.launchTemplate
            this.maxParallelLaunches = x.maxParallelLaunches
            this.snapshotConfiguration = x.snapshotConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.FastLaunchConfiguration = FastLaunchConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.FastLaunchLaunchTemplateSpecification] inside the given [block]
         */
        public fun launchTemplate(block: aws.sdk.kotlin.services.imagebuilder.model.FastLaunchLaunchTemplateSpecification.Builder.() -> kotlin.Unit) {
            this.launchTemplate = aws.sdk.kotlin.services.imagebuilder.model.FastLaunchLaunchTemplateSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.FastLaunchSnapshotConfiguration] inside the given [block]
         */
        public fun snapshotConfiguration(block: aws.sdk.kotlin.services.imagebuilder.model.FastLaunchSnapshotConfiguration.Builder.() -> kotlin.Unit) {
            this.snapshotConfiguration = aws.sdk.kotlin.services.imagebuilder.model.FastLaunchSnapshotConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
