// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



/**
 * Amazon Inspector generates a risk score for each finding. This score helps you to prioritize findings, to focus on the most critical findings and the most vulnerable resources. The score uses the Common Vulnerability Scoring System (CVSS) format. This format is a modification of the base CVSS score that the National Vulnerability Database (NVD) provides. For more information about severity levels, see [Severity levels for Amazon Inspector findings](https://docs.aws.amazon.com/inspector/latest/user/findings-understanding-severity.html) in the *Amazon Inspector User Guide*.
 */
public class CvssScore private constructor(builder: Builder) {
    /**
     * The CVSS base score.
     */
    public val baseScore: kotlin.Double? = builder.baseScore
    /**
     * The vector string of the CVSS score.
     */
    public val scoringVector: kotlin.String? = builder.scoringVector
    /**
     * The source of the CVSS score.
     */
    public val source: kotlin.String? = builder.source
    /**
     * The CVSS version that generated the score.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.CvssScore = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CvssScore(")
        append("baseScore=$baseScore,")
        append("scoringVector=$scoringVector,")
        append("source=$source,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = baseScore?.hashCode() ?: 0
        result = 31 * result + (scoringVector?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CvssScore

        if (baseScore != other.baseScore) return false
        if (scoringVector != other.scoringVector) return false
        if (source != other.source) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.CvssScore = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The CVSS base score.
         */
        public var baseScore: kotlin.Double? = null
        /**
         * The vector string of the CVSS score.
         */
        public var scoringVector: kotlin.String? = null
        /**
         * The source of the CVSS score.
         */
        public var source: kotlin.String? = null
        /**
         * The CVSS version that generated the score.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.CvssScore) : this() {
            this.baseScore = x.baseScore
            this.scoringVector = x.scoringVector
            this.source = x.source
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.CvssScore = CvssScore(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
