// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



public class CreateLifecyclePolicyRequest private constructor(builder: Builder) {
    /**
     * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see [Ensuring idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html) in the *Amazon EC2 API Reference*.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * Optional description for the lifecycle policy.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The role name or Amazon Resource Name (ARN) for the IAM role that grants Image Builder access to run lifecycle actions.
     */
    public val executionRole: kotlin.String? = builder.executionRole
    /**
     * The name of the lifecycle policy to create.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Configuration details for the lifecycle policy rules.
     */
    public val policyDetails: List<LifecyclePolicyDetail>? = builder.policyDetails
    /**
     * Selection criteria for the resources that the lifecycle policy applies to.
     */
    public val resourceSelection: aws.sdk.kotlin.services.imagebuilder.model.LifecyclePolicyResourceSelection? = builder.resourceSelection
    /**
     * The type of Image Builder resource that the lifecycle policy applies to.
     */
    public val resourceType: aws.sdk.kotlin.services.imagebuilder.model.LifecyclePolicyResourceType? = builder.resourceType
    /**
     * Indicates whether the lifecycle policy resource is enabled.
     */
    public val status: aws.sdk.kotlin.services.imagebuilder.model.LifecyclePolicyStatus? = builder.status
    /**
     * Tags to apply to the lifecycle policy resource.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.CreateLifecyclePolicyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateLifecyclePolicyRequest(")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("executionRole=$executionRole,")
        append("name=$name,")
        append("policyDetails=$policyDetails,")
        append("resourceSelection=$resourceSelection,")
        append("resourceType=$resourceType,")
        append("status=$status,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (executionRole?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (policyDetails?.hashCode() ?: 0)
        result = 31 * result + (resourceSelection?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateLifecyclePolicyRequest

        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (executionRole != other.executionRole) return false
        if (name != other.name) return false
        if (policyDetails != other.policyDetails) return false
        if (resourceSelection != other.resourceSelection) return false
        if (resourceType != other.resourceType) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.CreateLifecyclePolicyRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see [Ensuring idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html) in the *Amazon EC2 API Reference*.
         */
        public var clientToken: kotlin.String? = null
        /**
         * Optional description for the lifecycle policy.
         */
        public var description: kotlin.String? = null
        /**
         * The role name or Amazon Resource Name (ARN) for the IAM role that grants Image Builder access to run lifecycle actions.
         */
        public var executionRole: kotlin.String? = null
        /**
         * The name of the lifecycle policy to create.
         */
        public var name: kotlin.String? = null
        /**
         * Configuration details for the lifecycle policy rules.
         */
        public var policyDetails: List<LifecyclePolicyDetail>? = null
        /**
         * Selection criteria for the resources that the lifecycle policy applies to.
         */
        public var resourceSelection: aws.sdk.kotlin.services.imagebuilder.model.LifecyclePolicyResourceSelection? = null
        /**
         * The type of Image Builder resource that the lifecycle policy applies to.
         */
        public var resourceType: aws.sdk.kotlin.services.imagebuilder.model.LifecyclePolicyResourceType? = null
        /**
         * Indicates whether the lifecycle policy resource is enabled.
         */
        public var status: aws.sdk.kotlin.services.imagebuilder.model.LifecyclePolicyStatus? = null
        /**
         * Tags to apply to the lifecycle policy resource.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.CreateLifecyclePolicyRequest) : this() {
            this.clientToken = x.clientToken
            this.description = x.description
            this.executionRole = x.executionRole
            this.name = x.name
            this.policyDetails = x.policyDetails
            this.resourceSelection = x.resourceSelection
            this.resourceType = x.resourceType
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.CreateLifecyclePolicyRequest = CreateLifecyclePolicyRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.LifecyclePolicyResourceSelection] inside the given [block]
         */
        public fun resourceSelection(block: aws.sdk.kotlin.services.imagebuilder.model.LifecyclePolicyResourceSelection.Builder.() -> kotlin.Unit) {
            this.resourceSelection = aws.sdk.kotlin.services.imagebuilder.model.LifecyclePolicyResourceSelection.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
