// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



public class CreateImageRequest private constructor(builder: Builder) {
    /**
     * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see [Ensuring idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html) in the *Amazon EC2 API Reference*.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The Amazon Resource Name (ARN) of the container recipe that defines how images are configured and tested.
     */
    public val containerRecipeArn: kotlin.String? = builder.containerRecipeArn
    /**
     * The Amazon Resource Name (ARN) of the distribution configuration that defines and configures the outputs of your pipeline.
     */
    public val distributionConfigurationArn: kotlin.String? = builder.distributionConfigurationArn
    /**
     * Collects additional information about the image being created, including the operating system (OS) version and package list. This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.
     */
    public val enhancedImageMetadataEnabled: kotlin.Boolean? = builder.enhancedImageMetadataEnabled
    /**
     * The Amazon Resource Name (ARN) of the image recipe that defines how images are configured, tested, and assessed.
     */
    public val imageRecipeArn: kotlin.String? = builder.imageRecipeArn
    /**
     * Contains settings for vulnerability scans.
     */
    public val imageScanningConfiguration: aws.sdk.kotlin.services.imagebuilder.model.ImageScanningConfiguration? = builder.imageScanningConfiguration
    /**
     * The image tests configuration of the image.
     */
    public val imageTestsConfiguration: aws.sdk.kotlin.services.imagebuilder.model.ImageTestsConfiguration? = builder.imageTestsConfiguration
    /**
     * The Amazon Resource Name (ARN) of the infrastructure configuration that defines the environment in which your image will be built and tested.
     */
    public val infrastructureConfigurationArn: kotlin.String? = builder.infrastructureConfigurationArn
    /**
     * The tags of the image.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.CreateImageRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateImageRequest(")
        append("clientToken=$clientToken,")
        append("containerRecipeArn=$containerRecipeArn,")
        append("distributionConfigurationArn=$distributionConfigurationArn,")
        append("enhancedImageMetadataEnabled=$enhancedImageMetadataEnabled,")
        append("imageRecipeArn=$imageRecipeArn,")
        append("imageScanningConfiguration=$imageScanningConfiguration,")
        append("imageTestsConfiguration=$imageTestsConfiguration,")
        append("infrastructureConfigurationArn=$infrastructureConfigurationArn,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (containerRecipeArn?.hashCode() ?: 0)
        result = 31 * result + (distributionConfigurationArn?.hashCode() ?: 0)
        result = 31 * result + (enhancedImageMetadataEnabled?.hashCode() ?: 0)
        result = 31 * result + (imageRecipeArn?.hashCode() ?: 0)
        result = 31 * result + (imageScanningConfiguration?.hashCode() ?: 0)
        result = 31 * result + (imageTestsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (infrastructureConfigurationArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateImageRequest

        if (clientToken != other.clientToken) return false
        if (containerRecipeArn != other.containerRecipeArn) return false
        if (distributionConfigurationArn != other.distributionConfigurationArn) return false
        if (enhancedImageMetadataEnabled != other.enhancedImageMetadataEnabled) return false
        if (imageRecipeArn != other.imageRecipeArn) return false
        if (imageScanningConfiguration != other.imageScanningConfiguration) return false
        if (imageTestsConfiguration != other.imageTestsConfiguration) return false
        if (infrastructureConfigurationArn != other.infrastructureConfigurationArn) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.CreateImageRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see [Ensuring idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html) in the *Amazon EC2 API Reference*.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the container recipe that defines how images are configured and tested.
         */
        public var containerRecipeArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the distribution configuration that defines and configures the outputs of your pipeline.
         */
        public var distributionConfigurationArn: kotlin.String? = null
        /**
         * Collects additional information about the image being created, including the operating system (OS) version and package list. This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.
         */
        public var enhancedImageMetadataEnabled: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of the image recipe that defines how images are configured, tested, and assessed.
         */
        public var imageRecipeArn: kotlin.String? = null
        /**
         * Contains settings for vulnerability scans.
         */
        public var imageScanningConfiguration: aws.sdk.kotlin.services.imagebuilder.model.ImageScanningConfiguration? = null
        /**
         * The image tests configuration of the image.
         */
        public var imageTestsConfiguration: aws.sdk.kotlin.services.imagebuilder.model.ImageTestsConfiguration? = null
        /**
         * The Amazon Resource Name (ARN) of the infrastructure configuration that defines the environment in which your image will be built and tested.
         */
        public var infrastructureConfigurationArn: kotlin.String? = null
        /**
         * The tags of the image.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.CreateImageRequest) : this() {
            this.clientToken = x.clientToken
            this.containerRecipeArn = x.containerRecipeArn
            this.distributionConfigurationArn = x.distributionConfigurationArn
            this.enhancedImageMetadataEnabled = x.enhancedImageMetadataEnabled
            this.imageRecipeArn = x.imageRecipeArn
            this.imageScanningConfiguration = x.imageScanningConfiguration
            this.imageTestsConfiguration = x.imageTestsConfiguration
            this.infrastructureConfigurationArn = x.infrastructureConfigurationArn
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.CreateImageRequest = CreateImageRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.ImageScanningConfiguration] inside the given [block]
         */
        public fun imageScanningConfiguration(block: aws.sdk.kotlin.services.imagebuilder.model.ImageScanningConfiguration.Builder.() -> kotlin.Unit) {
            this.imageScanningConfiguration = aws.sdk.kotlin.services.imagebuilder.model.ImageScanningConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.ImageTestsConfiguration] inside the given [block]
         */
        public fun imageTestsConfiguration(block: aws.sdk.kotlin.services.imagebuilder.model.ImageTestsConfiguration.Builder.() -> kotlin.Unit) {
            this.imageTestsConfiguration = aws.sdk.kotlin.services.imagebuilder.model.ImageTestsConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
