// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



public class CreateImagePipelineRequest private constructor(builder: Builder) {
    /**
     * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see [Ensuring idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html) in the *Amazon EC2 API Reference*.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The Amazon Resource Name (ARN) of the container recipe that is used to configure images created by this container pipeline.
     */
    public val containerRecipeArn: kotlin.String? = builder.containerRecipeArn
    /**
     * The description of the image pipeline.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The Amazon Resource Name (ARN) of the distribution configuration that will be used to configure and distribute images created by this image pipeline.
     */
    public val distributionConfigurationArn: kotlin.String? = builder.distributionConfigurationArn
    /**
     * Collects additional information about the image being created, including the operating system (OS) version and package list. This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.
     */
    public val enhancedImageMetadataEnabled: kotlin.Boolean? = builder.enhancedImageMetadataEnabled
    /**
     * The Amazon Resource Name (ARN) of the image recipe that will be used to configure images created by this image pipeline.
     */
    public val imageRecipeArn: kotlin.String? = builder.imageRecipeArn
    /**
     * Contains settings for vulnerability scans.
     */
    public val imageScanningConfiguration: aws.sdk.kotlin.services.imagebuilder.model.ImageScanningConfiguration? = builder.imageScanningConfiguration
    /**
     * The image test configuration of the image pipeline.
     */
    public val imageTestsConfiguration: aws.sdk.kotlin.services.imagebuilder.model.ImageTestsConfiguration? = builder.imageTestsConfiguration
    /**
     * The Amazon Resource Name (ARN) of the infrastructure configuration that will be used to build images created by this image pipeline.
     */
    public val infrastructureConfigurationArn: kotlin.String? = builder.infrastructureConfigurationArn
    /**
     * The name of the image pipeline.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The schedule of the image pipeline.
     */
    public val schedule: aws.sdk.kotlin.services.imagebuilder.model.Schedule? = builder.schedule
    /**
     * The status of the image pipeline.
     */
    public val status: aws.sdk.kotlin.services.imagebuilder.model.PipelineStatus? = builder.status
    /**
     * The tags of the image pipeline.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.CreateImagePipelineRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateImagePipelineRequest(")
        append("clientToken=$clientToken,")
        append("containerRecipeArn=$containerRecipeArn,")
        append("description=$description,")
        append("distributionConfigurationArn=$distributionConfigurationArn,")
        append("enhancedImageMetadataEnabled=$enhancedImageMetadataEnabled,")
        append("imageRecipeArn=$imageRecipeArn,")
        append("imageScanningConfiguration=$imageScanningConfiguration,")
        append("imageTestsConfiguration=$imageTestsConfiguration,")
        append("infrastructureConfigurationArn=$infrastructureConfigurationArn,")
        append("name=$name,")
        append("schedule=$schedule,")
        append("status=$status,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (containerRecipeArn?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (distributionConfigurationArn?.hashCode() ?: 0)
        result = 31 * result + (enhancedImageMetadataEnabled?.hashCode() ?: 0)
        result = 31 * result + (imageRecipeArn?.hashCode() ?: 0)
        result = 31 * result + (imageScanningConfiguration?.hashCode() ?: 0)
        result = 31 * result + (imageTestsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (infrastructureConfigurationArn?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (schedule?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateImagePipelineRequest

        if (clientToken != other.clientToken) return false
        if (containerRecipeArn != other.containerRecipeArn) return false
        if (description != other.description) return false
        if (distributionConfigurationArn != other.distributionConfigurationArn) return false
        if (enhancedImageMetadataEnabled != other.enhancedImageMetadataEnabled) return false
        if (imageRecipeArn != other.imageRecipeArn) return false
        if (imageScanningConfiguration != other.imageScanningConfiguration) return false
        if (imageTestsConfiguration != other.imageTestsConfiguration) return false
        if (infrastructureConfigurationArn != other.infrastructureConfigurationArn) return false
        if (name != other.name) return false
        if (schedule != other.schedule) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.CreateImagePipelineRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see [Ensuring idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html) in the *Amazon EC2 API Reference*.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the container recipe that is used to configure images created by this container pipeline.
         */
        public var containerRecipeArn: kotlin.String? = null
        /**
         * The description of the image pipeline.
         */
        public var description: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the distribution configuration that will be used to configure and distribute images created by this image pipeline.
         */
        public var distributionConfigurationArn: kotlin.String? = null
        /**
         * Collects additional information about the image being created, including the operating system (OS) version and package list. This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.
         */
        public var enhancedImageMetadataEnabled: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of the image recipe that will be used to configure images created by this image pipeline.
         */
        public var imageRecipeArn: kotlin.String? = null
        /**
         * Contains settings for vulnerability scans.
         */
        public var imageScanningConfiguration: aws.sdk.kotlin.services.imagebuilder.model.ImageScanningConfiguration? = null
        /**
         * The image test configuration of the image pipeline.
         */
        public var imageTestsConfiguration: aws.sdk.kotlin.services.imagebuilder.model.ImageTestsConfiguration? = null
        /**
         * The Amazon Resource Name (ARN) of the infrastructure configuration that will be used to build images created by this image pipeline.
         */
        public var infrastructureConfigurationArn: kotlin.String? = null
        /**
         * The name of the image pipeline.
         */
        public var name: kotlin.String? = null
        /**
         * The schedule of the image pipeline.
         */
        public var schedule: aws.sdk.kotlin.services.imagebuilder.model.Schedule? = null
        /**
         * The status of the image pipeline.
         */
        public var status: aws.sdk.kotlin.services.imagebuilder.model.PipelineStatus? = null
        /**
         * The tags of the image pipeline.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.CreateImagePipelineRequest) : this() {
            this.clientToken = x.clientToken
            this.containerRecipeArn = x.containerRecipeArn
            this.description = x.description
            this.distributionConfigurationArn = x.distributionConfigurationArn
            this.enhancedImageMetadataEnabled = x.enhancedImageMetadataEnabled
            this.imageRecipeArn = x.imageRecipeArn
            this.imageScanningConfiguration = x.imageScanningConfiguration
            this.imageTestsConfiguration = x.imageTestsConfiguration
            this.infrastructureConfigurationArn = x.infrastructureConfigurationArn
            this.name = x.name
            this.schedule = x.schedule
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.CreateImagePipelineRequest = CreateImagePipelineRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.ImageScanningConfiguration] inside the given [block]
         */
        public fun imageScanningConfiguration(block: aws.sdk.kotlin.services.imagebuilder.model.ImageScanningConfiguration.Builder.() -> kotlin.Unit) {
            this.imageScanningConfiguration = aws.sdk.kotlin.services.imagebuilder.model.ImageScanningConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.ImageTestsConfiguration] inside the given [block]
         */
        public fun imageTestsConfiguration(block: aws.sdk.kotlin.services.imagebuilder.model.ImageTestsConfiguration.Builder.() -> kotlin.Unit) {
            this.imageTestsConfiguration = aws.sdk.kotlin.services.imagebuilder.model.ImageTestsConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.Schedule] inside the given [block]
         */
        public fun schedule(block: aws.sdk.kotlin.services.imagebuilder.model.Schedule.Builder.() -> kotlin.Unit) {
            this.schedule = aws.sdk.kotlin.services.imagebuilder.model.Schedule.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
