// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



/**
 * A detailed view of a component.
 */
public class Component private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the component.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The change description of the component.
     */
    public val changeDescription: kotlin.String? = builder.changeDescription
    /**
     * Component data contains the YAML document content for the component.
     */
    public val data: kotlin.String? = builder.data
    /**
     * The date that Image Builder created the component.
     */
    public val dateCreated: kotlin.String? = builder.dateCreated
    /**
     * The description of the component.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The encryption status of the component.
     */
    public val encrypted: kotlin.Boolean? = builder.encrypted
    /**
     * The KMS key identifier used to encrypt the component.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The name of the component.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Indicates whether component source is hidden from view in the console, and from component detail results for API, CLI, or SDK operations.
     */
    public val obfuscate: kotlin.Boolean = builder.obfuscate
    /**
     * The owner of the component.
     */
    public val owner: kotlin.String? = builder.owner
    /**
     * Contains parameter details for each of the parameters that the component document defined for the component.
     */
    public val parameters: List<ComponentParameterDetail>? = builder.parameters
    /**
     * The operating system platform of the component.
     */
    public val platform: aws.sdk.kotlin.services.imagebuilder.model.Platform? = builder.platform
    /**
     * Contains the name of the publisher if this is a third-party component. Otherwise, this property is empty.
     */
    public val publisher: kotlin.String? = builder.publisher
    /**
     * Describes the current status of the component. This is used for components that are no longer active.
     */
    public val state: aws.sdk.kotlin.services.imagebuilder.model.ComponentState? = builder.state
    /**
     * The operating system (OS) version supported by the component. If the OS information is available, Image Builder performs a prefix match against the base image OS version during image recipe creation.
     */
    public val supportedOsVersions: List<String>? = builder.supportedOsVersions
    /**
     * The tags that apply to the component.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The component type specifies whether Image Builder uses the component to build the image or only to test it.
     */
    public val type: aws.sdk.kotlin.services.imagebuilder.model.ComponentType? = builder.type
    /**
     * The version of the component.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.Component = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Component(")
        append("arn=$arn,")
        append("changeDescription=$changeDescription,")
        append("data=$data,")
        append("dateCreated=$dateCreated,")
        append("description=$description,")
        append("encrypted=$encrypted,")
        append("kmsKeyId=$kmsKeyId,")
        append("name=$name,")
        append("obfuscate=$obfuscate,")
        append("owner=$owner,")
        append("parameters=$parameters,")
        append("platform=$platform,")
        append("publisher=$publisher,")
        append("state=$state,")
        append("supportedOsVersions=$supportedOsVersions,")
        append("tags=$tags,")
        append("type=$type,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (changeDescription?.hashCode() ?: 0)
        result = 31 * result + (data?.hashCode() ?: 0)
        result = 31 * result + (dateCreated?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (encrypted?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (obfuscate.hashCode())
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (publisher?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (supportedOsVersions?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Component

        if (arn != other.arn) return false
        if (changeDescription != other.changeDescription) return false
        if (data != other.data) return false
        if (dateCreated != other.dateCreated) return false
        if (description != other.description) return false
        if (encrypted != other.encrypted) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (name != other.name) return false
        if (obfuscate != other.obfuscate) return false
        if (owner != other.owner) return false
        if (parameters != other.parameters) return false
        if (platform != other.platform) return false
        if (publisher != other.publisher) return false
        if (state != other.state) return false
        if (supportedOsVersions != other.supportedOsVersions) return false
        if (tags != other.tags) return false
        if (type != other.type) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.Component = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the component.
         */
        public var arn: kotlin.String? = null
        /**
         * The change description of the component.
         */
        public var changeDescription: kotlin.String? = null
        /**
         * Component data contains the YAML document content for the component.
         */
        public var data: kotlin.String? = null
        /**
         * The date that Image Builder created the component.
         */
        public var dateCreated: kotlin.String? = null
        /**
         * The description of the component.
         */
        public var description: kotlin.String? = null
        /**
         * The encryption status of the component.
         */
        public var encrypted: kotlin.Boolean? = null
        /**
         * The KMS key identifier used to encrypt the component.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The name of the component.
         */
        public var name: kotlin.String? = null
        /**
         * Indicates whether component source is hidden from view in the console, and from component detail results for API, CLI, or SDK operations.
         */
        public var obfuscate: kotlin.Boolean = false
        /**
         * The owner of the component.
         */
        public var owner: kotlin.String? = null
        /**
         * Contains parameter details for each of the parameters that the component document defined for the component.
         */
        public var parameters: List<ComponentParameterDetail>? = null
        /**
         * The operating system platform of the component.
         */
        public var platform: aws.sdk.kotlin.services.imagebuilder.model.Platform? = null
        /**
         * Contains the name of the publisher if this is a third-party component. Otherwise, this property is empty.
         */
        public var publisher: kotlin.String? = null
        /**
         * Describes the current status of the component. This is used for components that are no longer active.
         */
        public var state: aws.sdk.kotlin.services.imagebuilder.model.ComponentState? = null
        /**
         * The operating system (OS) version supported by the component. If the OS information is available, Image Builder performs a prefix match against the base image OS version during image recipe creation.
         */
        public var supportedOsVersions: List<String>? = null
        /**
         * The tags that apply to the component.
         */
        public var tags: Map<String, String>? = null
        /**
         * The component type specifies whether Image Builder uses the component to build the image or only to test it.
         */
        public var type: aws.sdk.kotlin.services.imagebuilder.model.ComponentType? = null
        /**
         * The version of the component.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.Component) : this() {
            this.arn = x.arn
            this.changeDescription = x.changeDescription
            this.data = x.data
            this.dateCreated = x.dateCreated
            this.description = x.description
            this.encrypted = x.encrypted
            this.kmsKeyId = x.kmsKeyId
            this.name = x.name
            this.obfuscate = x.obfuscate
            this.owner = x.owner
            this.parameters = x.parameters
            this.platform = x.platform
            this.publisher = x.publisher
            this.state = x.state
            this.supportedOsVersions = x.supportedOsVersions
            this.tags = x.tags
            this.type = x.type
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.Component = Component(this)

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.ComponentState] inside the given [block]
         */
        public fun state(block: aws.sdk.kotlin.services.imagebuilder.model.ComponentState.Builder.() -> kotlin.Unit) {
            this.state = aws.sdk.kotlin.services.imagebuilder.model.ComponentState.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
