// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.imagebuilder.model



/**
 * Contains counts of vulnerability findings from image scans that run when you create new Image Builder images, or build new versions of existing images. The vulnerability counts are grouped by severity level. The counts are aggregated across resources to create the final tally for the account that owns them.
 */
public class AccountAggregation private constructor(builder: Builder) {
    /**
     * Identifies the account that owns the aggregated resource findings.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * Counts by severity level for medium severity and higher level findings, plus a total for all of the findings.
     */
    public val severityCounts: aws.sdk.kotlin.services.imagebuilder.model.SeverityCounts? = builder.severityCounts

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.imagebuilder.model.AccountAggregation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AccountAggregation(")
        append("accountId=$accountId,")
        append("severityCounts=$severityCounts")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (severityCounts?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AccountAggregation

        if (accountId != other.accountId) return false
        if (severityCounts != other.severityCounts) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.imagebuilder.model.AccountAggregation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Identifies the account that owns the aggregated resource findings.
         */
        public var accountId: kotlin.String? = null
        /**
         * Counts by severity level for medium severity and higher level findings, plus a total for all of the findings.
         */
        public var severityCounts: aws.sdk.kotlin.services.imagebuilder.model.SeverityCounts? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.imagebuilder.model.AccountAggregation) : this() {
            this.accountId = x.accountId
            this.severityCounts = x.severityCounts
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.imagebuilder.model.AccountAggregation = AccountAggregation(this)

        /**
         * construct an [aws.sdk.kotlin.services.imagebuilder.model.SeverityCounts] inside the given [block]
         */
        public fun severityCounts(block: aws.sdk.kotlin.services.imagebuilder.model.SeverityCounts.Builder.() -> kotlin.Unit) {
            this.severityCounts = aws.sdk.kotlin.services.imagebuilder.model.SeverityCounts.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
