// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.identitystore.model

import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * Indicates that a requested resource is not found.
 */
class ResourceNotFoundException private constructor(builder: BuilderImpl) : IdentitystoreException() {

    override val message: String? = builder.message
    /**
     * The identifier for each request. This value is a globally unique ID that is generated by the Identity Store service for each sent request, and is then returned inside the exception if the request fails.
     */
    val requestId: String? = builder.requestId
    /**
     * The identifier for a resource in the identity store, which can be used as UserId or GroupId. The format for ResourceId is either UUID or 1234567890-UUID, where UUID is a randomly generated value for each resource when it is created and 1234567890 represents the IdentityStoreId string value. In the case that the identity store is migrated from a legacy SSO identity store, the ResourceId for that identity store will be in the format of UUID. Otherwise, it will be in the 1234567890-UUID format.
     */
    val resourceId: String? = builder.resourceId
    /**
     * The type of resource in the Identity Store service, which is an enum object. Valid values include USER, GROUP, and IDENTITY_STORE.
     */
    val resourceType: ResourceType? = builder.resourceType

    init {
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Client
    }

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ResourceNotFoundException = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceNotFoundException(")
        append("message=$message,")
        append("requestId=$requestId,")
        append("resourceId=$resourceId,")
        append("resourceType=$resourceType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = message?.hashCode() ?: 0
        result = 31 * result + (requestId?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ResourceNotFoundException

        if (message != other.message) return false
        if (requestId != other.requestId) return false
        if (resourceId != other.resourceId) return false
        if (resourceType != other.resourceType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ResourceNotFoundException = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ResourceNotFoundException
        fun message(message: String): FluentBuilder
        /**
         * The identifier for each request. This value is a globally unique ID that is generated by the Identity Store service for each sent request, and is then returned inside the exception if the request fails.
         */
        fun requestId(requestId: String): FluentBuilder
        /**
         * The identifier for a resource in the identity store, which can be used as UserId or GroupId. The format for ResourceId is either UUID or 1234567890-UUID, where UUID is a randomly generated value for each resource when it is created and 1234567890 represents the IdentityStoreId string value. In the case that the identity store is migrated from a legacy SSO identity store, the ResourceId for that identity store will be in the format of UUID. Otherwise, it will be in the 1234567890-UUID format.
         */
        fun resourceId(resourceId: String): FluentBuilder
        /**
         * The type of resource in the Identity Store service, which is an enum object. Valid values include USER, GROUP, and IDENTITY_STORE.
         */
        fun resourceType(resourceType: ResourceType): FluentBuilder
    }

    interface DslBuilder {
        var message: String?
        /**
         * The identifier for each request. This value is a globally unique ID that is generated by the Identity Store service for each sent request, and is then returned inside the exception if the request fails.
         */
        var requestId: String?
        /**
         * The identifier for a resource in the identity store, which can be used as UserId or GroupId. The format for ResourceId is either UUID or 1234567890-UUID, where UUID is a randomly generated value for each resource when it is created and 1234567890 represents the IdentityStoreId string value. In the case that the identity store is migrated from a legacy SSO identity store, the ResourceId for that identity store will be in the format of UUID. Otherwise, it will be in the 1234567890-UUID format.
         */
        var resourceId: String?
        /**
         * The type of resource in the Identity Store service, which is an enum object. Valid values include USER, GROUP, and IDENTITY_STORE.
         */
        var resourceType: ResourceType?

        fun build(): ResourceNotFoundException
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var message: String? = null
        override var requestId: String? = null
        override var resourceId: String? = null
        override var resourceType: ResourceType? = null

        constructor(x: ResourceNotFoundException) : this() {
            this.message = x.message
            this.requestId = x.requestId
            this.resourceId = x.resourceId
            this.resourceType = x.resourceType
        }

        override fun build(): ResourceNotFoundException = ResourceNotFoundException(this)
        override fun message(message: String): FluentBuilder = apply { this.message = message }
        override fun requestId(requestId: String): FluentBuilder = apply { this.requestId = requestId }
        override fun resourceId(resourceId: String): FluentBuilder = apply { this.resourceId = resourceId }
        override fun resourceType(resourceType: ResourceType): FluentBuilder = apply { this.resourceType = resourceType }
    }
}
