// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.identitystore.model



class ListGroupsRequest private constructor(builder: BuilderImpl) {
    /**
     * A list of Filter objects, which is used in the ListUsers and ListGroups request.
     */
    val filters: List<Filter>? = builder.filters
    /**
     * The globally unique identifier for the identity store, such as
     * d-1234567890. In this example, d- is a fixed prefix, and
     * 1234567890 is a randomly generated string that contains number and lower
     * case letters. This value is generated at the time that a new identity store is
     * created.
     */
    val identityStoreId: String? = builder.identityStoreId
    /**
     * The maximum number of results to be returned per request. This parameter is used in the
     * ListUsers and ListGroups request to specify how many results
     * to return in one page. The length limit is 50 characters.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The pagination token used for the ListUsers and ListGroups API
     * operations. This value is generated by the identity store service. It is returned in the
     * API response if the total results are more than the size of one page. This token is also
     * returned when it is used in the API request to search for the next page.
     */
    val nextToken: String? = builder.nextToken

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListGroupsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListGroupsRequest(")
        append("filters=$filters,")
        append("identityStoreId=$identityStoreId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = filters?.hashCode() ?: 0
        result = 31 * result + (identityStoreId?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListGroupsRequest

        if (filters != other.filters) return false
        if (identityStoreId != other.identityStoreId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListGroupsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListGroupsRequest
        /**
         * A list of Filter objects, which is used in the ListUsers and ListGroups request.
         */
        fun filters(filters: List<Filter>): FluentBuilder
        /**
         * The globally unique identifier for the identity store, such as
         * d-1234567890. In this example, d- is a fixed prefix, and
         * 1234567890 is a randomly generated string that contains number and lower
         * case letters. This value is generated at the time that a new identity store is
         * created.
         */
        fun identityStoreId(identityStoreId: String): FluentBuilder
        /**
         * The maximum number of results to be returned per request. This parameter is used in the
         * ListUsers and ListGroups request to specify how many results
         * to return in one page. The length limit is 50 characters.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The pagination token used for the ListUsers and ListGroups API
         * operations. This value is generated by the identity store service. It is returned in the
         * API response if the total results are more than the size of one page. This token is also
         * returned when it is used in the API request to search for the next page.
         */
        fun nextToken(nextToken: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A list of Filter objects, which is used in the ListUsers and ListGroups request.
         */
        var filters: List<Filter>?
        /**
         * The globally unique identifier for the identity store, such as
         * d-1234567890. In this example, d- is a fixed prefix, and
         * 1234567890 is a randomly generated string that contains number and lower
         * case letters. This value is generated at the time that a new identity store is
         * created.
         */
        var identityStoreId: String?
        /**
         * The maximum number of results to be returned per request. This parameter is used in the
         * ListUsers and ListGroups request to specify how many results
         * to return in one page. The length limit is 50 characters.
         */
        var maxResults: Int?
        /**
         * The pagination token used for the ListUsers and ListGroups API
         * operations. This value is generated by the identity store service. It is returned in the
         * API response if the total results are more than the size of one page. This token is also
         * returned when it is used in the API request to search for the next page.
         */
        var nextToken: String?

        fun build(): ListGroupsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var filters: List<Filter>? = null
        override var identityStoreId: String? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null

        constructor(x: ListGroupsRequest) : this() {
            this.filters = x.filters
            this.identityStoreId = x.identityStoreId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        override fun build(): ListGroupsRequest = ListGroupsRequest(this)
        override fun filters(filters: List<Filter>): FluentBuilder = apply { this.filters = filters }
        override fun identityStoreId(identityStoreId: String): FluentBuilder = apply { this.identityStoreId = identityStoreId }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
    }
}
