// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.identitystore

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.EndpointResolver
import aws.sdk.kotlin.services.identitystore.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.identitystore.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * The AWS Single Sign-On (SSO) Identity Store service provides a single place to retrieve all of your
 * identities (users and groups). For more information about AWS, see the <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/what-is.html">AWS Single Sign-On User
 * Guide.
 */
interface IdentitystoreClient : SdkClient {

    override val serviceName: String
        get() = "identitystore"
    /**
     * IdentitystoreClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.DslBuilder.() -> Unit = {}): IdentitystoreClient {
            val config = Config.BuilderImpl().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
            }.apply(block).build()
            return DefaultIdentitystoreClient(config)
        }

        operator fun invoke(config: Config): IdentitystoreClient = DefaultIdentitystoreClient(config)

        /**
         * Construct a [IdentitystoreClient] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): IdentitystoreClient {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return IdentitystoreClient(sharedConfig)
        }
    }

    class Config private constructor(builder: BuilderImpl): AwsClientConfig, HttpClientConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: EndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            @JvmStatic
            fun fluentBuilder(): FluentBuilder = BuilderImpl()

            operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Config = BuilderImpl().apply(block).build()
        }

        interface FluentBuilder {
            fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder
            fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder
            fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder
            fun region(region: String): FluentBuilder
            fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder
            fun build(): Config
        }

        interface DslBuilder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider?

            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: EndpointResolver?

            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine?

            /**
             * AWS region to make requests to
             */
            var region: String?

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode

        }

        internal class BuilderImpl() : FluentBuilder, DslBuilder {
            override var credentialsProvider: CredentialsProvider? = null
            override var endpointResolver: EndpointResolver? = null
            override var httpClientEngine: HttpClientEngine? = null
            override var region: String? = null
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default

            override fun build(): Config = Config(this)
            override fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder = apply { this.credentialsProvider = credentialsProvider }
            override fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder = apply { this.endpointResolver = endpointResolver }
            override fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder = apply { this.httpClientEngine = httpClientEngine }
            override fun region(region: String): FluentBuilder = apply { this.region = region }
            override fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder = apply { this.sdkLogMode = sdkLogMode }
        }
    }

    /**
     * Retrieves the group metadata and attributes from GroupId in an identity store.
     */
    suspend fun describeGroup(input: DescribeGroupRequest): DescribeGroupResponse

    /**
     * Retrieves the group metadata and attributes from GroupId in an identity store.
     */
    suspend fun describeGroup(block: DescribeGroupRequest.DslBuilder.() -> Unit) = describeGroup(DescribeGroupRequest.builder().apply(block).build())

    /**
     * Retrieves the user metadata and attributes from UserId in an identity store.
     */
    suspend fun describeUser(input: DescribeUserRequest): DescribeUserResponse

    /**
     * Retrieves the user metadata and attributes from UserId in an identity store.
     */
    suspend fun describeUser(block: DescribeUserRequest.DslBuilder.() -> Unit) = describeUser(DescribeUserRequest.builder().apply(block).build())

    /**
     * Lists the attribute name and value of the group that you specified in the search. We only support DisplayName as a valid filter
     * attribute path currently, and filter is required. This API returns minimum attributes, including GroupId and group
     * DisplayName in the response.
     */
    suspend fun listGroups(input: ListGroupsRequest): ListGroupsResponse

    /**
     * Lists the attribute name and value of the group that you specified in the search. We only support DisplayName as a valid filter
     * attribute path currently, and filter is required. This API returns minimum attributes, including GroupId and group
     * DisplayName in the response.
     */
    suspend fun listGroups(block: ListGroupsRequest.DslBuilder.() -> Unit) = listGroups(ListGroupsRequest.builder().apply(block).build())

    /**
     * Lists the attribute name and value of the user that you specified in the search. We only support UserName as a valid filter attribute
     * path currently, and filter is required. This API returns minimum attributes, including UserId and UserName in the
     * response.
     */
    suspend fun listUsers(input: ListUsersRequest): ListUsersResponse

    /**
     * Lists the attribute name and value of the user that you specified in the search. We only support UserName as a valid filter attribute
     * path currently, and filter is required. This API returns minimum attributes, including UserId and UserName in the
     * response.
     */
    suspend fun listUsers(block: ListUsersRequest.DslBuilder.() -> Unit) = listUsers(ListUsersRequest.builder().apply(block).build())
}
