// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.identitystore.paginators

import aws.sdk.kotlin.services.identitystore.IdentitystoreClient
import aws.sdk.kotlin.services.identitystore.model.Group
import aws.sdk.kotlin.services.identitystore.model.GroupMembership
import aws.sdk.kotlin.services.identitystore.model.ListGroupMembershipsForMemberRequest
import aws.sdk.kotlin.services.identitystore.model.ListGroupMembershipsForMemberResponse
import aws.sdk.kotlin.services.identitystore.model.ListGroupMembershipsRequest
import aws.sdk.kotlin.services.identitystore.model.ListGroupMembershipsResponse
import aws.sdk.kotlin.services.identitystore.model.ListGroupsRequest
import aws.sdk.kotlin.services.identitystore.model.ListGroupsResponse
import aws.sdk.kotlin.services.identitystore.model.ListUsersRequest
import aws.sdk.kotlin.services.identitystore.model.ListUsersResponse
import aws.sdk.kotlin.services.identitystore.model.User
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListGroupMembershipsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListGroupMembershipsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGroupMembershipsResponse]
 */
public fun IdentitystoreClient.listGroupMembershipsPaginated(initialRequest: ListGroupMembershipsRequest): Flow<ListGroupMembershipsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listGroupMembershipsPaginated.listGroupMemberships(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListGroupMembershipsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGroupMembershipsResponse]
 */
public fun IdentitystoreClient.listGroupMembershipsPaginated(block: ListGroupMembershipsRequest.Builder.() -> Unit): Flow<ListGroupMembershipsResponse> =
    listGroupMembershipsPaginated(ListGroupMembershipsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listGroupMembershipsPaginated]
 * to access the nested member [GroupMembership]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GroupMembership]
 */
@JvmName("listGroupMembershipsResponseGroupMembership")
public fun Flow<ListGroupMembershipsResponse>.groupMemberships(): Flow<GroupMembership> =
    transform() { response ->
        response.groupMemberships?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListGroupMembershipsForMemberResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListGroupMembershipsForMemberRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGroupMembershipsForMemberResponse]
 */
public fun IdentitystoreClient.listGroupMembershipsForMemberPaginated(initialRequest: ListGroupMembershipsForMemberRequest): Flow<ListGroupMembershipsForMemberResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listGroupMembershipsForMemberPaginated.listGroupMembershipsForMember(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListGroupMembershipsForMemberResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGroupMembershipsForMemberResponse]
 */
public fun IdentitystoreClient.listGroupMembershipsForMemberPaginated(block: ListGroupMembershipsForMemberRequest.Builder.() -> Unit): Flow<ListGroupMembershipsForMemberResponse> =
    listGroupMembershipsForMemberPaginated(ListGroupMembershipsForMemberRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listGroupMembershipsForMemberPaginated]
 * to access the nested member [GroupMembership]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GroupMembership]
 */
@JvmName("listGroupMembershipsForMemberResponseGroupMembership")
public fun Flow<ListGroupMembershipsForMemberResponse>.groupMemberships(): Flow<GroupMembership> =
    transform() { response ->
        response.groupMemberships?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGroupsResponse]
 */
public fun IdentitystoreClient.listGroupsPaginated(initialRequest: ListGroupsRequest): Flow<ListGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listGroupsPaginated.listGroups(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGroupsResponse]
 */
public fun IdentitystoreClient.listGroupsPaginated(block: ListGroupsRequest.Builder.() -> Unit): Flow<ListGroupsResponse> =
    listGroupsPaginated(ListGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listGroupsPaginated]
 * to access the nested member [Group]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Group]
 */
@JvmName("listGroupsResponseGroup")
public fun Flow<ListGroupsResponse>.groups(): Flow<Group> =
    transform() { response ->
        response.groups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListUsersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListUsersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUsersResponse]
 */
public fun IdentitystoreClient.listUsersPaginated(initialRequest: ListUsersRequest): Flow<ListUsersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listUsersPaginated.listUsers(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListUsersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUsersResponse]
 */
public fun IdentitystoreClient.listUsersPaginated(block: ListUsersRequest.Builder.() -> Unit): Flow<ListUsersResponse> =
    listUsersPaginated(ListUsersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listUsersPaginated]
 * to access the nested member [User]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [User]
 */
@JvmName("listUsersResponseUser")
public fun Flow<ListUsersResponse>.users(): Flow<User> =
    transform() { response ->
        response.users?.forEach {
            emit(it)
        }
    }
