// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.identitystore.model

import aws.smithy.kotlin.runtime.ErrorMetadata
import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * Indicates that the principal has crossed the throttling limits of the API operations.
 */
public class ThrottlingException private constructor(builder: Builder) : IdentitystoreException(builder.message) {

    /**
     * The identifier for each request. This value is a globally unique ID that is generated by the identity store service for each sent request, and is then returned inside the exception if the request fails.
     */
    public val requestId: kotlin.String? = builder.requestId
    /**
     * The number of seconds to wait before retrying the next request.
     */
    public val retryAfterSeconds: kotlin.Int = builder.retryAfterSeconds

    init {
        sdkErrorMetadata.attributes[ErrorMetadata.Retryable] = true
        sdkErrorMetadata.attributes[ErrorMetadata.ThrottlingError] = true
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Client
    }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.identitystore.model.ThrottlingException = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ThrottlingException(")
        append("message=$message,")
        append("requestId=$requestId,")
        append("retryAfterSeconds=$retryAfterSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = message?.hashCode() ?: 0
        result = 31 * result + (requestId?.hashCode() ?: 0)
        result = 31 * result + (retryAfterSeconds)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ThrottlingException

        if (message != other.message) return false
        if (requestId != other.requestId) return false
        if (retryAfterSeconds != other.retryAfterSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.identitystore.model.ThrottlingException = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        public var message: kotlin.String? = null
        /**
         * The identifier for each request. This value is a globally unique ID that is generated by the identity store service for each sent request, and is then returned inside the exception if the request fails.
         */
        public var requestId: kotlin.String? = null
        /**
         * The number of seconds to wait before retrying the next request.
         */
        public var retryAfterSeconds: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.identitystore.model.ThrottlingException) : this() {
            this.message = x.message
            this.requestId = x.requestId
            this.retryAfterSeconds = x.retryAfterSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.identitystore.model.ThrottlingException = ThrottlingException(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
