// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.identitystore.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListUsersRequest private constructor(builder: Builder) {
    /**
     * A list of `Filter` objects, which is used in the `ListUsers` and `ListGroups` requests.
     */
    @Deprecated("Using filters with ListUsers API is deprecated, please use GetGroupId API instead.")
    public val filters: List<Filter>? = builder.filters
    /**
     * The globally unique identifier for the identity store, such as `d-1234567890`. In this example, `d-` is a fixed prefix, and `1234567890` is a randomly generated string that contains numbers and lower case letters. This value is generated at the time that a new identity store is created.
     */
    public val identityStoreId: kotlin.String = requireNotNull(builder.identityStoreId) { "A non-null value must be provided for identityStoreId" }
    /**
     * The maximum number of results to be returned per request. This parameter is used in the `ListUsers` and `ListGroups` requests to specify how many results to return in one page. The length limit is 50 characters.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The pagination token used for the `ListUsers` and `ListGroups` API operations. This value is generated by the identity store service. It is returned in the API response if the total results are more than the size of one page. This token is also returned when it is used in the API request to search for the next page.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.identitystore.model.ListUsersRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListUsersRequest(")
        append("filters=$filters,")
        append("identityStoreId=$identityStoreId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = filters?.hashCode() ?: 0
        result = 31 * result + (identityStoreId.hashCode())
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListUsersRequest

        if (filters != other.filters) return false
        if (identityStoreId != other.identityStoreId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.identitystore.model.ListUsersRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of `Filter` objects, which is used in the `ListUsers` and `ListGroups` requests.
         */
        @Deprecated("Using filters with ListUsers API is deprecated, please use GetGroupId API instead.")
        public var filters: List<Filter>? = null
        /**
         * The globally unique identifier for the identity store, such as `d-1234567890`. In this example, `d-` is a fixed prefix, and `1234567890` is a randomly generated string that contains numbers and lower case letters. This value is generated at the time that a new identity store is created.
         */
        public var identityStoreId: kotlin.String? = null
        /**
         * The maximum number of results to be returned per request. This parameter is used in the `ListUsers` and `ListGroups` requests to specify how many results to return in one page. The length limit is 50 characters.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The pagination token used for the `ListUsers` and `ListGroups` API operations. This value is generated by the identity store service. It is returned in the API response if the total results are more than the size of one page. This token is also returned when it is used in the API request to search for the next page.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.identitystore.model.ListUsersRequest) : this() {
            this.filters = x.filters
            this.identityStoreId = x.identityStoreId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.identitystore.model.ListUsersRequest = ListUsersRequest(this)

        internal fun correctErrors(): Builder {
            if (identityStoreId == null) identityStoreId = ""
            return this
        }
    }
}
