// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.identitystore.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A group object that contains the metadata and attributes for a specified group.
 */
public class Group private constructor(builder: Builder) {
    /**
     * A string containing a description of the specified group.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The display name value for the group. The length limit is 1,024 characters. This value can consist of letters, accented characters, symbols, numbers, punctuation, tab, new line, carriage return, space, and nonbreaking space in this attribute. This value is specified at the time the group is created and stored as an attribute of the group object in the identity store.
     */
    public val displayName: kotlin.String? = builder.displayName
    /**
     * A list of `ExternalId` objects that contains the identifiers issued to this resource by an external identity provider.
     */
    public val externalIds: List<ExternalId>? = builder.externalIds
    /**
     * The identifier for a group in the identity store.
     */
    public val groupId: kotlin.String = requireNotNull(builder.groupId) { "A non-null value must be provided for groupId" }
    /**
     * The globally unique identifier for the identity store.
     */
    public val identityStoreId: kotlin.String = requireNotNull(builder.identityStoreId) { "A non-null value must be provided for identityStoreId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.identitystore.model.Group = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Group(")
        append("description=*** Sensitive Data Redacted ***,")
        append("displayName=*** Sensitive Data Redacted ***,")
        append("externalIds=$externalIds,")
        append("groupId=$groupId,")
        append("identityStoreId=$identityStoreId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (externalIds?.hashCode() ?: 0)
        result = 31 * result + (groupId.hashCode())
        result = 31 * result + (identityStoreId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Group

        if (description != other.description) return false
        if (displayName != other.displayName) return false
        if (externalIds != other.externalIds) return false
        if (groupId != other.groupId) return false
        if (identityStoreId != other.identityStoreId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.identitystore.model.Group = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A string containing a description of the specified group.
         */
        public var description: kotlin.String? = null
        /**
         * The display name value for the group. The length limit is 1,024 characters. This value can consist of letters, accented characters, symbols, numbers, punctuation, tab, new line, carriage return, space, and nonbreaking space in this attribute. This value is specified at the time the group is created and stored as an attribute of the group object in the identity store.
         */
        public var displayName: kotlin.String? = null
        /**
         * A list of `ExternalId` objects that contains the identifiers issued to this resource by an external identity provider.
         */
        public var externalIds: List<ExternalId>? = null
        /**
         * The identifier for a group in the identity store.
         */
        public var groupId: kotlin.String? = null
        /**
         * The globally unique identifier for the identity store.
         */
        public var identityStoreId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.identitystore.model.Group) : this() {
            this.description = x.description
            this.displayName = x.displayName
            this.externalIds = x.externalIds
            this.groupId = x.groupId
            this.identityStoreId = x.identityStoreId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.identitystore.model.Group = Group(this)

        internal fun correctErrors(): Builder {
            if (groupId == null) groupId = ""
            if (identityStoreId == null) identityStoreId = ""
            return this
        }
    }
}
