// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.identitystore.model

import aws.smithy.kotlin.runtime.SdkDsl

public class DescribeUserResponse private constructor(builder: Builder) {
    /**
     * The physical address of the user.
     */
    public val addresses: List<Address>? = builder.addresses
    /**
     * The display name of the user.
     */
    public val displayName: kotlin.String? = builder.displayName
    /**
     * The email address of the user.
     */
    public val emails: List<Email>? = builder.emails
    /**
     * A list of `ExternalId` objects that contains the identifiers issued to this resource by an external identity provider.
     */
    public val externalIds: List<ExternalId>? = builder.externalIds
    /**
     * The globally unique identifier for the identity store.
     */
    public val identityStoreId: kotlin.String = requireNotNull(builder.identityStoreId) { "A non-null value must be provided for identityStoreId" }
    /**
     * A string containing the geographical region or location of the user.
     */
    public val locale: kotlin.String? = builder.locale
    /**
     * The name of the user.
     */
    public val name: aws.sdk.kotlin.services.identitystore.model.Name? = builder.name
    /**
     * An alternative descriptive name for the user.
     */
    public val nickName: kotlin.String? = builder.nickName
    /**
     * A list of `PhoneNumber` objects associated with a user.
     */
    public val phoneNumbers: List<PhoneNumber>? = builder.phoneNumbers
    /**
     * The preferred language of the user.
     */
    public val preferredLanguage: kotlin.String? = builder.preferredLanguage
    /**
     * A URL link for the user's profile.
     */
    public val profileUrl: kotlin.String? = builder.profileUrl
    /**
     * The time zone for a user.
     */
    public val timezone: kotlin.String? = builder.timezone
    /**
     * A string containing the title of the user.
     */
    public val title: kotlin.String? = builder.title
    /**
     * The identifier for a user in the identity store.
     */
    public val userId: kotlin.String = requireNotNull(builder.userId) { "A non-null value must be provided for userId" }
    /**
     * A unique string used to identify the user. The length limit is 128 characters. This value can consist of letters, accented characters, symbols, numbers, and punctuation. This value is specified at the time the user is created and stored as an attribute of the user object in the identity store.
     */
    public val userName: kotlin.String? = builder.userName
    /**
     * A string indicating the type of user.
     */
    public val userType: kotlin.String? = builder.userType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.identitystore.model.DescribeUserResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeUserResponse(")
        append("addresses=$addresses,")
        append("displayName=*** Sensitive Data Redacted ***,")
        append("emails=$emails,")
        append("externalIds=$externalIds,")
        append("identityStoreId=$identityStoreId,")
        append("locale=*** Sensitive Data Redacted ***,")
        append("name=$name,")
        append("nickName=*** Sensitive Data Redacted ***,")
        append("phoneNumbers=$phoneNumbers,")
        append("preferredLanguage=*** Sensitive Data Redacted ***,")
        append("profileUrl=*** Sensitive Data Redacted ***,")
        append("timezone=*** Sensitive Data Redacted ***,")
        append("title=*** Sensitive Data Redacted ***,")
        append("userId=$userId,")
        append("userName=*** Sensitive Data Redacted ***,")
        append("userType=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = addresses?.hashCode() ?: 0
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (emails?.hashCode() ?: 0)
        result = 31 * result + (externalIds?.hashCode() ?: 0)
        result = 31 * result + (identityStoreId.hashCode())
        result = 31 * result + (locale?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (nickName?.hashCode() ?: 0)
        result = 31 * result + (phoneNumbers?.hashCode() ?: 0)
        result = 31 * result + (preferredLanguage?.hashCode() ?: 0)
        result = 31 * result + (profileUrl?.hashCode() ?: 0)
        result = 31 * result + (timezone?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        result = 31 * result + (userId.hashCode())
        result = 31 * result + (userName?.hashCode() ?: 0)
        result = 31 * result + (userType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeUserResponse

        if (addresses != other.addresses) return false
        if (displayName != other.displayName) return false
        if (emails != other.emails) return false
        if (externalIds != other.externalIds) return false
        if (identityStoreId != other.identityStoreId) return false
        if (locale != other.locale) return false
        if (name != other.name) return false
        if (nickName != other.nickName) return false
        if (phoneNumbers != other.phoneNumbers) return false
        if (preferredLanguage != other.preferredLanguage) return false
        if (profileUrl != other.profileUrl) return false
        if (timezone != other.timezone) return false
        if (title != other.title) return false
        if (userId != other.userId) return false
        if (userName != other.userName) return false
        if (userType != other.userType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.identitystore.model.DescribeUserResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The physical address of the user.
         */
        public var addresses: List<Address>? = null
        /**
         * The display name of the user.
         */
        public var displayName: kotlin.String? = null
        /**
         * The email address of the user.
         */
        public var emails: List<Email>? = null
        /**
         * A list of `ExternalId` objects that contains the identifiers issued to this resource by an external identity provider.
         */
        public var externalIds: List<ExternalId>? = null
        /**
         * The globally unique identifier for the identity store.
         */
        public var identityStoreId: kotlin.String? = null
        /**
         * A string containing the geographical region or location of the user.
         */
        public var locale: kotlin.String? = null
        /**
         * The name of the user.
         */
        public var name: aws.sdk.kotlin.services.identitystore.model.Name? = null
        /**
         * An alternative descriptive name for the user.
         */
        public var nickName: kotlin.String? = null
        /**
         * A list of `PhoneNumber` objects associated with a user.
         */
        public var phoneNumbers: List<PhoneNumber>? = null
        /**
         * The preferred language of the user.
         */
        public var preferredLanguage: kotlin.String? = null
        /**
         * A URL link for the user's profile.
         */
        public var profileUrl: kotlin.String? = null
        /**
         * The time zone for a user.
         */
        public var timezone: kotlin.String? = null
        /**
         * A string containing the title of the user.
         */
        public var title: kotlin.String? = null
        /**
         * The identifier for a user in the identity store.
         */
        public var userId: kotlin.String? = null
        /**
         * A unique string used to identify the user. The length limit is 128 characters. This value can consist of letters, accented characters, symbols, numbers, and punctuation. This value is specified at the time the user is created and stored as an attribute of the user object in the identity store.
         */
        public var userName: kotlin.String? = null
        /**
         * A string indicating the type of user.
         */
        public var userType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.identitystore.model.DescribeUserResponse) : this() {
            this.addresses = x.addresses
            this.displayName = x.displayName
            this.emails = x.emails
            this.externalIds = x.externalIds
            this.identityStoreId = x.identityStoreId
            this.locale = x.locale
            this.name = x.name
            this.nickName = x.nickName
            this.phoneNumbers = x.phoneNumbers
            this.preferredLanguage = x.preferredLanguage
            this.profileUrl = x.profileUrl
            this.timezone = x.timezone
            this.title = x.title
            this.userId = x.userId
            this.userName = x.userName
            this.userType = x.userType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.identitystore.model.DescribeUserResponse = DescribeUserResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.identitystore.model.Name] inside the given [block]
         */
        public fun name(block: aws.sdk.kotlin.services.identitystore.model.Name.Builder.() -> kotlin.Unit) {
            this.name = aws.sdk.kotlin.services.identitystore.model.Name.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (identityStoreId == null) identityStoreId = ""
            if (userId == null) userId = ""
            return this
        }
    }
}
