// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.identitystore

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.identitystore.auth.DefaultIdentitystoreAuthSchemeProvider
import aws.sdk.kotlin.services.identitystore.auth.IdentitystoreAuthSchemeProvider
import aws.sdk.kotlin.services.identitystore.endpoints.DefaultIdentitystoreEndpointProvider
import aws.sdk.kotlin.services.identitystore.endpoints.IdentitystoreEndpointParameters
import aws.sdk.kotlin.services.identitystore.endpoints.IdentitystoreEndpointProvider
import aws.sdk.kotlin.services.identitystore.model.CreateGroupMembershipRequest
import aws.sdk.kotlin.services.identitystore.model.CreateGroupMembershipResponse
import aws.sdk.kotlin.services.identitystore.model.CreateGroupRequest
import aws.sdk.kotlin.services.identitystore.model.CreateGroupResponse
import aws.sdk.kotlin.services.identitystore.model.CreateUserRequest
import aws.sdk.kotlin.services.identitystore.model.CreateUserResponse
import aws.sdk.kotlin.services.identitystore.model.DeleteGroupMembershipRequest
import aws.sdk.kotlin.services.identitystore.model.DeleteGroupMembershipResponse
import aws.sdk.kotlin.services.identitystore.model.DeleteGroupRequest
import aws.sdk.kotlin.services.identitystore.model.DeleteGroupResponse
import aws.sdk.kotlin.services.identitystore.model.DeleteUserRequest
import aws.sdk.kotlin.services.identitystore.model.DeleteUserResponse
import aws.sdk.kotlin.services.identitystore.model.DescribeGroupMembershipRequest
import aws.sdk.kotlin.services.identitystore.model.DescribeGroupMembershipResponse
import aws.sdk.kotlin.services.identitystore.model.DescribeGroupRequest
import aws.sdk.kotlin.services.identitystore.model.DescribeGroupResponse
import aws.sdk.kotlin.services.identitystore.model.DescribeUserRequest
import aws.sdk.kotlin.services.identitystore.model.DescribeUserResponse
import aws.sdk.kotlin.services.identitystore.model.GetGroupIdRequest
import aws.sdk.kotlin.services.identitystore.model.GetGroupIdResponse
import aws.sdk.kotlin.services.identitystore.model.GetGroupMembershipIdRequest
import aws.sdk.kotlin.services.identitystore.model.GetGroupMembershipIdResponse
import aws.sdk.kotlin.services.identitystore.model.GetUserIdRequest
import aws.sdk.kotlin.services.identitystore.model.GetUserIdResponse
import aws.sdk.kotlin.services.identitystore.model.IsMemberInGroupsRequest
import aws.sdk.kotlin.services.identitystore.model.IsMemberInGroupsResponse
import aws.sdk.kotlin.services.identitystore.model.ListGroupMembershipsForMemberRequest
import aws.sdk.kotlin.services.identitystore.model.ListGroupMembershipsForMemberResponse
import aws.sdk.kotlin.services.identitystore.model.ListGroupMembershipsRequest
import aws.sdk.kotlin.services.identitystore.model.ListGroupMembershipsResponse
import aws.sdk.kotlin.services.identitystore.model.ListGroupsRequest
import aws.sdk.kotlin.services.identitystore.model.ListGroupsResponse
import aws.sdk.kotlin.services.identitystore.model.ListUsersRequest
import aws.sdk.kotlin.services.identitystore.model.ListUsersResponse
import aws.sdk.kotlin.services.identitystore.model.UpdateGroupRequest
import aws.sdk.kotlin.services.identitystore.model.UpdateGroupResponse
import aws.sdk.kotlin.services.identitystore.model.UpdateUserRequest
import aws.sdk.kotlin.services.identitystore.model.UpdateUserResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "identitystore"
public const val SdkVersion: String = "1.2.3"
public const val ServiceApiVersion: String = "2020-06-15"

/**
 * The Identity Store service used by IAM Identity Center provides a single place to retrieve all of your identities (users and groups). For more information, see the [IAM Identity Center User Guide](https://docs.aws.amazon.com/singlesignon/latest/userguide/what-is.html).
 *
 * This reference guide describes the identity store operations that you can call programmatically and includes detailed information about data types and errors.
 *
 * IAM Identity Center uses the `sso` and `identitystore` API namespaces.
 */
public interface IdentitystoreClient : SdkClient {
    /**
     * IdentitystoreClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, IdentitystoreClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Identitystore",
                "IDENTITYSTORE",
                "identitystore",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, IdentitystoreClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): IdentitystoreClient = DefaultIdentitystoreClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: IdentitystoreEndpointProvider = builder.endpointProvider ?: DefaultIdentitystoreEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: IdentitystoreAuthSchemeProvider = builder.authSchemeProvider ?: DefaultIdentitystoreAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "identitystore"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: IdentitystoreEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: IdentitystoreAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a group within the specified identity store.
     */
    public suspend fun createGroup(input: CreateGroupRequest): CreateGroupResponse

    /**
     * Creates a relationship between a member and a group. The following identifiers must be specified: `GroupId`, `IdentityStoreId`, and `MemberId`.
     */
    public suspend fun createGroupMembership(input: CreateGroupMembershipRequest): CreateGroupMembershipResponse

    /**
     * Creates a user within the specified identity store.
     */
    public suspend fun createUser(input: CreateUserRequest): CreateUserResponse

    /**
     * Delete a group within an identity store given `GroupId`.
     */
    public suspend fun deleteGroup(input: DeleteGroupRequest): DeleteGroupResponse

    /**
     * Delete a membership within a group given `MembershipId`.
     */
    public suspend fun deleteGroupMembership(input: DeleteGroupMembershipRequest): DeleteGroupMembershipResponse

    /**
     * Deletes a user within an identity store given `UserId`.
     */
    public suspend fun deleteUser(input: DeleteUserRequest): DeleteUserResponse

    /**
     * Retrieves the group metadata and attributes from `GroupId` in an identity store.
     *
     * If you have administrator access to a member account, you can use this API from the member account. Read about [member accounts](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html) in the *Organizations User Guide*.
     */
    public suspend fun describeGroup(input: DescribeGroupRequest): DescribeGroupResponse

    /**
     * Retrieves membership metadata and attributes from `MembershipId` in an identity store.
     *
     * If you have administrator access to a member account, you can use this API from the member account. Read about [member accounts](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html) in the *Organizations User Guide*.
     */
    public suspend fun describeGroupMembership(input: DescribeGroupMembershipRequest): DescribeGroupMembershipResponse

    /**
     * Retrieves the user metadata and attributes from the `UserId` in an identity store.
     *
     * If you have administrator access to a member account, you can use this API from the member account. Read about [member accounts](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html) in the *Organizations User Guide*.
     */
    public suspend fun describeUser(input: DescribeUserRequest): DescribeUserResponse

    /**
     * Retrieves `GroupId` in an identity store.
     *
     * If you have administrator access to a member account, you can use this API from the member account. Read about [member accounts](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html) in the *Organizations User Guide*.
     */
    public suspend fun getGroupId(input: GetGroupIdRequest): GetGroupIdResponse

    /**
     * Retrieves the `MembershipId` in an identity store.
     *
     * If you have administrator access to a member account, you can use this API from the member account. Read about [member accounts](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html) in the *Organizations User Guide*.
     */
    public suspend fun getGroupMembershipId(input: GetGroupMembershipIdRequest): GetGroupMembershipIdResponse

    /**
     * Retrieves the `UserId` in an identity store.
     *
     * If you have administrator access to a member account, you can use this API from the member account. Read about [member accounts](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html) in the *Organizations User Guide*.
     */
    public suspend fun getUserId(input: GetUserIdRequest): GetUserIdResponse

    /**
     * Checks the user's membership in all requested groups and returns if the member exists in all queried groups.
     *
     * If you have administrator access to a member account, you can use this API from the member account. Read about [member accounts](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html) in the *Organizations User Guide*.
     */
    public suspend fun isMemberInGroups(input: IsMemberInGroupsRequest): IsMemberInGroupsResponse

    /**
     * For the specified group in the specified identity store, returns the list of all `GroupMembership` objects and returns results in paginated form.
     *
     * If you have administrator access to a member account, you can use this API from the member account. Read about [member accounts](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html) in the *Organizations User Guide*.
     */
    public suspend fun listGroupMemberships(input: ListGroupMembershipsRequest): ListGroupMembershipsResponse

    /**
     * For the specified member in the specified identity store, returns the list of all `GroupMembership` objects and returns results in paginated form.
     *
     * If you have administrator access to a member account, you can use this API from the member account. Read about [member accounts](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html) in the *Organizations User Guide*.
     */
    public suspend fun listGroupMembershipsForMember(input: ListGroupMembershipsForMemberRequest): ListGroupMembershipsForMemberResponse

    /**
     * Lists all groups in the identity store. Returns a paginated list of complete `Group` objects. Filtering for a `Group` by the `DisplayName` attribute is deprecated. Instead, use the `GetGroupId` API action.
     *
     * If you have administrator access to a member account, you can use this API from the member account. Read about [member accounts](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html) in the *Organizations User Guide*.
     */
    public suspend fun listGroups(input: ListGroupsRequest): ListGroupsResponse

    /**
     * Lists all users in the identity store. Returns a paginated list of complete `User` objects. Filtering for a `User` by the `UserName` attribute is deprecated. Instead, use the `GetUserId` API action.
     *
     * If you have administrator access to a member account, you can use this API from the member account. Read about [member accounts](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html) in the *Organizations User Guide*.
     */
    public suspend fun listUsers(input: ListUsersRequest): ListUsersResponse

    /**
     * For the specified group in the specified identity store, updates the group metadata and attributes.
     */
    public suspend fun updateGroup(input: UpdateGroupRequest): UpdateGroupResponse

    /**
     * For the specified user in the specified identity store, updates the user metadata and attributes.
     */
    public suspend fun updateUser(input: UpdateUserRequest): UpdateUserResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun IdentitystoreClient.withConfig(block: IdentitystoreClient.Config.Builder.() -> Unit): IdentitystoreClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultIdentitystoreClient(newConfig)
}

/**
 * Creates a group within the specified identity store.
 */
public suspend inline fun IdentitystoreClient.createGroup(crossinline block: CreateGroupRequest.Builder.() -> Unit): CreateGroupResponse = createGroup(CreateGroupRequest.Builder().apply(block).build())

/**
 * Creates a relationship between a member and a group. The following identifiers must be specified: `GroupId`, `IdentityStoreId`, and `MemberId`.
 */
public suspend inline fun IdentitystoreClient.createGroupMembership(crossinline block: CreateGroupMembershipRequest.Builder.() -> Unit): CreateGroupMembershipResponse = createGroupMembership(CreateGroupMembershipRequest.Builder().apply(block).build())

/**
 * Creates a user within the specified identity store.
 */
public suspend inline fun IdentitystoreClient.createUser(crossinline block: CreateUserRequest.Builder.() -> Unit): CreateUserResponse = createUser(CreateUserRequest.Builder().apply(block).build())

/**
 * Delete a group within an identity store given `GroupId`.
 */
public suspend inline fun IdentitystoreClient.deleteGroup(crossinline block: DeleteGroupRequest.Builder.() -> Unit): DeleteGroupResponse = deleteGroup(DeleteGroupRequest.Builder().apply(block).build())

/**
 * Delete a membership within a group given `MembershipId`.
 */
public suspend inline fun IdentitystoreClient.deleteGroupMembership(crossinline block: DeleteGroupMembershipRequest.Builder.() -> Unit): DeleteGroupMembershipResponse = deleteGroupMembership(DeleteGroupMembershipRequest.Builder().apply(block).build())

/**
 * Deletes a user within an identity store given `UserId`.
 */
public suspend inline fun IdentitystoreClient.deleteUser(crossinline block: DeleteUserRequest.Builder.() -> Unit): DeleteUserResponse = deleteUser(DeleteUserRequest.Builder().apply(block).build())

/**
 * Retrieves the group metadata and attributes from `GroupId` in an identity store.
 *
 * If you have administrator access to a member account, you can use this API from the member account. Read about [member accounts](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html) in the *Organizations User Guide*.
 */
public suspend inline fun IdentitystoreClient.describeGroup(crossinline block: DescribeGroupRequest.Builder.() -> Unit): DescribeGroupResponse = describeGroup(DescribeGroupRequest.Builder().apply(block).build())

/**
 * Retrieves membership metadata and attributes from `MembershipId` in an identity store.
 *
 * If you have administrator access to a member account, you can use this API from the member account. Read about [member accounts](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html) in the *Organizations User Guide*.
 */
public suspend inline fun IdentitystoreClient.describeGroupMembership(crossinline block: DescribeGroupMembershipRequest.Builder.() -> Unit): DescribeGroupMembershipResponse = describeGroupMembership(DescribeGroupMembershipRequest.Builder().apply(block).build())

/**
 * Retrieves the user metadata and attributes from the `UserId` in an identity store.
 *
 * If you have administrator access to a member account, you can use this API from the member account. Read about [member accounts](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html) in the *Organizations User Guide*.
 */
public suspend inline fun IdentitystoreClient.describeUser(crossinline block: DescribeUserRequest.Builder.() -> Unit): DescribeUserResponse = describeUser(DescribeUserRequest.Builder().apply(block).build())

/**
 * Retrieves `GroupId` in an identity store.
 *
 * If you have administrator access to a member account, you can use this API from the member account. Read about [member accounts](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html) in the *Organizations User Guide*.
 */
public suspend inline fun IdentitystoreClient.getGroupId(crossinline block: GetGroupIdRequest.Builder.() -> Unit): GetGroupIdResponse = getGroupId(GetGroupIdRequest.Builder().apply(block).build())

/**
 * Retrieves the `MembershipId` in an identity store.
 *
 * If you have administrator access to a member account, you can use this API from the member account. Read about [member accounts](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html) in the *Organizations User Guide*.
 */
public suspend inline fun IdentitystoreClient.getGroupMembershipId(crossinline block: GetGroupMembershipIdRequest.Builder.() -> Unit): GetGroupMembershipIdResponse = getGroupMembershipId(GetGroupMembershipIdRequest.Builder().apply(block).build())

/**
 * Retrieves the `UserId` in an identity store.
 *
 * If you have administrator access to a member account, you can use this API from the member account. Read about [member accounts](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html) in the *Organizations User Guide*.
 */
public suspend inline fun IdentitystoreClient.getUserId(crossinline block: GetUserIdRequest.Builder.() -> Unit): GetUserIdResponse = getUserId(GetUserIdRequest.Builder().apply(block).build())

/**
 * Checks the user's membership in all requested groups and returns if the member exists in all queried groups.
 *
 * If you have administrator access to a member account, you can use this API from the member account. Read about [member accounts](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html) in the *Organizations User Guide*.
 */
public suspend inline fun IdentitystoreClient.isMemberInGroups(crossinline block: IsMemberInGroupsRequest.Builder.() -> Unit): IsMemberInGroupsResponse = isMemberInGroups(IsMemberInGroupsRequest.Builder().apply(block).build())

/**
 * For the specified group in the specified identity store, returns the list of all `GroupMembership` objects and returns results in paginated form.
 *
 * If you have administrator access to a member account, you can use this API from the member account. Read about [member accounts](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html) in the *Organizations User Guide*.
 */
public suspend inline fun IdentitystoreClient.listGroupMemberships(crossinline block: ListGroupMembershipsRequest.Builder.() -> Unit): ListGroupMembershipsResponse = listGroupMemberships(ListGroupMembershipsRequest.Builder().apply(block).build())

/**
 * For the specified member in the specified identity store, returns the list of all `GroupMembership` objects and returns results in paginated form.
 *
 * If you have administrator access to a member account, you can use this API from the member account. Read about [member accounts](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html) in the *Organizations User Guide*.
 */
public suspend inline fun IdentitystoreClient.listGroupMembershipsForMember(crossinline block: ListGroupMembershipsForMemberRequest.Builder.() -> Unit): ListGroupMembershipsForMemberResponse = listGroupMembershipsForMember(ListGroupMembershipsForMemberRequest.Builder().apply(block).build())

/**
 * Lists all groups in the identity store. Returns a paginated list of complete `Group` objects. Filtering for a `Group` by the `DisplayName` attribute is deprecated. Instead, use the `GetGroupId` API action.
 *
 * If you have administrator access to a member account, you can use this API from the member account. Read about [member accounts](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html) in the *Organizations User Guide*.
 */
public suspend inline fun IdentitystoreClient.listGroups(crossinline block: ListGroupsRequest.Builder.() -> Unit): ListGroupsResponse = listGroups(ListGroupsRequest.Builder().apply(block).build())

/**
 * Lists all users in the identity store. Returns a paginated list of complete `User` objects. Filtering for a `User` by the `UserName` attribute is deprecated. Instead, use the `GetUserId` API action.
 *
 * If you have administrator access to a member account, you can use this API from the member account. Read about [member accounts](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html) in the *Organizations User Guide*.
 */
public suspend inline fun IdentitystoreClient.listUsers(crossinline block: ListUsersRequest.Builder.() -> Unit): ListUsersResponse = listUsers(ListUsersRequest.Builder().apply(block).build())

/**
 * For the specified group in the specified identity store, updates the group metadata and attributes.
 */
public suspend inline fun IdentitystoreClient.updateGroup(crossinline block: UpdateGroupRequest.Builder.() -> Unit): UpdateGroupResponse = updateGroup(UpdateGroupRequest.Builder().apply(block).build())

/**
 * For the specified user in the specified identity store, updates the user metadata and attributes.
 */
public suspend inline fun IdentitystoreClient.updateUser(crossinline block: UpdateUserRequest.Builder.() -> Unit): UpdateUserResponse = updateUser(UpdateUserRequest.Builder().apply(block).build())
