// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.identitystore.paginators

import aws.sdk.kotlin.services.identitystore.IdentitystoreClient
import aws.sdk.kotlin.services.identitystore.model.GroupMembership
import aws.sdk.kotlin.services.identitystore.model.ListGroupMembershipsForMemberRequest
import aws.sdk.kotlin.services.identitystore.model.ListGroupMembershipsForMemberResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListGroupMembershipsForMemberResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListGroupMembershipsForMemberRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGroupMembershipsForMemberResponse]
 */
public fun IdentitystoreClient.listGroupMembershipsForMemberPaginated(initialRequest: ListGroupMembershipsForMemberRequest): Flow<ListGroupMembershipsForMemberResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listGroupMembershipsForMemberPaginated.listGroupMembershipsForMember(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListGroupMembershipsForMemberResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGroupMembershipsForMemberResponse]
 */
public fun IdentitystoreClient.listGroupMembershipsForMemberPaginated(block: ListGroupMembershipsForMemberRequest.Builder.() -> Unit): Flow<ListGroupMembershipsForMemberResponse> =
    listGroupMembershipsForMemberPaginated(ListGroupMembershipsForMemberRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listGroupMembershipsForMemberPaginated]
 * to access the nested member [GroupMembership]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GroupMembership]
 */
@JvmName("listGroupMembershipsForMemberResponseGroupMembership")
public fun Flow<ListGroupMembershipsForMemberResponse>.groupMemberships(): Flow<GroupMembership> =
    transform() { response ->
        response.groupMemberships?.forEach {
            emit(it)
        }
    }
