// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.identitystore.model

import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * Indicates that a requested resource is not found.
 */
public class ResourceNotFoundException private constructor(builder: Builder) : IdentitystoreException() {

    override val message: kotlin.String? = builder.message
    /**
     * The identifier for each request. This value is a globally unique ID that is generated by the identity store service for each sent request, and is then returned inside the exception if the request fails.
     */
    public val requestId: kotlin.String? = builder.requestId
    /**
     * The identifier for a resource in the identity store that can be used as `UserId` or `GroupId`. The format for `ResourceId` is either `UUID` or `1234567890-UUID`, where `UUID` is a randomly generated value for each resource when it is created and `1234567890` represents the `IdentityStoreId` string value. In the case that the identity store is migrated from a legacy SSO identity store, the `ResourceId` for that identity store will be in the format of `UUID`. Otherwise, it will be in the `1234567890-UUID` format.
     */
    public val resourceId: kotlin.String? = builder.resourceId
    /**
     * An enum object indicating the type of resource in the identity store service. Valid values include USER, GROUP, and IDENTITY_STORE.
     */
    public val resourceType: aws.sdk.kotlin.services.identitystore.model.ResourceType? = builder.resourceType

    init {
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Client
    }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.identitystore.model.ResourceNotFoundException = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceNotFoundException(")
        append("message=$message,")
        append("requestId=$requestId,")
        append("resourceId=$resourceId,")
        append("resourceType=$resourceType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = message?.hashCode() ?: 0
        result = 31 * result + (requestId?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceNotFoundException

        if (message != other.message) return false
        if (requestId != other.requestId) return false
        if (resourceId != other.resourceId) return false
        if (resourceType != other.resourceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.identitystore.model.ResourceNotFoundException = Builder(this).apply(block).build()

    public class Builder {
        public var message: kotlin.String? = null
        /**
         * The identifier for each request. This value is a globally unique ID that is generated by the identity store service for each sent request, and is then returned inside the exception if the request fails.
         */
        public var requestId: kotlin.String? = null
        /**
         * The identifier for a resource in the identity store that can be used as `UserId` or `GroupId`. The format for `ResourceId` is either `UUID` or `1234567890-UUID`, where `UUID` is a randomly generated value for each resource when it is created and `1234567890` represents the `IdentityStoreId` string value. In the case that the identity store is migrated from a legacy SSO identity store, the `ResourceId` for that identity store will be in the format of `UUID`. Otherwise, it will be in the `1234567890-UUID` format.
         */
        public var resourceId: kotlin.String? = null
        /**
         * An enum object indicating the type of resource in the identity store service. Valid values include USER, GROUP, and IDENTITY_STORE.
         */
        public var resourceType: aws.sdk.kotlin.services.identitystore.model.ResourceType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.identitystore.model.ResourceNotFoundException) : this() {
            this.message = x.message
            this.requestId = x.requestId
            this.resourceId = x.resourceId
            this.resourceType = x.resourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.identitystore.model.ResourceNotFoundException = ResourceNotFoundException(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
