// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.identitystore.model



public class ListGroupMembershipsForMemberRequest private constructor(builder: Builder) {
    /**
     * The globally unique identifier for the identity store.
     */
    public val identityStoreId: kotlin.String = requireNotNull(builder.identityStoreId) { "A non-null value must be provided for identityStoreId" }
    /**
     * The maximum number of results to be returned per request. This parameter is used in the `ListUsers` and `ListGroups` requests to specify how many results to return in one page. The length limit is 50 characters.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * An object that contains the identifier of a group member. Setting the `UserID` field to the specific identifier for a user indicates that the user is a member of the group.
     */
    public val memberId: aws.sdk.kotlin.services.identitystore.model.MemberId? = builder.memberId
    /**
     * The pagination token used for the `ListUsers`, `ListGroups`, and `ListGroupMemberships` API operations. This value is generated by the identity store service. It is returned in the API response if the total results are more than the size of one page. This token is also returned when it is used in the API request to search for the next page.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.identitystore.model.ListGroupMembershipsForMemberRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListGroupMembershipsForMemberRequest(")
        append("identityStoreId=$identityStoreId,")
        append("maxResults=$maxResults,")
        append("memberId=$memberId,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = identityStoreId.hashCode()
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (memberId?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListGroupMembershipsForMemberRequest

        if (identityStoreId != other.identityStoreId) return false
        if (maxResults != other.maxResults) return false
        if (memberId != other.memberId) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.identitystore.model.ListGroupMembershipsForMemberRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The globally unique identifier for the identity store.
         */
        public var identityStoreId: kotlin.String? = null
        /**
         * The maximum number of results to be returned per request. This parameter is used in the `ListUsers` and `ListGroups` requests to specify how many results to return in one page. The length limit is 50 characters.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * An object that contains the identifier of a group member. Setting the `UserID` field to the specific identifier for a user indicates that the user is a member of the group.
         */
        public var memberId: aws.sdk.kotlin.services.identitystore.model.MemberId? = null
        /**
         * The pagination token used for the `ListUsers`, `ListGroups`, and `ListGroupMemberships` API operations. This value is generated by the identity store service. It is returned in the API response if the total results are more than the size of one page. This token is also returned when it is used in the API request to search for the next page.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.identitystore.model.ListGroupMembershipsForMemberRequest) : this() {
            this.identityStoreId = x.identityStoreId
            this.maxResults = x.maxResults
            this.memberId = x.memberId
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.identitystore.model.ListGroupMembershipsForMemberRequest = ListGroupMembershipsForMemberRequest(this)

        internal fun correctErrors(): Builder {
            if (identityStoreId == null) identityStoreId = ""
            return this
        }
    }
}
