// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.identitystore.model



/**
 * Contains the identifiers for a group, a group member, and a `GroupMembership` object in the identity store.
 */
public class GroupMembership private constructor(builder: Builder) {
    /**
     * The identifier for a group in the identity store.
     */
    public val groupId: kotlin.String? = builder.groupId
    /**
     * The globally unique identifier for the identity store.
     */
    public val identityStoreId: kotlin.String = requireNotNull(builder.identityStoreId) { "A non-null value must be provided for identityStoreId" }
    /**
     * An object that contains the identifier of a group member. Setting the `UserID` field to the specific identifier for a user indicates that the user is a member of the group.
     */
    public val memberId: aws.sdk.kotlin.services.identitystore.model.MemberId? = builder.memberId
    /**
     * The identifier for a `GroupMembership` object in an identity store.
     */
    public val membershipId: kotlin.String? = builder.membershipId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.identitystore.model.GroupMembership = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GroupMembership(")
        append("groupId=$groupId,")
        append("identityStoreId=$identityStoreId,")
        append("memberId=$memberId,")
        append("membershipId=$membershipId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = groupId?.hashCode() ?: 0
        result = 31 * result + (identityStoreId.hashCode())
        result = 31 * result + (memberId?.hashCode() ?: 0)
        result = 31 * result + (membershipId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GroupMembership

        if (groupId != other.groupId) return false
        if (identityStoreId != other.identityStoreId) return false
        if (memberId != other.memberId) return false
        if (membershipId != other.membershipId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.identitystore.model.GroupMembership = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier for a group in the identity store.
         */
        public var groupId: kotlin.String? = null
        /**
         * The globally unique identifier for the identity store.
         */
        public var identityStoreId: kotlin.String? = null
        /**
         * An object that contains the identifier of a group member. Setting the `UserID` field to the specific identifier for a user indicates that the user is a member of the group.
         */
        public var memberId: aws.sdk.kotlin.services.identitystore.model.MemberId? = null
        /**
         * The identifier for a `GroupMembership` object in an identity store.
         */
        public var membershipId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.identitystore.model.GroupMembership) : this() {
            this.groupId = x.groupId
            this.identityStoreId = x.identityStoreId
            this.memberId = x.memberId
            this.membershipId = x.membershipId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.identitystore.model.GroupMembership = GroupMembership(this)

        internal fun correctErrors(): Builder {
            if (identityStoreId == null) identityStoreId = ""
            return this
        }
    }
}
