// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.identitystore.model



/**
 * A query filter used by `ListUsers` and `ListGroups`. This filter object provides the attribute name and attribute value to search users or groups.
 */
public class Filter private constructor(builder: Builder) {
    /**
     * The attribute path that is used to specify which attribute name to search. Length limit is 255 characters. For example, `UserName` is a valid attribute path for the `ListUsers` API, and `DisplayName` is a valid attribute path for the `ListGroups` API.
     */
    public val attributePath: kotlin.String = requireNotNull(builder.attributePath) { "A non-null value must be provided for attributePath" }
    /**
     * Represents the data for an attribute. Each attribute value is described as a name-value pair.
     */
    public val attributeValue: kotlin.String = requireNotNull(builder.attributeValue) { "A non-null value must be provided for attributeValue" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.identitystore.model.Filter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Filter(")
        append("attributePath=$attributePath,")
        append("attributeValue=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributePath.hashCode()
        result = 31 * result + (attributeValue.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Filter

        if (attributePath != other.attributePath) return false
        if (attributeValue != other.attributeValue) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.identitystore.model.Filter = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The attribute path that is used to specify which attribute name to search. Length limit is 255 characters. For example, `UserName` is a valid attribute path for the `ListUsers` API, and `DisplayName` is a valid attribute path for the `ListGroups` API.
         */
        public var attributePath: kotlin.String? = null
        /**
         * Represents the data for an attribute. Each attribute value is described as a name-value pair.
         */
        public var attributeValue: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.identitystore.model.Filter) : this() {
            this.attributePath = x.attributePath
            this.attributeValue = x.attributeValue
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.identitystore.model.Filter = Filter(this)

        internal fun correctErrors(): Builder {
            if (attributePath == null) attributePath = ""
            if (attributeValue == null) attributeValue = ""
            return this
        }
    }
}
