// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.identitystore.serde

import aws.sdk.kotlin.services.identitystore.model.DescribeGroupMembershipResponse
import aws.sdk.kotlin.services.identitystore.model.IdentitystoreException
import aws.sdk.kotlin.services.identitystore.model.MemberId
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeGroupMembershipOperationDeserializer: HttpDeserialize<DescribeGroupMembershipResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeGroupMembershipResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeGroupMembershipError(context, call)
        }
        val builder = DescribeGroupMembershipResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeGroupMembershipOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeGroupMembershipError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IdentitystoreException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        else -> IdentitystoreException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeGroupMembershipOperationBody(builder: DescribeGroupMembershipResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val GROUPID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("GroupId"))
    val IDENTITYSTOREID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IdentityStoreId"))
    val MEMBERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("MemberId"))
    val MEMBERSHIPID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MembershipId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(GROUPID_DESCRIPTOR)
        field(IDENTITYSTOREID_DESCRIPTOR)
        field(MEMBERID_DESCRIPTOR)
        field(MEMBERSHIPID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                GROUPID_DESCRIPTOR.index -> builder.groupId = deserializeString()
                IDENTITYSTOREID_DESCRIPTOR.index -> builder.identityStoreId = deserializeString()
                MEMBERID_DESCRIPTOR.index -> builder.memberId = deserializeMemberIdDocument(deserializer)
                MEMBERSHIPID_DESCRIPTOR.index -> builder.membershipId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
