// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.identitystore.model



public class ListGroupMembershipsRequest private constructor(builder: Builder) {
    /**
     * The identifier for a group in the identity store.
     */
    public val groupId: kotlin.String = requireNotNull(builder.groupId) { "A non-null value must be provided for groupId" }
    /**
     * The globally unique identifier for the identity store.
     */
    public val identityStoreId: kotlin.String = requireNotNull(builder.identityStoreId) { "A non-null value must be provided for identityStoreId" }
    /**
     * The maximum number of results to be returned per request. This parameter is used in all `List` requests to specify how many results to return in one page.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The pagination token used for the `ListUsers`, `ListGroups` and `ListGroupMemberships` API operations. This value is generated by the identity store service. It is returned in the API response if the total results are more than the size of one page. This token is also returned when it is used in the API request to search for the next page.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.identitystore.model.ListGroupMembershipsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListGroupMembershipsRequest(")
        append("groupId=$groupId,")
        append("identityStoreId=$identityStoreId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = groupId.hashCode()
        result = 31 * result + (identityStoreId.hashCode())
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListGroupMembershipsRequest

        if (groupId != other.groupId) return false
        if (identityStoreId != other.identityStoreId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.identitystore.model.ListGroupMembershipsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier for a group in the identity store.
         */
        public var groupId: kotlin.String? = null
        /**
         * The globally unique identifier for the identity store.
         */
        public var identityStoreId: kotlin.String? = null
        /**
         * The maximum number of results to be returned per request. This parameter is used in all `List` requests to specify how many results to return in one page.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The pagination token used for the `ListUsers`, `ListGroups` and `ListGroupMemberships` API operations. This value is generated by the identity store service. It is returned in the API response if the total results are more than the size of one page. This token is also returned when it is used in the API request to search for the next page.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.identitystore.model.ListGroupMembershipsRequest) : this() {
            this.groupId = x.groupId
            this.identityStoreId = x.identityStoreId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.identitystore.model.ListGroupMembershipsRequest = ListGroupMembershipsRequest(this)

        internal fun correctErrors(): Builder {
            if (groupId == null) groupId = ""
            if (identityStoreId == null) identityStoreId = ""
            return this
        }
    }
}
