// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.serde

import aws.sdk.kotlin.services.iam.model.GetGroupPolicyResponse
import aws.sdk.kotlin.services.iam.model.IamException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class GetGroupPolicyOperationDeserializer: HttpDeserialize<GetGroupPolicyResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetGroupPolicyResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetGroupPolicyError(context, call)
        }
        val builder = GetGroupPolicyResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetGroupPolicyOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetGroupPolicyError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw IamException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NoSuchEntity" -> NoSuchEntityExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceFailure" -> ServiceFailureExceptionDeserializer().deserialize(context, wrappedCall)
        else -> IamException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetGroupPolicyOperationBody(builder: GetGroupPolicyResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("GetGroupPolicyResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("GetGroupPolicyResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap GetGroupPolicy response")
    }
    // end unwrap response wrapper

    val GROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("GroupName"))
    val POLICYDOCUMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("PolicyDocument"))
    val POLICYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("PolicyName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("https://iam.amazonaws.com/doc/2010-05-08/"))
        trait(XmlSerialName("GetGroupPolicyResult"))
        field(GROUPNAME_DESCRIPTOR)
        field(POLICYDOCUMENT_DESCRIPTOR)
        field(POLICYNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                GROUPNAME_DESCRIPTOR.index -> builder.groupName = deserializeString()
                POLICYDOCUMENT_DESCRIPTOR.index -> builder.policyDocument = deserializeString()
                POLICYNAME_DESCRIPTOR.index -> builder.policyName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
