// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.serde

import aws.sdk.kotlin.services.iam.model.GetCredentialReportResponse
import aws.sdk.kotlin.services.iam.model.IamException
import aws.sdk.kotlin.services.iam.model.ReportFormatType
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.text.encoding.decodeBase64Bytes
import aws.smithy.kotlin.runtime.time.Instant


internal class GetCredentialReportOperationDeserializer: HttpDeserialize<GetCredentialReportResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetCredentialReportResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetCredentialReportError(context, call)
        }
        val builder = GetCredentialReportResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetCredentialReportOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetCredentialReportError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw IamException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ReportInProgress" -> CredentialReportNotReadyExceptionDeserializer().deserialize(context, wrappedCall)
        "ReportExpired" -> CredentialReportExpiredExceptionDeserializer().deserialize(context, wrappedCall)
        "ReportNotPresent" -> CredentialReportNotPresentExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceFailure" -> ServiceFailureExceptionDeserializer().deserialize(context, wrappedCall)
        else -> IamException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetCredentialReportOperationBody(builder: GetCredentialReportResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("GetCredentialReportResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("GetCredentialReportResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap GetCredentialReport response")
    }
    // end unwrap response wrapper

    val CONTENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Blob, XmlSerialName("Content"))
    val GENERATEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("GeneratedTime"))
    val REPORTFORMAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, XmlSerialName("ReportFormat"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("https://iam.amazonaws.com/doc/2010-05-08/"))
        trait(XmlSerialName("GetCredentialReportResult"))
        field(CONTENT_DESCRIPTOR)
        field(GENERATEDTIME_DESCRIPTOR)
        field(REPORTFORMAT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONTENT_DESCRIPTOR.index -> builder.content = deserializeString().decodeBase64Bytes()
                GENERATEDTIME_DESCRIPTOR.index -> builder.generatedTime = deserializeString().let { Instant.fromIso8601(it) }
                REPORTFORMAT_DESCRIPTOR.index -> builder.reportFormat = deserializeString().let { ReportFormatType.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
