// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model



public class UploadServerCertificateRequest private constructor(builder: Builder) {
    /**
     * The contents of the public key certificate in PEM-encoded format.
     *
     * The [regex pattern](http://wikipedia.org/wiki/regex) used to validate this parameter is a string of characters consisting of the following:
     * + Any printable ASCII character ranging from the space character (`\u0020`) through the end of the ASCII character range
     * + The printable characters in the Basic Latin and Latin-1 Supplement character set (through `\u00FF`)
     * + The special characters tab (`\u0009`), line feed (`\u000A`), and carriage return (`\u000D`)
     */
    public val certificateBody: kotlin.String? = builder.certificateBody
    /**
     * The contents of the certificate chain. This is typically a concatenation of the PEM-encoded public key certificates of the chain.
     *
     * The [regex pattern](http://wikipedia.org/wiki/regex) used to validate this parameter is a string of characters consisting of the following:
     * + Any printable ASCII character ranging from the space character (`\u0020`) through the end of the ASCII character range
     * + The printable characters in the Basic Latin and Latin-1 Supplement character set (through `\u00FF`)
     * + The special characters tab (`\u0009`), line feed (`\u000A`), and carriage return (`\u000D`)
     */
    public val certificateChain: kotlin.String? = builder.certificateChain
    /**
     * The path for the server certificate. For more information about paths, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the *IAM User Guide*.
     *
     * This parameter is optional. If it is not included, it defaults to a slash (/). This parameter allows (through its [regex pattern](http://wikipedia.org/wiki/regex)) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain any ASCII character from the ! (`\u0021`) through the DEL character (`\u007F`), including most punctuation characters, digits, and upper and lowercased letters.
     *
     *  If you are uploading a server certificate specifically for use with Amazon CloudFront distributions, you must specify a path using the `path` parameter. The path must begin with `/cloudfront` and must include a trailing slash (for example, `/cloudfront/test/`).
     */
    public val path: kotlin.String? = builder.path
    /**
     * The contents of the private key in PEM-encoded format.
     *
     * The [regex pattern](http://wikipedia.org/wiki/regex) used to validate this parameter is a string of characters consisting of the following:
     * + Any printable ASCII character ranging from the space character (`\u0020`) through the end of the ASCII character range
     * + The printable characters in the Basic Latin and Latin-1 Supplement character set (through `\u00FF`)
     * + The special characters tab (`\u0009`), line feed (`\u000A`), and carriage return (`\u000D`)
     */
    public val privateKey: kotlin.String? = builder.privateKey
    /**
     * The name for the server certificate. Do not include the path in this value. The name of the certificate cannot contain any spaces.
     *
     * This parameter allows (through its [regex pattern](http://wikipedia.org/wiki/regex)) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-
     */
    public val serverCertificateName: kotlin.String? = builder.serverCertificateName
    /**
     * A list of tags that you want to attach to the new IAM server certificate resource. Each tag consists of a key name and an associated value. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
     *
     * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.UploadServerCertificateRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UploadServerCertificateRequest(")
        append("certificateBody=$certificateBody,")
        append("certificateChain=$certificateChain,")
        append("path=$path,")
        append("privateKey=*** Sensitive Data Redacted ***,")
        append("serverCertificateName=$serverCertificateName,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateBody?.hashCode() ?: 0
        result = 31 * result + (certificateChain?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (privateKey?.hashCode() ?: 0)
        result = 31 * result + (serverCertificateName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UploadServerCertificateRequest

        if (certificateBody != other.certificateBody) return false
        if (certificateChain != other.certificateChain) return false
        if (path != other.path) return false
        if (privateKey != other.privateKey) return false
        if (serverCertificateName != other.serverCertificateName) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.UploadServerCertificateRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The contents of the public key certificate in PEM-encoded format.
         *
         * The [regex pattern](http://wikipedia.org/wiki/regex) used to validate this parameter is a string of characters consisting of the following:
         * + Any printable ASCII character ranging from the space character (`\u0020`) through the end of the ASCII character range
         * + The printable characters in the Basic Latin and Latin-1 Supplement character set (through `\u00FF`)
         * + The special characters tab (`\u0009`), line feed (`\u000A`), and carriage return (`\u000D`)
         */
        public var certificateBody: kotlin.String? = null
        /**
         * The contents of the certificate chain. This is typically a concatenation of the PEM-encoded public key certificates of the chain.
         *
         * The [regex pattern](http://wikipedia.org/wiki/regex) used to validate this parameter is a string of characters consisting of the following:
         * + Any printable ASCII character ranging from the space character (`\u0020`) through the end of the ASCII character range
         * + The printable characters in the Basic Latin and Latin-1 Supplement character set (through `\u00FF`)
         * + The special characters tab (`\u0009`), line feed (`\u000A`), and carriage return (`\u000D`)
         */
        public var certificateChain: kotlin.String? = null
        /**
         * The path for the server certificate. For more information about paths, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the *IAM User Guide*.
         *
         * This parameter is optional. If it is not included, it defaults to a slash (/). This parameter allows (through its [regex pattern](http://wikipedia.org/wiki/regex)) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain any ASCII character from the ! (`\u0021`) through the DEL character (`\u007F`), including most punctuation characters, digits, and upper and lowercased letters.
         *
         *  If you are uploading a server certificate specifically for use with Amazon CloudFront distributions, you must specify a path using the `path` parameter. The path must begin with `/cloudfront` and must include a trailing slash (for example, `/cloudfront/test/`).
         */
        public var path: kotlin.String? = null
        /**
         * The contents of the private key in PEM-encoded format.
         *
         * The [regex pattern](http://wikipedia.org/wiki/regex) used to validate this parameter is a string of characters consisting of the following:
         * + Any printable ASCII character ranging from the space character (`\u0020`) through the end of the ASCII character range
         * + The printable characters in the Basic Latin and Latin-1 Supplement character set (through `\u00FF`)
         * + The special characters tab (`\u0009`), line feed (`\u000A`), and carriage return (`\u000D`)
         */
        public var privateKey: kotlin.String? = null
        /**
         * The name for the server certificate. Do not include the path in this value. The name of the certificate cannot contain any spaces.
         *
         * This parameter allows (through its [regex pattern](http://wikipedia.org/wiki/regex)) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-
         */
        public var serverCertificateName: kotlin.String? = null
        /**
         * A list of tags that you want to attach to the new IAM server certificate resource. Each tag consists of a key name and an associated value. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
         *
         * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.UploadServerCertificateRequest) : this() {
            this.certificateBody = x.certificateBody
            this.certificateChain = x.certificateChain
            this.path = x.path
            this.privateKey = x.privateKey
            this.serverCertificateName = x.serverCertificateName
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.UploadServerCertificateRequest = UploadServerCertificateRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
