// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model



/**
 * Contains a reference to a `Statement` element in a policy document that determines the result of the simulation.
 *
 * This data type is used by the `MatchedStatements` member of the ` <a>EvaluationResult</a> ` type.
 */
public class Statement private constructor(builder: Builder) {
    /**
     * The row and column of the end of a `Statement` in an IAM policy.
     */
    public val endPosition: aws.sdk.kotlin.services.iam.model.Position? = builder.endPosition
    /**
     * The identifier of the policy that was provided as an input.
     */
    public val sourcePolicyId: kotlin.String? = builder.sourcePolicyId
    /**
     * The type of the policy.
     */
    public val sourcePolicyType: aws.sdk.kotlin.services.iam.model.PolicySourceType? = builder.sourcePolicyType
    /**
     * The row and column of the beginning of the `Statement` in an IAM policy.
     */
    public val startPosition: aws.sdk.kotlin.services.iam.model.Position? = builder.startPosition

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.Statement = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Statement(")
        append("endPosition=$endPosition,")
        append("sourcePolicyId=$sourcePolicyId,")
        append("sourcePolicyType=$sourcePolicyType,")
        append("startPosition=$startPosition")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endPosition?.hashCode() ?: 0
        result = 31 * result + (sourcePolicyId?.hashCode() ?: 0)
        result = 31 * result + (sourcePolicyType?.hashCode() ?: 0)
        result = 31 * result + (startPosition?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Statement

        if (endPosition != other.endPosition) return false
        if (sourcePolicyId != other.sourcePolicyId) return false
        if (sourcePolicyType != other.sourcePolicyType) return false
        if (startPosition != other.startPosition) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.Statement = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The row and column of the end of a `Statement` in an IAM policy.
         */
        public var endPosition: aws.sdk.kotlin.services.iam.model.Position? = null
        /**
         * The identifier of the policy that was provided as an input.
         */
        public var sourcePolicyId: kotlin.String? = null
        /**
         * The type of the policy.
         */
        public var sourcePolicyType: aws.sdk.kotlin.services.iam.model.PolicySourceType? = null
        /**
         * The row and column of the beginning of the `Statement` in an IAM policy.
         */
        public var startPosition: aws.sdk.kotlin.services.iam.model.Position? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.Statement) : this() {
            this.endPosition = x.endPosition
            this.sourcePolicyId = x.sourcePolicyId
            this.sourcePolicyType = x.sourcePolicyType
            this.startPosition = x.startPosition
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.Statement = Statement(this)

        /**
         * construct an [aws.sdk.kotlin.services.iam.model.Position] inside the given [block]
         */
        public fun endPosition(block: aws.sdk.kotlin.services.iam.model.Position.Builder.() -> kotlin.Unit) {
            this.endPosition = aws.sdk.kotlin.services.iam.model.Position.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iam.model.Position] inside the given [block]
         */
        public fun startPosition(block: aws.sdk.kotlin.services.iam.model.Position.Builder.() -> kotlin.Unit) {
            this.startPosition = aws.sdk.kotlin.services.iam.model.Position.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
