// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about an SSH public key, without the key's body or fingerprint.
 *
 * This data type is used as a response element in the ListSSHPublicKeys operation.
 */
public class SshPublicKeyMetadata private constructor(builder: Builder) {
    /**
     * The unique identifier for the SSH public key.
     */
    public val sshPublicKeyId: kotlin.String = requireNotNull(builder.sshPublicKeyId) { "A non-null value must be provided for sshPublicKeyId" }
    /**
     * The status of the SSH public key. `Active` means that the key can be used for authentication with an CodeCommit repository. `Inactive` means that the key cannot be used.
     */
    public val status: aws.sdk.kotlin.services.iam.model.StatusType = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The date and time, in [ISO 8601 date-time format](http://www.iso.org/iso/iso8601), when the SSH public key was uploaded.
     */
    public val uploadDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.uploadDate) { "A non-null value must be provided for uploadDate" }
    /**
     * The name of the IAM user associated with the SSH public key.
     */
    public val userName: kotlin.String = requireNotNull(builder.userName) { "A non-null value must be provided for userName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.SshPublicKeyMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SshPublicKeyMetadata(")
        append("sshPublicKeyId=$sshPublicKeyId,")
        append("status=$status,")
        append("uploadDate=$uploadDate,")
        append("userName=$userName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = sshPublicKeyId.hashCode()
        result = 31 * result + (status.hashCode())
        result = 31 * result + (uploadDate.hashCode())
        result = 31 * result + (userName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SshPublicKeyMetadata

        if (sshPublicKeyId != other.sshPublicKeyId) return false
        if (status != other.status) return false
        if (uploadDate != other.uploadDate) return false
        if (userName != other.userName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.SshPublicKeyMetadata = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique identifier for the SSH public key.
         */
        public var sshPublicKeyId: kotlin.String? = null
        /**
         * The status of the SSH public key. `Active` means that the key can be used for authentication with an CodeCommit repository. `Inactive` means that the key cannot be used.
         */
        public var status: aws.sdk.kotlin.services.iam.model.StatusType? = null
        /**
         * The date and time, in [ISO 8601 date-time format](http://www.iso.org/iso/iso8601), when the SSH public key was uploaded.
         */
        public var uploadDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the IAM user associated with the SSH public key.
         */
        public var userName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.SshPublicKeyMetadata) : this() {
            this.sshPublicKeyId = x.sshPublicKeyId
            this.status = x.status
            this.uploadDate = x.uploadDate
            this.userName = x.userName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.SshPublicKeyMetadata = SshPublicKeyMetadata(this)

        internal fun correctErrors(): Builder {
            if (sshPublicKeyId == null) sshPublicKeyId = ""
            if (status == null) status = StatusType.SdkUnknown("no value provided")
            if (uploadDate == null) uploadDate = Instant.fromEpochSeconds(0)
            if (userName == null) userName = ""
            return this
        }
    }
}
