// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model



public class PutGroupPolicyRequest private constructor(builder: Builder) {
    /**
     * The name of the group to associate the policy with.
     *
     * This parameter allows (through its [regex pattern](http://wikipedia.org/wiki/regex)) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
     */
    public val groupName: kotlin.String? = builder.groupName
    /**
     * The policy document.
     *
     * You must provide policies in JSON format in IAM. However, for CloudFormation templates formatted in YAML, you can provide the policy in JSON or YAML format. CloudFormation always converts a YAML policy to JSON format before submitting it to IAM.
     *
     * The [regex pattern](http://wikipedia.org/wiki/regex) used to validate this parameter is a string of characters consisting of the following:
     * + Any printable ASCII character ranging from the space character (`\u0020`) through the end of the ASCII character range
     * + The printable characters in the Basic Latin and Latin-1 Supplement character set (through `\u00FF`)
     * + The special characters tab (`\u0009`), line feed (`\u000A`), and carriage return (`\u000D`)
     */
    public val policyDocument: kotlin.String? = builder.policyDocument
    /**
     * The name of the policy document.
     *
     * This parameter allows (through its [regex pattern](http://wikipedia.org/wiki/regex)) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-
     */
    public val policyName: kotlin.String? = builder.policyName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.PutGroupPolicyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutGroupPolicyRequest(")
        append("groupName=$groupName,")
        append("policyDocument=$policyDocument,")
        append("policyName=$policyName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = groupName?.hashCode() ?: 0
        result = 31 * result + (policyDocument?.hashCode() ?: 0)
        result = 31 * result + (policyName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutGroupPolicyRequest

        if (groupName != other.groupName) return false
        if (policyDocument != other.policyDocument) return false
        if (policyName != other.policyName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.PutGroupPolicyRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the group to associate the policy with.
         *
         * This parameter allows (through its [regex pattern](http://wikipedia.org/wiki/regex)) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
         */
        public var groupName: kotlin.String? = null
        /**
         * The policy document.
         *
         * You must provide policies in JSON format in IAM. However, for CloudFormation templates formatted in YAML, you can provide the policy in JSON or YAML format. CloudFormation always converts a YAML policy to JSON format before submitting it to IAM.
         *
         * The [regex pattern](http://wikipedia.org/wiki/regex) used to validate this parameter is a string of characters consisting of the following:
         * + Any printable ASCII character ranging from the space character (`\u0020`) through the end of the ASCII character range
         * + The printable characters in the Basic Latin and Latin-1 Supplement character set (through `\u00FF`)
         * + The special characters tab (`\u0009`), line feed (`\u000A`), and carriage return (`\u000D`)
         */
        public var policyDocument: kotlin.String? = null
        /**
         * The name of the policy document.
         *
         * This parameter allows (through its [regex pattern](http://wikipedia.org/wiki/regex)) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-
         */
        public var policyName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.PutGroupPolicyRequest) : this() {
            this.groupName = x.groupName
            this.policyDocument = x.policyDocument
            this.policyName = x.policyName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.PutGroupPolicyRequest = PutGroupPolicyRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
