// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a managed policy.
 *
 * This data type is used as a response element in the CreatePolicy, GetPolicy, and ListPolicies operations.
 *
 * For more information about managed policies, refer to [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
 */
public class Policy private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.
     *
     * For more information about ARNs, go to [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The number of entities (users, groups, and roles) that the policy is attached to.
     */
    public val attachmentCount: kotlin.Int? = builder.attachmentCount
    /**
     * The date and time, in [ISO 8601 date-time format](http://www.iso.org/iso/iso8601), when the policy was created.
     */
    public val createDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createDate
    /**
     * The identifier for the version of the policy that is set as the default version.
     */
    public val defaultVersionId: kotlin.String? = builder.defaultVersionId
    /**
     * A friendly description of the policy.
     *
     * This element is included in the response to the GetPolicy operation. It is not included in the response to the ListPolicies operation.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Specifies whether the policy can be attached to an IAM user, group, or role.
     */
    public val isAttachable: kotlin.Boolean = builder.isAttachable
    /**
     * The path to the policy.
     *
     * For more information about paths, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the *IAM User Guide*.
     */
    public val path: kotlin.String? = builder.path
    /**
     * The number of entities (users and roles) for which the policy is used to set the permissions boundary.
     *
     * For more information about permissions boundaries, see [Permissions boundaries for IAM identities ](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html) in the *IAM User Guide*.
     */
    public val permissionsBoundaryUsageCount: kotlin.Int? = builder.permissionsBoundaryUsageCount
    /**
     * The stable and unique string identifying the policy.
     *
     * For more information about IDs, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the *IAM User Guide*.
     */
    public val policyId: kotlin.String? = builder.policyId
    /**
     * The friendly name (not ARN) identifying the policy.
     */
    public val policyName: kotlin.String? = builder.policyName
    /**
     * A list of tags that are attached to the instance profile. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The date and time, in [ISO 8601 date-time format](http://www.iso.org/iso/iso8601), when the policy was last updated.
     *
     * When a policy has only one version, this field contains the date and time when the policy was created. When a policy has more than one version, this field contains the date and time when the most recent policy version was created.
     */
    public val updateDate: aws.smithy.kotlin.runtime.time.Instant? = builder.updateDate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.Policy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Policy(")
        append("arn=$arn,")
        append("attachmentCount=$attachmentCount,")
        append("createDate=$createDate,")
        append("defaultVersionId=$defaultVersionId,")
        append("description=$description,")
        append("isAttachable=$isAttachable,")
        append("path=$path,")
        append("permissionsBoundaryUsageCount=$permissionsBoundaryUsageCount,")
        append("policyId=$policyId,")
        append("policyName=$policyName,")
        append("tags=$tags,")
        append("updateDate=$updateDate")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (attachmentCount ?: 0)
        result = 31 * result + (createDate?.hashCode() ?: 0)
        result = 31 * result + (defaultVersionId?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (isAttachable.hashCode())
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (permissionsBoundaryUsageCount ?: 0)
        result = 31 * result + (policyId?.hashCode() ?: 0)
        result = 31 * result + (policyName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (updateDate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Policy

        if (arn != other.arn) return false
        if (attachmentCount != other.attachmentCount) return false
        if (createDate != other.createDate) return false
        if (defaultVersionId != other.defaultVersionId) return false
        if (description != other.description) return false
        if (isAttachable != other.isAttachable) return false
        if (path != other.path) return false
        if (permissionsBoundaryUsageCount != other.permissionsBoundaryUsageCount) return false
        if (policyId != other.policyId) return false
        if (policyName != other.policyName) return false
        if (tags != other.tags) return false
        if (updateDate != other.updateDate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.Policy = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.
         *
         * For more information about ARNs, go to [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
         */
        public var arn: kotlin.String? = null
        /**
         * The number of entities (users, groups, and roles) that the policy is attached to.
         */
        public var attachmentCount: kotlin.Int? = null
        /**
         * The date and time, in [ISO 8601 date-time format](http://www.iso.org/iso/iso8601), when the policy was created.
         */
        public var createDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The identifier for the version of the policy that is set as the default version.
         */
        public var defaultVersionId: kotlin.String? = null
        /**
         * A friendly description of the policy.
         *
         * This element is included in the response to the GetPolicy operation. It is not included in the response to the ListPolicies operation.
         */
        public var description: kotlin.String? = null
        /**
         * Specifies whether the policy can be attached to an IAM user, group, or role.
         */
        public var isAttachable: kotlin.Boolean = false
        /**
         * The path to the policy.
         *
         * For more information about paths, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the *IAM User Guide*.
         */
        public var path: kotlin.String? = null
        /**
         * The number of entities (users and roles) for which the policy is used to set the permissions boundary.
         *
         * For more information about permissions boundaries, see [Permissions boundaries for IAM identities ](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html) in the *IAM User Guide*.
         */
        public var permissionsBoundaryUsageCount: kotlin.Int? = null
        /**
         * The stable and unique string identifying the policy.
         *
         * For more information about IDs, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the *IAM User Guide*.
         */
        public var policyId: kotlin.String? = null
        /**
         * The friendly name (not ARN) identifying the policy.
         */
        public var policyName: kotlin.String? = null
        /**
         * A list of tags that are attached to the instance profile. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
         */
        public var tags: List<Tag>? = null
        /**
         * The date and time, in [ISO 8601 date-time format](http://www.iso.org/iso/iso8601), when the policy was last updated.
         *
         * When a policy has only one version, this field contains the date and time when the policy was created. When a policy has more than one version, this field contains the date and time when the most recent policy version was created.
         */
        public var updateDate: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.Policy) : this() {
            this.arn = x.arn
            this.attachmentCount = x.attachmentCount
            this.createDate = x.createDate
            this.defaultVersionId = x.defaultVersionId
            this.description = x.description
            this.isAttachable = x.isAttachable
            this.path = x.path
            this.permissionsBoundaryUsageCount = x.permissionsBoundaryUsageCount
            this.policyId = x.policyId
            this.policyName = x.policyName
            this.tags = x.tags
            this.updateDate = x.updateDate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.Policy = Policy(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
