// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about an MFA device.
 *
 * This data type is used as a response element in the ListMFADevices operation.
 */
public class MfaDevice private constructor(builder: Builder) {
    /**
     * The date when the MFA device was enabled for the user.
     */
    public val enableDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.enableDate) { "A non-null value must be provided for enableDate" }
    /**
     * The serial number that uniquely identifies the MFA device. For virtual MFA devices, the serial number is the device ARN.
     */
    public val serialNumber: kotlin.String = requireNotNull(builder.serialNumber) { "A non-null value must be provided for serialNumber" }
    /**
     * The user with whom the MFA device is associated.
     */
    public val userName: kotlin.String = requireNotNull(builder.userName) { "A non-null value must be provided for userName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.MfaDevice = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MfaDevice(")
        append("enableDate=$enableDate,")
        append("serialNumber=$serialNumber,")
        append("userName=$userName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enableDate.hashCode()
        result = 31 * result + (serialNumber.hashCode())
        result = 31 * result + (userName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MfaDevice

        if (enableDate != other.enableDate) return false
        if (serialNumber != other.serialNumber) return false
        if (userName != other.userName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.MfaDevice = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date when the MFA device was enabled for the user.
         */
        public var enableDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The serial number that uniquely identifies the MFA device. For virtual MFA devices, the serial number is the device ARN.
         */
        public var serialNumber: kotlin.String? = null
        /**
         * The user with whom the MFA device is associated.
         */
        public var userName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.MfaDevice) : this() {
            this.enableDate = x.enableDate
            this.serialNumber = x.serialNumber
            this.userName = x.userName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.MfaDevice = MfaDevice(this)

        internal fun correctErrors(): Builder {
            if (enableDate == null) enableDate = Instant.fromEpochSeconds(0)
            if (serialNumber == null) serialNumber = ""
            if (userName == null) userName = ""
            return this
        }
    }
}
