// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model



/**
 * Contains the response to a successful ListEntitiesForPolicy request.
 */
public class ListEntitiesForPolicyResponse private constructor(builder: Builder) {
    /**
     * A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the `Marker` request parameter to retrieve more items. Note that IAM might return fewer than the `MaxItems` number of results even when there are more results available. We recommend that you check `IsTruncated` after every call to ensure that you receive all your results.
     */
    public val isTruncated: kotlin.Boolean = builder.isTruncated
    /**
     * When `IsTruncated` is `true`, this element is present and contains the value to use for the `Marker` parameter in a subsequent pagination request.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * A list of IAM groups that the policy is attached to.
     */
    public val policyGroups: List<PolicyGroup>? = builder.policyGroups
    /**
     * A list of IAM roles that the policy is attached to.
     */
    public val policyRoles: List<PolicyRole>? = builder.policyRoles
    /**
     * A list of IAM users that the policy is attached to.
     */
    public val policyUsers: List<PolicyUser>? = builder.policyUsers

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.ListEntitiesForPolicyResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListEntitiesForPolicyResponse(")
        append("isTruncated=$isTruncated,")
        append("marker=$marker,")
        append("policyGroups=$policyGroups,")
        append("policyRoles=$policyRoles,")
        append("policyUsers=$policyUsers")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = isTruncated.hashCode()
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (policyGroups?.hashCode() ?: 0)
        result = 31 * result + (policyRoles?.hashCode() ?: 0)
        result = 31 * result + (policyUsers?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListEntitiesForPolicyResponse

        if (isTruncated != other.isTruncated) return false
        if (marker != other.marker) return false
        if (policyGroups != other.policyGroups) return false
        if (policyRoles != other.policyRoles) return false
        if (policyUsers != other.policyUsers) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.ListEntitiesForPolicyResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the `Marker` request parameter to retrieve more items. Note that IAM might return fewer than the `MaxItems` number of results even when there are more results available. We recommend that you check `IsTruncated` after every call to ensure that you receive all your results.
         */
        public var isTruncated: kotlin.Boolean = false
        /**
         * When `IsTruncated` is `true`, this element is present and contains the value to use for the `Marker` parameter in a subsequent pagination request.
         */
        public var marker: kotlin.String? = null
        /**
         * A list of IAM groups that the policy is attached to.
         */
        public var policyGroups: List<PolicyGroup>? = null
        /**
         * A list of IAM roles that the policy is attached to.
         */
        public var policyRoles: List<PolicyRole>? = null
        /**
         * A list of IAM users that the policy is attached to.
         */
        public var policyUsers: List<PolicyUser>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.ListEntitiesForPolicyResponse) : this() {
            this.isTruncated = x.isTruncated
            this.marker = x.marker
            this.policyGroups = x.policyGroups
            this.policyRoles = x.policyRoles
            this.policyUsers = x.policyUsers
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.ListEntitiesForPolicyResponse = ListEntitiesForPolicyResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
