// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model



/**
 * Contains the response to a successful GetUser request.
 */
public class GetUserResponse private constructor(builder: Builder) {
    /**
     * A structure containing details about the IAM user.
     *
     * Due to a service issue, password last used data does not include password use from May 3, 2018 22:50 PDT to May 23, 2018 14:08 PDT. This affects [last sign-in](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_finding-unused.html) dates shown in the IAM console and password last used dates in the [IAM credential report](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_getting-report.html), and returned by this operation. If users signed in during the affected time, the password last used date that is returned is the date the user last signed in before May 3, 2018. For users that signed in after May 23, 2018 14:08 PDT, the returned password last used date is accurate.
     *
     * You can use password last used information to identify unused credentials for deletion. For example, you might delete users who did not sign in to Amazon Web Services in the last 90 days. In cases like this, we recommend that you adjust your evaluation window to include dates after May 23, 2018. Alternatively, if your users use access keys to access Amazon Web Services programmatically you can refer to access key last used information because it is accurate for all dates.
     */
    public val user: aws.sdk.kotlin.services.iam.model.User? = builder.user

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.GetUserResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetUserResponse(")
        append("user=$user")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = user?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetUserResponse

        if (user != other.user) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.GetUserResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A structure containing details about the IAM user.
         *
         * Due to a service issue, password last used data does not include password use from May 3, 2018 22:50 PDT to May 23, 2018 14:08 PDT. This affects [last sign-in](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_finding-unused.html) dates shown in the IAM console and password last used dates in the [IAM credential report](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_getting-report.html), and returned by this operation. If users signed in during the affected time, the password last used date that is returned is the date the user last signed in before May 3, 2018. For users that signed in after May 23, 2018 14:08 PDT, the returned password last used date is accurate.
         *
         * You can use password last used information to identify unused credentials for deletion. For example, you might delete users who did not sign in to Amazon Web Services in the last 90 days. In cases like this, we recommend that you adjust your evaluation window to include dates after May 23, 2018. Alternatively, if your users use access keys to access Amazon Web Services programmatically you can refer to access key last used information because it is accurate for all dates.
         */
        public var user: aws.sdk.kotlin.services.iam.model.User? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.GetUserResponse) : this() {
            this.user = x.user
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.GetUserResponse = GetUserResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.iam.model.User] inside the given [block]
         */
        public fun user(block: aws.sdk.kotlin.services.iam.model.User.Builder.() -> kotlin.Unit) {
            this.user = aws.sdk.kotlin.services.iam.model.User.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
