// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model



/**
 * Contains the response to a successful GetUserPolicy request.
 */
public class GetUserPolicyResponse private constructor(builder: Builder) {
    /**
     * The policy document.
     *
     * IAM stores policies in JSON format. However, resources that were created using CloudFormation templates can be formatted in YAML. CloudFormation always converts a YAML policy to JSON format before submitting it to IAM.
     */
    public val policyDocument: kotlin.String = requireNotNull(builder.policyDocument) { "A non-null value must be provided for policyDocument" }
    /**
     * The name of the policy.
     */
    public val policyName: kotlin.String = requireNotNull(builder.policyName) { "A non-null value must be provided for policyName" }
    /**
     * The user the policy is associated with.
     */
    public val userName: kotlin.String = requireNotNull(builder.userName) { "A non-null value must be provided for userName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.GetUserPolicyResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetUserPolicyResponse(")
        append("policyDocument=$policyDocument,")
        append("policyName=$policyName,")
        append("userName=$userName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = policyDocument.hashCode()
        result = 31 * result + (policyName.hashCode())
        result = 31 * result + (userName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetUserPolicyResponse

        if (policyDocument != other.policyDocument) return false
        if (policyName != other.policyName) return false
        if (userName != other.userName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.GetUserPolicyResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The policy document.
         *
         * IAM stores policies in JSON format. However, resources that were created using CloudFormation templates can be formatted in YAML. CloudFormation always converts a YAML policy to JSON format before submitting it to IAM.
         */
        public var policyDocument: kotlin.String? = null
        /**
         * The name of the policy.
         */
        public var policyName: kotlin.String? = null
        /**
         * The user the policy is associated with.
         */
        public var userName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.GetUserPolicyResponse) : this() {
            this.policyDocument = x.policyDocument
            this.policyName = x.policyName
            this.userName = x.userName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.GetUserPolicyResponse = GetUserPolicyResponse(this)

        internal fun correctErrors(): Builder {
            if (policyDocument == null) policyDocument = ""
            if (policyName == null) policyName = ""
            if (userName == null) userName = ""
            return this
        }
    }
}
