// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model



/**
 * Contains the response to a successful GetRolePolicy request.
 */
public class GetRolePolicyResponse private constructor(builder: Builder) {
    /**
     * The policy document.
     *
     * IAM stores policies in JSON format. However, resources that were created using CloudFormation templates can be formatted in YAML. CloudFormation always converts a YAML policy to JSON format before submitting it to IAM.
     */
    public val policyDocument: kotlin.String = requireNotNull(builder.policyDocument) { "A non-null value must be provided for policyDocument" }
    /**
     * The name of the policy.
     */
    public val policyName: kotlin.String = requireNotNull(builder.policyName) { "A non-null value must be provided for policyName" }
    /**
     * The role the policy is associated with.
     */
    public val roleName: kotlin.String = requireNotNull(builder.roleName) { "A non-null value must be provided for roleName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.GetRolePolicyResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetRolePolicyResponse(")
        append("policyDocument=$policyDocument,")
        append("policyName=$policyName,")
        append("roleName=$roleName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = policyDocument.hashCode()
        result = 31 * result + (policyName.hashCode())
        result = 31 * result + (roleName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetRolePolicyResponse

        if (policyDocument != other.policyDocument) return false
        if (policyName != other.policyName) return false
        if (roleName != other.roleName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.GetRolePolicyResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The policy document.
         *
         * IAM stores policies in JSON format. However, resources that were created using CloudFormation templates can be formatted in YAML. CloudFormation always converts a YAML policy to JSON format before submitting it to IAM.
         */
        public var policyDocument: kotlin.String? = null
        /**
         * The name of the policy.
         */
        public var policyName: kotlin.String? = null
        /**
         * The role the policy is associated with.
         */
        public var roleName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.GetRolePolicyResponse) : this() {
            this.policyDocument = x.policyDocument
            this.policyName = x.policyName
            this.roleName = x.roleName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.GetRolePolicyResponse = GetRolePolicyResponse(this)

        internal fun correctErrors(): Builder {
            if (policyDocument == null) policyDocument = ""
            if (policyName == null) policyName = ""
            if (roleName == null) roleName = ""
            return this
        }
    }
}
