// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model



/**
 * Contains the response to a successful GetGroupPolicy request.
 */
public class GetGroupPolicyResponse private constructor(builder: Builder) {
    /**
     * The group the policy is associated with.
     */
    public val groupName: kotlin.String = requireNotNull(builder.groupName) { "A non-null value must be provided for groupName" }
    /**
     * The policy document.
     *
     * IAM stores policies in JSON format. However, resources that were created using CloudFormation templates can be formatted in YAML. CloudFormation always converts a YAML policy to JSON format before submitting it to IAM.
     */
    public val policyDocument: kotlin.String = requireNotNull(builder.policyDocument) { "A non-null value must be provided for policyDocument" }
    /**
     * The name of the policy.
     */
    public val policyName: kotlin.String = requireNotNull(builder.policyName) { "A non-null value must be provided for policyName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.GetGroupPolicyResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetGroupPolicyResponse(")
        append("groupName=$groupName,")
        append("policyDocument=$policyDocument,")
        append("policyName=$policyName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = groupName.hashCode()
        result = 31 * result + (policyDocument.hashCode())
        result = 31 * result + (policyName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetGroupPolicyResponse

        if (groupName != other.groupName) return false
        if (policyDocument != other.policyDocument) return false
        if (policyName != other.policyName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.GetGroupPolicyResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The group the policy is associated with.
         */
        public var groupName: kotlin.String? = null
        /**
         * The policy document.
         *
         * IAM stores policies in JSON format. However, resources that were created using CloudFormation templates can be formatted in YAML. CloudFormation always converts a YAML policy to JSON format before submitting it to IAM.
         */
        public var policyDocument: kotlin.String? = null
        /**
         * The name of the policy.
         */
        public var policyName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.GetGroupPolicyResponse) : this() {
            this.groupName = x.groupName
            this.policyDocument = x.policyDocument
            this.policyName = x.policyName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.GetGroupPolicyResponse = GetGroupPolicyResponse(this)

        internal fun correctErrors(): Builder {
            if (groupName == null) groupName = ""
            if (policyDocument == null) policyDocument = ""
            if (policyName == null) policyName = ""
            return this
        }
    }
}
