// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model



/**
 * Contains details about the specified entity (user or role).
 *
 * This data type is an element of the EntityDetails object.
 */
public class EntityInfo private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.
     *
     * For more information about ARNs, go to [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The identifier of the entity (user or role).
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The name of the entity (user or role).
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The path to the entity (user or role). For more information about paths, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the *IAM User Guide*.
     */
    public val path: kotlin.String? = builder.path
    /**
     * The type of entity (user or role).
     */
    public val type: aws.sdk.kotlin.services.iam.model.PolicyOwnerEntityType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.EntityInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EntityInfo(")
        append("arn=$arn,")
        append("id=$id,")
        append("name=$name,")
        append("path=$path,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (id.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EntityInfo

        if (arn != other.arn) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (path != other.path) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.EntityInfo = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.
         *
         * For more information about ARNs, go to [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
         */
        public var arn: kotlin.String? = null
        /**
         * The identifier of the entity (user or role).
         */
        public var id: kotlin.String? = null
        /**
         * The name of the entity (user or role).
         */
        public var name: kotlin.String? = null
        /**
         * The path to the entity (user or role). For more information about paths, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the *IAM User Guide*.
         */
        public var path: kotlin.String? = null
        /**
         * The type of entity (user or role).
         */
        public var type: aws.sdk.kotlin.services.iam.model.PolicyOwnerEntityType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.EntityInfo) : this() {
            this.arn = x.arn
            this.id = x.id
            this.name = x.name
            this.path = x.path
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.EntityInfo = EntityInfo(this)

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (id == null) id = ""
            if (name == null) name = ""
            if (type == null) type = PolicyOwnerEntityType.SdkUnknown("no value provided")
            return this
        }
    }
}
