// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model



public class CreateVirtualMfaDeviceRequest private constructor(builder: Builder) {
    /**
     * The path for the virtual MFA device. For more information about paths, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the *IAM User Guide*.
     *
     * This parameter is optional. If it is not included, it defaults to a slash (/).
     *
     * This parameter allows (through its [regex pattern](http://wikipedia.org/wiki/regex)) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain any ASCII character from the ! (`\u0021`) through the DEL character (`\u007F`), including most punctuation characters, digits, and upper and lowercased letters.
     */
    public val path: kotlin.String? = builder.path
    /**
     * A list of tags that you want to attach to the new IAM virtual MFA device. Each tag consists of a key name and an associated value. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
     *
     * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The name of the virtual MFA device, which must be unique. Use with path to uniquely identify a virtual MFA device.
     *
     * This parameter allows (through its [regex pattern](http://wikipedia.org/wiki/regex)) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-
     */
    public val virtualMfaDeviceName: kotlin.String? = builder.virtualMfaDeviceName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.CreateVirtualMfaDeviceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateVirtualMfaDeviceRequest(")
        append("path=$path,")
        append("tags=$tags,")
        append("virtualMfaDeviceName=$virtualMfaDeviceName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = path?.hashCode() ?: 0
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (virtualMfaDeviceName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateVirtualMfaDeviceRequest

        if (path != other.path) return false
        if (tags != other.tags) return false
        if (virtualMfaDeviceName != other.virtualMfaDeviceName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.CreateVirtualMfaDeviceRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The path for the virtual MFA device. For more information about paths, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the *IAM User Guide*.
         *
         * This parameter is optional. If it is not included, it defaults to a slash (/).
         *
         * This parameter allows (through its [regex pattern](http://wikipedia.org/wiki/regex)) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain any ASCII character from the ! (`\u0021`) through the DEL character (`\u007F`), including most punctuation characters, digits, and upper and lowercased letters.
         */
        public var path: kotlin.String? = null
        /**
         * A list of tags that you want to attach to the new IAM virtual MFA device. Each tag consists of a key name and an associated value. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
         *
         * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created.
         */
        public var tags: List<Tag>? = null
        /**
         * The name of the virtual MFA device, which must be unique. Use with path to uniquely identify a virtual MFA device.
         *
         * This parameter allows (through its [regex pattern](http://wikipedia.org/wiki/regex)) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-
         */
        public var virtualMfaDeviceName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.CreateVirtualMfaDeviceRequest) : this() {
            this.path = x.path
            this.tags = x.tags
            this.virtualMfaDeviceName = x.virtualMfaDeviceName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.CreateVirtualMfaDeviceRequest = CreateVirtualMfaDeviceRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
