// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.iam.auth.DefaultIamAuthSchemeProvider
import aws.sdk.kotlin.services.iam.auth.IamAuthSchemeProvider
import aws.sdk.kotlin.services.iam.endpoints.DefaultIamEndpointProvider
import aws.sdk.kotlin.services.iam.endpoints.IamEndpointParameters
import aws.sdk.kotlin.services.iam.endpoints.IamEndpointProvider
import aws.sdk.kotlin.services.iam.model.AddClientIdToOpenIdConnectProviderRequest
import aws.sdk.kotlin.services.iam.model.AddClientIdToOpenIdConnectProviderResponse
import aws.sdk.kotlin.services.iam.model.AddRoleToInstanceProfileRequest
import aws.sdk.kotlin.services.iam.model.AddRoleToInstanceProfileResponse
import aws.sdk.kotlin.services.iam.model.AddUserToGroupRequest
import aws.sdk.kotlin.services.iam.model.AddUserToGroupResponse
import aws.sdk.kotlin.services.iam.model.AttachGroupPolicyRequest
import aws.sdk.kotlin.services.iam.model.AttachGroupPolicyResponse
import aws.sdk.kotlin.services.iam.model.AttachRolePolicyRequest
import aws.sdk.kotlin.services.iam.model.AttachRolePolicyResponse
import aws.sdk.kotlin.services.iam.model.AttachUserPolicyRequest
import aws.sdk.kotlin.services.iam.model.AttachUserPolicyResponse
import aws.sdk.kotlin.services.iam.model.ChangePasswordRequest
import aws.sdk.kotlin.services.iam.model.ChangePasswordResponse
import aws.sdk.kotlin.services.iam.model.CreateAccessKeyRequest
import aws.sdk.kotlin.services.iam.model.CreateAccessKeyResponse
import aws.sdk.kotlin.services.iam.model.CreateAccountAliasRequest
import aws.sdk.kotlin.services.iam.model.CreateAccountAliasResponse
import aws.sdk.kotlin.services.iam.model.CreateGroupRequest
import aws.sdk.kotlin.services.iam.model.CreateGroupResponse
import aws.sdk.kotlin.services.iam.model.CreateInstanceProfileRequest
import aws.sdk.kotlin.services.iam.model.CreateInstanceProfileResponse
import aws.sdk.kotlin.services.iam.model.CreateLoginProfileRequest
import aws.sdk.kotlin.services.iam.model.CreateLoginProfileResponse
import aws.sdk.kotlin.services.iam.model.CreateOpenIdConnectProviderRequest
import aws.sdk.kotlin.services.iam.model.CreateOpenIdConnectProviderResponse
import aws.sdk.kotlin.services.iam.model.CreatePolicyRequest
import aws.sdk.kotlin.services.iam.model.CreatePolicyResponse
import aws.sdk.kotlin.services.iam.model.CreatePolicyVersionRequest
import aws.sdk.kotlin.services.iam.model.CreatePolicyVersionResponse
import aws.sdk.kotlin.services.iam.model.CreateRoleRequest
import aws.sdk.kotlin.services.iam.model.CreateRoleResponse
import aws.sdk.kotlin.services.iam.model.CreateSamlProviderRequest
import aws.sdk.kotlin.services.iam.model.CreateSamlProviderResponse
import aws.sdk.kotlin.services.iam.model.CreateServiceLinkedRoleRequest
import aws.sdk.kotlin.services.iam.model.CreateServiceLinkedRoleResponse
import aws.sdk.kotlin.services.iam.model.CreateServiceSpecificCredentialRequest
import aws.sdk.kotlin.services.iam.model.CreateServiceSpecificCredentialResponse
import aws.sdk.kotlin.services.iam.model.CreateUserRequest
import aws.sdk.kotlin.services.iam.model.CreateUserResponse
import aws.sdk.kotlin.services.iam.model.CreateVirtualMfaDeviceRequest
import aws.sdk.kotlin.services.iam.model.CreateVirtualMfaDeviceResponse
import aws.sdk.kotlin.services.iam.model.DeactivateMfaDeviceRequest
import aws.sdk.kotlin.services.iam.model.DeactivateMfaDeviceResponse
import aws.sdk.kotlin.services.iam.model.DeleteAccessKeyRequest
import aws.sdk.kotlin.services.iam.model.DeleteAccessKeyResponse
import aws.sdk.kotlin.services.iam.model.DeleteAccountAliasRequest
import aws.sdk.kotlin.services.iam.model.DeleteAccountAliasResponse
import aws.sdk.kotlin.services.iam.model.DeleteAccountPasswordPolicyRequest
import aws.sdk.kotlin.services.iam.model.DeleteAccountPasswordPolicyResponse
import aws.sdk.kotlin.services.iam.model.DeleteGroupPolicyRequest
import aws.sdk.kotlin.services.iam.model.DeleteGroupPolicyResponse
import aws.sdk.kotlin.services.iam.model.DeleteGroupRequest
import aws.sdk.kotlin.services.iam.model.DeleteGroupResponse
import aws.sdk.kotlin.services.iam.model.DeleteInstanceProfileRequest
import aws.sdk.kotlin.services.iam.model.DeleteInstanceProfileResponse
import aws.sdk.kotlin.services.iam.model.DeleteLoginProfileRequest
import aws.sdk.kotlin.services.iam.model.DeleteLoginProfileResponse
import aws.sdk.kotlin.services.iam.model.DeleteOpenIdConnectProviderRequest
import aws.sdk.kotlin.services.iam.model.DeleteOpenIdConnectProviderResponse
import aws.sdk.kotlin.services.iam.model.DeletePolicyRequest
import aws.sdk.kotlin.services.iam.model.DeletePolicyResponse
import aws.sdk.kotlin.services.iam.model.DeletePolicyVersionRequest
import aws.sdk.kotlin.services.iam.model.DeletePolicyVersionResponse
import aws.sdk.kotlin.services.iam.model.DeleteRolePermissionsBoundaryRequest
import aws.sdk.kotlin.services.iam.model.DeleteRolePermissionsBoundaryResponse
import aws.sdk.kotlin.services.iam.model.DeleteRolePolicyRequest
import aws.sdk.kotlin.services.iam.model.DeleteRolePolicyResponse
import aws.sdk.kotlin.services.iam.model.DeleteRoleRequest
import aws.sdk.kotlin.services.iam.model.DeleteRoleResponse
import aws.sdk.kotlin.services.iam.model.DeleteSamlProviderRequest
import aws.sdk.kotlin.services.iam.model.DeleteSamlProviderResponse
import aws.sdk.kotlin.services.iam.model.DeleteServerCertificateRequest
import aws.sdk.kotlin.services.iam.model.DeleteServerCertificateResponse
import aws.sdk.kotlin.services.iam.model.DeleteServiceLinkedRoleRequest
import aws.sdk.kotlin.services.iam.model.DeleteServiceLinkedRoleResponse
import aws.sdk.kotlin.services.iam.model.DeleteServiceSpecificCredentialRequest
import aws.sdk.kotlin.services.iam.model.DeleteServiceSpecificCredentialResponse
import aws.sdk.kotlin.services.iam.model.DeleteSigningCertificateRequest
import aws.sdk.kotlin.services.iam.model.DeleteSigningCertificateResponse
import aws.sdk.kotlin.services.iam.model.DeleteSshPublicKeyRequest
import aws.sdk.kotlin.services.iam.model.DeleteSshPublicKeyResponse
import aws.sdk.kotlin.services.iam.model.DeleteUserPermissionsBoundaryRequest
import aws.sdk.kotlin.services.iam.model.DeleteUserPermissionsBoundaryResponse
import aws.sdk.kotlin.services.iam.model.DeleteUserPolicyRequest
import aws.sdk.kotlin.services.iam.model.DeleteUserPolicyResponse
import aws.sdk.kotlin.services.iam.model.DeleteUserRequest
import aws.sdk.kotlin.services.iam.model.DeleteUserResponse
import aws.sdk.kotlin.services.iam.model.DeleteVirtualMfaDeviceRequest
import aws.sdk.kotlin.services.iam.model.DeleteVirtualMfaDeviceResponse
import aws.sdk.kotlin.services.iam.model.DetachGroupPolicyRequest
import aws.sdk.kotlin.services.iam.model.DetachGroupPolicyResponse
import aws.sdk.kotlin.services.iam.model.DetachRolePolicyRequest
import aws.sdk.kotlin.services.iam.model.DetachRolePolicyResponse
import aws.sdk.kotlin.services.iam.model.DetachUserPolicyRequest
import aws.sdk.kotlin.services.iam.model.DetachUserPolicyResponse
import aws.sdk.kotlin.services.iam.model.EnableMfaDeviceRequest
import aws.sdk.kotlin.services.iam.model.EnableMfaDeviceResponse
import aws.sdk.kotlin.services.iam.model.GenerateCredentialReportRequest
import aws.sdk.kotlin.services.iam.model.GenerateCredentialReportResponse
import aws.sdk.kotlin.services.iam.model.GenerateOrganizationsAccessReportRequest
import aws.sdk.kotlin.services.iam.model.GenerateOrganizationsAccessReportResponse
import aws.sdk.kotlin.services.iam.model.GenerateServiceLastAccessedDetailsRequest
import aws.sdk.kotlin.services.iam.model.GenerateServiceLastAccessedDetailsResponse
import aws.sdk.kotlin.services.iam.model.GetAccessKeyLastUsedRequest
import aws.sdk.kotlin.services.iam.model.GetAccessKeyLastUsedResponse
import aws.sdk.kotlin.services.iam.model.GetAccountAuthorizationDetailsRequest
import aws.sdk.kotlin.services.iam.model.GetAccountAuthorizationDetailsResponse
import aws.sdk.kotlin.services.iam.model.GetAccountPasswordPolicyRequest
import aws.sdk.kotlin.services.iam.model.GetAccountPasswordPolicyResponse
import aws.sdk.kotlin.services.iam.model.GetAccountSummaryRequest
import aws.sdk.kotlin.services.iam.model.GetAccountSummaryResponse
import aws.sdk.kotlin.services.iam.model.GetContextKeysForCustomPolicyRequest
import aws.sdk.kotlin.services.iam.model.GetContextKeysForCustomPolicyResponse
import aws.sdk.kotlin.services.iam.model.GetContextKeysForPrincipalPolicyRequest
import aws.sdk.kotlin.services.iam.model.GetContextKeysForPrincipalPolicyResponse
import aws.sdk.kotlin.services.iam.model.GetCredentialReportRequest
import aws.sdk.kotlin.services.iam.model.GetCredentialReportResponse
import aws.sdk.kotlin.services.iam.model.GetGroupPolicyRequest
import aws.sdk.kotlin.services.iam.model.GetGroupPolicyResponse
import aws.sdk.kotlin.services.iam.model.GetGroupRequest
import aws.sdk.kotlin.services.iam.model.GetGroupResponse
import aws.sdk.kotlin.services.iam.model.GetInstanceProfileRequest
import aws.sdk.kotlin.services.iam.model.GetInstanceProfileResponse
import aws.sdk.kotlin.services.iam.model.GetLoginProfileRequest
import aws.sdk.kotlin.services.iam.model.GetLoginProfileResponse
import aws.sdk.kotlin.services.iam.model.GetMfaDeviceRequest
import aws.sdk.kotlin.services.iam.model.GetMfaDeviceResponse
import aws.sdk.kotlin.services.iam.model.GetOpenIdConnectProviderRequest
import aws.sdk.kotlin.services.iam.model.GetOpenIdConnectProviderResponse
import aws.sdk.kotlin.services.iam.model.GetOrganizationsAccessReportRequest
import aws.sdk.kotlin.services.iam.model.GetOrganizationsAccessReportResponse
import aws.sdk.kotlin.services.iam.model.GetPolicyRequest
import aws.sdk.kotlin.services.iam.model.GetPolicyResponse
import aws.sdk.kotlin.services.iam.model.GetPolicyVersionRequest
import aws.sdk.kotlin.services.iam.model.GetPolicyVersionResponse
import aws.sdk.kotlin.services.iam.model.GetRolePolicyRequest
import aws.sdk.kotlin.services.iam.model.GetRolePolicyResponse
import aws.sdk.kotlin.services.iam.model.GetRoleRequest
import aws.sdk.kotlin.services.iam.model.GetRoleResponse
import aws.sdk.kotlin.services.iam.model.GetSamlProviderRequest
import aws.sdk.kotlin.services.iam.model.GetSamlProviderResponse
import aws.sdk.kotlin.services.iam.model.GetServerCertificateRequest
import aws.sdk.kotlin.services.iam.model.GetServerCertificateResponse
import aws.sdk.kotlin.services.iam.model.GetServiceLastAccessedDetailsRequest
import aws.sdk.kotlin.services.iam.model.GetServiceLastAccessedDetailsResponse
import aws.sdk.kotlin.services.iam.model.GetServiceLastAccessedDetailsWithEntitiesRequest
import aws.sdk.kotlin.services.iam.model.GetServiceLastAccessedDetailsWithEntitiesResponse
import aws.sdk.kotlin.services.iam.model.GetServiceLinkedRoleDeletionStatusRequest
import aws.sdk.kotlin.services.iam.model.GetServiceLinkedRoleDeletionStatusResponse
import aws.sdk.kotlin.services.iam.model.GetSshPublicKeyRequest
import aws.sdk.kotlin.services.iam.model.GetSshPublicKeyResponse
import aws.sdk.kotlin.services.iam.model.GetUserPolicyRequest
import aws.sdk.kotlin.services.iam.model.GetUserPolicyResponse
import aws.sdk.kotlin.services.iam.model.GetUserRequest
import aws.sdk.kotlin.services.iam.model.GetUserResponse
import aws.sdk.kotlin.services.iam.model.ListAccessKeysRequest
import aws.sdk.kotlin.services.iam.model.ListAccessKeysResponse
import aws.sdk.kotlin.services.iam.model.ListAccountAliasesRequest
import aws.sdk.kotlin.services.iam.model.ListAccountAliasesResponse
import aws.sdk.kotlin.services.iam.model.ListAttachedGroupPoliciesRequest
import aws.sdk.kotlin.services.iam.model.ListAttachedGroupPoliciesResponse
import aws.sdk.kotlin.services.iam.model.ListAttachedRolePoliciesRequest
import aws.sdk.kotlin.services.iam.model.ListAttachedRolePoliciesResponse
import aws.sdk.kotlin.services.iam.model.ListAttachedUserPoliciesRequest
import aws.sdk.kotlin.services.iam.model.ListAttachedUserPoliciesResponse
import aws.sdk.kotlin.services.iam.model.ListEntitiesForPolicyRequest
import aws.sdk.kotlin.services.iam.model.ListEntitiesForPolicyResponse
import aws.sdk.kotlin.services.iam.model.ListGroupPoliciesRequest
import aws.sdk.kotlin.services.iam.model.ListGroupPoliciesResponse
import aws.sdk.kotlin.services.iam.model.ListGroupsForUserRequest
import aws.sdk.kotlin.services.iam.model.ListGroupsForUserResponse
import aws.sdk.kotlin.services.iam.model.ListGroupsRequest
import aws.sdk.kotlin.services.iam.model.ListGroupsResponse
import aws.sdk.kotlin.services.iam.model.ListInstanceProfileTagsRequest
import aws.sdk.kotlin.services.iam.model.ListInstanceProfileTagsResponse
import aws.sdk.kotlin.services.iam.model.ListInstanceProfilesForRoleRequest
import aws.sdk.kotlin.services.iam.model.ListInstanceProfilesForRoleResponse
import aws.sdk.kotlin.services.iam.model.ListInstanceProfilesRequest
import aws.sdk.kotlin.services.iam.model.ListInstanceProfilesResponse
import aws.sdk.kotlin.services.iam.model.ListMfaDeviceTagsRequest
import aws.sdk.kotlin.services.iam.model.ListMfaDeviceTagsResponse
import aws.sdk.kotlin.services.iam.model.ListMfaDevicesRequest
import aws.sdk.kotlin.services.iam.model.ListMfaDevicesResponse
import aws.sdk.kotlin.services.iam.model.ListOpenIdConnectProviderTagsRequest
import aws.sdk.kotlin.services.iam.model.ListOpenIdConnectProviderTagsResponse
import aws.sdk.kotlin.services.iam.model.ListOpenIdConnectProvidersRequest
import aws.sdk.kotlin.services.iam.model.ListOpenIdConnectProvidersResponse
import aws.sdk.kotlin.services.iam.model.ListPoliciesGrantingServiceAccessRequest
import aws.sdk.kotlin.services.iam.model.ListPoliciesGrantingServiceAccessResponse
import aws.sdk.kotlin.services.iam.model.ListPoliciesRequest
import aws.sdk.kotlin.services.iam.model.ListPoliciesResponse
import aws.sdk.kotlin.services.iam.model.ListPolicyTagsRequest
import aws.sdk.kotlin.services.iam.model.ListPolicyTagsResponse
import aws.sdk.kotlin.services.iam.model.ListPolicyVersionsRequest
import aws.sdk.kotlin.services.iam.model.ListPolicyVersionsResponse
import aws.sdk.kotlin.services.iam.model.ListRolePoliciesRequest
import aws.sdk.kotlin.services.iam.model.ListRolePoliciesResponse
import aws.sdk.kotlin.services.iam.model.ListRoleTagsRequest
import aws.sdk.kotlin.services.iam.model.ListRoleTagsResponse
import aws.sdk.kotlin.services.iam.model.ListRolesRequest
import aws.sdk.kotlin.services.iam.model.ListRolesResponse
import aws.sdk.kotlin.services.iam.model.ListSamlProviderTagsRequest
import aws.sdk.kotlin.services.iam.model.ListSamlProviderTagsResponse
import aws.sdk.kotlin.services.iam.model.ListSamlProvidersRequest
import aws.sdk.kotlin.services.iam.model.ListSamlProvidersResponse
import aws.sdk.kotlin.services.iam.model.ListServerCertificateTagsRequest
import aws.sdk.kotlin.services.iam.model.ListServerCertificateTagsResponse
import aws.sdk.kotlin.services.iam.model.ListServerCertificatesRequest
import aws.sdk.kotlin.services.iam.model.ListServerCertificatesResponse
import aws.sdk.kotlin.services.iam.model.ListServiceSpecificCredentialsRequest
import aws.sdk.kotlin.services.iam.model.ListServiceSpecificCredentialsResponse
import aws.sdk.kotlin.services.iam.model.ListSigningCertificatesRequest
import aws.sdk.kotlin.services.iam.model.ListSigningCertificatesResponse
import aws.sdk.kotlin.services.iam.model.ListSshPublicKeysRequest
import aws.sdk.kotlin.services.iam.model.ListSshPublicKeysResponse
import aws.sdk.kotlin.services.iam.model.ListUserPoliciesRequest
import aws.sdk.kotlin.services.iam.model.ListUserPoliciesResponse
import aws.sdk.kotlin.services.iam.model.ListUserTagsRequest
import aws.sdk.kotlin.services.iam.model.ListUserTagsResponse
import aws.sdk.kotlin.services.iam.model.ListUsersRequest
import aws.sdk.kotlin.services.iam.model.ListUsersResponse
import aws.sdk.kotlin.services.iam.model.ListVirtualMfaDevicesRequest
import aws.sdk.kotlin.services.iam.model.ListVirtualMfaDevicesResponse
import aws.sdk.kotlin.services.iam.model.PutGroupPolicyRequest
import aws.sdk.kotlin.services.iam.model.PutGroupPolicyResponse
import aws.sdk.kotlin.services.iam.model.PutRolePermissionsBoundaryRequest
import aws.sdk.kotlin.services.iam.model.PutRolePermissionsBoundaryResponse
import aws.sdk.kotlin.services.iam.model.PutRolePolicyRequest
import aws.sdk.kotlin.services.iam.model.PutRolePolicyResponse
import aws.sdk.kotlin.services.iam.model.PutUserPermissionsBoundaryRequest
import aws.sdk.kotlin.services.iam.model.PutUserPermissionsBoundaryResponse
import aws.sdk.kotlin.services.iam.model.PutUserPolicyRequest
import aws.sdk.kotlin.services.iam.model.PutUserPolicyResponse
import aws.sdk.kotlin.services.iam.model.RemoveClientIdFromOpenIdConnectProviderRequest
import aws.sdk.kotlin.services.iam.model.RemoveClientIdFromOpenIdConnectProviderResponse
import aws.sdk.kotlin.services.iam.model.RemoveRoleFromInstanceProfileRequest
import aws.sdk.kotlin.services.iam.model.RemoveRoleFromInstanceProfileResponse
import aws.sdk.kotlin.services.iam.model.RemoveUserFromGroupRequest
import aws.sdk.kotlin.services.iam.model.RemoveUserFromGroupResponse
import aws.sdk.kotlin.services.iam.model.ResetServiceSpecificCredentialRequest
import aws.sdk.kotlin.services.iam.model.ResetServiceSpecificCredentialResponse
import aws.sdk.kotlin.services.iam.model.ResyncMfaDeviceRequest
import aws.sdk.kotlin.services.iam.model.ResyncMfaDeviceResponse
import aws.sdk.kotlin.services.iam.model.SetDefaultPolicyVersionRequest
import aws.sdk.kotlin.services.iam.model.SetDefaultPolicyVersionResponse
import aws.sdk.kotlin.services.iam.model.SetSecurityTokenServicePreferencesRequest
import aws.sdk.kotlin.services.iam.model.SetSecurityTokenServicePreferencesResponse
import aws.sdk.kotlin.services.iam.model.SimulateCustomPolicyRequest
import aws.sdk.kotlin.services.iam.model.SimulateCustomPolicyResponse
import aws.sdk.kotlin.services.iam.model.SimulatePrincipalPolicyRequest
import aws.sdk.kotlin.services.iam.model.SimulatePrincipalPolicyResponse
import aws.sdk.kotlin.services.iam.model.TagInstanceProfileRequest
import aws.sdk.kotlin.services.iam.model.TagInstanceProfileResponse
import aws.sdk.kotlin.services.iam.model.TagMfaDeviceRequest
import aws.sdk.kotlin.services.iam.model.TagMfaDeviceResponse
import aws.sdk.kotlin.services.iam.model.TagOpenIdConnectProviderRequest
import aws.sdk.kotlin.services.iam.model.TagOpenIdConnectProviderResponse
import aws.sdk.kotlin.services.iam.model.TagPolicyRequest
import aws.sdk.kotlin.services.iam.model.TagPolicyResponse
import aws.sdk.kotlin.services.iam.model.TagRoleRequest
import aws.sdk.kotlin.services.iam.model.TagRoleResponse
import aws.sdk.kotlin.services.iam.model.TagSamlProviderRequest
import aws.sdk.kotlin.services.iam.model.TagSamlProviderResponse
import aws.sdk.kotlin.services.iam.model.TagServerCertificateRequest
import aws.sdk.kotlin.services.iam.model.TagServerCertificateResponse
import aws.sdk.kotlin.services.iam.model.TagUserRequest
import aws.sdk.kotlin.services.iam.model.TagUserResponse
import aws.sdk.kotlin.services.iam.model.UntagInstanceProfileRequest
import aws.sdk.kotlin.services.iam.model.UntagInstanceProfileResponse
import aws.sdk.kotlin.services.iam.model.UntagMfaDeviceRequest
import aws.sdk.kotlin.services.iam.model.UntagMfaDeviceResponse
import aws.sdk.kotlin.services.iam.model.UntagOpenIdConnectProviderRequest
import aws.sdk.kotlin.services.iam.model.UntagOpenIdConnectProviderResponse
import aws.sdk.kotlin.services.iam.model.UntagPolicyRequest
import aws.sdk.kotlin.services.iam.model.UntagPolicyResponse
import aws.sdk.kotlin.services.iam.model.UntagRoleRequest
import aws.sdk.kotlin.services.iam.model.UntagRoleResponse
import aws.sdk.kotlin.services.iam.model.UntagSamlProviderRequest
import aws.sdk.kotlin.services.iam.model.UntagSamlProviderResponse
import aws.sdk.kotlin.services.iam.model.UntagServerCertificateRequest
import aws.sdk.kotlin.services.iam.model.UntagServerCertificateResponse
import aws.sdk.kotlin.services.iam.model.UntagUserRequest
import aws.sdk.kotlin.services.iam.model.UntagUserResponse
import aws.sdk.kotlin.services.iam.model.UpdateAccessKeyRequest
import aws.sdk.kotlin.services.iam.model.UpdateAccessKeyResponse
import aws.sdk.kotlin.services.iam.model.UpdateAccountPasswordPolicyRequest
import aws.sdk.kotlin.services.iam.model.UpdateAccountPasswordPolicyResponse
import aws.sdk.kotlin.services.iam.model.UpdateAssumeRolePolicyRequest
import aws.sdk.kotlin.services.iam.model.UpdateAssumeRolePolicyResponse
import aws.sdk.kotlin.services.iam.model.UpdateGroupRequest
import aws.sdk.kotlin.services.iam.model.UpdateGroupResponse
import aws.sdk.kotlin.services.iam.model.UpdateLoginProfileRequest
import aws.sdk.kotlin.services.iam.model.UpdateLoginProfileResponse
import aws.sdk.kotlin.services.iam.model.UpdateOpenIdConnectProviderThumbprintRequest
import aws.sdk.kotlin.services.iam.model.UpdateOpenIdConnectProviderThumbprintResponse
import aws.sdk.kotlin.services.iam.model.UpdateRoleDescriptionRequest
import aws.sdk.kotlin.services.iam.model.UpdateRoleDescriptionResponse
import aws.sdk.kotlin.services.iam.model.UpdateRoleRequest
import aws.sdk.kotlin.services.iam.model.UpdateRoleResponse
import aws.sdk.kotlin.services.iam.model.UpdateSamlProviderRequest
import aws.sdk.kotlin.services.iam.model.UpdateSamlProviderResponse
import aws.sdk.kotlin.services.iam.model.UpdateServerCertificateRequest
import aws.sdk.kotlin.services.iam.model.UpdateServerCertificateResponse
import aws.sdk.kotlin.services.iam.model.UpdateServiceSpecificCredentialRequest
import aws.sdk.kotlin.services.iam.model.UpdateServiceSpecificCredentialResponse
import aws.sdk.kotlin.services.iam.model.UpdateSigningCertificateRequest
import aws.sdk.kotlin.services.iam.model.UpdateSigningCertificateResponse
import aws.sdk.kotlin.services.iam.model.UpdateSshPublicKeyRequest
import aws.sdk.kotlin.services.iam.model.UpdateSshPublicKeyResponse
import aws.sdk.kotlin.services.iam.model.UpdateUserRequest
import aws.sdk.kotlin.services.iam.model.UpdateUserResponse
import aws.sdk.kotlin.services.iam.model.UploadServerCertificateRequest
import aws.sdk.kotlin.services.iam.model.UploadServerCertificateResponse
import aws.sdk.kotlin.services.iam.model.UploadSigningCertificateRequest
import aws.sdk.kotlin.services.iam.model.UploadSigningCertificateResponse
import aws.sdk.kotlin.services.iam.model.UploadSshPublicKeyRequest
import aws.sdk.kotlin.services.iam.model.UploadSshPublicKeyResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "IAM"
public const val SdkVersion: String = "1.0.52"
public const val ServiceApiVersion: String = "2010-05-08"

/**
 * # Identity and Access Management
 * Identity and Access Management (IAM) is a web service for securely controlling access to Amazon Web Services services. With IAM, you can centrally manage users, security credentials such as access keys, and permissions that control which Amazon Web Services resources users and applications can access. For more information about IAM, see [Identity and Access Management (IAM)](http://aws.amazon.com/iam/) and the [Identity and Access Management User Guide](https://docs.aws.amazon.com/IAM/latest/UserGuide/).
 */
public interface IamClient : SdkClient {
    /**
     * IamClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, IamClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Iam",
                "IAM",
                "iam",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, IamClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): IamClient = DefaultIamClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: IamEndpointProvider = builder.endpointProvider ?: DefaultIamEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: IamAuthSchemeProvider = builder.authSchemeProvider ?: DefaultIamAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "IAM"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: IamEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: IamAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Adds a new client ID (also known as audience) to the list of client IDs already registered for the specified IAM OpenID Connect (OIDC) provider resource.
     *
     * This operation is idempotent; it does not fail or return an error if you add an existing client ID to the provider.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.AddClientIDToOpenIDConnectProvider.sample
     */
    public suspend fun addClientIdToOpenIdConnectProvider(input: AddClientIdToOpenIdConnectProviderRequest): AddClientIdToOpenIdConnectProviderResponse

    /**
     * Adds the specified IAM role to the specified instance profile. An instance profile can contain only one role, and this quota cannot be increased. You can remove the existing role and then add a different role to an instance profile. You must then wait for the change to appear across all of Amazon Web Services because of [eventual consistency](https://en.wikipedia.org/wiki/Eventual_consistency). To force the change, you must [disassociate the instance profile](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateIamInstanceProfile.html) and then [associate the instance profile](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateIamInstanceProfile.html), or you can stop your instance and then restart it.
     *
     * The caller of this operation must be granted the `PassRole` permission on the IAM role by a permissions policy.
     *
     *  For more information about roles, see [IAM roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html) in the *IAM User Guide*. For more information about instance profiles, see [Using instance profiles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2_instance-profiles.html) in the *IAM User Guide*.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.AddRoleToInstanceProfile.sample
     */
    public suspend fun addRoleToInstanceProfile(input: AddRoleToInstanceProfileRequest): AddRoleToInstanceProfileResponse

    /**
     * Adds the specified user to the specified group.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.AddUserToGroup.sample
     */
    public suspend fun addUserToGroup(input: AddUserToGroupRequest): AddUserToGroupResponse

    /**
     * Attaches the specified managed policy to the specified IAM group.
     *
     * You use this operation to attach a managed policy to a group. To embed an inline policy in a group, use `PutGroupPolicy`[](https://docs.aws.amazon.com/IAM/latest/APIReference/API_PutGroupPolicy.html).
     *
     * As a best practice, you can validate your IAM policies. To learn more, see [Validating IAM policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html) in the *IAM User Guide*.
     *
     * For more information about policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.AttachGroupPolicy.sample
     */
    public suspend fun attachGroupPolicy(input: AttachGroupPolicyRequest): AttachGroupPolicyResponse

    /**
     * Attaches the specified managed policy to the specified IAM role. When you attach a managed policy to a role, the managed policy becomes part of the role's permission (access) policy.
     *
     * You cannot use a managed policy as the role's trust policy. The role's trust policy is created at the same time as the role, using `CreateRole`[](https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html). You can update a role's trust policy using `UpdateAssumerolePolicy`[](https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateAssumeRolePolicy.html).
     *
     * Use this operation to attach a *managed* policy to a role. To embed an inline policy in a role, use `PutRolePolicy`[](https://docs.aws.amazon.com/IAM/latest/APIReference/API_PutRolePolicy.html). For more information about policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
     *
     * As a best practice, you can validate your IAM policies. To learn more, see [Validating IAM policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html) in the *IAM User Guide*.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.AttachRolePolicy.sample
     */
    public suspend fun attachRolePolicy(input: AttachRolePolicyRequest): AttachRolePolicyResponse

    /**
     * Attaches the specified managed policy to the specified user.
     *
     * You use this operation to attach a *managed* policy to a user. To embed an inline policy in a user, use `PutUserPolicy`[](https://docs.aws.amazon.com/IAM/latest/APIReference/API_PutUserPolicy.html).
     *
     * As a best practice, you can validate your IAM policies. To learn more, see [Validating IAM policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html) in the *IAM User Guide*.
     *
     * For more information about policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.AttachUserPolicy.sample
     */
    public suspend fun attachUserPolicy(input: AttachUserPolicyRequest): AttachUserPolicyResponse

    /**
     * Changes the password of the IAM user who is calling this operation. This operation can be performed using the CLI, the Amazon Web Services API, or the **My Security Credentials** page in the Amazon Web Services Management Console. The Amazon Web Services account root user password is not affected by this operation.
     *
     * Use UpdateLoginProfile to use the CLI, the Amazon Web Services API, or the **Users** page in the IAM console to change the password for any IAM user. For more information about modifying passwords, see [Managing passwords](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html) in the *IAM User Guide*.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.ChangePassword.sample
     */
    public suspend fun changePassword(input: ChangePasswordRequest): ChangePasswordResponse

    /**
     * Creates a new Amazon Web Services secret access key and corresponding Amazon Web Services access key ID for the specified user. The default status for new keys is `Active`.
     *
     * If you do not specify a user name, IAM determines the user name implicitly based on the Amazon Web Services access key ID signing the request. This operation works for access keys under the Amazon Web Services account. Consequently, you can use this operation to manage Amazon Web Services account root user credentials. This is true even if the Amazon Web Services account has no associated users.
     *
     *  For information about quotas on the number of keys you can create, see [IAM and STS quotas](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html) in the *IAM User Guide*.
     *
     * To ensure the security of your Amazon Web Services account, the secret access key is accessible only during key and user creation. You must save the key (for example, in a text file) if you want to be able to access it again. If a secret key is lost, you can delete the access keys for the associated user and then create new keys.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.CreateAccessKey.sample
     */
    public suspend fun createAccessKey(input: CreateAccessKeyRequest = CreateAccessKeyRequest { }): CreateAccessKeyResponse

    /**
     * Creates an alias for your Amazon Web Services account. For information about using an Amazon Web Services account alias, see [Creating, deleting, and listing an Amazon Web Services account alias](https://docs.aws.amazon.com/signin/latest/userguide/CreateAccountAlias.html) in the *Amazon Web Services Sign-In User Guide*.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.CreateAccountAlias.sample
     */
    public suspend fun createAccountAlias(input: CreateAccountAliasRequest): CreateAccountAliasResponse

    /**
     * Creates a new group.
     *
     *  For information about the number of groups you can create, see [IAM and STS quotas](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html) in the *IAM User Guide*.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.CreateGroup.sample
     */
    public suspend fun createGroup(input: CreateGroupRequest): CreateGroupResponse

    /**
     * Creates a new instance profile. For information about instance profiles, see [Using roles for applications on Amazon EC2](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html) in the *IAM User Guide*, and [Instance profiles](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-roles-for-amazon-ec2.html#ec2-instance-profile) in the *Amazon EC2 User Guide*.
     *
     *  For information about the number of instance profiles you can create, see [IAM object quotas](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html) in the *IAM User Guide*.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.CreateInstanceProfile.sample
     */
    public suspend fun createInstanceProfile(input: CreateInstanceProfileRequest): CreateInstanceProfileResponse

    /**
     * Creates a password for the specified IAM user. A password allows an IAM user to access Amazon Web Services services through the Amazon Web Services Management Console.
     *
     * You can use the CLI, the Amazon Web Services API, or the **Users** page in the IAM console to create a password for any IAM user. Use ChangePassword to update your own existing password in the **My Security Credentials** page in the Amazon Web Services Management Console.
     *
     * For more information about managing passwords, see [Managing passwords](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html) in the *IAM User Guide*.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.CreateLoginProfile.sample
     */
    public suspend fun createLoginProfile(input: CreateLoginProfileRequest): CreateLoginProfileResponse

    /**
     * Creates an IAM entity to describe an identity provider (IdP) that supports [OpenID Connect (OIDC)](http://openid.net/connect/).
     *
     * The OIDC provider that you create with this operation can be used as a principal in a role's trust policy. Such a policy establishes a trust relationship between Amazon Web Services and the OIDC provider.
     *
     * If you are using an OIDC identity provider from Google, Facebook, or Amazon Cognito, you don't need to create a separate IAM identity provider. These OIDC identity providers are already built-in to Amazon Web Services and are available for your use. Instead, you can move directly to creating new roles using your identity provider. To learn more, see [Creating a role for web identity or OpenID connect federation](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-idp_oidc.html) in the *IAM User Guide*.
     *
     * When you create the IAM OIDC provider, you specify the following:
     * + The URL of the OIDC identity provider (IdP) to trust
     * + A list of client IDs (also known as audiences) that identify the application or applications allowed to authenticate using the OIDC provider
     * + A list of tags that are attached to the specified IAM OIDC provider
     * + A list of thumbprints of one or more server certificates that the IdP uses
     *
     * You get all of this information from the OIDC IdP you want to use to access Amazon Web Services.
     *
     * Amazon Web Services secures communication with some OIDC identity providers (IdPs) through our library of trusted root certificate authorities (CAs) instead of using a certificate thumbprint to verify your IdP server certificate. In these cases, your legacy thumbprint remains in your configuration, but is no longer used for validation. These OIDC IdPs include Auth0, GitHub, GitLab, Google, and those that use an Amazon S3 bucket to host a JSON Web Key Set (JWKS) endpoint.
     *
     * The trust for the OIDC provider is derived from the IAM provider that this operation creates. Therefore, it is best to limit access to the CreateOpenIDConnectProvider operation to highly privileged users.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.CreateOpenIDConnectProvider.sample
     */
    public suspend fun createOpenIdConnectProvider(input: CreateOpenIdConnectProviderRequest): CreateOpenIdConnectProviderResponse

    /**
     * Creates a new managed policy for your Amazon Web Services account.
     *
     * This operation creates a policy version with a version identifier of `v1` and sets v1 as the policy's default version. For more information about policy versions, see [Versioning for managed policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html) in the *IAM User Guide*.
     *
     * As a best practice, you can validate your IAM policies. To learn more, see [Validating IAM policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html) in the *IAM User Guide*.
     *
     * For more information about managed policies in general, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
     */
    public suspend fun createPolicy(input: CreatePolicyRequest): CreatePolicyResponse

    /**
     * Creates a new version of the specified managed policy. To update a managed policy, you create a new policy version. A managed policy can have up to five versions. If the policy has five versions, you must delete an existing version using DeletePolicyVersion before you create a new version.
     *
     * Optionally, you can set the new version as the policy's default version. The default version is the version that is in effect for the IAM users, groups, and roles to which the policy is attached.
     *
     * For more information about managed policy versions, see [Versioning for managed policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html) in the *IAM User Guide*.
     */
    public suspend fun createPolicyVersion(input: CreatePolicyVersionRequest): CreatePolicyVersionResponse

    /**
     * Creates a new role for your Amazon Web Services account.
     *
     *  For more information about roles, see [IAM roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html) in the *IAM User Guide*. For information about quotas for role names and the number of roles you can create, see [IAM and STS quotas](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html) in the *IAM User Guide*.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.CreateRole.sample
     */
    public suspend fun createRole(input: CreateRoleRequest): CreateRoleResponse

    /**
     * Creates an IAM resource that describes an identity provider (IdP) that supports SAML 2.0.
     *
     * The SAML provider resource that you create with this operation can be used as a principal in an IAM role's trust policy. Such a policy can enable federated users who sign in using the SAML IdP to assume the role. You can create an IAM role that supports Web-based single sign-on (SSO) to the Amazon Web Services Management Console or one that supports API access to Amazon Web Services.
     *
     * When you create the SAML provider resource, you upload a SAML metadata document that you get from your IdP. That document includes the issuer's name, expiration information, and keys that can be used to validate the SAML authentication response (assertions) that the IdP sends. You must generate the metadata document using the identity management software that is used as your organization's IdP.
     *
     *  This operation requires [Signature Version 4](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
     *
     *  For more information, see [Enabling SAML 2.0 federated users to access the Amazon Web Services Management Console](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-saml.html) and [About SAML 2.0-based federation](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html) in the *IAM User Guide*.
     */
    public suspend fun createSamlProvider(input: CreateSamlProviderRequest): CreateSamlProviderResponse

    /**
     * Creates an IAM role that is linked to a specific Amazon Web Services service. The service controls the attached policies and when the role can be deleted. This helps ensure that the service is not broken by an unexpectedly changed or deleted role, which could put your Amazon Web Services resources into an unknown state. Allowing the service to control the role helps improve service stability and proper cleanup when a service and its role are no longer needed. For more information, see [Using service-linked roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/using-service-linked-roles.html) in the *IAM User Guide*.
     *
     * To attach a policy to this service-linked role, you must make the request using the Amazon Web Services service that depends on this role.
     */
    public suspend fun createServiceLinkedRole(input: CreateServiceLinkedRoleRequest): CreateServiceLinkedRoleResponse

    /**
     * Generates a set of credentials consisting of a user name and password that can be used to access the service specified in the request. These credentials are generated by IAM, and can be used only for the specified service.
     *
     * You can have a maximum of two sets of service-specific credentials for each supported service per user.
     *
     * You can create service-specific credentials for CodeCommit and Amazon Keyspaces (for Apache Cassandra).
     *
     * You can reset the password to a new service-generated value by calling ResetServiceSpecificCredential.
     *
     * For more information about service-specific credentials, see [Using IAM with CodeCommit: Git credentials, SSH keys, and Amazon Web Services access keys](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_ssh-keys.html) in the *IAM User Guide*.
     */
    public suspend fun createServiceSpecificCredential(input: CreateServiceSpecificCredentialRequest): CreateServiceSpecificCredentialResponse

    /**
     * Creates a new IAM user for your Amazon Web Services account.
     *
     *  For information about quotas for the number of IAM users you can create, see [IAM and STS quotas](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html) in the *IAM User Guide*.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.CreateUser.sample
     */
    public suspend fun createUser(input: CreateUserRequest): CreateUserResponse

    /**
     * Creates a new virtual MFA device for the Amazon Web Services account. After creating the virtual MFA, use EnableMFADevice to attach the MFA device to an IAM user. For more information about creating and working with virtual MFA devices, see [Using a virtual MFA device](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html) in the *IAM User Guide*.
     *
     * For information about the maximum number of MFA devices you can create, see [IAM and STS quotas](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html) in the *IAM User Guide*.
     *
     * The seed information contained in the QR code and the Base32 string should be treated like any other secret access information. In other words, protect the seed information as you would your Amazon Web Services access keys or your passwords. After you provision your virtual device, you should ensure that the information is destroyed following secure procedures.
     */
    public suspend fun createVirtualMfaDevice(input: CreateVirtualMfaDeviceRequest): CreateVirtualMfaDeviceResponse

    /**
     * Deactivates the specified MFA device and removes it from association with the user name for which it was originally enabled.
     *
     * For more information about creating and working with virtual MFA devices, see [Enabling a virtual multi-factor authentication (MFA) device](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html) in the *IAM User Guide*.
     */
    public suspend fun deactivateMfaDevice(input: DeactivateMfaDeviceRequest): DeactivateMfaDeviceResponse

    /**
     * Deletes the access key pair associated with the specified IAM user.
     *
     * If you do not specify a user name, IAM determines the user name implicitly based on the Amazon Web Services access key ID signing the request. This operation works for access keys under the Amazon Web Services account. Consequently, you can use this operation to manage Amazon Web Services account root user credentials even if the Amazon Web Services account has no associated users.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.DeleteAccessKey.sample
     */
    public suspend fun deleteAccessKey(input: DeleteAccessKeyRequest): DeleteAccessKeyResponse

    /**
     * Deletes the specified Amazon Web Services account alias. For information about using an Amazon Web Services account alias, see [Creating, deleting, and listing an Amazon Web Services account alias](https://docs.aws.amazon.com/signin/latest/userguide/CreateAccountAlias.html) in the *Amazon Web Services Sign-In User Guide*.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.DeleteAccountAlias.sample
     */
    public suspend fun deleteAccountAlias(input: DeleteAccountAliasRequest): DeleteAccountAliasResponse

    /**
     * Deletes the password policy for the Amazon Web Services account. There are no parameters.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.DeleteAccountPasswordPolicy.sample
     */
    public suspend fun deleteAccountPasswordPolicy(input: DeleteAccountPasswordPolicyRequest = DeleteAccountPasswordPolicyRequest { }): DeleteAccountPasswordPolicyResponse

    /**
     * Deletes the specified IAM group. The group must not contain any users or have any attached policies.
     */
    public suspend fun deleteGroup(input: DeleteGroupRequest): DeleteGroupResponse

    /**
     * Deletes the specified inline policy that is embedded in the specified IAM group.
     *
     * A group can also have managed policies attached to it. To detach a managed policy from a group, use DetachGroupPolicy. For more information about policies, refer to [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.DeleteGroupPolicy.sample
     */
    public suspend fun deleteGroupPolicy(input: DeleteGroupPolicyRequest): DeleteGroupPolicyResponse

    /**
     * Deletes the specified instance profile. The instance profile must not have an associated role.
     *
     * Make sure that you do not have any Amazon EC2 instances running with the instance profile you are about to delete. Deleting a role or instance profile that is associated with a running instance will break any applications running on the instance.
     *
     * For more information about instance profiles, see [Using instance profiles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2_instance-profiles.html) in the *IAM User Guide*.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.DeleteInstanceProfile.sample
     */
    public suspend fun deleteInstanceProfile(input: DeleteInstanceProfileRequest): DeleteInstanceProfileResponse

    /**
     * Deletes the password for the specified IAM user, For more information, see [Managing passwords for IAM users](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_passwords_admin-change-user.html).
     *
     * You can use the CLI, the Amazon Web Services API, or the **Users** page in the IAM console to delete a password for any IAM user. You can use ChangePassword to update, but not delete, your own password in the **My Security Credentials** page in the Amazon Web Services Management Console.
     *
     * Deleting a user's password does not prevent a user from accessing Amazon Web Services through the command line interface or the API. To prevent all user access, you must also either make any access keys inactive or delete them. For more information about making keys inactive or deleting them, see UpdateAccessKey and DeleteAccessKey.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.DeleteLoginProfile.sample
     */
    public suspend fun deleteLoginProfile(input: DeleteLoginProfileRequest): DeleteLoginProfileResponse

    /**
     * Deletes an OpenID Connect identity provider (IdP) resource object in IAM.
     *
     * Deleting an IAM OIDC provider resource does not update any roles that reference the provider as a principal in their trust policies. Any attempt to assume a role that references a deleted provider fails.
     *
     * This operation is idempotent; it does not fail or return an error if you call the operation for a provider that does not exist.
     */
    public suspend fun deleteOpenIdConnectProvider(input: DeleteOpenIdConnectProviderRequest): DeleteOpenIdConnectProviderResponse

    /**
     * Deletes the specified managed policy.
     *
     * Before you can delete a managed policy, you must first detach the policy from all users, groups, and roles that it is attached to. In addition, you must delete all the policy's versions. The following steps describe the process for deleting a managed policy:
     * + Detach the policy from all users, groups, and roles that the policy is attached to, using DetachUserPolicy, DetachGroupPolicy, or DetachRolePolicy. To list all the users, groups, and roles that a policy is attached to, use ListEntitiesForPolicy.
     * + Delete all versions of the policy using DeletePolicyVersion. To list the policy's versions, use ListPolicyVersions. You cannot use DeletePolicyVersion to delete the version that is marked as the default version. You delete the policy's default version in the next step of the process.
     * + Delete the policy (this automatically deletes the policy's default version) using this operation.
     *
     * For information about managed policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
     */
    public suspend fun deletePolicy(input: DeletePolicyRequest): DeletePolicyResponse

    /**
     * Deletes the specified version from the specified managed policy.
     *
     * You cannot delete the default version from a policy using this operation. To delete the default version from a policy, use DeletePolicy. To find out which version of a policy is marked as the default version, use ListPolicyVersions.
     *
     * For information about versions for managed policies, see [Versioning for managed policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html) in the *IAM User Guide*.
     */
    public suspend fun deletePolicyVersion(input: DeletePolicyVersionRequest): DeletePolicyVersionResponse

    /**
     * Deletes the specified role. Unlike the Amazon Web Services Management Console, when you delete a role programmatically, you must delete the items attached to the role manually, or the deletion fails. For more information, see [Deleting an IAM role](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_manage_delete.html#roles-managingrole-deleting-cli). Before attempting to delete a role, remove the following attached items:
     * + Inline policies (DeleteRolePolicy)
     * + Attached managed policies (DetachRolePolicy)
     * + Instance profile (RemoveRoleFromInstanceProfile)
     * + Optional – Delete instance profile after detaching from role for resource clean up (DeleteInstanceProfile)
     *
     * Make sure that you do not have any Amazon EC2 instances running with the role you are about to delete. Deleting a role or instance profile that is associated with a running instance will break any applications running on the instance.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.DeleteRole.sample
     */
    public suspend fun deleteRole(input: DeleteRoleRequest): DeleteRoleResponse

    /**
     * Deletes the permissions boundary for the specified IAM role.
     *
     * You cannot set the boundary for a service-linked role.
     *
     * Deleting the permissions boundary for a role might increase its permissions. For example, it might allow anyone who assumes the role to perform all the actions granted in its permissions policies.
     */
    public suspend fun deleteRolePermissionsBoundary(input: DeleteRolePermissionsBoundaryRequest): DeleteRolePermissionsBoundaryResponse

    /**
     * Deletes the specified inline policy that is embedded in the specified IAM role.
     *
     * A role can also have managed policies attached to it. To detach a managed policy from a role, use DetachRolePolicy. For more information about policies, refer to [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.DeleteRolePolicy.sample
     */
    public suspend fun deleteRolePolicy(input: DeleteRolePolicyRequest): DeleteRolePolicyResponse

    /**
     * Deletes a SAML provider resource in IAM.
     *
     * Deleting the provider resource from IAM does not update any roles that reference the SAML provider resource's ARN as a principal in their trust policies. Any attempt to assume a role that references a non-existent provider resource ARN fails.
     *
     *  This operation requires [Signature Version 4](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
     */
    public suspend fun deleteSamlProvider(input: DeleteSamlProviderRequest): DeleteSamlProviderResponse

    /**
     * Deletes the specified server certificate.
     *
     * For more information about working with server certificates, see [Working with server certificates](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html) in the *IAM User Guide*. This topic also includes a list of Amazon Web Services services that can use the server certificates that you manage with IAM.
     *
     *  If you are using a server certificate with Elastic Load Balancing, deleting the certificate could have implications for your application. If Elastic Load Balancing doesn't detect the deletion of bound certificates, it may continue to use the certificates. This could cause Elastic Load Balancing to stop accepting traffic. We recommend that you remove the reference to the certificate from Elastic Load Balancing before using this command to delete the certificate. For more information, see [DeleteLoadBalancerListeners](https://docs.aws.amazon.com/ElasticLoadBalancing/latest/APIReference/API_DeleteLoadBalancerListeners.html) in the *Elastic Load Balancing API Reference*.
     */
    public suspend fun deleteServerCertificate(input: DeleteServerCertificateRequest): DeleteServerCertificateResponse

    /**
     * Submits a service-linked role deletion request and returns a `DeletionTaskId`, which you can use to check the status of the deletion. Before you call this operation, confirm that the role has no active sessions and that any resources used by the role in the linked service are deleted. If you call this operation more than once for the same service-linked role and an earlier deletion task is not complete, then the `DeletionTaskId` of the earlier request is returned.
     *
     * If you submit a deletion request for a service-linked role whose linked service is still accessing a resource, then the deletion task fails. If it fails, the GetServiceLinkedRoleDeletionStatus operation returns the reason for the failure, usually including the resources that must be deleted. To delete the service-linked role, you must first remove those resources from the linked service and then submit the deletion request again. Resources are specific to the service that is linked to the role. For more information about removing resources from a service, see the [Amazon Web Services documentation](http://docs.aws.amazon.com/) for your service.
     *
     * For more information about service-linked roles, see [Roles terms and concepts: Amazon Web Services service-linked role](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-linked-role) in the *IAM User Guide*.
     */
    public suspend fun deleteServiceLinkedRole(input: DeleteServiceLinkedRoleRequest): DeleteServiceLinkedRoleResponse

    /**
     * Deletes the specified service-specific credential.
     */
    public suspend fun deleteServiceSpecificCredential(input: DeleteServiceSpecificCredentialRequest): DeleteServiceSpecificCredentialResponse

    /**
     * Deletes a signing certificate associated with the specified IAM user.
     *
     * If you do not specify a user name, IAM determines the user name implicitly based on the Amazon Web Services access key ID signing the request. This operation works for access keys under the Amazon Web Services account. Consequently, you can use this operation to manage Amazon Web Services account root user credentials even if the Amazon Web Services account has no associated IAM users.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.DeleteSigningCertificate.sample
     */
    public suspend fun deleteSigningCertificate(input: DeleteSigningCertificateRequest): DeleteSigningCertificateResponse

    /**
     * Deletes the specified SSH public key.
     *
     * The SSH public key deleted by this operation is used only for authenticating the associated IAM user to an CodeCommit repository. For more information about using SSH keys to authenticate to an CodeCommit repository, see [Set up CodeCommit for SSH connections](https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html) in the *CodeCommit User Guide*.
     */
    public suspend fun deleteSshPublicKey(input: DeleteSshPublicKeyRequest): DeleteSshPublicKeyResponse

    /**
     * Deletes the specified IAM user. Unlike the Amazon Web Services Management Console, when you delete a user programmatically, you must delete the items attached to the user manually, or the deletion fails. For more information, see [Deleting an IAM user](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users_manage.html#id_users_deleting_cli). Before attempting to delete a user, remove the following items:
     * + Password (DeleteLoginProfile)
     * + Access keys (DeleteAccessKey)
     * + Signing certificate (DeleteSigningCertificate)
     * + SSH public key (DeleteSSHPublicKey)
     * + Git credentials (DeleteServiceSpecificCredential)
     * + Multi-factor authentication (MFA) device (DeactivateMFADevice, DeleteVirtualMFADevice)
     * + Inline policies (DeleteUserPolicy)
     * + Attached managed policies (DetachUserPolicy)
     * + Group memberships (RemoveUserFromGroup)
     *
     * @sample aws.sdk.kotlin.services.iam.samples.DeleteUser.sample
     */
    public suspend fun deleteUser(input: DeleteUserRequest): DeleteUserResponse

    /**
     * Deletes the permissions boundary for the specified IAM user.
     *
     * Deleting the permissions boundary for a user might increase its permissions by allowing the user to perform all the actions granted in its permissions policies.
     */
    public suspend fun deleteUserPermissionsBoundary(input: DeleteUserPermissionsBoundaryRequest): DeleteUserPermissionsBoundaryResponse

    /**
     * Deletes the specified inline policy that is embedded in the specified IAM user.
     *
     * A user can also have managed policies attached to it. To detach a managed policy from a user, use DetachUserPolicy. For more information about policies, refer to [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.DeleteUserPolicy.sample
     */
    public suspend fun deleteUserPolicy(input: DeleteUserPolicyRequest): DeleteUserPolicyResponse

    /**
     * Deletes a virtual MFA device.
     *
     *  You must deactivate a user's virtual MFA device before you can delete it. For information about deactivating MFA devices, see DeactivateMFADevice.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.DeleteVirtualMFADevice.sample
     */
    public suspend fun deleteVirtualMfaDevice(input: DeleteVirtualMfaDeviceRequest): DeleteVirtualMfaDeviceResponse

    /**
     * Removes the specified managed policy from the specified IAM group.
     *
     * A group can also have inline policies embedded with it. To delete an inline policy, use DeleteGroupPolicy. For information about policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
     */
    public suspend fun detachGroupPolicy(input: DetachGroupPolicyRequest): DetachGroupPolicyResponse

    /**
     * Removes the specified managed policy from the specified role.
     *
     * A role can also have inline policies embedded with it. To delete an inline policy, use DeleteRolePolicy. For information about policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
     */
    public suspend fun detachRolePolicy(input: DetachRolePolicyRequest): DetachRolePolicyResponse

    /**
     * Removes the specified managed policy from the specified user.
     *
     * A user can also have inline policies embedded with it. To delete an inline policy, use DeleteUserPolicy. For information about policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
     */
    public suspend fun detachUserPolicy(input: DetachUserPolicyRequest): DetachUserPolicyResponse

    /**
     * Enables the specified MFA device and associates it with the specified IAM user. When enabled, the MFA device is required for every subsequent login by the IAM user associated with the device.
     */
    public suspend fun enableMfaDevice(input: EnableMfaDeviceRequest): EnableMfaDeviceResponse

    /**
     * Generates a credential report for the Amazon Web Services account. For more information about the credential report, see [Getting credential reports](https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html) in the *IAM User Guide*.
     */
    public suspend fun generateCredentialReport(input: GenerateCredentialReportRequest = GenerateCredentialReportRequest { }): GenerateCredentialReportResponse

    /**
     * Generates a report for service last accessed data for Organizations. You can generate a report for any entities (organization root, organizational unit, or account) or policies in your organization.
     *
     * To call this operation, you must be signed in using your Organizations management account credentials. You can use your long-term IAM user or root user credentials, or temporary credentials from assuming an IAM role. SCPs must be enabled for your organization root. You must have the required IAM and Organizations permissions. For more information, see [Refining permissions using service last accessed data](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html) in the *IAM User Guide*.
     *
     * You can generate a service last accessed data report for entities by specifying only the entity's path. This data includes a list of services that are allowed by any service control policies (SCPs) that apply to the entity.
     *
     * You can generate a service last accessed data report for a policy by specifying an entity's path and an optional Organizations policy ID. This data includes a list of services that are allowed by the specified SCP.
     *
     * For each service in both report types, the data includes the most recent account activity that the policy allows to account principals in the entity or the entity's children. For important information about the data, reporting period, permissions required, troubleshooting, and supported Regions see [Reducing permissions using service last accessed data](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html) in the *IAM User Guide*.
     *
     * The data includes all attempts to access Amazon Web Services, not just the successful ones. This includes all attempts that were made using the Amazon Web Services Management Console, the Amazon Web Services API through any of the SDKs, or any of the command line tools. An unexpected entry in the service last accessed data does not mean that an account has been compromised, because the request might have been denied. Refer to your CloudTrail logs as the authoritative source for information about all API calls and whether they were successful or denied access. For more information, see [Logging IAM events with CloudTrail](https://docs.aws.amazon.com/IAM/latest/UserGuide/cloudtrail-integration.html) in the *IAM User Guide*.
     *
     * This operation returns a `JobId`. Use this parameter in the ` <a>GetOrganizationsAccessReport</a> ` operation to check the status of the report generation. To check the status of this request, use the `JobId` parameter in the ` <a>GetOrganizationsAccessReport</a> ` operation and test the `JobStatus` response parameter. When the job is complete, you can retrieve the report.
     *
     * To generate a service last accessed data report for entities, specify an entity path without specifying the optional Organizations policy ID. The type of entity that you specify determines the data returned in the report.
     * + **Root** – When you specify the organizations root as the entity, the resulting report lists all of the services allowed by SCPs that are attached to your root. For each service, the report includes data for all accounts in your organization except the management account, because the management account is not limited by SCPs.
     * + **OU** – When you specify an organizational unit (OU) as the entity, the resulting report lists all of the services allowed by SCPs that are attached to the OU and its parents. For each service, the report includes data for all accounts in the OU or its children. This data excludes the management account, because the management account is not limited by SCPs.
     * + **management account** – When you specify the management account, the resulting report lists all Amazon Web Services services, because the management account is not limited by SCPs. For each service, the report includes data for only the management account.
     * + **Account** – When you specify another account as the entity, the resulting report lists all of the services allowed by SCPs that are attached to the account and its parents. For each service, the report includes data for only the specified account.
     *
     * To generate a service last accessed data report for policies, specify an entity path and the optional Organizations policy ID. The type of entity that you specify determines the data returned for each service.
     * + **Root** – When you specify the root entity and a policy ID, the resulting report lists all of the services that are allowed by the specified SCP. For each service, the report includes data for all accounts in your organization to which the SCP applies. This data excludes the management account, because the management account is not limited by SCPs. If the SCP is not attached to any entities in the organization, then the report will return a list of services with no data.
     * + **OU** – When you specify an OU entity and a policy ID, the resulting report lists all of the services that are allowed by the specified SCP. For each service, the report includes data for all accounts in the OU or its children to which the SCP applies. This means that other accounts outside the OU that are affected by the SCP might not be included in the data. This data excludes the management account, because the management account is not limited by SCPs. If the SCP is not attached to the OU or one of its children, the report will return a list of services with no data.
     * + **management account** – When you specify the management account, the resulting report lists all Amazon Web Services services, because the management account is not limited by SCPs. If you specify a policy ID in the CLI or API, the policy is ignored. For each service, the report includes data for only the management account.
     * + **Account** – When you specify another account entity and a policy ID, the resulting report lists all of the services that are allowed by the specified SCP. For each service, the report includes data for only the specified account. This means that other accounts in the organization that are affected by the SCP might not be included in the data. If the SCP is not attached to the account, the report will return a list of services with no data.
     *
     * Service last accessed data does not use other policy types when determining whether a principal could access a service. These other policy types include identity-based policies, resource-based policies, access control lists, IAM permissions boundaries, and STS assume role policies. It only applies SCP logic. For more about the evaluation of policy types, see [Evaluating policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics) in the *IAM User Guide*.
     *
     * For more information about service last accessed data, see [Reducing policy scope by viewing user activity](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html) in the *IAM User Guide*.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.GenerateOrganizationsAccessReport.sample
     */
    public suspend fun generateOrganizationsAccessReport(input: GenerateOrganizationsAccessReportRequest): GenerateOrganizationsAccessReportResponse

    /**
     * Generates a report that includes details about when an IAM resource (user, group, role, or policy) was last used in an attempt to access Amazon Web Services services. Recent activity usually appears within four hours. IAM reports activity for at least the last 400 days, or less if your Region began supporting this feature within the last year. For more information, see [Regions where data is tracked](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period). For more information about services and actions for which action last accessed information is displayed, see [IAM action last accessed information services and actions](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor-action-last-accessed.html).
     *
     * The service last accessed data includes all attempts to access an Amazon Web Services API, not just the successful ones. This includes all attempts that were made using the Amazon Web Services Management Console, the Amazon Web Services API through any of the SDKs, or any of the command line tools. An unexpected entry in the service last accessed data does not mean that your account has been compromised, because the request might have been denied. Refer to your CloudTrail logs as the authoritative source for information about all API calls and whether they were successful or denied access. For more information, see [Logging IAM events with CloudTrail](https://docs.aws.amazon.com/IAM/latest/UserGuide/cloudtrail-integration.html) in the *IAM User Guide*.
     *
     * The `GenerateServiceLastAccessedDetails` operation returns a `JobId`. Use this parameter in the following operations to retrieve the following details from your report:
     * + GetServiceLastAccessedDetails – Use this operation for users, groups, roles, or policies to list every Amazon Web Services service that the resource could access using permissions policies. For each service, the response includes information about the most recent access attempt.The `JobId` returned by `GenerateServiceLastAccessedDetail` must be used by the same role within a session, or by the same user when used to call `GetServiceLastAccessedDetail`.
     * + GetServiceLastAccessedDetailsWithEntities – Use this operation for groups and policies to list information about the associated entities (users or roles) that attempted to access a specific Amazon Web Services service.
     *
     * To check the status of the `GenerateServiceLastAccessedDetails` request, use the `JobId` parameter in the same operations and test the `JobStatus` response parameter.
     *
     * For additional information about the permissions policies that allow an identity (user, group, or role) to access specific services, use the ListPoliciesGrantingServiceAccess operation.
     *
     * Service last accessed data does not use other policy types when determining whether a resource could access a service. These other policy types include resource-based policies, access control lists, Organizations policies, IAM permissions boundaries, and STS assume role policies. It only applies permissions policy logic. For more about the evaluation of policy types, see [Evaluating policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics) in the *IAM User Guide*.
     *
     * For more information about service and action last accessed data, see [Reducing permissions using service last accessed data](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html) in the *IAM User Guide*.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.GenerateServiceLastAccessedDetails.sample
     */
    public suspend fun generateServiceLastAccessedDetails(input: GenerateServiceLastAccessedDetailsRequest): GenerateServiceLastAccessedDetailsResponse

    /**
     * Retrieves information about when the specified access key was last used. The information includes the date and time of last use, along with the Amazon Web Services service and Region that were specified in the last request made with that key.
     */
    public suspend fun getAccessKeyLastUsed(input: GetAccessKeyLastUsedRequest): GetAccessKeyLastUsedResponse

    /**
     * Retrieves information about all IAM users, groups, roles, and policies in your Amazon Web Services account, including their relationships to one another. Use this operation to obtain a snapshot of the configuration of IAM permissions (users, groups, roles, and policies) in your account.
     *
     * Policies returned by this operation are URL-encoded compliant with [RFC 3986](https://tools.ietf.org/html/rfc3986). You can use a URL decoding method to convert the policy back to plain JSON text. For example, if you use Java, you can use the `decode` method of the `java.net.URLDecoder` utility class in the Java SDK. Other languages and SDKs provide similar functionality.
     *
     * You can optionally filter the results using the `Filter` parameter. You can paginate the results using the `MaxItems` and `Marker` parameters.
     */
    public suspend fun getAccountAuthorizationDetails(input: GetAccountAuthorizationDetailsRequest = GetAccountAuthorizationDetailsRequest { }): GetAccountAuthorizationDetailsResponse

    /**
     * Retrieves the password policy for the Amazon Web Services account. This tells you the complexity requirements and mandatory rotation periods for the IAM user passwords in your account. For more information about using a password policy, see [Managing an IAM password policy](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingPasswordPolicies.html).
     *
     * @sample aws.sdk.kotlin.services.iam.samples.GetAccountPasswordPolicy.sample
     */
    public suspend fun getAccountPasswordPolicy(input: GetAccountPasswordPolicyRequest = GetAccountPasswordPolicyRequest { }): GetAccountPasswordPolicyResponse

    /**
     * Retrieves information about IAM entity usage and IAM quotas in the Amazon Web Services account.
     *
     *  For information about IAM quotas, see [IAM and STS quotas](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html) in the *IAM User Guide*.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.GetAccountSummary.sample
     */
    public suspend fun getAccountSummary(input: GetAccountSummaryRequest = GetAccountSummaryRequest { }): GetAccountSummaryResponse

    /**
     * Gets a list of all of the context keys referenced in the input policies. The policies are supplied as a list of one or more strings. To get the context keys from policies associated with an IAM user, group, or role, use GetContextKeysForPrincipalPolicy.
     *
     * Context keys are variables maintained by Amazon Web Services and its services that provide details about the context of an API query request. Context keys can be evaluated by testing against a value specified in an IAM policy. Use `GetContextKeysForCustomPolicy` to understand what key names and values you must supply when you call SimulateCustomPolicy. Note that all parameters are shown in unencoded form here for clarity but must be URL encoded to be included as a part of a real HTML request.
     */
    public suspend fun getContextKeysForCustomPolicy(input: GetContextKeysForCustomPolicyRequest): GetContextKeysForCustomPolicyResponse

    /**
     * Gets a list of all of the context keys referenced in all the IAM policies that are attached to the specified IAM entity. The entity can be an IAM user, group, or role. If you specify a user, then the request also includes all of the policies attached to groups that the user is a member of.
     *
     * You can optionally include a list of one or more additional policies, specified as strings. If you want to include *only* a list of policies by string, use GetContextKeysForCustomPolicy instead.
     *
     * **Note:** This operation discloses information about the permissions granted to other users. If you do not want users to see other user's permissions, then consider allowing them to use GetContextKeysForCustomPolicy instead.
     *
     * Context keys are variables maintained by Amazon Web Services and its services that provide details about the context of an API query request. Context keys can be evaluated by testing against a value in an IAM policy. Use GetContextKeysForPrincipalPolicy to understand what key names and values you must supply when you call SimulatePrincipalPolicy.
     */
    public suspend fun getContextKeysForPrincipalPolicy(input: GetContextKeysForPrincipalPolicyRequest): GetContextKeysForPrincipalPolicyResponse

    /**
     * Retrieves a credential report for the Amazon Web Services account. For more information about the credential report, see [Getting credential reports](https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html) in the *IAM User Guide*.
     */
    public suspend fun getCredentialReport(input: GetCredentialReportRequest = GetCredentialReportRequest { }): GetCredentialReportResponse

    /**
     * Returns a list of IAM users that are in the specified IAM group. You can paginate the results using the `MaxItems` and `Marker` parameters.
     */
    public suspend fun getGroup(input: GetGroupRequest): GetGroupResponse

    /**
     * Retrieves the specified inline policy document that is embedded in the specified IAM group.
     *
     * Policies returned by this operation are URL-encoded compliant with [RFC 3986](https://tools.ietf.org/html/rfc3986). You can use a URL decoding method to convert the policy back to plain JSON text. For example, if you use Java, you can use the `decode` method of the `java.net.URLDecoder` utility class in the Java SDK. Other languages and SDKs provide similar functionality.
     *
     * An IAM group can also have managed policies attached to it. To retrieve a managed policy document that is attached to a group, use GetPolicy to determine the policy's default version, then use GetPolicyVersion to retrieve the policy document.
     *
     * For more information about policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
     */
    public suspend fun getGroupPolicy(input: GetGroupPolicyRequest): GetGroupPolicyResponse

    /**
     * Retrieves information about the specified instance profile, including the instance profile's path, GUID, ARN, and role. For more information about instance profiles, see [Using instance profiles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2_instance-profiles.html) in the *IAM User Guide*.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.GetInstanceProfile.sample
     */
    public suspend fun getInstanceProfile(input: GetInstanceProfileRequest): GetInstanceProfileResponse

    /**
     * Retrieves the user name for the specified IAM user. A login profile is created when you create a password for the user to access the Amazon Web Services Management Console. If the user does not exist or does not have a password, the operation returns a 404 (`NoSuchEntity`) error.
     *
     * If you create an IAM user with access to the console, the `CreateDate` reflects the date you created the initial password for the user.
     *
     * If you create an IAM user with programmatic access, and then later add a password for the user to access the Amazon Web Services Management Console, the `CreateDate` reflects the initial password creation date. A user with programmatic access does not have a login profile unless you create a password for the user to access the Amazon Web Services Management Console.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.GetLoginProfile.sample
     */
    public suspend fun getLoginProfile(input: GetLoginProfileRequest): GetLoginProfileResponse

    /**
     * Retrieves information about an MFA device for a specified user.
     */
    public suspend fun getMfaDevice(input: GetMfaDeviceRequest): GetMfaDeviceResponse

    /**
     * Returns information about the specified OpenID Connect (OIDC) provider resource object in IAM.
     */
    public suspend fun getOpenIdConnectProvider(input: GetOpenIdConnectProviderRequest): GetOpenIdConnectProviderResponse

    /**
     * Retrieves the service last accessed data report for Organizations that was previously generated using the ` <a>GenerateOrganizationsAccessReport</a> ` operation. This operation retrieves the status of your report job and the report contents.
     *
     * Depending on the parameters that you passed when you generated the report, the data returned could include different information. For details, see GenerateOrganizationsAccessReport.
     *
     * To call this operation, you must be signed in to the management account in your organization. SCPs must be enabled for your organization root. You must have permissions to perform this operation. For more information, see [Refining permissions using service last accessed data](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html) in the *IAM User Guide*.
     *
     * For each service that principals in an account (root user, IAM users, or IAM roles) could access using SCPs, the operation returns details about the most recent access attempt. If there was no attempt, the service is listed without details about the most recent attempt to access the service. If the operation fails, it returns the reason that it failed.
     *
     * By default, the list is sorted by service namespace.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.GetOrganizationsAccessReport.sample
     */
    public suspend fun getOrganizationsAccessReport(input: GetOrganizationsAccessReportRequest): GetOrganizationsAccessReportResponse

    /**
     * Retrieves information about the specified managed policy, including the policy's default version and the total number of IAM users, groups, and roles to which the policy is attached. To retrieve the list of the specific users, groups, and roles that the policy is attached to, use ListEntitiesForPolicy. This operation returns metadata about the policy. To retrieve the actual policy document for a specific version of the policy, use GetPolicyVersion.
     *
     * This operation retrieves information about managed policies. To retrieve information about an inline policy that is embedded with an IAM user, group, or role, use GetUserPolicy, GetGroupPolicy, or GetRolePolicy.
     *
     * For more information about policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
     */
    public suspend fun getPolicy(input: GetPolicyRequest): GetPolicyResponse

    /**
     * Retrieves information about the specified version of the specified managed policy, including the policy document.
     *
     * Policies returned by this operation are URL-encoded compliant with [RFC 3986](https://tools.ietf.org/html/rfc3986). You can use a URL decoding method to convert the policy back to plain JSON text. For example, if you use Java, you can use the `decode` method of the `java.net.URLDecoder` utility class in the Java SDK. Other languages and SDKs provide similar functionality.
     *
     * To list the available versions for a policy, use ListPolicyVersions.
     *
     * This operation retrieves information about managed policies. To retrieve information about an inline policy that is embedded in a user, group, or role, use GetUserPolicy, GetGroupPolicy, or GetRolePolicy.
     *
     * For more information about the types of policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
     *
     * For more information about managed policy versions, see [Versioning for managed policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html) in the *IAM User Guide*.
     */
    public suspend fun getPolicyVersion(input: GetPolicyVersionRequest): GetPolicyVersionResponse

    /**
     * Retrieves information about the specified role, including the role's path, GUID, ARN, and the role's trust policy that grants permission to assume the role. For more information about roles, see [IAM roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html) in the *IAM User Guide*.
     *
     * Policies returned by this operation are URL-encoded compliant with [RFC 3986](https://tools.ietf.org/html/rfc3986). You can use a URL decoding method to convert the policy back to plain JSON text. For example, if you use Java, you can use the `decode` method of the `java.net.URLDecoder` utility class in the Java SDK. Other languages and SDKs provide similar functionality.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.GetRole.sample
     */
    public suspend fun getRole(input: GetRoleRequest): GetRoleResponse

    /**
     * Retrieves the specified inline policy document that is embedded with the specified IAM role.
     *
     * Policies returned by this operation are URL-encoded compliant with [RFC 3986](https://tools.ietf.org/html/rfc3986). You can use a URL decoding method to convert the policy back to plain JSON text. For example, if you use Java, you can use the `decode` method of the `java.net.URLDecoder` utility class in the Java SDK. Other languages and SDKs provide similar functionality.
     *
     * An IAM role can also have managed policies attached to it. To retrieve a managed policy document that is attached to a role, use GetPolicy to determine the policy's default version, then use GetPolicyVersion to retrieve the policy document.
     *
     * For more information about policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
     *
     *  For more information about roles, see [IAM roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html) in the *IAM User Guide*.
     */
    public suspend fun getRolePolicy(input: GetRolePolicyRequest): GetRolePolicyResponse

    /**
     * Returns the SAML provider metadocument that was uploaded when the IAM SAML provider resource object was created or updated.
     *
     * This operation requires [Signature Version 4](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
     */
    public suspend fun getSamlProvider(input: GetSamlProviderRequest): GetSamlProviderResponse

    /**
     * Retrieves information about the specified server certificate stored in IAM.
     *
     * For more information about working with server certificates, see [Working with server certificates](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html) in the *IAM User Guide*. This topic includes a list of Amazon Web Services services that can use the server certificates that you manage with IAM.
     */
    public suspend fun getServerCertificate(input: GetServerCertificateRequest): GetServerCertificateResponse

    /**
     * Retrieves a service last accessed report that was created using the `GenerateServiceLastAccessedDetails` operation. You can use the `JobId` parameter in `GetServiceLastAccessedDetails` to retrieve the status of your report job. When the report is complete, you can retrieve the generated report. The report includes a list of Amazon Web Services services that the resource (user, group, role, or managed policy) can access.
     *
     * Service last accessed data does not use other policy types when determining whether a resource could access a service. These other policy types include resource-based policies, access control lists, Organizations policies, IAM permissions boundaries, and STS assume role policies. It only applies permissions policy logic. For more about the evaluation of policy types, see [Evaluating policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics) in the *IAM User Guide*.
     *
     * For each service that the resource could access using permissions policies, the operation returns details about the most recent access attempt. If there was no attempt, the service is listed without details about the most recent attempt to access the service. If the operation fails, the `GetServiceLastAccessedDetails` operation returns the reason that it failed.
     *
     * The `GetServiceLastAccessedDetails` operation returns a list of services. This list includes the number of entities that have attempted to access the service and the date and time of the last attempt. It also returns the ARN of the following entity, depending on the resource ARN that you used to generate the report:
     * + **User** – Returns the user ARN that you used to generate the report
     * + **Group** – Returns the ARN of the group member (user) that last attempted to access the service
     * + **Role** – Returns the role ARN that you used to generate the report
     * + **Policy** – Returns the ARN of the user or role that last used the policy to attempt to access the service
     *
     * By default, the list is sorted by service namespace.
     *
     * If you specified `ACTION_LEVEL` granularity when you generated the report, this operation returns service and action last accessed data. This includes the most recent access attempt for each tracked action within a service. Otherwise, this operation returns only service data.
     *
     * For more information about service and action last accessed data, see [Reducing permissions using service last accessed data](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html) in the *IAM User Guide*.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.GetServiceLastAccessedDetails.sample
     */
    public suspend fun getServiceLastAccessedDetails(input: GetServiceLastAccessedDetailsRequest): GetServiceLastAccessedDetailsResponse

    /**
     * After you generate a group or policy report using the `GenerateServiceLastAccessedDetails` operation, you can use the `JobId` parameter in `GetServiceLastAccessedDetailsWithEntities`. This operation retrieves the status of your report job and a list of entities that could have used group or policy permissions to access the specified service.
     * + **Group** – For a group report, this operation returns a list of users in the group that could have used the group’s policies in an attempt to access the service.
     * + **Policy** – For a policy report, this operation returns a list of entities (users or roles) that could have used the policy in an attempt to access the service.
     *
     * You can also use this operation for user or role reports to retrieve details about those entities.
     *
     * If the operation fails, the `GetServiceLastAccessedDetailsWithEntities` operation returns the reason that it failed.
     *
     * By default, the list of associated entities is sorted by date, with the most recent access listed first.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.GetServiceLastAccessedDetailsWithEntities.sample
     */
    public suspend fun getServiceLastAccessedDetailsWithEntities(input: GetServiceLastAccessedDetailsWithEntitiesRequest): GetServiceLastAccessedDetailsWithEntitiesResponse

    /**
     * Retrieves the status of your service-linked role deletion. After you use DeleteServiceLinkedRole to submit a service-linked role for deletion, you can use the `DeletionTaskId` parameter in `GetServiceLinkedRoleDeletionStatus` to check the status of the deletion. If the deletion fails, this operation returns the reason that it failed, if that information is returned by the service.
     */
    public suspend fun getServiceLinkedRoleDeletionStatus(input: GetServiceLinkedRoleDeletionStatusRequest): GetServiceLinkedRoleDeletionStatusResponse

    /**
     * Retrieves the specified SSH public key, including metadata about the key.
     *
     * The SSH public key retrieved by this operation is used only for authenticating the associated IAM user to an CodeCommit repository. For more information about using SSH keys to authenticate to an CodeCommit repository, see [Set up CodeCommit for SSH connections](https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html) in the *CodeCommit User Guide*.
     */
    public suspend fun getSshPublicKey(input: GetSshPublicKeyRequest): GetSshPublicKeyResponse

    /**
     * Retrieves information about the specified IAM user, including the user's creation date, path, unique ID, and ARN.
     *
     * If you do not specify a user name, IAM determines the user name implicitly based on the Amazon Web Services access key ID used to sign the request to this operation.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.GetUser.sample
     */
    public suspend fun getUser(input: GetUserRequest = GetUserRequest { }): GetUserResponse

    /**
     * Retrieves the specified inline policy document that is embedded in the specified IAM user.
     *
     * Policies returned by this operation are URL-encoded compliant with [RFC 3986](https://tools.ietf.org/html/rfc3986). You can use a URL decoding method to convert the policy back to plain JSON text. For example, if you use Java, you can use the `decode` method of the `java.net.URLDecoder` utility class in the Java SDK. Other languages and SDKs provide similar functionality.
     *
     * An IAM user can also have managed policies attached to it. To retrieve a managed policy document that is attached to a user, use GetPolicy to determine the policy's default version. Then use GetPolicyVersion to retrieve the policy document.
     *
     * For more information about policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
     */
    public suspend fun getUserPolicy(input: GetUserPolicyRequest): GetUserPolicyResponse

    /**
     * Returns information about the access key IDs associated with the specified IAM user. If there is none, the operation returns an empty list.
     *
     * Although each user is limited to a small number of keys, you can still paginate the results using the `MaxItems` and `Marker` parameters.
     *
     * If the `UserName` is not specified, the user name is determined implicitly based on the Amazon Web Services access key ID used to sign the request. If a temporary access key is used, then `UserName` is required. If a long-term key is assigned to the user, then `UserName` is not required.
     *
     * This operation works for access keys under the Amazon Web Services account. If the Amazon Web Services account has no associated users, the root user returns it's own access key IDs by running this command.
     *
     * To ensure the security of your Amazon Web Services account, the secret access key is accessible only during key and user creation.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.ListAccessKeys.sample
     */
    public suspend fun listAccessKeys(input: ListAccessKeysRequest = ListAccessKeysRequest { }): ListAccessKeysResponse

    /**
     * Lists the account alias associated with the Amazon Web Services account (Note: you can have only one). For information about using an Amazon Web Services account alias, see [Creating, deleting, and listing an Amazon Web Services account alias](https://docs.aws.amazon.com/signin/latest/userguide/CreateAccountAlias.html) in the *Amazon Web Services Sign-In User Guide*.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.ListAccountAliases.sample
     */
    public suspend fun listAccountAliases(input: ListAccountAliasesRequest = ListAccountAliasesRequest { }): ListAccountAliasesResponse

    /**
     * Lists all managed policies that are attached to the specified IAM group.
     *
     * An IAM group can also have inline policies embedded with it. To list the inline policies for a group, use ListGroupPolicies. For information about policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
     *
     * You can paginate the results using the `MaxItems` and `Marker` parameters. You can use the `PathPrefix` parameter to limit the list of policies to only those matching the specified path prefix. If there are no policies attached to the specified group (or none that match the specified path prefix), the operation returns an empty list.
     */
    public suspend fun listAttachedGroupPolicies(input: ListAttachedGroupPoliciesRequest): ListAttachedGroupPoliciesResponse

    /**
     * Lists all managed policies that are attached to the specified IAM role.
     *
     * An IAM role can also have inline policies embedded with it. To list the inline policies for a role, use ListRolePolicies. For information about policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
     *
     * You can paginate the results using the `MaxItems` and `Marker` parameters. You can use the `PathPrefix` parameter to limit the list of policies to only those matching the specified path prefix. If there are no policies attached to the specified role (or none that match the specified path prefix), the operation returns an empty list.
     */
    public suspend fun listAttachedRolePolicies(input: ListAttachedRolePoliciesRequest): ListAttachedRolePoliciesResponse

    /**
     * Lists all managed policies that are attached to the specified IAM user.
     *
     * An IAM user can also have inline policies embedded with it. To list the inline policies for a user, use ListUserPolicies. For information about policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
     *
     * You can paginate the results using the `MaxItems` and `Marker` parameters. You can use the `PathPrefix` parameter to limit the list of policies to only those matching the specified path prefix. If there are no policies attached to the specified group (or none that match the specified path prefix), the operation returns an empty list.
     */
    public suspend fun listAttachedUserPolicies(input: ListAttachedUserPoliciesRequest): ListAttachedUserPoliciesResponse

    /**
     * Lists all IAM users, groups, and roles that the specified managed policy is attached to.
     *
     * You can use the optional `EntityFilter` parameter to limit the results to a particular type of entity (users, groups, or roles). For example, to list only the roles that are attached to the specified policy, set `EntityFilter` to `Role`.
     *
     * You can paginate the results using the `MaxItems` and `Marker` parameters.
     */
    public suspend fun listEntitiesForPolicy(input: ListEntitiesForPolicyRequest): ListEntitiesForPolicyResponse

    /**
     * Lists the names of the inline policies that are embedded in the specified IAM group.
     *
     * An IAM group can also have managed policies attached to it. To list the managed policies that are attached to a group, use ListAttachedGroupPolicies. For more information about policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
     *
     * You can paginate the results using the `MaxItems` and `Marker` parameters. If there are no inline policies embedded with the specified group, the operation returns an empty list.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.ListGroupPolicies.sample
     */
    public suspend fun listGroupPolicies(input: ListGroupPoliciesRequest): ListGroupPoliciesResponse

    /**
     * Lists the IAM groups that have the specified path prefix.
     *
     *  You can paginate the results using the `MaxItems` and `Marker` parameters.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.ListGroups.sample
     */
    public suspend fun listGroups(input: ListGroupsRequest = ListGroupsRequest { }): ListGroupsResponse

    /**
     * Lists the IAM groups that the specified IAM user belongs to.
     *
     * You can paginate the results using the `MaxItems` and `Marker` parameters.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.ListGroupsForUser.sample
     */
    public suspend fun listGroupsForUser(input: ListGroupsForUserRequest): ListGroupsForUserResponse

    /**
     * Lists the tags that are attached to the specified IAM instance profile. The returned list of tags is sorted by tag key. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
     */
    public suspend fun listInstanceProfileTags(input: ListInstanceProfileTagsRequest): ListInstanceProfileTagsResponse

    /**
     * Lists the instance profiles that have the specified path prefix. If there are none, the operation returns an empty list. For more information about instance profiles, see [Using instance profiles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2_instance-profiles.html) in the *IAM User Guide*.
     *
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view all of the information for an instance profile, see GetInstanceProfile.
     *
     * You can paginate the results using the `MaxItems` and `Marker` parameters.
     */
    public suspend fun listInstanceProfiles(input: ListInstanceProfilesRequest = ListInstanceProfilesRequest { }): ListInstanceProfilesResponse

    /**
     * Lists the instance profiles that have the specified associated IAM role. If there are none, the operation returns an empty list. For more information about instance profiles, go to [Using instance profiles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2_instance-profiles.html) in the *IAM User Guide*.
     *
     * You can paginate the results using the `MaxItems` and `Marker` parameters.
     */
    public suspend fun listInstanceProfilesForRole(input: ListInstanceProfilesForRoleRequest): ListInstanceProfilesForRoleResponse

    /**
     * Lists the tags that are attached to the specified IAM virtual multi-factor authentication (MFA) device. The returned list of tags is sorted by tag key. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
     */
    public suspend fun listMfaDeviceTags(input: ListMfaDeviceTagsRequest): ListMfaDeviceTagsResponse

    /**
     * Lists the MFA devices for an IAM user. If the request includes a IAM user name, then this operation lists all the MFA devices associated with the specified user. If you do not specify a user name, IAM determines the user name implicitly based on the Amazon Web Services access key ID signing the request for this operation.
     *
     * You can paginate the results using the `MaxItems` and `Marker` parameters.
     */
    public suspend fun listMfaDevices(input: ListMfaDevicesRequest = ListMfaDevicesRequest { }): ListMfaDevicesResponse

    /**
     * Lists the tags that are attached to the specified OpenID Connect (OIDC)-compatible identity provider. The returned list of tags is sorted by tag key. For more information, see [About web identity federation](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc.html).
     *
     * For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
     */
    public suspend fun listOpenIdConnectProviderTags(input: ListOpenIdConnectProviderTagsRequest): ListOpenIdConnectProviderTagsResponse

    /**
     * Lists information about the IAM OpenID Connect (OIDC) provider resource objects defined in the Amazon Web Services account.
     *
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view all of the information for an OIDC provider, see GetOpenIDConnectProvider.
     */
    public suspend fun listOpenIdConnectProviders(input: ListOpenIdConnectProvidersRequest = ListOpenIdConnectProvidersRequest { }): ListOpenIdConnectProvidersResponse

    /**
     * Lists all the managed policies that are available in your Amazon Web Services account, including your own customer-defined managed policies and all Amazon Web Services managed policies.
     *
     * You can filter the list of policies that is returned using the optional `OnlyAttached`, `Scope`, and `PathPrefix` parameters. For example, to list only the customer managed policies in your Amazon Web Services account, set `Scope` to `Local`. To list only Amazon Web Services managed policies, set `Scope` to `AWS`.
     *
     * You can paginate the results using the `MaxItems` and `Marker` parameters.
     *
     * For more information about managed policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
     *
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view all of the information for a customer manged policy, see GetPolicy.
     */
    public suspend fun listPolicies(input: ListPoliciesRequest = ListPoliciesRequest { }): ListPoliciesResponse

    /**
     * Retrieves a list of policies that the IAM identity (user, group, or role) can use to access each specified service.
     *
     * This operation does not use other policy types when determining whether a resource could access a service. These other policy types include resource-based policies, access control lists, Organizations policies, IAM permissions boundaries, and STS assume role policies. It only applies permissions policy logic. For more about the evaluation of policy types, see [Evaluating policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics) in the *IAM User Guide*.
     *
     * The list of policies returned by the operation depends on the ARN of the identity that you provide.
     * + **User** – The list of policies includes the managed and inline policies that are attached to the user directly. The list also includes any additional managed and inline policies that are attached to the group to which the user belongs.
     * + **Group** – The list of policies includes only the managed and inline policies that are attached to the group directly. Policies that are attached to the group’s user are not included.
     * + **Role** – The list of policies includes only the managed and inline policies that are attached to the role.
     *
     * For each managed policy, this operation returns the ARN and policy name. For each inline policy, it returns the policy name and the entity to which it is attached. Inline policies do not have an ARN. For more information about these policy types, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html) in the *IAM User Guide*.
     *
     * Policies that are attached to users and roles as permissions boundaries are not returned. To view which managed policy is currently used to set the permissions boundary for a user or role, use the GetUser or GetRole operations.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.ListPoliciesGrantingServiceAccess.sample
     */
    public suspend fun listPoliciesGrantingServiceAccess(input: ListPoliciesGrantingServiceAccessRequest): ListPoliciesGrantingServiceAccessResponse

    /**
     * Lists the tags that are attached to the specified IAM customer managed policy. The returned list of tags is sorted by tag key. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
     */
    public suspend fun listPolicyTags(input: ListPolicyTagsRequest): ListPolicyTagsResponse

    /**
     * Lists information about the versions of the specified managed policy, including the version that is currently set as the policy's default version.
     *
     * For more information about managed policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
     */
    public suspend fun listPolicyVersions(input: ListPolicyVersionsRequest): ListPolicyVersionsResponse

    /**
     * Lists the names of the inline policies that are embedded in the specified IAM role.
     *
     * An IAM role can also have managed policies attached to it. To list the managed policies that are attached to a role, use ListAttachedRolePolicies. For more information about policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
     *
     * You can paginate the results using the `MaxItems` and `Marker` parameters. If there are no inline policies embedded with the specified role, the operation returns an empty list.
     */
    public suspend fun listRolePolicies(input: ListRolePoliciesRequest): ListRolePoliciesResponse

    /**
     * Lists the tags that are attached to the specified role. The returned list of tags is sorted by tag key. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.ListRoleTags.sample
     */
    public suspend fun listRoleTags(input: ListRoleTagsRequest): ListRoleTagsResponse

    /**
     * Lists the IAM roles that have the specified path prefix. If there are none, the operation returns an empty list. For more information about roles, see [IAM roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html) in the *IAM User Guide*.
     *
     * IAM resource-listing operations return a subset of the available attributes for the resource. This operation does not return the following attributes, even though they are an attribute of the returned object:
     * + PermissionsBoundary
     * + RoleLastUsed
     * + Tags
     * To view all of the information for a role, see GetRole.
     *
     * You can paginate the results using the `MaxItems` and `Marker` parameters.
     */
    public suspend fun listRoles(input: ListRolesRequest = ListRolesRequest { }): ListRolesResponse

    /**
     * Lists the tags that are attached to the specified Security Assertion Markup Language (SAML) identity provider. The returned list of tags is sorted by tag key. For more information, see [About SAML 2.0-based federation](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html).
     *
     * For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
     */
    public suspend fun listSamlProviderTags(input: ListSamlProviderTagsRequest): ListSamlProviderTagsResponse

    /**
     * Lists the SAML provider resource objects defined in IAM in the account. IAM resource-listing operations return a subset of the available attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view all of the information for a SAML provider, see GetSAMLProvider.
     *
     *  This operation requires [Signature Version 4](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
     */
    public suspend fun listSamlProviders(input: ListSamlProvidersRequest = ListSamlProvidersRequest { }): ListSamlProvidersResponse

    /**
     * Lists the tags that are attached to the specified IAM server certificate. The returned list of tags is sorted by tag key. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
     *
     * For certificates in a Region supported by Certificate Manager (ACM), we recommend that you don't use IAM server certificates. Instead, use ACM to provision, manage, and deploy your server certificates. For more information about IAM server certificates, [Working with server certificates](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html) in the *IAM User Guide*.
     */
    public suspend fun listServerCertificateTags(input: ListServerCertificateTagsRequest): ListServerCertificateTagsResponse

    /**
     * Lists the server certificates stored in IAM that have the specified path prefix. If none exist, the operation returns an empty list.
     *
     *  You can paginate the results using the `MaxItems` and `Marker` parameters.
     *
     * For more information about working with server certificates, see [Working with server certificates](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html) in the *IAM User Guide*. This topic also includes a list of Amazon Web Services services that can use the server certificates that you manage with IAM.
     *
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view all of the information for a servercertificate, see GetServerCertificate.
     */
    public suspend fun listServerCertificates(input: ListServerCertificatesRequest = ListServerCertificatesRequest { }): ListServerCertificatesResponse

    /**
     * Returns information about the service-specific credentials associated with the specified IAM user. If none exists, the operation returns an empty list. The service-specific credentials returned by this operation are used only for authenticating the IAM user to a specific service. For more information about using service-specific credentials to authenticate to an Amazon Web Services service, see [Set up service-specific credentials](https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-gc.html) in the CodeCommit User Guide.
     */
    public suspend fun listServiceSpecificCredentials(input: ListServiceSpecificCredentialsRequest = ListServiceSpecificCredentialsRequest { }): ListServiceSpecificCredentialsResponse

    /**
     * Returns information about the signing certificates associated with the specified IAM user. If none exists, the operation returns an empty list.
     *
     * Although each user is limited to a small number of signing certificates, you can still paginate the results using the `MaxItems` and `Marker` parameters.
     *
     * If the `UserName` field is not specified, the user name is determined implicitly based on the Amazon Web Services access key ID used to sign the request for this operation. This operation works for access keys under the Amazon Web Services account. Consequently, you can use this operation to manage Amazon Web Services account root user credentials even if the Amazon Web Services account has no associated users.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.ListSigningCertificates.sample
     */
    public suspend fun listSigningCertificates(input: ListSigningCertificatesRequest = ListSigningCertificatesRequest { }): ListSigningCertificatesResponse

    /**
     * Returns information about the SSH public keys associated with the specified IAM user. If none exists, the operation returns an empty list.
     *
     * The SSH public keys returned by this operation are used only for authenticating the IAM user to an CodeCommit repository. For more information about using SSH keys to authenticate to an CodeCommit repository, see [Set up CodeCommit for SSH connections](https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html) in the *CodeCommit User Guide*.
     *
     * Although each user is limited to a small number of keys, you can still paginate the results using the `MaxItems` and `Marker` parameters.
     */
    public suspend fun listSshPublicKeys(input: ListSshPublicKeysRequest = ListSshPublicKeysRequest { }): ListSshPublicKeysResponse

    /**
     * Lists the names of the inline policies embedded in the specified IAM user.
     *
     * An IAM user can also have managed policies attached to it. To list the managed policies that are attached to a user, use ListAttachedUserPolicies. For more information about policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
     *
     * You can paginate the results using the `MaxItems` and `Marker` parameters. If there are no inline policies embedded with the specified user, the operation returns an empty list.
     */
    public suspend fun listUserPolicies(input: ListUserPoliciesRequest): ListUserPoliciesResponse

    /**
     * Lists the tags that are attached to the specified IAM user. The returned list of tags is sorted by tag key. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.ListUserTags.sample
     */
    public suspend fun listUserTags(input: ListUserTagsRequest): ListUserTagsResponse

    /**
     * Lists the IAM users that have the specified path prefix. If no path prefix is specified, the operation returns all users in the Amazon Web Services account. If there are none, the operation returns an empty list.
     *
     * IAM resource-listing operations return a subset of the available attributes for the resource. This operation does not return the following attributes, even though they are an attribute of the returned object:
     * + PermissionsBoundary
     * + Tags
     * To view all of the information for a user, see GetUser.
     *
     * You can paginate the results using the `MaxItems` and `Marker` parameters.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.ListUsers.sample
     */
    public suspend fun listUsers(input: ListUsersRequest = ListUsersRequest { }): ListUsersResponse

    /**
     * Lists the virtual MFA devices defined in the Amazon Web Services account by assignment status. If you do not specify an assignment status, the operation returns a list of all virtual MFA devices. Assignment status can be `Assigned`, `Unassigned`, or `Any`.
     *
     * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view tag information for a virtual MFA device, see ListMFADeviceTags.
     *
     * You can paginate the results using the `MaxItems` and `Marker` parameters.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.ListVirtualMFADevices.sample
     */
    public suspend fun listVirtualMfaDevices(input: ListVirtualMfaDevicesRequest = ListVirtualMfaDevicesRequest { }): ListVirtualMfaDevicesResponse

    /**
     * Adds or updates an inline policy document that is embedded in the specified IAM group.
     *
     * A user can also have managed policies attached to it. To attach a managed policy to a group, use `AttachGroupPolicy`[](https://docs.aws.amazon.com/IAM/latest/APIReference/API_AttachGroupPolicy.html). To create a new managed policy, use `CreatePolicy`[](https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreatePolicy.html). For information about policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
     *
     * For information about the maximum number of inline policies that you can embed in a group, see [IAM and STS quotas](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html) in the *IAM User Guide*.
     *
     * Because policy documents can be large, you should use POST rather than GET when calling `PutGroupPolicy`. For general information about using the Query API with IAM, see [Making query requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html) in the *IAM User Guide*.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.PutGroupPolicy.sample
     */
    public suspend fun putGroupPolicy(input: PutGroupPolicyRequest): PutGroupPolicyResponse

    /**
     * Adds or updates the policy that is specified as the IAM role's permissions boundary. You can use an Amazon Web Services managed policy or a customer managed policy to set the boundary for a role. Use the boundary to control the maximum permissions that the role can have. Setting a permissions boundary is an advanced feature that can affect the permissions for the role.
     *
     * You cannot set the boundary for a service-linked role.
     *
     * Policies used as permissions boundaries do not provide permissions. You must also attach a permissions policy to the role. To learn how the effective permissions for a role are evaluated, see [IAM JSON policy evaluation logic](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html) in the IAM User Guide.
     */
    public suspend fun putRolePermissionsBoundary(input: PutRolePermissionsBoundaryRequest): PutRolePermissionsBoundaryResponse

    /**
     * Adds or updates an inline policy document that is embedded in the specified IAM role.
     *
     * When you embed an inline policy in a role, the inline policy is used as part of the role's access (permissions) policy. The role's trust policy is created at the same time as the role, using `CreateRole`[](https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html). You can update a role's trust policy using `UpdateAssumeRolePolicy`[](https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateAssumeRolePolicy.html). For more information about roles, see [IAM roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html) in the *IAM User Guide*.
     *
     * A role can also have a managed policy attached to it. To attach a managed policy to a role, use `AttachRolePolicy`[](https://docs.aws.amazon.com/IAM/latest/APIReference/API_AttachRolePolicy.html). To create a new managed policy, use `CreatePolicy`[](https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreatePolicy.html). For information about policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
     *
     * For information about the maximum number of inline policies that you can embed with a role, see [IAM and STS quotas](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html) in the *IAM User Guide*.
     *
     * Because policy documents can be large, you should use POST rather than GET when calling `PutRolePolicy`. For general information about using the Query API with IAM, see [Making query requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html) in the *IAM User Guide*.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.PutRolePolicy.sample
     */
    public suspend fun putRolePolicy(input: PutRolePolicyRequest): PutRolePolicyResponse

    /**
     * Adds or updates the policy that is specified as the IAM user's permissions boundary. You can use an Amazon Web Services managed policy or a customer managed policy to set the boundary for a user. Use the boundary to control the maximum permissions that the user can have. Setting a permissions boundary is an advanced feature that can affect the permissions for the user.
     *
     * Policies that are used as permissions boundaries do not provide permissions. You must also attach a permissions policy to the user. To learn how the effective permissions for a user are evaluated, see [IAM JSON policy evaluation logic](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html) in the IAM User Guide.
     */
    public suspend fun putUserPermissionsBoundary(input: PutUserPermissionsBoundaryRequest): PutUserPermissionsBoundaryResponse

    /**
     * Adds or updates an inline policy document that is embedded in the specified IAM user.
     *
     * An IAM user can also have a managed policy attached to it. To attach a managed policy to a user, use `AttachUserPolicy`[](https://docs.aws.amazon.com/IAM/latest/APIReference/API_AttachUserPolicy.html). To create a new managed policy, use `CreatePolicy`[](https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreatePolicy.html). For information about policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
     *
     * For information about the maximum number of inline policies that you can embed in a user, see [IAM and STS quotas](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html) in the *IAM User Guide*.
     *
     * Because policy documents can be large, you should use POST rather than GET when calling `PutUserPolicy`. For general information about using the Query API with IAM, see [Making query requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html) in the *IAM User Guide*.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.PutUserPolicy.sample
     */
    public suspend fun putUserPolicy(input: PutUserPolicyRequest): PutUserPolicyResponse

    /**
     * Removes the specified client ID (also known as audience) from the list of client IDs registered for the specified IAM OpenID Connect (OIDC) provider resource object.
     *
     * This operation is idempotent; it does not fail or return an error if you try to remove a client ID that does not exist.
     */
    public suspend fun removeClientIdFromOpenIdConnectProvider(input: RemoveClientIdFromOpenIdConnectProviderRequest): RemoveClientIdFromOpenIdConnectProviderResponse

    /**
     * Removes the specified IAM role from the specified EC2 instance profile.
     *
     * Make sure that you do not have any Amazon EC2 instances running with the role you are about to remove from the instance profile. Removing a role from an instance profile that is associated with a running instance might break any applications running on the instance.
     *
     *  For more information about roles, see [IAM roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html) in the *IAM User Guide*. For more information about instance profiles, see [Using instance profiles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2_instance-profiles.html) in the *IAM User Guide*.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.RemoveRoleFromInstanceProfile.sample
     */
    public suspend fun removeRoleFromInstanceProfile(input: RemoveRoleFromInstanceProfileRequest): RemoveRoleFromInstanceProfileResponse

    /**
     * Removes the specified user from the specified group.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.RemoveUserFromGroup.sample
     */
    public suspend fun removeUserFromGroup(input: RemoveUserFromGroupRequest): RemoveUserFromGroupResponse

    /**
     * Resets the password for a service-specific credential. The new password is Amazon Web Services generated and cryptographically strong. It cannot be configured by the user. Resetting the password immediately invalidates the previous password associated with this user.
     */
    public suspend fun resetServiceSpecificCredential(input: ResetServiceSpecificCredentialRequest): ResetServiceSpecificCredentialResponse

    /**
     * Synchronizes the specified MFA device with its IAM resource object on the Amazon Web Services servers.
     *
     * For more information about creating and working with virtual MFA devices, see [Using a virtual MFA device](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html) in the *IAM User Guide*.
     */
    public suspend fun resyncMfaDevice(input: ResyncMfaDeviceRequest): ResyncMfaDeviceResponse

    /**
     * Sets the specified version of the specified policy as the policy's default (operative) version.
     *
     * This operation affects all users, groups, and roles that the policy is attached to. To list the users, groups, and roles that the policy is attached to, use ListEntitiesForPolicy.
     *
     * For information about managed policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
     */
    public suspend fun setDefaultPolicyVersion(input: SetDefaultPolicyVersionRequest): SetDefaultPolicyVersionResponse

    /**
     * Sets the specified version of the global endpoint token as the token version used for the Amazon Web Services account.
     *
     * By default, Security Token Service (STS) is available as a global service, and all STS requests go to a single endpoint at `https://sts.amazonaws.com`. Amazon Web Services recommends using Regional STS endpoints to reduce latency, build in redundancy, and increase session token availability. For information about Regional endpoints for STS, see [Security Token Service endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/sts.html) in the *Amazon Web Services General Reference*.
     *
     * If you make an STS call to the global endpoint, the resulting session tokens might be valid in some Regions but not others. It depends on the version that is set in this operation. Version 1 tokens are valid only in Amazon Web Services Regions that are available by default. These tokens do not work in manually enabled Regions, such as Asia Pacific (Hong Kong). Version 2 tokens are valid in all Regions. However, version 2 tokens are longer and might affect systems where you temporarily store tokens. For information, see [Activating and deactivating STS in an Amazon Web Services Region](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html) in the *IAM User Guide*.
     *
     * To view the current session token version, see the `GlobalEndpointTokenVersion` entry in the response of the GetAccountSummary operation.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.SetSecurityTokenServicePreferences.sample
     */
    public suspend fun setSecurityTokenServicePreferences(input: SetSecurityTokenServicePreferencesRequest): SetSecurityTokenServicePreferencesResponse

    /**
     * Simulate how a set of IAM policies and optionally a resource-based policy works with a list of API operations and Amazon Web Services resources to determine the policies' effective permissions. The policies are provided as strings.
     *
     * The simulation does not perform the API operations; it only checks the authorization to determine if the simulated policies allow or deny the operations. You can simulate resources that don't exist in your account.
     *
     * If you want to simulate existing policies that are attached to an IAM user, group, or role, use SimulatePrincipalPolicy instead.
     *
     * Context keys are variables that are maintained by Amazon Web Services and its services and which provide details about the context of an API query request. You can use the `Condition` element of an IAM policy to evaluate context keys. To get the list of context keys that the policies require for correct simulation, use GetContextKeysForCustomPolicy.
     *
     * If the output is long, you can use `MaxItems` and `Marker` parameters to paginate the results.
     *
     * The IAM policy simulator evaluates statements in the identity-based policy and the inputs that you provide during simulation. The policy simulator results can differ from your live Amazon Web Services environment. We recommend that you check your policies against your live Amazon Web Services environment after testing using the policy simulator to confirm that you have the desired results. For more information about using the policy simulator, see [Testing IAM policies with the IAM policy simulator ](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_testing-policies.html)in the *IAM User Guide*.
     */
    public suspend fun simulateCustomPolicy(input: SimulateCustomPolicyRequest): SimulateCustomPolicyResponse

    /**
     * Simulate how a set of IAM policies attached to an IAM entity works with a list of API operations and Amazon Web Services resources to determine the policies' effective permissions. The entity can be an IAM user, group, or role. If you specify a user, then the simulation also includes all of the policies that are attached to groups that the user belongs to. You can simulate resources that don't exist in your account.
     *
     * You can optionally include a list of one or more additional policies specified as strings to include in the simulation. If you want to simulate only policies specified as strings, use SimulateCustomPolicy instead.
     *
     * You can also optionally include one resource-based policy to be evaluated with each of the resources included in the simulation for IAM users only.
     *
     * The simulation does not perform the API operations; it only checks the authorization to determine if the simulated policies allow or deny the operations.
     *
     * **Note:** This operation discloses information about the permissions granted to other users. If you do not want users to see other user's permissions, then consider allowing them to use SimulateCustomPolicy instead.
     *
     * Context keys are variables maintained by Amazon Web Services and its services that provide details about the context of an API query request. You can use the `Condition` element of an IAM policy to evaluate context keys. To get the list of context keys that the policies require for correct simulation, use GetContextKeysForPrincipalPolicy.
     *
     * If the output is long, you can use the `MaxItems` and `Marker` parameters to paginate the results.
     *
     * The IAM policy simulator evaluates statements in the identity-based policy and the inputs that you provide during simulation. The policy simulator results can differ from your live Amazon Web Services environment. We recommend that you check your policies against your live Amazon Web Services environment after testing using the policy simulator to confirm that you have the desired results. For more information about using the policy simulator, see [Testing IAM policies with the IAM policy simulator ](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_testing-policies.html)in the *IAM User Guide*.
     */
    public suspend fun simulatePrincipalPolicy(input: SimulatePrincipalPolicyRequest): SimulatePrincipalPolicyResponse

    /**
     * Adds one or more tags to an IAM instance profile. If a tag with the same key name already exists, then that tag is overwritten with the new value.
     *
     * Each tag consists of a key name and an associated value. By assigning tags to your resources, you can do the following:
     * + **Administrative grouping and discovery** - Attach tags to resources to aid in organization and search. For example, you could search for all resources with the key name *Project* and the value *MyImportantProject*. Or search for all resources with the key name *Cost Center* and the value *41200*.
     * + **Access control** - Include tags in IAM user-based and resource-based policies. You can use tags to restrict access to only an IAM instance profile that has a specified tag attached. For examples of policies that show how to use tags to control access, see [Control access using IAM tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html) in the *IAM User Guide*.
     *
     * + If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
     * + Amazon Web Services always interprets the tag `Value` as a single string. If you need to store an array, you can store comma-separated values in the string. However, you must interpret the value in your code.
     */
    public suspend fun tagInstanceProfile(input: TagInstanceProfileRequest): TagInstanceProfileResponse

    /**
     * Adds one or more tags to an IAM virtual multi-factor authentication (MFA) device. If a tag with the same key name already exists, then that tag is overwritten with the new value.
     *
     * A tag consists of a key name and an associated value. By assigning tags to your resources, you can do the following:
     * + **Administrative grouping and discovery** - Attach tags to resources to aid in organization and search. For example, you could search for all resources with the key name *Project* and the value *MyImportantProject*. Or search for all resources with the key name *Cost Center* and the value *41200*.
     * + **Access control** - Include tags in IAM user-based and resource-based policies. You can use tags to restrict access to only an IAM virtual MFA device that has a specified tag attached. For examples of policies that show how to use tags to control access, see [Control access using IAM tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html) in the *IAM User Guide*.
     *
     * + If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
     * + Amazon Web Services always interprets the tag `Value` as a single string. If you need to store an array, you can store comma-separated values in the string. However, you must interpret the value in your code.
     */
    public suspend fun tagMfaDevice(input: TagMfaDeviceRequest): TagMfaDeviceResponse

    /**
     * Adds one or more tags to an OpenID Connect (OIDC)-compatible identity provider. For more information about these providers, see [About web identity federation](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc.html). If a tag with the same key name already exists, then that tag is overwritten with the new value.
     *
     * A tag consists of a key name and an associated value. By assigning tags to your resources, you can do the following:
     * + **Administrative grouping and discovery** - Attach tags to resources to aid in organization and search. For example, you could search for all resources with the key name *Project* and the value *MyImportantProject*. Or search for all resources with the key name *Cost Center* and the value *41200*.
     * + **Access control** - Include tags in IAM identity-based and resource-based policies. You can use tags to restrict access to only an OIDC provider that has a specified tag attached. For examples of policies that show how to use tags to control access, see [Control access using IAM tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html) in the *IAM User Guide*.
     *
     * + If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
     * + Amazon Web Services always interprets the tag `Value` as a single string. If you need to store an array, you can store comma-separated values in the string. However, you must interpret the value in your code.
     */
    public suspend fun tagOpenIdConnectProvider(input: TagOpenIdConnectProviderRequest): TagOpenIdConnectProviderResponse

    /**
     * Adds one or more tags to an IAM customer managed policy. If a tag with the same key name already exists, then that tag is overwritten with the new value.
     *
     * A tag consists of a key name and an associated value. By assigning tags to your resources, you can do the following:
     * + **Administrative grouping and discovery** - Attach tags to resources to aid in organization and search. For example, you could search for all resources with the key name *Project* and the value *MyImportantProject*. Or search for all resources with the key name *Cost Center* and the value *41200*.
     * + **Access control** - Include tags in IAM user-based and resource-based policies. You can use tags to restrict access to only an IAM customer managed policy that has a specified tag attached. For examples of policies that show how to use tags to control access, see [Control access using IAM tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html) in the *IAM User Guide*.
     *
     * + If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
     * + Amazon Web Services always interprets the tag `Value` as a single string. If you need to store an array, you can store comma-separated values in the string. However, you must interpret the value in your code.
     */
    public suspend fun tagPolicy(input: TagPolicyRequest): TagPolicyResponse

    /**
     * Adds one or more tags to an IAM role. The role can be a regular role or a service-linked role. If a tag with the same key name already exists, then that tag is overwritten with the new value.
     *
     * A tag consists of a key name and an associated value. By assigning tags to your resources, you can do the following:
     * + **Administrative grouping and discovery** - Attach tags to resources to aid in organization and search. For example, you could search for all resources with the key name *Project* and the value *MyImportantProject*. Or search for all resources with the key name *Cost Center* and the value *41200*.
     * + **Access control** - Include tags in IAM user-based and resource-based policies. You can use tags to restrict access to only an IAM role that has a specified tag attached. You can also restrict access to only those resources that have a certain tag attached. For examples of policies that show how to use tags to control access, see [Control access using IAM tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html) in the *IAM User Guide*.
     * + **Cost allocation** - Use tags to help track which individuals and teams are using which Amazon Web Services resources.
     *
     * + If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
     * + Amazon Web Services always interprets the tag `Value` as a single string. If you need to store an array, you can store comma-separated values in the string. However, you must interpret the value in your code.
     * For more information about tagging, see [Tagging IAM identities](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.TagRole.sample
     */
    public suspend fun tagRole(input: TagRoleRequest): TagRoleResponse

    /**
     * Adds one or more tags to a Security Assertion Markup Language (SAML) identity provider. For more information about these providers, see [About SAML 2.0-based federation ](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html). If a tag with the same key name already exists, then that tag is overwritten with the new value.
     *
     * A tag consists of a key name and an associated value. By assigning tags to your resources, you can do the following:
     * + **Administrative grouping and discovery** - Attach tags to resources to aid in organization and search. For example, you could search for all resources with the key name *Project* and the value *MyImportantProject*. Or search for all resources with the key name *Cost Center* and the value *41200*.
     * + **Access control** - Include tags in IAM user-based and resource-based policies. You can use tags to restrict access to only a SAML identity provider that has a specified tag attached. For examples of policies that show how to use tags to control access, see [Control access using IAM tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html) in the *IAM User Guide*.
     *
     * + If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
     * + Amazon Web Services always interprets the tag `Value` as a single string. If you need to store an array, you can store comma-separated values in the string. However, you must interpret the value in your code.
     */
    public suspend fun tagSamlProvider(input: TagSamlProviderRequest): TagSamlProviderResponse

    /**
     * Adds one or more tags to an IAM server certificate. If a tag with the same key name already exists, then that tag is overwritten with the new value.
     *
     * For certificates in a Region supported by Certificate Manager (ACM), we recommend that you don't use IAM server certificates. Instead, use ACM to provision, manage, and deploy your server certificates. For more information about IAM server certificates, [Working with server certificates](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html) in the *IAM User Guide*.
     *
     * A tag consists of a key name and an associated value. By assigning tags to your resources, you can do the following:
     * + **Administrative grouping and discovery** - Attach tags to resources to aid in organization and search. For example, you could search for all resources with the key name *Project* and the value *MyImportantProject*. Or search for all resources with the key name *Cost Center* and the value *41200*.
     * + **Access control** - Include tags in IAM user-based and resource-based policies. You can use tags to restrict access to only a server certificate that has a specified tag attached. For examples of policies that show how to use tags to control access, see [Control access using IAM tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html) in the *IAM User Guide*.
     * + **Cost allocation** - Use tags to help track which individuals and teams are using which Amazon Web Services resources.
     *
     * + If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
     * + Amazon Web Services always interprets the tag `Value` as a single string. If you need to store an array, you can store comma-separated values in the string. However, you must interpret the value in your code.
     */
    public suspend fun tagServerCertificate(input: TagServerCertificateRequest): TagServerCertificateResponse

    /**
     * Adds one or more tags to an IAM user. If a tag with the same key name already exists, then that tag is overwritten with the new value.
     *
     * A tag consists of a key name and an associated value. By assigning tags to your resources, you can do the following:
     * + **Administrative grouping and discovery** - Attach tags to resources to aid in organization and search. For example, you could search for all resources with the key name *Project* and the value *MyImportantProject*. Or search for all resources with the key name *Cost Center* and the value *41200*.
     * + **Access control** - Include tags in IAM identity-based and resource-based policies. You can use tags to restrict access to only an IAM requesting user that has a specified tag attached. You can also restrict access to only those resources that have a certain tag attached. For examples of policies that show how to use tags to control access, see [Control access using IAM tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html) in the *IAM User Guide*.
     * + **Cost allocation** - Use tags to help track which individuals and teams are using which Amazon Web Services resources.
     *
     * + If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
     * + Amazon Web Services always interprets the tag `Value` as a single string. If you need to store an array, you can store comma-separated values in the string. However, you must interpret the value in your code.
     * For more information about tagging, see [Tagging IAM identities](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.TagUser.sample
     */
    public suspend fun tagUser(input: TagUserRequest): TagUserResponse

    /**
     * Removes the specified tags from the IAM instance profile. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
     */
    public suspend fun untagInstanceProfile(input: UntagInstanceProfileRequest): UntagInstanceProfileResponse

    /**
     * Removes the specified tags from the IAM virtual multi-factor authentication (MFA) device. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
     */
    public suspend fun untagMfaDevice(input: UntagMfaDeviceRequest): UntagMfaDeviceResponse

    /**
     * Removes the specified tags from the specified OpenID Connect (OIDC)-compatible identity provider in IAM. For more information about OIDC providers, see [About web identity federation](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc.html). For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
     */
    public suspend fun untagOpenIdConnectProvider(input: UntagOpenIdConnectProviderRequest): UntagOpenIdConnectProviderResponse

    /**
     * Removes the specified tags from the customer managed policy. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
     */
    public suspend fun untagPolicy(input: UntagPolicyRequest): UntagPolicyResponse

    /**
     * Removes the specified tags from the role. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.UntagRole.sample
     */
    public suspend fun untagRole(input: UntagRoleRequest): UntagRoleResponse

    /**
     * Removes the specified tags from the specified Security Assertion Markup Language (SAML) identity provider in IAM. For more information about these providers, see [About web identity federation](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc.html). For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
     */
    public suspend fun untagSamlProvider(input: UntagSamlProviderRequest): UntagSamlProviderResponse

    /**
     * Removes the specified tags from the IAM server certificate. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
     *
     * For certificates in a Region supported by Certificate Manager (ACM), we recommend that you don't use IAM server certificates. Instead, use ACM to provision, manage, and deploy your server certificates. For more information about IAM server certificates, [Working with server certificates](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html) in the *IAM User Guide*.
     */
    public suspend fun untagServerCertificate(input: UntagServerCertificateRequest): UntagServerCertificateResponse

    /**
     * Removes the specified tags from the user. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.UntagUser.sample
     */
    public suspend fun untagUser(input: UntagUserRequest): UntagUserResponse

    /**
     * Changes the status of the specified access key from Active to Inactive, or vice versa. This operation can be used to disable a user's key as part of a key rotation workflow.
     *
     * If the `UserName` is not specified, the user name is determined implicitly based on the Amazon Web Services access key ID used to sign the request. If a temporary access key is used, then `UserName` is required. If a long-term key is assigned to the user, then `UserName` is not required. This operation works for access keys under the Amazon Web Services account. Consequently, you can use this operation to manage Amazon Web Services account root user credentials even if the Amazon Web Services account has no associated users.
     *
     * For information about rotating keys, see [Managing keys and certificates](https://docs.aws.amazon.com/IAM/latest/UserGuide/ManagingCredentials.html) in the *IAM User Guide*.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.UpdateAccessKey.sample
     */
    public suspend fun updateAccessKey(input: UpdateAccessKeyRequest): UpdateAccessKeyResponse

    /**
     * Updates the password policy settings for the Amazon Web Services account.
     *
     * This operation does not support partial updates. No parameters are required, but if you do not specify a parameter, that parameter's value reverts to its default value. See the **Request Parameters** section for each parameter's default value. Also note that some parameters do not allow the default parameter to be explicitly set. Instead, to invoke the default value, do not include that parameter when you invoke the operation.
     *
     *  For more information about using a password policy, see [Managing an IAM password policy](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingPasswordPolicies.html) in the *IAM User Guide*.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.UpdateAccountPasswordPolicy.sample
     */
    public suspend fun updateAccountPasswordPolicy(input: UpdateAccountPasswordPolicyRequest = UpdateAccountPasswordPolicyRequest { }): UpdateAccountPasswordPolicyResponse

    /**
     * Updates the policy that grants an IAM entity permission to assume a role. This is typically referred to as the "role trust policy". For more information about roles, see [Using roles to delegate permissions and federate identities](https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html).
     *
     * @sample aws.sdk.kotlin.services.iam.samples.UpdateAssumeRolePolicy.sample
     */
    public suspend fun updateAssumeRolePolicy(input: UpdateAssumeRolePolicyRequest): UpdateAssumeRolePolicyResponse

    /**
     * Updates the name and/or the path of the specified IAM group.
     *
     *  You should understand the implications of changing a group's path or name. For more information, see [Renaming users and groups](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_WorkingWithGroupsAndUsers.html) in the *IAM User Guide*.
     *
     * The person making the request (the principal), must have permission to change the role group with the old name and the new name. For example, to change the group named `Managers` to `MGRs`, the principal must have a policy that allows them to update both groups. If the principal has permission to update the `Managers` group, but not the `MGRs` group, then the update fails. For more information about permissions, see [Access management](https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html).
     *
     * @sample aws.sdk.kotlin.services.iam.samples.UpdateGroup.sample
     */
    public suspend fun updateGroup(input: UpdateGroupRequest): UpdateGroupResponse

    /**
     * Changes the password for the specified IAM user. You can use the CLI, the Amazon Web Services API, or the **Users** page in the IAM console to change the password for any IAM user. Use ChangePassword to change your own password in the **My Security Credentials** page in the Amazon Web Services Management Console.
     *
     * For more information about modifying passwords, see [Managing passwords](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html) in the *IAM User Guide*.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.UpdateLoginProfile.sample
     */
    public suspend fun updateLoginProfile(input: UpdateLoginProfileRequest): UpdateLoginProfileResponse

    /**
     * Replaces the existing list of server certificate thumbprints associated with an OpenID Connect (OIDC) provider resource object with a new list of thumbprints.
     *
     * The list that you pass with this operation completely replaces the existing list of thumbprints. (The lists are not merged.)
     *
     * Typically, you need to update a thumbprint only when the identity provider certificate changes, which occurs rarely. However, if the provider's certificate *does* change, any attempt to assume an IAM role that specifies the OIDC provider as a principal fails until the certificate thumbprint is updated.
     *
     * Amazon Web Services secures communication with some OIDC identity providers (IdPs) through our library of trusted root certificate authorities (CAs) instead of using a certificate thumbprint to verify your IdP server certificate. In these cases, your legacy thumbprint remains in your configuration, but is no longer used for validation. These OIDC IdPs include Auth0, GitHub, GitLab, Google, and those that use an Amazon S3 bucket to host a JSON Web Key Set (JWKS) endpoint.
     *
     * Trust for the OIDC provider is derived from the provider certificate and is validated by the thumbprint. Therefore, it is best to limit access to the `UpdateOpenIDConnectProviderThumbprint` operation to highly privileged users.
     */
    public suspend fun updateOpenIdConnectProviderThumbprint(input: UpdateOpenIdConnectProviderThumbprintRequest): UpdateOpenIdConnectProviderThumbprintResponse

    /**
     * Updates the description or maximum session duration setting of a role.
     */
    public suspend fun updateRole(input: UpdateRoleRequest): UpdateRoleResponse

    /**
     * Use UpdateRole instead.
     *
     * Modifies only the description of a role. This operation performs the same function as the `Description` parameter in the `UpdateRole` operation.
     */
    public suspend fun updateRoleDescription(input: UpdateRoleDescriptionRequest): UpdateRoleDescriptionResponse

    /**
     * Updates the metadata document for an existing SAML provider resource object.
     *
     * This operation requires [Signature Version 4](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
     */
    public suspend fun updateSamlProvider(input: UpdateSamlProviderRequest): UpdateSamlProviderResponse

    /**
     * Updates the name and/or the path of the specified server certificate stored in IAM.
     *
     * For more information about working with server certificates, see [Working with server certificates](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html) in the *IAM User Guide*. This topic also includes a list of Amazon Web Services services that can use the server certificates that you manage with IAM.
     *
     * You should understand the implications of changing a server certificate's path or name. For more information, see [Renaming a server certificate](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs_manage.html#RenamingServerCerts) in the *IAM User Guide*.
     *
     * The person making the request (the principal), must have permission to change the server certificate with the old name and the new name. For example, to change the certificate named `ProductionCert` to `ProdCert`, the principal must have a policy that allows them to update both certificates. If the principal has permission to update the `ProductionCert` group, but not the `ProdCert` certificate, then the update fails. For more information about permissions, see [Access management](https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html) in the *IAM User Guide*.
     */
    public suspend fun updateServerCertificate(input: UpdateServerCertificateRequest): UpdateServerCertificateResponse

    /**
     * Sets the status of a service-specific credential to `Active` or `Inactive`. Service-specific credentials that are inactive cannot be used for authentication to the service. This operation can be used to disable a user's service-specific credential as part of a credential rotation work flow.
     */
    public suspend fun updateServiceSpecificCredential(input: UpdateServiceSpecificCredentialRequest): UpdateServiceSpecificCredentialResponse

    /**
     * Changes the status of the specified user signing certificate from active to disabled, or vice versa. This operation can be used to disable an IAM user's signing certificate as part of a certificate rotation work flow.
     *
     * If the `UserName` field is not specified, the user name is determined implicitly based on the Amazon Web Services access key ID used to sign the request. This operation works for access keys under the Amazon Web Services account. Consequently, you can use this operation to manage Amazon Web Services account root user credentials even if the Amazon Web Services account has no associated users.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.UpdateSigningCertificate.sample
     */
    public suspend fun updateSigningCertificate(input: UpdateSigningCertificateRequest): UpdateSigningCertificateResponse

    /**
     * Sets the status of an IAM user's SSH public key to active or inactive. SSH public keys that are inactive cannot be used for authentication. This operation can be used to disable a user's SSH public key as part of a key rotation work flow.
     *
     * The SSH public key affected by this operation is used only for authenticating the associated IAM user to an CodeCommit repository. For more information about using SSH keys to authenticate to an CodeCommit repository, see [Set up CodeCommit for SSH connections](https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html) in the *CodeCommit User Guide*.
     */
    public suspend fun updateSshPublicKey(input: UpdateSshPublicKeyRequest): UpdateSshPublicKeyResponse

    /**
     * Updates the name and/or the path of the specified IAM user.
     *
     *  You should understand the implications of changing an IAM user's path or name. For more information, see [Renaming an IAM user](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users_manage.html#id_users_renaming) and [Renaming an IAM group](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_groups_manage_rename.html) in the *IAM User Guide*.
     *
     *  To change a user name, the requester must have appropriate permissions on both the source object and the target object. For example, to change Bob to Robert, the entity making the request must have permission on Bob and Robert, or must have permission on all (*). For more information about permissions, see [Permissions and policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/PermissionsAndPolicies.html).
     *
     * @sample aws.sdk.kotlin.services.iam.samples.UpdateUser.sample
     */
    public suspend fun updateUser(input: UpdateUserRequest): UpdateUserResponse

    /**
     * Uploads a server certificate entity for the Amazon Web Services account. The server certificate entity includes a public key certificate, a private key, and an optional certificate chain, which should all be PEM-encoded.
     *
     * We recommend that you use [Certificate Manager](https://docs.aws.amazon.com/acm/) to provision, manage, and deploy your server certificates. With ACM you can request a certificate, deploy it to Amazon Web Services resources, and let ACM handle certificate renewals for you. Certificates provided by ACM are free. For more information about using ACM, see the [Certificate Manager User Guide](https://docs.aws.amazon.com/acm/latest/userguide/).
     *
     * For more information about working with server certificates, see [Working with server certificates](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html) in the *IAM User Guide*. This topic includes a list of Amazon Web Services services that can use the server certificates that you manage with IAM.
     *
     * For information about the number of server certificates you can upload, see [IAM and STS quotas](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html) in the *IAM User Guide*.
     *
     * Because the body of the public key certificate, private key, and the certificate chain can be large, you should use POST rather than GET when calling `UploadServerCertificate`. For information about setting up signatures and authorization through the API, see [Signing Amazon Web Services API requests](https://docs.aws.amazon.com/general/latest/gr/signing_aws_api_requests.html) in the *Amazon Web Services General Reference*. For general information about using the Query API with IAM, see [Calling the API by making HTTP query requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/programming.html) in the *IAM User Guide*.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.UploadServerCertificate.sample
     */
    public suspend fun uploadServerCertificate(input: UploadServerCertificateRequest): UploadServerCertificateResponse

    /**
     * Uploads an X.509 signing certificate and associates it with the specified IAM user. Some Amazon Web Services services require you to use certificates to validate requests that are signed with a corresponding private key. When you upload the certificate, its default status is `Active`.
     *
     * For information about when you would use an X.509 signing certificate, see [Managing server certificates in IAM](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html) in the *IAM User Guide*.
     *
     * If the `UserName` is not specified, the IAM user name is determined implicitly based on the Amazon Web Services access key ID used to sign the request. This operation works for access keys under the Amazon Web Services account. Consequently, you can use this operation to manage Amazon Web Services account root user credentials even if the Amazon Web Services account has no associated users.
     *
     * Because the body of an X.509 certificate can be large, you should use POST rather than GET when calling `UploadSigningCertificate`. For information about setting up signatures and authorization through the API, see [Signing Amazon Web Services API requests](https://docs.aws.amazon.com/general/latest/gr/signing_aws_api_requests.html) in the *Amazon Web Services General Reference*. For general information about using the Query API with IAM, see [Making query requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html) in the *IAM User Guide*.
     *
     * @sample aws.sdk.kotlin.services.iam.samples.UploadSigningCertificate.sample
     */
    public suspend fun uploadSigningCertificate(input: UploadSigningCertificateRequest): UploadSigningCertificateResponse

    /**
     * Uploads an SSH public key and associates it with the specified IAM user.
     *
     * The SSH public key uploaded by this operation can be used only for authenticating the associated IAM user to an CodeCommit repository. For more information about using SSH keys to authenticate to an CodeCommit repository, see [Set up CodeCommit for SSH connections](https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html) in the *CodeCommit User Guide*.
     */
    public suspend fun uploadSshPublicKey(input: UploadSshPublicKeyRequest): UploadSshPublicKeyResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun IamClient.withConfig(block: IamClient.Config.Builder.() -> Unit): IamClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultIamClient(newConfig)
}

/**
 * Adds a new client ID (also known as audience) to the list of client IDs already registered for the specified IAM OpenID Connect (OIDC) provider resource.
 *
 * This operation is idempotent; it does not fail or return an error if you add an existing client ID to the provider.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.AddClientIDToOpenIDConnectProvider.sample
 */
public suspend inline fun IamClient.addClientIdToOpenIdConnectProvider(crossinline block: AddClientIdToOpenIdConnectProviderRequest.Builder.() -> Unit): AddClientIdToOpenIdConnectProviderResponse = addClientIdToOpenIdConnectProvider(AddClientIdToOpenIdConnectProviderRequest.Builder().apply(block).build())

/**
 * Adds the specified IAM role to the specified instance profile. An instance profile can contain only one role, and this quota cannot be increased. You can remove the existing role and then add a different role to an instance profile. You must then wait for the change to appear across all of Amazon Web Services because of [eventual consistency](https://en.wikipedia.org/wiki/Eventual_consistency). To force the change, you must [disassociate the instance profile](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateIamInstanceProfile.html) and then [associate the instance profile](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateIamInstanceProfile.html), or you can stop your instance and then restart it.
 *
 * The caller of this operation must be granted the `PassRole` permission on the IAM role by a permissions policy.
 *
 *  For more information about roles, see [IAM roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html) in the *IAM User Guide*. For more information about instance profiles, see [Using instance profiles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2_instance-profiles.html) in the *IAM User Guide*.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.AddRoleToInstanceProfile.sample
 */
public suspend inline fun IamClient.addRoleToInstanceProfile(crossinline block: AddRoleToInstanceProfileRequest.Builder.() -> Unit): AddRoleToInstanceProfileResponse = addRoleToInstanceProfile(AddRoleToInstanceProfileRequest.Builder().apply(block).build())

/**
 * Adds the specified user to the specified group.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.AddUserToGroup.sample
 */
public suspend inline fun IamClient.addUserToGroup(crossinline block: AddUserToGroupRequest.Builder.() -> Unit): AddUserToGroupResponse = addUserToGroup(AddUserToGroupRequest.Builder().apply(block).build())

/**
 * Attaches the specified managed policy to the specified IAM group.
 *
 * You use this operation to attach a managed policy to a group. To embed an inline policy in a group, use `PutGroupPolicy`[](https://docs.aws.amazon.com/IAM/latest/APIReference/API_PutGroupPolicy.html).
 *
 * As a best practice, you can validate your IAM policies. To learn more, see [Validating IAM policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html) in the *IAM User Guide*.
 *
 * For more information about policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.AttachGroupPolicy.sample
 */
public suspend inline fun IamClient.attachGroupPolicy(crossinline block: AttachGroupPolicyRequest.Builder.() -> Unit): AttachGroupPolicyResponse = attachGroupPolicy(AttachGroupPolicyRequest.Builder().apply(block).build())

/**
 * Attaches the specified managed policy to the specified IAM role. When you attach a managed policy to a role, the managed policy becomes part of the role's permission (access) policy.
 *
 * You cannot use a managed policy as the role's trust policy. The role's trust policy is created at the same time as the role, using `CreateRole`[](https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html). You can update a role's trust policy using `UpdateAssumerolePolicy`[](https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateAssumeRolePolicy.html).
 *
 * Use this operation to attach a *managed* policy to a role. To embed an inline policy in a role, use `PutRolePolicy`[](https://docs.aws.amazon.com/IAM/latest/APIReference/API_PutRolePolicy.html). For more information about policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
 *
 * As a best practice, you can validate your IAM policies. To learn more, see [Validating IAM policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html) in the *IAM User Guide*.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.AttachRolePolicy.sample
 */
public suspend inline fun IamClient.attachRolePolicy(crossinline block: AttachRolePolicyRequest.Builder.() -> Unit): AttachRolePolicyResponse = attachRolePolicy(AttachRolePolicyRequest.Builder().apply(block).build())

/**
 * Attaches the specified managed policy to the specified user.
 *
 * You use this operation to attach a *managed* policy to a user. To embed an inline policy in a user, use `PutUserPolicy`[](https://docs.aws.amazon.com/IAM/latest/APIReference/API_PutUserPolicy.html).
 *
 * As a best practice, you can validate your IAM policies. To learn more, see [Validating IAM policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html) in the *IAM User Guide*.
 *
 * For more information about policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.AttachUserPolicy.sample
 */
public suspend inline fun IamClient.attachUserPolicy(crossinline block: AttachUserPolicyRequest.Builder.() -> Unit): AttachUserPolicyResponse = attachUserPolicy(AttachUserPolicyRequest.Builder().apply(block).build())

/**
 * Changes the password of the IAM user who is calling this operation. This operation can be performed using the CLI, the Amazon Web Services API, or the **My Security Credentials** page in the Amazon Web Services Management Console. The Amazon Web Services account root user password is not affected by this operation.
 *
 * Use UpdateLoginProfile to use the CLI, the Amazon Web Services API, or the **Users** page in the IAM console to change the password for any IAM user. For more information about modifying passwords, see [Managing passwords](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html) in the *IAM User Guide*.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.ChangePassword.sample
 */
public suspend inline fun IamClient.changePassword(crossinline block: ChangePasswordRequest.Builder.() -> Unit): ChangePasswordResponse = changePassword(ChangePasswordRequest.Builder().apply(block).build())

/**
 * Creates a new Amazon Web Services secret access key and corresponding Amazon Web Services access key ID for the specified user. The default status for new keys is `Active`.
 *
 * If you do not specify a user name, IAM determines the user name implicitly based on the Amazon Web Services access key ID signing the request. This operation works for access keys under the Amazon Web Services account. Consequently, you can use this operation to manage Amazon Web Services account root user credentials. This is true even if the Amazon Web Services account has no associated users.
 *
 *  For information about quotas on the number of keys you can create, see [IAM and STS quotas](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html) in the *IAM User Guide*.
 *
 * To ensure the security of your Amazon Web Services account, the secret access key is accessible only during key and user creation. You must save the key (for example, in a text file) if you want to be able to access it again. If a secret key is lost, you can delete the access keys for the associated user and then create new keys.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.CreateAccessKey.sample
 */
public suspend inline fun IamClient.createAccessKey(crossinline block: CreateAccessKeyRequest.Builder.() -> Unit): CreateAccessKeyResponse = createAccessKey(CreateAccessKeyRequest.Builder().apply(block).build())

/**
 * Creates an alias for your Amazon Web Services account. For information about using an Amazon Web Services account alias, see [Creating, deleting, and listing an Amazon Web Services account alias](https://docs.aws.amazon.com/signin/latest/userguide/CreateAccountAlias.html) in the *Amazon Web Services Sign-In User Guide*.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.CreateAccountAlias.sample
 */
public suspend inline fun IamClient.createAccountAlias(crossinline block: CreateAccountAliasRequest.Builder.() -> Unit): CreateAccountAliasResponse = createAccountAlias(CreateAccountAliasRequest.Builder().apply(block).build())

/**
 * Creates a new group.
 *
 *  For information about the number of groups you can create, see [IAM and STS quotas](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html) in the *IAM User Guide*.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.CreateGroup.sample
 */
public suspend inline fun IamClient.createGroup(crossinline block: CreateGroupRequest.Builder.() -> Unit): CreateGroupResponse = createGroup(CreateGroupRequest.Builder().apply(block).build())

/**
 * Creates a new instance profile. For information about instance profiles, see [Using roles for applications on Amazon EC2](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html) in the *IAM User Guide*, and [Instance profiles](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-roles-for-amazon-ec2.html#ec2-instance-profile) in the *Amazon EC2 User Guide*.
 *
 *  For information about the number of instance profiles you can create, see [IAM object quotas](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html) in the *IAM User Guide*.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.CreateInstanceProfile.sample
 */
public suspend inline fun IamClient.createInstanceProfile(crossinline block: CreateInstanceProfileRequest.Builder.() -> Unit): CreateInstanceProfileResponse = createInstanceProfile(CreateInstanceProfileRequest.Builder().apply(block).build())

/**
 * Creates a password for the specified IAM user. A password allows an IAM user to access Amazon Web Services services through the Amazon Web Services Management Console.
 *
 * You can use the CLI, the Amazon Web Services API, or the **Users** page in the IAM console to create a password for any IAM user. Use ChangePassword to update your own existing password in the **My Security Credentials** page in the Amazon Web Services Management Console.
 *
 * For more information about managing passwords, see [Managing passwords](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html) in the *IAM User Guide*.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.CreateLoginProfile.sample
 */
public suspend inline fun IamClient.createLoginProfile(crossinline block: CreateLoginProfileRequest.Builder.() -> Unit): CreateLoginProfileResponse = createLoginProfile(CreateLoginProfileRequest.Builder().apply(block).build())

/**
 * Creates an IAM entity to describe an identity provider (IdP) that supports [OpenID Connect (OIDC)](http://openid.net/connect/).
 *
 * The OIDC provider that you create with this operation can be used as a principal in a role's trust policy. Such a policy establishes a trust relationship between Amazon Web Services and the OIDC provider.
 *
 * If you are using an OIDC identity provider from Google, Facebook, or Amazon Cognito, you don't need to create a separate IAM identity provider. These OIDC identity providers are already built-in to Amazon Web Services and are available for your use. Instead, you can move directly to creating new roles using your identity provider. To learn more, see [Creating a role for web identity or OpenID connect federation](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-idp_oidc.html) in the *IAM User Guide*.
 *
 * When you create the IAM OIDC provider, you specify the following:
 * + The URL of the OIDC identity provider (IdP) to trust
 * + A list of client IDs (also known as audiences) that identify the application or applications allowed to authenticate using the OIDC provider
 * + A list of tags that are attached to the specified IAM OIDC provider
 * + A list of thumbprints of one or more server certificates that the IdP uses
 *
 * You get all of this information from the OIDC IdP you want to use to access Amazon Web Services.
 *
 * Amazon Web Services secures communication with some OIDC identity providers (IdPs) through our library of trusted root certificate authorities (CAs) instead of using a certificate thumbprint to verify your IdP server certificate. In these cases, your legacy thumbprint remains in your configuration, but is no longer used for validation. These OIDC IdPs include Auth0, GitHub, GitLab, Google, and those that use an Amazon S3 bucket to host a JSON Web Key Set (JWKS) endpoint.
 *
 * The trust for the OIDC provider is derived from the IAM provider that this operation creates. Therefore, it is best to limit access to the CreateOpenIDConnectProvider operation to highly privileged users.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.CreateOpenIDConnectProvider.sample
 */
public suspend inline fun IamClient.createOpenIdConnectProvider(crossinline block: CreateOpenIdConnectProviderRequest.Builder.() -> Unit): CreateOpenIdConnectProviderResponse = createOpenIdConnectProvider(CreateOpenIdConnectProviderRequest.Builder().apply(block).build())

/**
 * Creates a new managed policy for your Amazon Web Services account.
 *
 * This operation creates a policy version with a version identifier of `v1` and sets v1 as the policy's default version. For more information about policy versions, see [Versioning for managed policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html) in the *IAM User Guide*.
 *
 * As a best practice, you can validate your IAM policies. To learn more, see [Validating IAM policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html) in the *IAM User Guide*.
 *
 * For more information about managed policies in general, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
 */
public suspend inline fun IamClient.createPolicy(crossinline block: CreatePolicyRequest.Builder.() -> Unit): CreatePolicyResponse = createPolicy(CreatePolicyRequest.Builder().apply(block).build())

/**
 * Creates a new version of the specified managed policy. To update a managed policy, you create a new policy version. A managed policy can have up to five versions. If the policy has five versions, you must delete an existing version using DeletePolicyVersion before you create a new version.
 *
 * Optionally, you can set the new version as the policy's default version. The default version is the version that is in effect for the IAM users, groups, and roles to which the policy is attached.
 *
 * For more information about managed policy versions, see [Versioning for managed policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html) in the *IAM User Guide*.
 */
public suspend inline fun IamClient.createPolicyVersion(crossinline block: CreatePolicyVersionRequest.Builder.() -> Unit): CreatePolicyVersionResponse = createPolicyVersion(CreatePolicyVersionRequest.Builder().apply(block).build())

/**
 * Creates a new role for your Amazon Web Services account.
 *
 *  For more information about roles, see [IAM roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html) in the *IAM User Guide*. For information about quotas for role names and the number of roles you can create, see [IAM and STS quotas](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html) in the *IAM User Guide*.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.CreateRole.sample
 */
public suspend inline fun IamClient.createRole(crossinline block: CreateRoleRequest.Builder.() -> Unit): CreateRoleResponse = createRole(CreateRoleRequest.Builder().apply(block).build())

/**
 * Creates an IAM resource that describes an identity provider (IdP) that supports SAML 2.0.
 *
 * The SAML provider resource that you create with this operation can be used as a principal in an IAM role's trust policy. Such a policy can enable federated users who sign in using the SAML IdP to assume the role. You can create an IAM role that supports Web-based single sign-on (SSO) to the Amazon Web Services Management Console or one that supports API access to Amazon Web Services.
 *
 * When you create the SAML provider resource, you upload a SAML metadata document that you get from your IdP. That document includes the issuer's name, expiration information, and keys that can be used to validate the SAML authentication response (assertions) that the IdP sends. You must generate the metadata document using the identity management software that is used as your organization's IdP.
 *
 *  This operation requires [Signature Version 4](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
 *
 *  For more information, see [Enabling SAML 2.0 federated users to access the Amazon Web Services Management Console](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-saml.html) and [About SAML 2.0-based federation](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html) in the *IAM User Guide*.
 */
public suspend inline fun IamClient.createSamlProvider(crossinline block: CreateSamlProviderRequest.Builder.() -> Unit): CreateSamlProviderResponse = createSamlProvider(CreateSamlProviderRequest.Builder().apply(block).build())

/**
 * Creates an IAM role that is linked to a specific Amazon Web Services service. The service controls the attached policies and when the role can be deleted. This helps ensure that the service is not broken by an unexpectedly changed or deleted role, which could put your Amazon Web Services resources into an unknown state. Allowing the service to control the role helps improve service stability and proper cleanup when a service and its role are no longer needed. For more information, see [Using service-linked roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/using-service-linked-roles.html) in the *IAM User Guide*.
 *
 * To attach a policy to this service-linked role, you must make the request using the Amazon Web Services service that depends on this role.
 */
public suspend inline fun IamClient.createServiceLinkedRole(crossinline block: CreateServiceLinkedRoleRequest.Builder.() -> Unit): CreateServiceLinkedRoleResponse = createServiceLinkedRole(CreateServiceLinkedRoleRequest.Builder().apply(block).build())

/**
 * Generates a set of credentials consisting of a user name and password that can be used to access the service specified in the request. These credentials are generated by IAM, and can be used only for the specified service.
 *
 * You can have a maximum of two sets of service-specific credentials for each supported service per user.
 *
 * You can create service-specific credentials for CodeCommit and Amazon Keyspaces (for Apache Cassandra).
 *
 * You can reset the password to a new service-generated value by calling ResetServiceSpecificCredential.
 *
 * For more information about service-specific credentials, see [Using IAM with CodeCommit: Git credentials, SSH keys, and Amazon Web Services access keys](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_ssh-keys.html) in the *IAM User Guide*.
 */
public suspend inline fun IamClient.createServiceSpecificCredential(crossinline block: CreateServiceSpecificCredentialRequest.Builder.() -> Unit): CreateServiceSpecificCredentialResponse = createServiceSpecificCredential(CreateServiceSpecificCredentialRequest.Builder().apply(block).build())

/**
 * Creates a new IAM user for your Amazon Web Services account.
 *
 *  For information about quotas for the number of IAM users you can create, see [IAM and STS quotas](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html) in the *IAM User Guide*.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.CreateUser.sample
 */
public suspend inline fun IamClient.createUser(crossinline block: CreateUserRequest.Builder.() -> Unit): CreateUserResponse = createUser(CreateUserRequest.Builder().apply(block).build())

/**
 * Creates a new virtual MFA device for the Amazon Web Services account. After creating the virtual MFA, use EnableMFADevice to attach the MFA device to an IAM user. For more information about creating and working with virtual MFA devices, see [Using a virtual MFA device](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html) in the *IAM User Guide*.
 *
 * For information about the maximum number of MFA devices you can create, see [IAM and STS quotas](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html) in the *IAM User Guide*.
 *
 * The seed information contained in the QR code and the Base32 string should be treated like any other secret access information. In other words, protect the seed information as you would your Amazon Web Services access keys or your passwords. After you provision your virtual device, you should ensure that the information is destroyed following secure procedures.
 */
public suspend inline fun IamClient.createVirtualMfaDevice(crossinline block: CreateVirtualMfaDeviceRequest.Builder.() -> Unit): CreateVirtualMfaDeviceResponse = createVirtualMfaDevice(CreateVirtualMfaDeviceRequest.Builder().apply(block).build())

/**
 * Deactivates the specified MFA device and removes it from association with the user name for which it was originally enabled.
 *
 * For more information about creating and working with virtual MFA devices, see [Enabling a virtual multi-factor authentication (MFA) device](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html) in the *IAM User Guide*.
 */
public suspend inline fun IamClient.deactivateMfaDevice(crossinline block: DeactivateMfaDeviceRequest.Builder.() -> Unit): DeactivateMfaDeviceResponse = deactivateMfaDevice(DeactivateMfaDeviceRequest.Builder().apply(block).build())

/**
 * Deletes the access key pair associated with the specified IAM user.
 *
 * If you do not specify a user name, IAM determines the user name implicitly based on the Amazon Web Services access key ID signing the request. This operation works for access keys under the Amazon Web Services account. Consequently, you can use this operation to manage Amazon Web Services account root user credentials even if the Amazon Web Services account has no associated users.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.DeleteAccessKey.sample
 */
public suspend inline fun IamClient.deleteAccessKey(crossinline block: DeleteAccessKeyRequest.Builder.() -> Unit): DeleteAccessKeyResponse = deleteAccessKey(DeleteAccessKeyRequest.Builder().apply(block).build())

/**
 * Deletes the specified Amazon Web Services account alias. For information about using an Amazon Web Services account alias, see [Creating, deleting, and listing an Amazon Web Services account alias](https://docs.aws.amazon.com/signin/latest/userguide/CreateAccountAlias.html) in the *Amazon Web Services Sign-In User Guide*.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.DeleteAccountAlias.sample
 */
public suspend inline fun IamClient.deleteAccountAlias(crossinline block: DeleteAccountAliasRequest.Builder.() -> Unit): DeleteAccountAliasResponse = deleteAccountAlias(DeleteAccountAliasRequest.Builder().apply(block).build())

/**
 * Deletes the password policy for the Amazon Web Services account. There are no parameters.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.DeleteAccountPasswordPolicy.sample
 */
public suspend inline fun IamClient.deleteAccountPasswordPolicy(crossinline block: DeleteAccountPasswordPolicyRequest.Builder.() -> Unit): DeleteAccountPasswordPolicyResponse = deleteAccountPasswordPolicy(DeleteAccountPasswordPolicyRequest.Builder().apply(block).build())

/**
 * Deletes the specified IAM group. The group must not contain any users or have any attached policies.
 */
public suspend inline fun IamClient.deleteGroup(crossinline block: DeleteGroupRequest.Builder.() -> Unit): DeleteGroupResponse = deleteGroup(DeleteGroupRequest.Builder().apply(block).build())

/**
 * Deletes the specified inline policy that is embedded in the specified IAM group.
 *
 * A group can also have managed policies attached to it. To detach a managed policy from a group, use DetachGroupPolicy. For more information about policies, refer to [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.DeleteGroupPolicy.sample
 */
public suspend inline fun IamClient.deleteGroupPolicy(crossinline block: DeleteGroupPolicyRequest.Builder.() -> Unit): DeleteGroupPolicyResponse = deleteGroupPolicy(DeleteGroupPolicyRequest.Builder().apply(block).build())

/**
 * Deletes the specified instance profile. The instance profile must not have an associated role.
 *
 * Make sure that you do not have any Amazon EC2 instances running with the instance profile you are about to delete. Deleting a role or instance profile that is associated with a running instance will break any applications running on the instance.
 *
 * For more information about instance profiles, see [Using instance profiles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2_instance-profiles.html) in the *IAM User Guide*.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.DeleteInstanceProfile.sample
 */
public suspend inline fun IamClient.deleteInstanceProfile(crossinline block: DeleteInstanceProfileRequest.Builder.() -> Unit): DeleteInstanceProfileResponse = deleteInstanceProfile(DeleteInstanceProfileRequest.Builder().apply(block).build())

/**
 * Deletes the password for the specified IAM user, For more information, see [Managing passwords for IAM users](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_passwords_admin-change-user.html).
 *
 * You can use the CLI, the Amazon Web Services API, or the **Users** page in the IAM console to delete a password for any IAM user. You can use ChangePassword to update, but not delete, your own password in the **My Security Credentials** page in the Amazon Web Services Management Console.
 *
 * Deleting a user's password does not prevent a user from accessing Amazon Web Services through the command line interface or the API. To prevent all user access, you must also either make any access keys inactive or delete them. For more information about making keys inactive or deleting them, see UpdateAccessKey and DeleteAccessKey.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.DeleteLoginProfile.sample
 */
public suspend inline fun IamClient.deleteLoginProfile(crossinline block: DeleteLoginProfileRequest.Builder.() -> Unit): DeleteLoginProfileResponse = deleteLoginProfile(DeleteLoginProfileRequest.Builder().apply(block).build())

/**
 * Deletes an OpenID Connect identity provider (IdP) resource object in IAM.
 *
 * Deleting an IAM OIDC provider resource does not update any roles that reference the provider as a principal in their trust policies. Any attempt to assume a role that references a deleted provider fails.
 *
 * This operation is idempotent; it does not fail or return an error if you call the operation for a provider that does not exist.
 */
public suspend inline fun IamClient.deleteOpenIdConnectProvider(crossinline block: DeleteOpenIdConnectProviderRequest.Builder.() -> Unit): DeleteOpenIdConnectProviderResponse = deleteOpenIdConnectProvider(DeleteOpenIdConnectProviderRequest.Builder().apply(block).build())

/**
 * Deletes the specified managed policy.
 *
 * Before you can delete a managed policy, you must first detach the policy from all users, groups, and roles that it is attached to. In addition, you must delete all the policy's versions. The following steps describe the process for deleting a managed policy:
 * + Detach the policy from all users, groups, and roles that the policy is attached to, using DetachUserPolicy, DetachGroupPolicy, or DetachRolePolicy. To list all the users, groups, and roles that a policy is attached to, use ListEntitiesForPolicy.
 * + Delete all versions of the policy using DeletePolicyVersion. To list the policy's versions, use ListPolicyVersions. You cannot use DeletePolicyVersion to delete the version that is marked as the default version. You delete the policy's default version in the next step of the process.
 * + Delete the policy (this automatically deletes the policy's default version) using this operation.
 *
 * For information about managed policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
 */
public suspend inline fun IamClient.deletePolicy(crossinline block: DeletePolicyRequest.Builder.() -> Unit): DeletePolicyResponse = deletePolicy(DeletePolicyRequest.Builder().apply(block).build())

/**
 * Deletes the specified version from the specified managed policy.
 *
 * You cannot delete the default version from a policy using this operation. To delete the default version from a policy, use DeletePolicy. To find out which version of a policy is marked as the default version, use ListPolicyVersions.
 *
 * For information about versions for managed policies, see [Versioning for managed policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html) in the *IAM User Guide*.
 */
public suspend inline fun IamClient.deletePolicyVersion(crossinline block: DeletePolicyVersionRequest.Builder.() -> Unit): DeletePolicyVersionResponse = deletePolicyVersion(DeletePolicyVersionRequest.Builder().apply(block).build())

/**
 * Deletes the specified role. Unlike the Amazon Web Services Management Console, when you delete a role programmatically, you must delete the items attached to the role manually, or the deletion fails. For more information, see [Deleting an IAM role](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_manage_delete.html#roles-managingrole-deleting-cli). Before attempting to delete a role, remove the following attached items:
 * + Inline policies (DeleteRolePolicy)
 * + Attached managed policies (DetachRolePolicy)
 * + Instance profile (RemoveRoleFromInstanceProfile)
 * + Optional – Delete instance profile after detaching from role for resource clean up (DeleteInstanceProfile)
 *
 * Make sure that you do not have any Amazon EC2 instances running with the role you are about to delete. Deleting a role or instance profile that is associated with a running instance will break any applications running on the instance.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.DeleteRole.sample
 */
public suspend inline fun IamClient.deleteRole(crossinline block: DeleteRoleRequest.Builder.() -> Unit): DeleteRoleResponse = deleteRole(DeleteRoleRequest.Builder().apply(block).build())

/**
 * Deletes the permissions boundary for the specified IAM role.
 *
 * You cannot set the boundary for a service-linked role.
 *
 * Deleting the permissions boundary for a role might increase its permissions. For example, it might allow anyone who assumes the role to perform all the actions granted in its permissions policies.
 */
public suspend inline fun IamClient.deleteRolePermissionsBoundary(crossinline block: DeleteRolePermissionsBoundaryRequest.Builder.() -> Unit): DeleteRolePermissionsBoundaryResponse = deleteRolePermissionsBoundary(DeleteRolePermissionsBoundaryRequest.Builder().apply(block).build())

/**
 * Deletes the specified inline policy that is embedded in the specified IAM role.
 *
 * A role can also have managed policies attached to it. To detach a managed policy from a role, use DetachRolePolicy. For more information about policies, refer to [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.DeleteRolePolicy.sample
 */
public suspend inline fun IamClient.deleteRolePolicy(crossinline block: DeleteRolePolicyRequest.Builder.() -> Unit): DeleteRolePolicyResponse = deleteRolePolicy(DeleteRolePolicyRequest.Builder().apply(block).build())

/**
 * Deletes a SAML provider resource in IAM.
 *
 * Deleting the provider resource from IAM does not update any roles that reference the SAML provider resource's ARN as a principal in their trust policies. Any attempt to assume a role that references a non-existent provider resource ARN fails.
 *
 *  This operation requires [Signature Version 4](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
 */
public suspend inline fun IamClient.deleteSamlProvider(crossinline block: DeleteSamlProviderRequest.Builder.() -> Unit): DeleteSamlProviderResponse = deleteSamlProvider(DeleteSamlProviderRequest.Builder().apply(block).build())

/**
 * Deletes the specified server certificate.
 *
 * For more information about working with server certificates, see [Working with server certificates](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html) in the *IAM User Guide*. This topic also includes a list of Amazon Web Services services that can use the server certificates that you manage with IAM.
 *
 *  If you are using a server certificate with Elastic Load Balancing, deleting the certificate could have implications for your application. If Elastic Load Balancing doesn't detect the deletion of bound certificates, it may continue to use the certificates. This could cause Elastic Load Balancing to stop accepting traffic. We recommend that you remove the reference to the certificate from Elastic Load Balancing before using this command to delete the certificate. For more information, see [DeleteLoadBalancerListeners](https://docs.aws.amazon.com/ElasticLoadBalancing/latest/APIReference/API_DeleteLoadBalancerListeners.html) in the *Elastic Load Balancing API Reference*.
 */
public suspend inline fun IamClient.deleteServerCertificate(crossinline block: DeleteServerCertificateRequest.Builder.() -> Unit): DeleteServerCertificateResponse = deleteServerCertificate(DeleteServerCertificateRequest.Builder().apply(block).build())

/**
 * Submits a service-linked role deletion request and returns a `DeletionTaskId`, which you can use to check the status of the deletion. Before you call this operation, confirm that the role has no active sessions and that any resources used by the role in the linked service are deleted. If you call this operation more than once for the same service-linked role and an earlier deletion task is not complete, then the `DeletionTaskId` of the earlier request is returned.
 *
 * If you submit a deletion request for a service-linked role whose linked service is still accessing a resource, then the deletion task fails. If it fails, the GetServiceLinkedRoleDeletionStatus operation returns the reason for the failure, usually including the resources that must be deleted. To delete the service-linked role, you must first remove those resources from the linked service and then submit the deletion request again. Resources are specific to the service that is linked to the role. For more information about removing resources from a service, see the [Amazon Web Services documentation](http://docs.aws.amazon.com/) for your service.
 *
 * For more information about service-linked roles, see [Roles terms and concepts: Amazon Web Services service-linked role](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-linked-role) in the *IAM User Guide*.
 */
public suspend inline fun IamClient.deleteServiceLinkedRole(crossinline block: DeleteServiceLinkedRoleRequest.Builder.() -> Unit): DeleteServiceLinkedRoleResponse = deleteServiceLinkedRole(DeleteServiceLinkedRoleRequest.Builder().apply(block).build())

/**
 * Deletes the specified service-specific credential.
 */
public suspend inline fun IamClient.deleteServiceSpecificCredential(crossinline block: DeleteServiceSpecificCredentialRequest.Builder.() -> Unit): DeleteServiceSpecificCredentialResponse = deleteServiceSpecificCredential(DeleteServiceSpecificCredentialRequest.Builder().apply(block).build())

/**
 * Deletes a signing certificate associated with the specified IAM user.
 *
 * If you do not specify a user name, IAM determines the user name implicitly based on the Amazon Web Services access key ID signing the request. This operation works for access keys under the Amazon Web Services account. Consequently, you can use this operation to manage Amazon Web Services account root user credentials even if the Amazon Web Services account has no associated IAM users.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.DeleteSigningCertificate.sample
 */
public suspend inline fun IamClient.deleteSigningCertificate(crossinline block: DeleteSigningCertificateRequest.Builder.() -> Unit): DeleteSigningCertificateResponse = deleteSigningCertificate(DeleteSigningCertificateRequest.Builder().apply(block).build())

/**
 * Deletes the specified SSH public key.
 *
 * The SSH public key deleted by this operation is used only for authenticating the associated IAM user to an CodeCommit repository. For more information about using SSH keys to authenticate to an CodeCommit repository, see [Set up CodeCommit for SSH connections](https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html) in the *CodeCommit User Guide*.
 */
public suspend inline fun IamClient.deleteSshPublicKey(crossinline block: DeleteSshPublicKeyRequest.Builder.() -> Unit): DeleteSshPublicKeyResponse = deleteSshPublicKey(DeleteSshPublicKeyRequest.Builder().apply(block).build())

/**
 * Deletes the specified IAM user. Unlike the Amazon Web Services Management Console, when you delete a user programmatically, you must delete the items attached to the user manually, or the deletion fails. For more information, see [Deleting an IAM user](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users_manage.html#id_users_deleting_cli). Before attempting to delete a user, remove the following items:
 * + Password (DeleteLoginProfile)
 * + Access keys (DeleteAccessKey)
 * + Signing certificate (DeleteSigningCertificate)
 * + SSH public key (DeleteSSHPublicKey)
 * + Git credentials (DeleteServiceSpecificCredential)
 * + Multi-factor authentication (MFA) device (DeactivateMFADevice, DeleteVirtualMFADevice)
 * + Inline policies (DeleteUserPolicy)
 * + Attached managed policies (DetachUserPolicy)
 * + Group memberships (RemoveUserFromGroup)
 *
 * @sample aws.sdk.kotlin.services.iam.samples.DeleteUser.sample
 */
public suspend inline fun IamClient.deleteUser(crossinline block: DeleteUserRequest.Builder.() -> Unit): DeleteUserResponse = deleteUser(DeleteUserRequest.Builder().apply(block).build())

/**
 * Deletes the permissions boundary for the specified IAM user.
 *
 * Deleting the permissions boundary for a user might increase its permissions by allowing the user to perform all the actions granted in its permissions policies.
 */
public suspend inline fun IamClient.deleteUserPermissionsBoundary(crossinline block: DeleteUserPermissionsBoundaryRequest.Builder.() -> Unit): DeleteUserPermissionsBoundaryResponse = deleteUserPermissionsBoundary(DeleteUserPermissionsBoundaryRequest.Builder().apply(block).build())

/**
 * Deletes the specified inline policy that is embedded in the specified IAM user.
 *
 * A user can also have managed policies attached to it. To detach a managed policy from a user, use DetachUserPolicy. For more information about policies, refer to [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.DeleteUserPolicy.sample
 */
public suspend inline fun IamClient.deleteUserPolicy(crossinline block: DeleteUserPolicyRequest.Builder.() -> Unit): DeleteUserPolicyResponse = deleteUserPolicy(DeleteUserPolicyRequest.Builder().apply(block).build())

/**
 * Deletes a virtual MFA device.
 *
 *  You must deactivate a user's virtual MFA device before you can delete it. For information about deactivating MFA devices, see DeactivateMFADevice.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.DeleteVirtualMFADevice.sample
 */
public suspend inline fun IamClient.deleteVirtualMfaDevice(crossinline block: DeleteVirtualMfaDeviceRequest.Builder.() -> Unit): DeleteVirtualMfaDeviceResponse = deleteVirtualMfaDevice(DeleteVirtualMfaDeviceRequest.Builder().apply(block).build())

/**
 * Removes the specified managed policy from the specified IAM group.
 *
 * A group can also have inline policies embedded with it. To delete an inline policy, use DeleteGroupPolicy. For information about policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
 */
public suspend inline fun IamClient.detachGroupPolicy(crossinline block: DetachGroupPolicyRequest.Builder.() -> Unit): DetachGroupPolicyResponse = detachGroupPolicy(DetachGroupPolicyRequest.Builder().apply(block).build())

/**
 * Removes the specified managed policy from the specified role.
 *
 * A role can also have inline policies embedded with it. To delete an inline policy, use DeleteRolePolicy. For information about policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
 */
public suspend inline fun IamClient.detachRolePolicy(crossinline block: DetachRolePolicyRequest.Builder.() -> Unit): DetachRolePolicyResponse = detachRolePolicy(DetachRolePolicyRequest.Builder().apply(block).build())

/**
 * Removes the specified managed policy from the specified user.
 *
 * A user can also have inline policies embedded with it. To delete an inline policy, use DeleteUserPolicy. For information about policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
 */
public suspend inline fun IamClient.detachUserPolicy(crossinline block: DetachUserPolicyRequest.Builder.() -> Unit): DetachUserPolicyResponse = detachUserPolicy(DetachUserPolicyRequest.Builder().apply(block).build())

/**
 * Enables the specified MFA device and associates it with the specified IAM user. When enabled, the MFA device is required for every subsequent login by the IAM user associated with the device.
 */
public suspend inline fun IamClient.enableMfaDevice(crossinline block: EnableMfaDeviceRequest.Builder.() -> Unit): EnableMfaDeviceResponse = enableMfaDevice(EnableMfaDeviceRequest.Builder().apply(block).build())

/**
 * Generates a credential report for the Amazon Web Services account. For more information about the credential report, see [Getting credential reports](https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html) in the *IAM User Guide*.
 */
public suspend inline fun IamClient.generateCredentialReport(crossinline block: GenerateCredentialReportRequest.Builder.() -> Unit): GenerateCredentialReportResponse = generateCredentialReport(GenerateCredentialReportRequest.Builder().apply(block).build())

/**
 * Generates a report for service last accessed data for Organizations. You can generate a report for any entities (organization root, organizational unit, or account) or policies in your organization.
 *
 * To call this operation, you must be signed in using your Organizations management account credentials. You can use your long-term IAM user or root user credentials, or temporary credentials from assuming an IAM role. SCPs must be enabled for your organization root. You must have the required IAM and Organizations permissions. For more information, see [Refining permissions using service last accessed data](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html) in the *IAM User Guide*.
 *
 * You can generate a service last accessed data report for entities by specifying only the entity's path. This data includes a list of services that are allowed by any service control policies (SCPs) that apply to the entity.
 *
 * You can generate a service last accessed data report for a policy by specifying an entity's path and an optional Organizations policy ID. This data includes a list of services that are allowed by the specified SCP.
 *
 * For each service in both report types, the data includes the most recent account activity that the policy allows to account principals in the entity or the entity's children. For important information about the data, reporting period, permissions required, troubleshooting, and supported Regions see [Reducing permissions using service last accessed data](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html) in the *IAM User Guide*.
 *
 * The data includes all attempts to access Amazon Web Services, not just the successful ones. This includes all attempts that were made using the Amazon Web Services Management Console, the Amazon Web Services API through any of the SDKs, or any of the command line tools. An unexpected entry in the service last accessed data does not mean that an account has been compromised, because the request might have been denied. Refer to your CloudTrail logs as the authoritative source for information about all API calls and whether they were successful or denied access. For more information, see [Logging IAM events with CloudTrail](https://docs.aws.amazon.com/IAM/latest/UserGuide/cloudtrail-integration.html) in the *IAM User Guide*.
 *
 * This operation returns a `JobId`. Use this parameter in the ` <a>GetOrganizationsAccessReport</a> ` operation to check the status of the report generation. To check the status of this request, use the `JobId` parameter in the ` <a>GetOrganizationsAccessReport</a> ` operation and test the `JobStatus` response parameter. When the job is complete, you can retrieve the report.
 *
 * To generate a service last accessed data report for entities, specify an entity path without specifying the optional Organizations policy ID. The type of entity that you specify determines the data returned in the report.
 * + **Root** – When you specify the organizations root as the entity, the resulting report lists all of the services allowed by SCPs that are attached to your root. For each service, the report includes data for all accounts in your organization except the management account, because the management account is not limited by SCPs.
 * + **OU** – When you specify an organizational unit (OU) as the entity, the resulting report lists all of the services allowed by SCPs that are attached to the OU and its parents. For each service, the report includes data for all accounts in the OU or its children. This data excludes the management account, because the management account is not limited by SCPs.
 * + **management account** – When you specify the management account, the resulting report lists all Amazon Web Services services, because the management account is not limited by SCPs. For each service, the report includes data for only the management account.
 * + **Account** – When you specify another account as the entity, the resulting report lists all of the services allowed by SCPs that are attached to the account and its parents. For each service, the report includes data for only the specified account.
 *
 * To generate a service last accessed data report for policies, specify an entity path and the optional Organizations policy ID. The type of entity that you specify determines the data returned for each service.
 * + **Root** – When you specify the root entity and a policy ID, the resulting report lists all of the services that are allowed by the specified SCP. For each service, the report includes data for all accounts in your organization to which the SCP applies. This data excludes the management account, because the management account is not limited by SCPs. If the SCP is not attached to any entities in the organization, then the report will return a list of services with no data.
 * + **OU** – When you specify an OU entity and a policy ID, the resulting report lists all of the services that are allowed by the specified SCP. For each service, the report includes data for all accounts in the OU or its children to which the SCP applies. This means that other accounts outside the OU that are affected by the SCP might not be included in the data. This data excludes the management account, because the management account is not limited by SCPs. If the SCP is not attached to the OU or one of its children, the report will return a list of services with no data.
 * + **management account** – When you specify the management account, the resulting report lists all Amazon Web Services services, because the management account is not limited by SCPs. If you specify a policy ID in the CLI or API, the policy is ignored. For each service, the report includes data for only the management account.
 * + **Account** – When you specify another account entity and a policy ID, the resulting report lists all of the services that are allowed by the specified SCP. For each service, the report includes data for only the specified account. This means that other accounts in the organization that are affected by the SCP might not be included in the data. If the SCP is not attached to the account, the report will return a list of services with no data.
 *
 * Service last accessed data does not use other policy types when determining whether a principal could access a service. These other policy types include identity-based policies, resource-based policies, access control lists, IAM permissions boundaries, and STS assume role policies. It only applies SCP logic. For more about the evaluation of policy types, see [Evaluating policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics) in the *IAM User Guide*.
 *
 * For more information about service last accessed data, see [Reducing policy scope by viewing user activity](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html) in the *IAM User Guide*.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.GenerateOrganizationsAccessReport.sample
 */
public suspend inline fun IamClient.generateOrganizationsAccessReport(crossinline block: GenerateOrganizationsAccessReportRequest.Builder.() -> Unit): GenerateOrganizationsAccessReportResponse = generateOrganizationsAccessReport(GenerateOrganizationsAccessReportRequest.Builder().apply(block).build())

/**
 * Generates a report that includes details about when an IAM resource (user, group, role, or policy) was last used in an attempt to access Amazon Web Services services. Recent activity usually appears within four hours. IAM reports activity for at least the last 400 days, or less if your Region began supporting this feature within the last year. For more information, see [Regions where data is tracked](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period). For more information about services and actions for which action last accessed information is displayed, see [IAM action last accessed information services and actions](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor-action-last-accessed.html).
 *
 * The service last accessed data includes all attempts to access an Amazon Web Services API, not just the successful ones. This includes all attempts that were made using the Amazon Web Services Management Console, the Amazon Web Services API through any of the SDKs, or any of the command line tools. An unexpected entry in the service last accessed data does not mean that your account has been compromised, because the request might have been denied. Refer to your CloudTrail logs as the authoritative source for information about all API calls and whether they were successful or denied access. For more information, see [Logging IAM events with CloudTrail](https://docs.aws.amazon.com/IAM/latest/UserGuide/cloudtrail-integration.html) in the *IAM User Guide*.
 *
 * The `GenerateServiceLastAccessedDetails` operation returns a `JobId`. Use this parameter in the following operations to retrieve the following details from your report:
 * + GetServiceLastAccessedDetails – Use this operation for users, groups, roles, or policies to list every Amazon Web Services service that the resource could access using permissions policies. For each service, the response includes information about the most recent access attempt.The `JobId` returned by `GenerateServiceLastAccessedDetail` must be used by the same role within a session, or by the same user when used to call `GetServiceLastAccessedDetail`.
 * + GetServiceLastAccessedDetailsWithEntities – Use this operation for groups and policies to list information about the associated entities (users or roles) that attempted to access a specific Amazon Web Services service.
 *
 * To check the status of the `GenerateServiceLastAccessedDetails` request, use the `JobId` parameter in the same operations and test the `JobStatus` response parameter.
 *
 * For additional information about the permissions policies that allow an identity (user, group, or role) to access specific services, use the ListPoliciesGrantingServiceAccess operation.
 *
 * Service last accessed data does not use other policy types when determining whether a resource could access a service. These other policy types include resource-based policies, access control lists, Organizations policies, IAM permissions boundaries, and STS assume role policies. It only applies permissions policy logic. For more about the evaluation of policy types, see [Evaluating policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics) in the *IAM User Guide*.
 *
 * For more information about service and action last accessed data, see [Reducing permissions using service last accessed data](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html) in the *IAM User Guide*.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.GenerateServiceLastAccessedDetails.sample
 */
public suspend inline fun IamClient.generateServiceLastAccessedDetails(crossinline block: GenerateServiceLastAccessedDetailsRequest.Builder.() -> Unit): GenerateServiceLastAccessedDetailsResponse = generateServiceLastAccessedDetails(GenerateServiceLastAccessedDetailsRequest.Builder().apply(block).build())

/**
 * Retrieves information about when the specified access key was last used. The information includes the date and time of last use, along with the Amazon Web Services service and Region that were specified in the last request made with that key.
 */
public suspend inline fun IamClient.getAccessKeyLastUsed(crossinline block: GetAccessKeyLastUsedRequest.Builder.() -> Unit): GetAccessKeyLastUsedResponse = getAccessKeyLastUsed(GetAccessKeyLastUsedRequest.Builder().apply(block).build())

/**
 * Retrieves information about all IAM users, groups, roles, and policies in your Amazon Web Services account, including their relationships to one another. Use this operation to obtain a snapshot of the configuration of IAM permissions (users, groups, roles, and policies) in your account.
 *
 * Policies returned by this operation are URL-encoded compliant with [RFC 3986](https://tools.ietf.org/html/rfc3986). You can use a URL decoding method to convert the policy back to plain JSON text. For example, if you use Java, you can use the `decode` method of the `java.net.URLDecoder` utility class in the Java SDK. Other languages and SDKs provide similar functionality.
 *
 * You can optionally filter the results using the `Filter` parameter. You can paginate the results using the `MaxItems` and `Marker` parameters.
 */
public suspend inline fun IamClient.getAccountAuthorizationDetails(crossinline block: GetAccountAuthorizationDetailsRequest.Builder.() -> Unit): GetAccountAuthorizationDetailsResponse = getAccountAuthorizationDetails(GetAccountAuthorizationDetailsRequest.Builder().apply(block).build())

/**
 * Retrieves the password policy for the Amazon Web Services account. This tells you the complexity requirements and mandatory rotation periods for the IAM user passwords in your account. For more information about using a password policy, see [Managing an IAM password policy](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingPasswordPolicies.html).
 *
 * @sample aws.sdk.kotlin.services.iam.samples.GetAccountPasswordPolicy.sample
 */
public suspend inline fun IamClient.getAccountPasswordPolicy(crossinline block: GetAccountPasswordPolicyRequest.Builder.() -> Unit): GetAccountPasswordPolicyResponse = getAccountPasswordPolicy(GetAccountPasswordPolicyRequest.Builder().apply(block).build())

/**
 * Retrieves information about IAM entity usage and IAM quotas in the Amazon Web Services account.
 *
 *  For information about IAM quotas, see [IAM and STS quotas](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html) in the *IAM User Guide*.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.GetAccountSummary.sample
 */
public suspend inline fun IamClient.getAccountSummary(crossinline block: GetAccountSummaryRequest.Builder.() -> Unit): GetAccountSummaryResponse = getAccountSummary(GetAccountSummaryRequest.Builder().apply(block).build())

/**
 * Gets a list of all of the context keys referenced in the input policies. The policies are supplied as a list of one or more strings. To get the context keys from policies associated with an IAM user, group, or role, use GetContextKeysForPrincipalPolicy.
 *
 * Context keys are variables maintained by Amazon Web Services and its services that provide details about the context of an API query request. Context keys can be evaluated by testing against a value specified in an IAM policy. Use `GetContextKeysForCustomPolicy` to understand what key names and values you must supply when you call SimulateCustomPolicy. Note that all parameters are shown in unencoded form here for clarity but must be URL encoded to be included as a part of a real HTML request.
 */
public suspend inline fun IamClient.getContextKeysForCustomPolicy(crossinline block: GetContextKeysForCustomPolicyRequest.Builder.() -> Unit): GetContextKeysForCustomPolicyResponse = getContextKeysForCustomPolicy(GetContextKeysForCustomPolicyRequest.Builder().apply(block).build())

/**
 * Gets a list of all of the context keys referenced in all the IAM policies that are attached to the specified IAM entity. The entity can be an IAM user, group, or role. If you specify a user, then the request also includes all of the policies attached to groups that the user is a member of.
 *
 * You can optionally include a list of one or more additional policies, specified as strings. If you want to include *only* a list of policies by string, use GetContextKeysForCustomPolicy instead.
 *
 * **Note:** This operation discloses information about the permissions granted to other users. If you do not want users to see other user's permissions, then consider allowing them to use GetContextKeysForCustomPolicy instead.
 *
 * Context keys are variables maintained by Amazon Web Services and its services that provide details about the context of an API query request. Context keys can be evaluated by testing against a value in an IAM policy. Use GetContextKeysForPrincipalPolicy to understand what key names and values you must supply when you call SimulatePrincipalPolicy.
 */
public suspend inline fun IamClient.getContextKeysForPrincipalPolicy(crossinline block: GetContextKeysForPrincipalPolicyRequest.Builder.() -> Unit): GetContextKeysForPrincipalPolicyResponse = getContextKeysForPrincipalPolicy(GetContextKeysForPrincipalPolicyRequest.Builder().apply(block).build())

/**
 * Retrieves a credential report for the Amazon Web Services account. For more information about the credential report, see [Getting credential reports](https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html) in the *IAM User Guide*.
 */
public suspend inline fun IamClient.getCredentialReport(crossinline block: GetCredentialReportRequest.Builder.() -> Unit): GetCredentialReportResponse = getCredentialReport(GetCredentialReportRequest.Builder().apply(block).build())

/**
 * Returns a list of IAM users that are in the specified IAM group. You can paginate the results using the `MaxItems` and `Marker` parameters.
 */
public suspend inline fun IamClient.getGroup(crossinline block: GetGroupRequest.Builder.() -> Unit): GetGroupResponse = getGroup(GetGroupRequest.Builder().apply(block).build())

/**
 * Retrieves the specified inline policy document that is embedded in the specified IAM group.
 *
 * Policies returned by this operation are URL-encoded compliant with [RFC 3986](https://tools.ietf.org/html/rfc3986). You can use a URL decoding method to convert the policy back to plain JSON text. For example, if you use Java, you can use the `decode` method of the `java.net.URLDecoder` utility class in the Java SDK. Other languages and SDKs provide similar functionality.
 *
 * An IAM group can also have managed policies attached to it. To retrieve a managed policy document that is attached to a group, use GetPolicy to determine the policy's default version, then use GetPolicyVersion to retrieve the policy document.
 *
 * For more information about policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
 */
public suspend inline fun IamClient.getGroupPolicy(crossinline block: GetGroupPolicyRequest.Builder.() -> Unit): GetGroupPolicyResponse = getGroupPolicy(GetGroupPolicyRequest.Builder().apply(block).build())

/**
 * Retrieves information about the specified instance profile, including the instance profile's path, GUID, ARN, and role. For more information about instance profiles, see [Using instance profiles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2_instance-profiles.html) in the *IAM User Guide*.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.GetInstanceProfile.sample
 */
public suspend inline fun IamClient.getInstanceProfile(crossinline block: GetInstanceProfileRequest.Builder.() -> Unit): GetInstanceProfileResponse = getInstanceProfile(GetInstanceProfileRequest.Builder().apply(block).build())

/**
 * Retrieves the user name for the specified IAM user. A login profile is created when you create a password for the user to access the Amazon Web Services Management Console. If the user does not exist or does not have a password, the operation returns a 404 (`NoSuchEntity`) error.
 *
 * If you create an IAM user with access to the console, the `CreateDate` reflects the date you created the initial password for the user.
 *
 * If you create an IAM user with programmatic access, and then later add a password for the user to access the Amazon Web Services Management Console, the `CreateDate` reflects the initial password creation date. A user with programmatic access does not have a login profile unless you create a password for the user to access the Amazon Web Services Management Console.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.GetLoginProfile.sample
 */
public suspend inline fun IamClient.getLoginProfile(crossinline block: GetLoginProfileRequest.Builder.() -> Unit): GetLoginProfileResponse = getLoginProfile(GetLoginProfileRequest.Builder().apply(block).build())

/**
 * Retrieves information about an MFA device for a specified user.
 */
public suspend inline fun IamClient.getMfaDevice(crossinline block: GetMfaDeviceRequest.Builder.() -> Unit): GetMfaDeviceResponse = getMfaDevice(GetMfaDeviceRequest.Builder().apply(block).build())

/**
 * Returns information about the specified OpenID Connect (OIDC) provider resource object in IAM.
 */
public suspend inline fun IamClient.getOpenIdConnectProvider(crossinline block: GetOpenIdConnectProviderRequest.Builder.() -> Unit): GetOpenIdConnectProviderResponse = getOpenIdConnectProvider(GetOpenIdConnectProviderRequest.Builder().apply(block).build())

/**
 * Retrieves the service last accessed data report for Organizations that was previously generated using the ` <a>GenerateOrganizationsAccessReport</a> ` operation. This operation retrieves the status of your report job and the report contents.
 *
 * Depending on the parameters that you passed when you generated the report, the data returned could include different information. For details, see GenerateOrganizationsAccessReport.
 *
 * To call this operation, you must be signed in to the management account in your organization. SCPs must be enabled for your organization root. You must have permissions to perform this operation. For more information, see [Refining permissions using service last accessed data](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html) in the *IAM User Guide*.
 *
 * For each service that principals in an account (root user, IAM users, or IAM roles) could access using SCPs, the operation returns details about the most recent access attempt. If there was no attempt, the service is listed without details about the most recent attempt to access the service. If the operation fails, it returns the reason that it failed.
 *
 * By default, the list is sorted by service namespace.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.GetOrganizationsAccessReport.sample
 */
public suspend inline fun IamClient.getOrganizationsAccessReport(crossinline block: GetOrganizationsAccessReportRequest.Builder.() -> Unit): GetOrganizationsAccessReportResponse = getOrganizationsAccessReport(GetOrganizationsAccessReportRequest.Builder().apply(block).build())

/**
 * Retrieves information about the specified managed policy, including the policy's default version and the total number of IAM users, groups, and roles to which the policy is attached. To retrieve the list of the specific users, groups, and roles that the policy is attached to, use ListEntitiesForPolicy. This operation returns metadata about the policy. To retrieve the actual policy document for a specific version of the policy, use GetPolicyVersion.
 *
 * This operation retrieves information about managed policies. To retrieve information about an inline policy that is embedded with an IAM user, group, or role, use GetUserPolicy, GetGroupPolicy, or GetRolePolicy.
 *
 * For more information about policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
 */
public suspend inline fun IamClient.getPolicy(crossinline block: GetPolicyRequest.Builder.() -> Unit): GetPolicyResponse = getPolicy(GetPolicyRequest.Builder().apply(block).build())

/**
 * Retrieves information about the specified version of the specified managed policy, including the policy document.
 *
 * Policies returned by this operation are URL-encoded compliant with [RFC 3986](https://tools.ietf.org/html/rfc3986). You can use a URL decoding method to convert the policy back to plain JSON text. For example, if you use Java, you can use the `decode` method of the `java.net.URLDecoder` utility class in the Java SDK. Other languages and SDKs provide similar functionality.
 *
 * To list the available versions for a policy, use ListPolicyVersions.
 *
 * This operation retrieves information about managed policies. To retrieve information about an inline policy that is embedded in a user, group, or role, use GetUserPolicy, GetGroupPolicy, or GetRolePolicy.
 *
 * For more information about the types of policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
 *
 * For more information about managed policy versions, see [Versioning for managed policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html) in the *IAM User Guide*.
 */
public suspend inline fun IamClient.getPolicyVersion(crossinline block: GetPolicyVersionRequest.Builder.() -> Unit): GetPolicyVersionResponse = getPolicyVersion(GetPolicyVersionRequest.Builder().apply(block).build())

/**
 * Retrieves information about the specified role, including the role's path, GUID, ARN, and the role's trust policy that grants permission to assume the role. For more information about roles, see [IAM roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html) in the *IAM User Guide*.
 *
 * Policies returned by this operation are URL-encoded compliant with [RFC 3986](https://tools.ietf.org/html/rfc3986). You can use a URL decoding method to convert the policy back to plain JSON text. For example, if you use Java, you can use the `decode` method of the `java.net.URLDecoder` utility class in the Java SDK. Other languages and SDKs provide similar functionality.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.GetRole.sample
 */
public suspend inline fun IamClient.getRole(crossinline block: GetRoleRequest.Builder.() -> Unit): GetRoleResponse = getRole(GetRoleRequest.Builder().apply(block).build())

/**
 * Retrieves the specified inline policy document that is embedded with the specified IAM role.
 *
 * Policies returned by this operation are URL-encoded compliant with [RFC 3986](https://tools.ietf.org/html/rfc3986). You can use a URL decoding method to convert the policy back to plain JSON text. For example, if you use Java, you can use the `decode` method of the `java.net.URLDecoder` utility class in the Java SDK. Other languages and SDKs provide similar functionality.
 *
 * An IAM role can also have managed policies attached to it. To retrieve a managed policy document that is attached to a role, use GetPolicy to determine the policy's default version, then use GetPolicyVersion to retrieve the policy document.
 *
 * For more information about policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
 *
 *  For more information about roles, see [IAM roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html) in the *IAM User Guide*.
 */
public suspend inline fun IamClient.getRolePolicy(crossinline block: GetRolePolicyRequest.Builder.() -> Unit): GetRolePolicyResponse = getRolePolicy(GetRolePolicyRequest.Builder().apply(block).build())

/**
 * Returns the SAML provider metadocument that was uploaded when the IAM SAML provider resource object was created or updated.
 *
 * This operation requires [Signature Version 4](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
 */
public suspend inline fun IamClient.getSamlProvider(crossinline block: GetSamlProviderRequest.Builder.() -> Unit): GetSamlProviderResponse = getSamlProvider(GetSamlProviderRequest.Builder().apply(block).build())

/**
 * Retrieves information about the specified server certificate stored in IAM.
 *
 * For more information about working with server certificates, see [Working with server certificates](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html) in the *IAM User Guide*. This topic includes a list of Amazon Web Services services that can use the server certificates that you manage with IAM.
 */
public suspend inline fun IamClient.getServerCertificate(crossinline block: GetServerCertificateRequest.Builder.() -> Unit): GetServerCertificateResponse = getServerCertificate(GetServerCertificateRequest.Builder().apply(block).build())

/**
 * Retrieves a service last accessed report that was created using the `GenerateServiceLastAccessedDetails` operation. You can use the `JobId` parameter in `GetServiceLastAccessedDetails` to retrieve the status of your report job. When the report is complete, you can retrieve the generated report. The report includes a list of Amazon Web Services services that the resource (user, group, role, or managed policy) can access.
 *
 * Service last accessed data does not use other policy types when determining whether a resource could access a service. These other policy types include resource-based policies, access control lists, Organizations policies, IAM permissions boundaries, and STS assume role policies. It only applies permissions policy logic. For more about the evaluation of policy types, see [Evaluating policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics) in the *IAM User Guide*.
 *
 * For each service that the resource could access using permissions policies, the operation returns details about the most recent access attempt. If there was no attempt, the service is listed without details about the most recent attempt to access the service. If the operation fails, the `GetServiceLastAccessedDetails` operation returns the reason that it failed.
 *
 * The `GetServiceLastAccessedDetails` operation returns a list of services. This list includes the number of entities that have attempted to access the service and the date and time of the last attempt. It also returns the ARN of the following entity, depending on the resource ARN that you used to generate the report:
 * + **User** – Returns the user ARN that you used to generate the report
 * + **Group** – Returns the ARN of the group member (user) that last attempted to access the service
 * + **Role** – Returns the role ARN that you used to generate the report
 * + **Policy** – Returns the ARN of the user or role that last used the policy to attempt to access the service
 *
 * By default, the list is sorted by service namespace.
 *
 * If you specified `ACTION_LEVEL` granularity when you generated the report, this operation returns service and action last accessed data. This includes the most recent access attempt for each tracked action within a service. Otherwise, this operation returns only service data.
 *
 * For more information about service and action last accessed data, see [Reducing permissions using service last accessed data](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html) in the *IAM User Guide*.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.GetServiceLastAccessedDetails.sample
 */
public suspend inline fun IamClient.getServiceLastAccessedDetails(crossinline block: GetServiceLastAccessedDetailsRequest.Builder.() -> Unit): GetServiceLastAccessedDetailsResponse = getServiceLastAccessedDetails(GetServiceLastAccessedDetailsRequest.Builder().apply(block).build())

/**
 * After you generate a group or policy report using the `GenerateServiceLastAccessedDetails` operation, you can use the `JobId` parameter in `GetServiceLastAccessedDetailsWithEntities`. This operation retrieves the status of your report job and a list of entities that could have used group or policy permissions to access the specified service.
 * + **Group** – For a group report, this operation returns a list of users in the group that could have used the group’s policies in an attempt to access the service.
 * + **Policy** – For a policy report, this operation returns a list of entities (users or roles) that could have used the policy in an attempt to access the service.
 *
 * You can also use this operation for user or role reports to retrieve details about those entities.
 *
 * If the operation fails, the `GetServiceLastAccessedDetailsWithEntities` operation returns the reason that it failed.
 *
 * By default, the list of associated entities is sorted by date, with the most recent access listed first.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.GetServiceLastAccessedDetailsWithEntities.sample
 */
public suspend inline fun IamClient.getServiceLastAccessedDetailsWithEntities(crossinline block: GetServiceLastAccessedDetailsWithEntitiesRequest.Builder.() -> Unit): GetServiceLastAccessedDetailsWithEntitiesResponse = getServiceLastAccessedDetailsWithEntities(GetServiceLastAccessedDetailsWithEntitiesRequest.Builder().apply(block).build())

/**
 * Retrieves the status of your service-linked role deletion. After you use DeleteServiceLinkedRole to submit a service-linked role for deletion, you can use the `DeletionTaskId` parameter in `GetServiceLinkedRoleDeletionStatus` to check the status of the deletion. If the deletion fails, this operation returns the reason that it failed, if that information is returned by the service.
 */
public suspend inline fun IamClient.getServiceLinkedRoleDeletionStatus(crossinline block: GetServiceLinkedRoleDeletionStatusRequest.Builder.() -> Unit): GetServiceLinkedRoleDeletionStatusResponse = getServiceLinkedRoleDeletionStatus(GetServiceLinkedRoleDeletionStatusRequest.Builder().apply(block).build())

/**
 * Retrieves the specified SSH public key, including metadata about the key.
 *
 * The SSH public key retrieved by this operation is used only for authenticating the associated IAM user to an CodeCommit repository. For more information about using SSH keys to authenticate to an CodeCommit repository, see [Set up CodeCommit for SSH connections](https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html) in the *CodeCommit User Guide*.
 */
public suspend inline fun IamClient.getSshPublicKey(crossinline block: GetSshPublicKeyRequest.Builder.() -> Unit): GetSshPublicKeyResponse = getSshPublicKey(GetSshPublicKeyRequest.Builder().apply(block).build())

/**
 * Retrieves information about the specified IAM user, including the user's creation date, path, unique ID, and ARN.
 *
 * If you do not specify a user name, IAM determines the user name implicitly based on the Amazon Web Services access key ID used to sign the request to this operation.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.GetUser.sample
 */
public suspend inline fun IamClient.getUser(crossinline block: GetUserRequest.Builder.() -> Unit): GetUserResponse = getUser(GetUserRequest.Builder().apply(block).build())

/**
 * Retrieves the specified inline policy document that is embedded in the specified IAM user.
 *
 * Policies returned by this operation are URL-encoded compliant with [RFC 3986](https://tools.ietf.org/html/rfc3986). You can use a URL decoding method to convert the policy back to plain JSON text. For example, if you use Java, you can use the `decode` method of the `java.net.URLDecoder` utility class in the Java SDK. Other languages and SDKs provide similar functionality.
 *
 * An IAM user can also have managed policies attached to it. To retrieve a managed policy document that is attached to a user, use GetPolicy to determine the policy's default version. Then use GetPolicyVersion to retrieve the policy document.
 *
 * For more information about policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
 */
public suspend inline fun IamClient.getUserPolicy(crossinline block: GetUserPolicyRequest.Builder.() -> Unit): GetUserPolicyResponse = getUserPolicy(GetUserPolicyRequest.Builder().apply(block).build())

/**
 * Returns information about the access key IDs associated with the specified IAM user. If there is none, the operation returns an empty list.
 *
 * Although each user is limited to a small number of keys, you can still paginate the results using the `MaxItems` and `Marker` parameters.
 *
 * If the `UserName` is not specified, the user name is determined implicitly based on the Amazon Web Services access key ID used to sign the request. If a temporary access key is used, then `UserName` is required. If a long-term key is assigned to the user, then `UserName` is not required.
 *
 * This operation works for access keys under the Amazon Web Services account. If the Amazon Web Services account has no associated users, the root user returns it's own access key IDs by running this command.
 *
 * To ensure the security of your Amazon Web Services account, the secret access key is accessible only during key and user creation.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.ListAccessKeys.sample
 */
public suspend inline fun IamClient.listAccessKeys(crossinline block: ListAccessKeysRequest.Builder.() -> Unit): ListAccessKeysResponse = listAccessKeys(ListAccessKeysRequest.Builder().apply(block).build())

/**
 * Lists the account alias associated with the Amazon Web Services account (Note: you can have only one). For information about using an Amazon Web Services account alias, see [Creating, deleting, and listing an Amazon Web Services account alias](https://docs.aws.amazon.com/signin/latest/userguide/CreateAccountAlias.html) in the *Amazon Web Services Sign-In User Guide*.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.ListAccountAliases.sample
 */
public suspend inline fun IamClient.listAccountAliases(crossinline block: ListAccountAliasesRequest.Builder.() -> Unit): ListAccountAliasesResponse = listAccountAliases(ListAccountAliasesRequest.Builder().apply(block).build())

/**
 * Lists all managed policies that are attached to the specified IAM group.
 *
 * An IAM group can also have inline policies embedded with it. To list the inline policies for a group, use ListGroupPolicies. For information about policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
 *
 * You can paginate the results using the `MaxItems` and `Marker` parameters. You can use the `PathPrefix` parameter to limit the list of policies to only those matching the specified path prefix. If there are no policies attached to the specified group (or none that match the specified path prefix), the operation returns an empty list.
 */
public suspend inline fun IamClient.listAttachedGroupPolicies(crossinline block: ListAttachedGroupPoliciesRequest.Builder.() -> Unit): ListAttachedGroupPoliciesResponse = listAttachedGroupPolicies(ListAttachedGroupPoliciesRequest.Builder().apply(block).build())

/**
 * Lists all managed policies that are attached to the specified IAM role.
 *
 * An IAM role can also have inline policies embedded with it. To list the inline policies for a role, use ListRolePolicies. For information about policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
 *
 * You can paginate the results using the `MaxItems` and `Marker` parameters. You can use the `PathPrefix` parameter to limit the list of policies to only those matching the specified path prefix. If there are no policies attached to the specified role (or none that match the specified path prefix), the operation returns an empty list.
 */
public suspend inline fun IamClient.listAttachedRolePolicies(crossinline block: ListAttachedRolePoliciesRequest.Builder.() -> Unit): ListAttachedRolePoliciesResponse = listAttachedRolePolicies(ListAttachedRolePoliciesRequest.Builder().apply(block).build())

/**
 * Lists all managed policies that are attached to the specified IAM user.
 *
 * An IAM user can also have inline policies embedded with it. To list the inline policies for a user, use ListUserPolicies. For information about policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
 *
 * You can paginate the results using the `MaxItems` and `Marker` parameters. You can use the `PathPrefix` parameter to limit the list of policies to only those matching the specified path prefix. If there are no policies attached to the specified group (or none that match the specified path prefix), the operation returns an empty list.
 */
public suspend inline fun IamClient.listAttachedUserPolicies(crossinline block: ListAttachedUserPoliciesRequest.Builder.() -> Unit): ListAttachedUserPoliciesResponse = listAttachedUserPolicies(ListAttachedUserPoliciesRequest.Builder().apply(block).build())

/**
 * Lists all IAM users, groups, and roles that the specified managed policy is attached to.
 *
 * You can use the optional `EntityFilter` parameter to limit the results to a particular type of entity (users, groups, or roles). For example, to list only the roles that are attached to the specified policy, set `EntityFilter` to `Role`.
 *
 * You can paginate the results using the `MaxItems` and `Marker` parameters.
 */
public suspend inline fun IamClient.listEntitiesForPolicy(crossinline block: ListEntitiesForPolicyRequest.Builder.() -> Unit): ListEntitiesForPolicyResponse = listEntitiesForPolicy(ListEntitiesForPolicyRequest.Builder().apply(block).build())

/**
 * Lists the names of the inline policies that are embedded in the specified IAM group.
 *
 * An IAM group can also have managed policies attached to it. To list the managed policies that are attached to a group, use ListAttachedGroupPolicies. For more information about policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
 *
 * You can paginate the results using the `MaxItems` and `Marker` parameters. If there are no inline policies embedded with the specified group, the operation returns an empty list.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.ListGroupPolicies.sample
 */
public suspend inline fun IamClient.listGroupPolicies(crossinline block: ListGroupPoliciesRequest.Builder.() -> Unit): ListGroupPoliciesResponse = listGroupPolicies(ListGroupPoliciesRequest.Builder().apply(block).build())

/**
 * Lists the IAM groups that have the specified path prefix.
 *
 *  You can paginate the results using the `MaxItems` and `Marker` parameters.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.ListGroups.sample
 */
public suspend inline fun IamClient.listGroups(crossinline block: ListGroupsRequest.Builder.() -> Unit): ListGroupsResponse = listGroups(ListGroupsRequest.Builder().apply(block).build())

/**
 * Lists the IAM groups that the specified IAM user belongs to.
 *
 * You can paginate the results using the `MaxItems` and `Marker` parameters.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.ListGroupsForUser.sample
 */
public suspend inline fun IamClient.listGroupsForUser(crossinline block: ListGroupsForUserRequest.Builder.() -> Unit): ListGroupsForUserResponse = listGroupsForUser(ListGroupsForUserRequest.Builder().apply(block).build())

/**
 * Lists the tags that are attached to the specified IAM instance profile. The returned list of tags is sorted by tag key. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
 */
public suspend inline fun IamClient.listInstanceProfileTags(crossinline block: ListInstanceProfileTagsRequest.Builder.() -> Unit): ListInstanceProfileTagsResponse = listInstanceProfileTags(ListInstanceProfileTagsRequest.Builder().apply(block).build())

/**
 * Lists the instance profiles that have the specified path prefix. If there are none, the operation returns an empty list. For more information about instance profiles, see [Using instance profiles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2_instance-profiles.html) in the *IAM User Guide*.
 *
 * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view all of the information for an instance profile, see GetInstanceProfile.
 *
 * You can paginate the results using the `MaxItems` and `Marker` parameters.
 */
public suspend inline fun IamClient.listInstanceProfiles(crossinline block: ListInstanceProfilesRequest.Builder.() -> Unit): ListInstanceProfilesResponse = listInstanceProfiles(ListInstanceProfilesRequest.Builder().apply(block).build())

/**
 * Lists the instance profiles that have the specified associated IAM role. If there are none, the operation returns an empty list. For more information about instance profiles, go to [Using instance profiles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2_instance-profiles.html) in the *IAM User Guide*.
 *
 * You can paginate the results using the `MaxItems` and `Marker` parameters.
 */
public suspend inline fun IamClient.listInstanceProfilesForRole(crossinline block: ListInstanceProfilesForRoleRequest.Builder.() -> Unit): ListInstanceProfilesForRoleResponse = listInstanceProfilesForRole(ListInstanceProfilesForRoleRequest.Builder().apply(block).build())

/**
 * Lists the tags that are attached to the specified IAM virtual multi-factor authentication (MFA) device. The returned list of tags is sorted by tag key. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
 */
public suspend inline fun IamClient.listMfaDeviceTags(crossinline block: ListMfaDeviceTagsRequest.Builder.() -> Unit): ListMfaDeviceTagsResponse = listMfaDeviceTags(ListMfaDeviceTagsRequest.Builder().apply(block).build())

/**
 * Lists the MFA devices for an IAM user. If the request includes a IAM user name, then this operation lists all the MFA devices associated with the specified user. If you do not specify a user name, IAM determines the user name implicitly based on the Amazon Web Services access key ID signing the request for this operation.
 *
 * You can paginate the results using the `MaxItems` and `Marker` parameters.
 */
public suspend inline fun IamClient.listMfaDevices(crossinline block: ListMfaDevicesRequest.Builder.() -> Unit): ListMfaDevicesResponse = listMfaDevices(ListMfaDevicesRequest.Builder().apply(block).build())

/**
 * Lists the tags that are attached to the specified OpenID Connect (OIDC)-compatible identity provider. The returned list of tags is sorted by tag key. For more information, see [About web identity federation](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc.html).
 *
 * For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
 */
public suspend inline fun IamClient.listOpenIdConnectProviderTags(crossinline block: ListOpenIdConnectProviderTagsRequest.Builder.() -> Unit): ListOpenIdConnectProviderTagsResponse = listOpenIdConnectProviderTags(ListOpenIdConnectProviderTagsRequest.Builder().apply(block).build())

/**
 * Lists information about the IAM OpenID Connect (OIDC) provider resource objects defined in the Amazon Web Services account.
 *
 * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view all of the information for an OIDC provider, see GetOpenIDConnectProvider.
 */
public suspend inline fun IamClient.listOpenIdConnectProviders(crossinline block: ListOpenIdConnectProvidersRequest.Builder.() -> Unit): ListOpenIdConnectProvidersResponse = listOpenIdConnectProviders(ListOpenIdConnectProvidersRequest.Builder().apply(block).build())

/**
 * Lists all the managed policies that are available in your Amazon Web Services account, including your own customer-defined managed policies and all Amazon Web Services managed policies.
 *
 * You can filter the list of policies that is returned using the optional `OnlyAttached`, `Scope`, and `PathPrefix` parameters. For example, to list only the customer managed policies in your Amazon Web Services account, set `Scope` to `Local`. To list only Amazon Web Services managed policies, set `Scope` to `AWS`.
 *
 * You can paginate the results using the `MaxItems` and `Marker` parameters.
 *
 * For more information about managed policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
 *
 * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view all of the information for a customer manged policy, see GetPolicy.
 */
public suspend inline fun IamClient.listPolicies(crossinline block: ListPoliciesRequest.Builder.() -> Unit): ListPoliciesResponse = listPolicies(ListPoliciesRequest.Builder().apply(block).build())

/**
 * Retrieves a list of policies that the IAM identity (user, group, or role) can use to access each specified service.
 *
 * This operation does not use other policy types when determining whether a resource could access a service. These other policy types include resource-based policies, access control lists, Organizations policies, IAM permissions boundaries, and STS assume role policies. It only applies permissions policy logic. For more about the evaluation of policy types, see [Evaluating policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics) in the *IAM User Guide*.
 *
 * The list of policies returned by the operation depends on the ARN of the identity that you provide.
 * + **User** – The list of policies includes the managed and inline policies that are attached to the user directly. The list also includes any additional managed and inline policies that are attached to the group to which the user belongs.
 * + **Group** – The list of policies includes only the managed and inline policies that are attached to the group directly. Policies that are attached to the group’s user are not included.
 * + **Role** – The list of policies includes only the managed and inline policies that are attached to the role.
 *
 * For each managed policy, this operation returns the ARN and policy name. For each inline policy, it returns the policy name and the entity to which it is attached. Inline policies do not have an ARN. For more information about these policy types, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html) in the *IAM User Guide*.
 *
 * Policies that are attached to users and roles as permissions boundaries are not returned. To view which managed policy is currently used to set the permissions boundary for a user or role, use the GetUser or GetRole operations.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.ListPoliciesGrantingServiceAccess.sample
 */
public suspend inline fun IamClient.listPoliciesGrantingServiceAccess(crossinline block: ListPoliciesGrantingServiceAccessRequest.Builder.() -> Unit): ListPoliciesGrantingServiceAccessResponse = listPoliciesGrantingServiceAccess(ListPoliciesGrantingServiceAccessRequest.Builder().apply(block).build())

/**
 * Lists the tags that are attached to the specified IAM customer managed policy. The returned list of tags is sorted by tag key. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
 */
public suspend inline fun IamClient.listPolicyTags(crossinline block: ListPolicyTagsRequest.Builder.() -> Unit): ListPolicyTagsResponse = listPolicyTags(ListPolicyTagsRequest.Builder().apply(block).build())

/**
 * Lists information about the versions of the specified managed policy, including the version that is currently set as the policy's default version.
 *
 * For more information about managed policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
 */
public suspend inline fun IamClient.listPolicyVersions(crossinline block: ListPolicyVersionsRequest.Builder.() -> Unit): ListPolicyVersionsResponse = listPolicyVersions(ListPolicyVersionsRequest.Builder().apply(block).build())

/**
 * Lists the names of the inline policies that are embedded in the specified IAM role.
 *
 * An IAM role can also have managed policies attached to it. To list the managed policies that are attached to a role, use ListAttachedRolePolicies. For more information about policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
 *
 * You can paginate the results using the `MaxItems` and `Marker` parameters. If there are no inline policies embedded with the specified role, the operation returns an empty list.
 */
public suspend inline fun IamClient.listRolePolicies(crossinline block: ListRolePoliciesRequest.Builder.() -> Unit): ListRolePoliciesResponse = listRolePolicies(ListRolePoliciesRequest.Builder().apply(block).build())

/**
 * Lists the tags that are attached to the specified role. The returned list of tags is sorted by tag key. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.ListRoleTags.sample
 */
public suspend inline fun IamClient.listRoleTags(crossinline block: ListRoleTagsRequest.Builder.() -> Unit): ListRoleTagsResponse = listRoleTags(ListRoleTagsRequest.Builder().apply(block).build())

/**
 * Lists the IAM roles that have the specified path prefix. If there are none, the operation returns an empty list. For more information about roles, see [IAM roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html) in the *IAM User Guide*.
 *
 * IAM resource-listing operations return a subset of the available attributes for the resource. This operation does not return the following attributes, even though they are an attribute of the returned object:
 * + PermissionsBoundary
 * + RoleLastUsed
 * + Tags
 * To view all of the information for a role, see GetRole.
 *
 * You can paginate the results using the `MaxItems` and `Marker` parameters.
 */
public suspend inline fun IamClient.listRoles(crossinline block: ListRolesRequest.Builder.() -> Unit): ListRolesResponse = listRoles(ListRolesRequest.Builder().apply(block).build())

/**
 * Lists the tags that are attached to the specified Security Assertion Markup Language (SAML) identity provider. The returned list of tags is sorted by tag key. For more information, see [About SAML 2.0-based federation](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html).
 *
 * For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
 */
public suspend inline fun IamClient.listSamlProviderTags(crossinline block: ListSamlProviderTagsRequest.Builder.() -> Unit): ListSamlProviderTagsResponse = listSamlProviderTags(ListSamlProviderTagsRequest.Builder().apply(block).build())

/**
 * Lists the SAML provider resource objects defined in IAM in the account. IAM resource-listing operations return a subset of the available attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view all of the information for a SAML provider, see GetSAMLProvider.
 *
 *  This operation requires [Signature Version 4](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
 */
public suspend inline fun IamClient.listSamlProviders(crossinline block: ListSamlProvidersRequest.Builder.() -> Unit): ListSamlProvidersResponse = listSamlProviders(ListSamlProvidersRequest.Builder().apply(block).build())

/**
 * Lists the tags that are attached to the specified IAM server certificate. The returned list of tags is sorted by tag key. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
 *
 * For certificates in a Region supported by Certificate Manager (ACM), we recommend that you don't use IAM server certificates. Instead, use ACM to provision, manage, and deploy your server certificates. For more information about IAM server certificates, [Working with server certificates](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html) in the *IAM User Guide*.
 */
public suspend inline fun IamClient.listServerCertificateTags(crossinline block: ListServerCertificateTagsRequest.Builder.() -> Unit): ListServerCertificateTagsResponse = listServerCertificateTags(ListServerCertificateTagsRequest.Builder().apply(block).build())

/**
 * Lists the server certificates stored in IAM that have the specified path prefix. If none exist, the operation returns an empty list.
 *
 *  You can paginate the results using the `MaxItems` and `Marker` parameters.
 *
 * For more information about working with server certificates, see [Working with server certificates](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html) in the *IAM User Guide*. This topic also includes a list of Amazon Web Services services that can use the server certificates that you manage with IAM.
 *
 * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view all of the information for a servercertificate, see GetServerCertificate.
 */
public suspend inline fun IamClient.listServerCertificates(crossinline block: ListServerCertificatesRequest.Builder.() -> Unit): ListServerCertificatesResponse = listServerCertificates(ListServerCertificatesRequest.Builder().apply(block).build())

/**
 * Returns information about the service-specific credentials associated with the specified IAM user. If none exists, the operation returns an empty list. The service-specific credentials returned by this operation are used only for authenticating the IAM user to a specific service. For more information about using service-specific credentials to authenticate to an Amazon Web Services service, see [Set up service-specific credentials](https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-gc.html) in the CodeCommit User Guide.
 */
public suspend inline fun IamClient.listServiceSpecificCredentials(crossinline block: ListServiceSpecificCredentialsRequest.Builder.() -> Unit): ListServiceSpecificCredentialsResponse = listServiceSpecificCredentials(ListServiceSpecificCredentialsRequest.Builder().apply(block).build())

/**
 * Returns information about the signing certificates associated with the specified IAM user. If none exists, the operation returns an empty list.
 *
 * Although each user is limited to a small number of signing certificates, you can still paginate the results using the `MaxItems` and `Marker` parameters.
 *
 * If the `UserName` field is not specified, the user name is determined implicitly based on the Amazon Web Services access key ID used to sign the request for this operation. This operation works for access keys under the Amazon Web Services account. Consequently, you can use this operation to manage Amazon Web Services account root user credentials even if the Amazon Web Services account has no associated users.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.ListSigningCertificates.sample
 */
public suspend inline fun IamClient.listSigningCertificates(crossinline block: ListSigningCertificatesRequest.Builder.() -> Unit): ListSigningCertificatesResponse = listSigningCertificates(ListSigningCertificatesRequest.Builder().apply(block).build())

/**
 * Returns information about the SSH public keys associated with the specified IAM user. If none exists, the operation returns an empty list.
 *
 * The SSH public keys returned by this operation are used only for authenticating the IAM user to an CodeCommit repository. For more information about using SSH keys to authenticate to an CodeCommit repository, see [Set up CodeCommit for SSH connections](https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html) in the *CodeCommit User Guide*.
 *
 * Although each user is limited to a small number of keys, you can still paginate the results using the `MaxItems` and `Marker` parameters.
 */
public suspend inline fun IamClient.listSshPublicKeys(crossinline block: ListSshPublicKeysRequest.Builder.() -> Unit): ListSshPublicKeysResponse = listSshPublicKeys(ListSshPublicKeysRequest.Builder().apply(block).build())

/**
 * Lists the names of the inline policies embedded in the specified IAM user.
 *
 * An IAM user can also have managed policies attached to it. To list the managed policies that are attached to a user, use ListAttachedUserPolicies. For more information about policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
 *
 * You can paginate the results using the `MaxItems` and `Marker` parameters. If there are no inline policies embedded with the specified user, the operation returns an empty list.
 */
public suspend inline fun IamClient.listUserPolicies(crossinline block: ListUserPoliciesRequest.Builder.() -> Unit): ListUserPoliciesResponse = listUserPolicies(ListUserPoliciesRequest.Builder().apply(block).build())

/**
 * Lists the tags that are attached to the specified IAM user. The returned list of tags is sorted by tag key. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.ListUserTags.sample
 */
public suspend inline fun IamClient.listUserTags(crossinline block: ListUserTagsRequest.Builder.() -> Unit): ListUserTagsResponse = listUserTags(ListUserTagsRequest.Builder().apply(block).build())

/**
 * Lists the IAM users that have the specified path prefix. If no path prefix is specified, the operation returns all users in the Amazon Web Services account. If there are none, the operation returns an empty list.
 *
 * IAM resource-listing operations return a subset of the available attributes for the resource. This operation does not return the following attributes, even though they are an attribute of the returned object:
 * + PermissionsBoundary
 * + Tags
 * To view all of the information for a user, see GetUser.
 *
 * You can paginate the results using the `MaxItems` and `Marker` parameters.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.ListUsers.sample
 */
public suspend inline fun IamClient.listUsers(crossinline block: ListUsersRequest.Builder.() -> Unit): ListUsersResponse = listUsers(ListUsersRequest.Builder().apply(block).build())

/**
 * Lists the virtual MFA devices defined in the Amazon Web Services account by assignment status. If you do not specify an assignment status, the operation returns a list of all virtual MFA devices. Assignment status can be `Assigned`, `Unassigned`, or `Any`.
 *
 * IAM resource-listing operations return a subset of the available attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view tag information for a virtual MFA device, see ListMFADeviceTags.
 *
 * You can paginate the results using the `MaxItems` and `Marker` parameters.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.ListVirtualMFADevices.sample
 */
public suspend inline fun IamClient.listVirtualMfaDevices(crossinline block: ListVirtualMfaDevicesRequest.Builder.() -> Unit): ListVirtualMfaDevicesResponse = listVirtualMfaDevices(ListVirtualMfaDevicesRequest.Builder().apply(block).build())

/**
 * Adds or updates an inline policy document that is embedded in the specified IAM group.
 *
 * A user can also have managed policies attached to it. To attach a managed policy to a group, use `AttachGroupPolicy`[](https://docs.aws.amazon.com/IAM/latest/APIReference/API_AttachGroupPolicy.html). To create a new managed policy, use `CreatePolicy`[](https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreatePolicy.html). For information about policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
 *
 * For information about the maximum number of inline policies that you can embed in a group, see [IAM and STS quotas](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html) in the *IAM User Guide*.
 *
 * Because policy documents can be large, you should use POST rather than GET when calling `PutGroupPolicy`. For general information about using the Query API with IAM, see [Making query requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html) in the *IAM User Guide*.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.PutGroupPolicy.sample
 */
public suspend inline fun IamClient.putGroupPolicy(crossinline block: PutGroupPolicyRequest.Builder.() -> Unit): PutGroupPolicyResponse = putGroupPolicy(PutGroupPolicyRequest.Builder().apply(block).build())

/**
 * Adds or updates the policy that is specified as the IAM role's permissions boundary. You can use an Amazon Web Services managed policy or a customer managed policy to set the boundary for a role. Use the boundary to control the maximum permissions that the role can have. Setting a permissions boundary is an advanced feature that can affect the permissions for the role.
 *
 * You cannot set the boundary for a service-linked role.
 *
 * Policies used as permissions boundaries do not provide permissions. You must also attach a permissions policy to the role. To learn how the effective permissions for a role are evaluated, see [IAM JSON policy evaluation logic](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html) in the IAM User Guide.
 */
public suspend inline fun IamClient.putRolePermissionsBoundary(crossinline block: PutRolePermissionsBoundaryRequest.Builder.() -> Unit): PutRolePermissionsBoundaryResponse = putRolePermissionsBoundary(PutRolePermissionsBoundaryRequest.Builder().apply(block).build())

/**
 * Adds or updates an inline policy document that is embedded in the specified IAM role.
 *
 * When you embed an inline policy in a role, the inline policy is used as part of the role's access (permissions) policy. The role's trust policy is created at the same time as the role, using `CreateRole`[](https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html). You can update a role's trust policy using `UpdateAssumeRolePolicy`[](https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateAssumeRolePolicy.html). For more information about roles, see [IAM roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html) in the *IAM User Guide*.
 *
 * A role can also have a managed policy attached to it. To attach a managed policy to a role, use `AttachRolePolicy`[](https://docs.aws.amazon.com/IAM/latest/APIReference/API_AttachRolePolicy.html). To create a new managed policy, use `CreatePolicy`[](https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreatePolicy.html). For information about policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
 *
 * For information about the maximum number of inline policies that you can embed with a role, see [IAM and STS quotas](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html) in the *IAM User Guide*.
 *
 * Because policy documents can be large, you should use POST rather than GET when calling `PutRolePolicy`. For general information about using the Query API with IAM, see [Making query requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html) in the *IAM User Guide*.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.PutRolePolicy.sample
 */
public suspend inline fun IamClient.putRolePolicy(crossinline block: PutRolePolicyRequest.Builder.() -> Unit): PutRolePolicyResponse = putRolePolicy(PutRolePolicyRequest.Builder().apply(block).build())

/**
 * Adds or updates the policy that is specified as the IAM user's permissions boundary. You can use an Amazon Web Services managed policy or a customer managed policy to set the boundary for a user. Use the boundary to control the maximum permissions that the user can have. Setting a permissions boundary is an advanced feature that can affect the permissions for the user.
 *
 * Policies that are used as permissions boundaries do not provide permissions. You must also attach a permissions policy to the user. To learn how the effective permissions for a user are evaluated, see [IAM JSON policy evaluation logic](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html) in the IAM User Guide.
 */
public suspend inline fun IamClient.putUserPermissionsBoundary(crossinline block: PutUserPermissionsBoundaryRequest.Builder.() -> Unit): PutUserPermissionsBoundaryResponse = putUserPermissionsBoundary(PutUserPermissionsBoundaryRequest.Builder().apply(block).build())

/**
 * Adds or updates an inline policy document that is embedded in the specified IAM user.
 *
 * An IAM user can also have a managed policy attached to it. To attach a managed policy to a user, use `AttachUserPolicy`[](https://docs.aws.amazon.com/IAM/latest/APIReference/API_AttachUserPolicy.html). To create a new managed policy, use `CreatePolicy`[](https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreatePolicy.html). For information about policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
 *
 * For information about the maximum number of inline policies that you can embed in a user, see [IAM and STS quotas](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html) in the *IAM User Guide*.
 *
 * Because policy documents can be large, you should use POST rather than GET when calling `PutUserPolicy`. For general information about using the Query API with IAM, see [Making query requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html) in the *IAM User Guide*.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.PutUserPolicy.sample
 */
public suspend inline fun IamClient.putUserPolicy(crossinline block: PutUserPolicyRequest.Builder.() -> Unit): PutUserPolicyResponse = putUserPolicy(PutUserPolicyRequest.Builder().apply(block).build())

/**
 * Removes the specified client ID (also known as audience) from the list of client IDs registered for the specified IAM OpenID Connect (OIDC) provider resource object.
 *
 * This operation is idempotent; it does not fail or return an error if you try to remove a client ID that does not exist.
 */
public suspend inline fun IamClient.removeClientIdFromOpenIdConnectProvider(crossinline block: RemoveClientIdFromOpenIdConnectProviderRequest.Builder.() -> Unit): RemoveClientIdFromOpenIdConnectProviderResponse = removeClientIdFromOpenIdConnectProvider(RemoveClientIdFromOpenIdConnectProviderRequest.Builder().apply(block).build())

/**
 * Removes the specified IAM role from the specified EC2 instance profile.
 *
 * Make sure that you do not have any Amazon EC2 instances running with the role you are about to remove from the instance profile. Removing a role from an instance profile that is associated with a running instance might break any applications running on the instance.
 *
 *  For more information about roles, see [IAM roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html) in the *IAM User Guide*. For more information about instance profiles, see [Using instance profiles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2_instance-profiles.html) in the *IAM User Guide*.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.RemoveRoleFromInstanceProfile.sample
 */
public suspend inline fun IamClient.removeRoleFromInstanceProfile(crossinline block: RemoveRoleFromInstanceProfileRequest.Builder.() -> Unit): RemoveRoleFromInstanceProfileResponse = removeRoleFromInstanceProfile(RemoveRoleFromInstanceProfileRequest.Builder().apply(block).build())

/**
 * Removes the specified user from the specified group.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.RemoveUserFromGroup.sample
 */
public suspend inline fun IamClient.removeUserFromGroup(crossinline block: RemoveUserFromGroupRequest.Builder.() -> Unit): RemoveUserFromGroupResponse = removeUserFromGroup(RemoveUserFromGroupRequest.Builder().apply(block).build())

/**
 * Resets the password for a service-specific credential. The new password is Amazon Web Services generated and cryptographically strong. It cannot be configured by the user. Resetting the password immediately invalidates the previous password associated with this user.
 */
public suspend inline fun IamClient.resetServiceSpecificCredential(crossinline block: ResetServiceSpecificCredentialRequest.Builder.() -> Unit): ResetServiceSpecificCredentialResponse = resetServiceSpecificCredential(ResetServiceSpecificCredentialRequest.Builder().apply(block).build())

/**
 * Synchronizes the specified MFA device with its IAM resource object on the Amazon Web Services servers.
 *
 * For more information about creating and working with virtual MFA devices, see [Using a virtual MFA device](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html) in the *IAM User Guide*.
 */
public suspend inline fun IamClient.resyncMfaDevice(crossinline block: ResyncMfaDeviceRequest.Builder.() -> Unit): ResyncMfaDeviceResponse = resyncMfaDevice(ResyncMfaDeviceRequest.Builder().apply(block).build())

/**
 * Sets the specified version of the specified policy as the policy's default (operative) version.
 *
 * This operation affects all users, groups, and roles that the policy is attached to. To list the users, groups, and roles that the policy is attached to, use ListEntitiesForPolicy.
 *
 * For information about managed policies, see [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
 */
public suspend inline fun IamClient.setDefaultPolicyVersion(crossinline block: SetDefaultPolicyVersionRequest.Builder.() -> Unit): SetDefaultPolicyVersionResponse = setDefaultPolicyVersion(SetDefaultPolicyVersionRequest.Builder().apply(block).build())

/**
 * Sets the specified version of the global endpoint token as the token version used for the Amazon Web Services account.
 *
 * By default, Security Token Service (STS) is available as a global service, and all STS requests go to a single endpoint at `https://sts.amazonaws.com`. Amazon Web Services recommends using Regional STS endpoints to reduce latency, build in redundancy, and increase session token availability. For information about Regional endpoints for STS, see [Security Token Service endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/sts.html) in the *Amazon Web Services General Reference*.
 *
 * If you make an STS call to the global endpoint, the resulting session tokens might be valid in some Regions but not others. It depends on the version that is set in this operation. Version 1 tokens are valid only in Amazon Web Services Regions that are available by default. These tokens do not work in manually enabled Regions, such as Asia Pacific (Hong Kong). Version 2 tokens are valid in all Regions. However, version 2 tokens are longer and might affect systems where you temporarily store tokens. For information, see [Activating and deactivating STS in an Amazon Web Services Region](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html) in the *IAM User Guide*.
 *
 * To view the current session token version, see the `GlobalEndpointTokenVersion` entry in the response of the GetAccountSummary operation.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.SetSecurityTokenServicePreferences.sample
 */
public suspend inline fun IamClient.setSecurityTokenServicePreferences(crossinline block: SetSecurityTokenServicePreferencesRequest.Builder.() -> Unit): SetSecurityTokenServicePreferencesResponse = setSecurityTokenServicePreferences(SetSecurityTokenServicePreferencesRequest.Builder().apply(block).build())

/**
 * Simulate how a set of IAM policies and optionally a resource-based policy works with a list of API operations and Amazon Web Services resources to determine the policies' effective permissions. The policies are provided as strings.
 *
 * The simulation does not perform the API operations; it only checks the authorization to determine if the simulated policies allow or deny the operations. You can simulate resources that don't exist in your account.
 *
 * If you want to simulate existing policies that are attached to an IAM user, group, or role, use SimulatePrincipalPolicy instead.
 *
 * Context keys are variables that are maintained by Amazon Web Services and its services and which provide details about the context of an API query request. You can use the `Condition` element of an IAM policy to evaluate context keys. To get the list of context keys that the policies require for correct simulation, use GetContextKeysForCustomPolicy.
 *
 * If the output is long, you can use `MaxItems` and `Marker` parameters to paginate the results.
 *
 * The IAM policy simulator evaluates statements in the identity-based policy and the inputs that you provide during simulation. The policy simulator results can differ from your live Amazon Web Services environment. We recommend that you check your policies against your live Amazon Web Services environment after testing using the policy simulator to confirm that you have the desired results. For more information about using the policy simulator, see [Testing IAM policies with the IAM policy simulator ](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_testing-policies.html)in the *IAM User Guide*.
 */
public suspend inline fun IamClient.simulateCustomPolicy(crossinline block: SimulateCustomPolicyRequest.Builder.() -> Unit): SimulateCustomPolicyResponse = simulateCustomPolicy(SimulateCustomPolicyRequest.Builder().apply(block).build())

/**
 * Simulate how a set of IAM policies attached to an IAM entity works with a list of API operations and Amazon Web Services resources to determine the policies' effective permissions. The entity can be an IAM user, group, or role. If you specify a user, then the simulation also includes all of the policies that are attached to groups that the user belongs to. You can simulate resources that don't exist in your account.
 *
 * You can optionally include a list of one or more additional policies specified as strings to include in the simulation. If you want to simulate only policies specified as strings, use SimulateCustomPolicy instead.
 *
 * You can also optionally include one resource-based policy to be evaluated with each of the resources included in the simulation for IAM users only.
 *
 * The simulation does not perform the API operations; it only checks the authorization to determine if the simulated policies allow or deny the operations.
 *
 * **Note:** This operation discloses information about the permissions granted to other users. If you do not want users to see other user's permissions, then consider allowing them to use SimulateCustomPolicy instead.
 *
 * Context keys are variables maintained by Amazon Web Services and its services that provide details about the context of an API query request. You can use the `Condition` element of an IAM policy to evaluate context keys. To get the list of context keys that the policies require for correct simulation, use GetContextKeysForPrincipalPolicy.
 *
 * If the output is long, you can use the `MaxItems` and `Marker` parameters to paginate the results.
 *
 * The IAM policy simulator evaluates statements in the identity-based policy and the inputs that you provide during simulation. The policy simulator results can differ from your live Amazon Web Services environment. We recommend that you check your policies against your live Amazon Web Services environment after testing using the policy simulator to confirm that you have the desired results. For more information about using the policy simulator, see [Testing IAM policies with the IAM policy simulator ](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_testing-policies.html)in the *IAM User Guide*.
 */
public suspend inline fun IamClient.simulatePrincipalPolicy(crossinline block: SimulatePrincipalPolicyRequest.Builder.() -> Unit): SimulatePrincipalPolicyResponse = simulatePrincipalPolicy(SimulatePrincipalPolicyRequest.Builder().apply(block).build())

/**
 * Adds one or more tags to an IAM instance profile. If a tag with the same key name already exists, then that tag is overwritten with the new value.
 *
 * Each tag consists of a key name and an associated value. By assigning tags to your resources, you can do the following:
 * + **Administrative grouping and discovery** - Attach tags to resources to aid in organization and search. For example, you could search for all resources with the key name *Project* and the value *MyImportantProject*. Or search for all resources with the key name *Cost Center* and the value *41200*.
 * + **Access control** - Include tags in IAM user-based and resource-based policies. You can use tags to restrict access to only an IAM instance profile that has a specified tag attached. For examples of policies that show how to use tags to control access, see [Control access using IAM tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html) in the *IAM User Guide*.
 *
 * + If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
 * + Amazon Web Services always interprets the tag `Value` as a single string. If you need to store an array, you can store comma-separated values in the string. However, you must interpret the value in your code.
 */
public suspend inline fun IamClient.tagInstanceProfile(crossinline block: TagInstanceProfileRequest.Builder.() -> Unit): TagInstanceProfileResponse = tagInstanceProfile(TagInstanceProfileRequest.Builder().apply(block).build())

/**
 * Adds one or more tags to an IAM virtual multi-factor authentication (MFA) device. If a tag with the same key name already exists, then that tag is overwritten with the new value.
 *
 * A tag consists of a key name and an associated value. By assigning tags to your resources, you can do the following:
 * + **Administrative grouping and discovery** - Attach tags to resources to aid in organization and search. For example, you could search for all resources with the key name *Project* and the value *MyImportantProject*. Or search for all resources with the key name *Cost Center* and the value *41200*.
 * + **Access control** - Include tags in IAM user-based and resource-based policies. You can use tags to restrict access to only an IAM virtual MFA device that has a specified tag attached. For examples of policies that show how to use tags to control access, see [Control access using IAM tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html) in the *IAM User Guide*.
 *
 * + If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
 * + Amazon Web Services always interprets the tag `Value` as a single string. If you need to store an array, you can store comma-separated values in the string. However, you must interpret the value in your code.
 */
public suspend inline fun IamClient.tagMfaDevice(crossinline block: TagMfaDeviceRequest.Builder.() -> Unit): TagMfaDeviceResponse = tagMfaDevice(TagMfaDeviceRequest.Builder().apply(block).build())

/**
 * Adds one or more tags to an OpenID Connect (OIDC)-compatible identity provider. For more information about these providers, see [About web identity federation](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc.html). If a tag with the same key name already exists, then that tag is overwritten with the new value.
 *
 * A tag consists of a key name and an associated value. By assigning tags to your resources, you can do the following:
 * + **Administrative grouping and discovery** - Attach tags to resources to aid in organization and search. For example, you could search for all resources with the key name *Project* and the value *MyImportantProject*. Or search for all resources with the key name *Cost Center* and the value *41200*.
 * + **Access control** - Include tags in IAM identity-based and resource-based policies. You can use tags to restrict access to only an OIDC provider that has a specified tag attached. For examples of policies that show how to use tags to control access, see [Control access using IAM tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html) in the *IAM User Guide*.
 *
 * + If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
 * + Amazon Web Services always interprets the tag `Value` as a single string. If you need to store an array, you can store comma-separated values in the string. However, you must interpret the value in your code.
 */
public suspend inline fun IamClient.tagOpenIdConnectProvider(crossinline block: TagOpenIdConnectProviderRequest.Builder.() -> Unit): TagOpenIdConnectProviderResponse = tagOpenIdConnectProvider(TagOpenIdConnectProviderRequest.Builder().apply(block).build())

/**
 * Adds one or more tags to an IAM customer managed policy. If a tag with the same key name already exists, then that tag is overwritten with the new value.
 *
 * A tag consists of a key name and an associated value. By assigning tags to your resources, you can do the following:
 * + **Administrative grouping and discovery** - Attach tags to resources to aid in organization and search. For example, you could search for all resources with the key name *Project* and the value *MyImportantProject*. Or search for all resources with the key name *Cost Center* and the value *41200*.
 * + **Access control** - Include tags in IAM user-based and resource-based policies. You can use tags to restrict access to only an IAM customer managed policy that has a specified tag attached. For examples of policies that show how to use tags to control access, see [Control access using IAM tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html) in the *IAM User Guide*.
 *
 * + If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
 * + Amazon Web Services always interprets the tag `Value` as a single string. If you need to store an array, you can store comma-separated values in the string. However, you must interpret the value in your code.
 */
public suspend inline fun IamClient.tagPolicy(crossinline block: TagPolicyRequest.Builder.() -> Unit): TagPolicyResponse = tagPolicy(TagPolicyRequest.Builder().apply(block).build())

/**
 * Adds one or more tags to an IAM role. The role can be a regular role or a service-linked role. If a tag with the same key name already exists, then that tag is overwritten with the new value.
 *
 * A tag consists of a key name and an associated value. By assigning tags to your resources, you can do the following:
 * + **Administrative grouping and discovery** - Attach tags to resources to aid in organization and search. For example, you could search for all resources with the key name *Project* and the value *MyImportantProject*. Or search for all resources with the key name *Cost Center* and the value *41200*.
 * + **Access control** - Include tags in IAM user-based and resource-based policies. You can use tags to restrict access to only an IAM role that has a specified tag attached. You can also restrict access to only those resources that have a certain tag attached. For examples of policies that show how to use tags to control access, see [Control access using IAM tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html) in the *IAM User Guide*.
 * + **Cost allocation** - Use tags to help track which individuals and teams are using which Amazon Web Services resources.
 *
 * + If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
 * + Amazon Web Services always interprets the tag `Value` as a single string. If you need to store an array, you can store comma-separated values in the string. However, you must interpret the value in your code.
 * For more information about tagging, see [Tagging IAM identities](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.TagRole.sample
 */
public suspend inline fun IamClient.tagRole(crossinline block: TagRoleRequest.Builder.() -> Unit): TagRoleResponse = tagRole(TagRoleRequest.Builder().apply(block).build())

/**
 * Adds one or more tags to a Security Assertion Markup Language (SAML) identity provider. For more information about these providers, see [About SAML 2.0-based federation ](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html). If a tag with the same key name already exists, then that tag is overwritten with the new value.
 *
 * A tag consists of a key name and an associated value. By assigning tags to your resources, you can do the following:
 * + **Administrative grouping and discovery** - Attach tags to resources to aid in organization and search. For example, you could search for all resources with the key name *Project* and the value *MyImportantProject*. Or search for all resources with the key name *Cost Center* and the value *41200*.
 * + **Access control** - Include tags in IAM user-based and resource-based policies. You can use tags to restrict access to only a SAML identity provider that has a specified tag attached. For examples of policies that show how to use tags to control access, see [Control access using IAM tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html) in the *IAM User Guide*.
 *
 * + If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
 * + Amazon Web Services always interprets the tag `Value` as a single string. If you need to store an array, you can store comma-separated values in the string. However, you must interpret the value in your code.
 */
public suspend inline fun IamClient.tagSamlProvider(crossinline block: TagSamlProviderRequest.Builder.() -> Unit): TagSamlProviderResponse = tagSamlProvider(TagSamlProviderRequest.Builder().apply(block).build())

/**
 * Adds one or more tags to an IAM server certificate. If a tag with the same key name already exists, then that tag is overwritten with the new value.
 *
 * For certificates in a Region supported by Certificate Manager (ACM), we recommend that you don't use IAM server certificates. Instead, use ACM to provision, manage, and deploy your server certificates. For more information about IAM server certificates, [Working with server certificates](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html) in the *IAM User Guide*.
 *
 * A tag consists of a key name and an associated value. By assigning tags to your resources, you can do the following:
 * + **Administrative grouping and discovery** - Attach tags to resources to aid in organization and search. For example, you could search for all resources with the key name *Project* and the value *MyImportantProject*. Or search for all resources with the key name *Cost Center* and the value *41200*.
 * + **Access control** - Include tags in IAM user-based and resource-based policies. You can use tags to restrict access to only a server certificate that has a specified tag attached. For examples of policies that show how to use tags to control access, see [Control access using IAM tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html) in the *IAM User Guide*.
 * + **Cost allocation** - Use tags to help track which individuals and teams are using which Amazon Web Services resources.
 *
 * + If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
 * + Amazon Web Services always interprets the tag `Value` as a single string. If you need to store an array, you can store comma-separated values in the string. However, you must interpret the value in your code.
 */
public suspend inline fun IamClient.tagServerCertificate(crossinline block: TagServerCertificateRequest.Builder.() -> Unit): TagServerCertificateResponse = tagServerCertificate(TagServerCertificateRequest.Builder().apply(block).build())

/**
 * Adds one or more tags to an IAM user. If a tag with the same key name already exists, then that tag is overwritten with the new value.
 *
 * A tag consists of a key name and an associated value. By assigning tags to your resources, you can do the following:
 * + **Administrative grouping and discovery** - Attach tags to resources to aid in organization and search. For example, you could search for all resources with the key name *Project* and the value *MyImportantProject*. Or search for all resources with the key name *Cost Center* and the value *41200*.
 * + **Access control** - Include tags in IAM identity-based and resource-based policies. You can use tags to restrict access to only an IAM requesting user that has a specified tag attached. You can also restrict access to only those resources that have a certain tag attached. For examples of policies that show how to use tags to control access, see [Control access using IAM tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html) in the *IAM User Guide*.
 * + **Cost allocation** - Use tags to help track which individuals and teams are using which Amazon Web Services resources.
 *
 * + If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
 * + Amazon Web Services always interprets the tag `Value` as a single string. If you need to store an array, you can store comma-separated values in the string. However, you must interpret the value in your code.
 * For more information about tagging, see [Tagging IAM identities](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.TagUser.sample
 */
public suspend inline fun IamClient.tagUser(crossinline block: TagUserRequest.Builder.() -> Unit): TagUserResponse = tagUser(TagUserRequest.Builder().apply(block).build())

/**
 * Removes the specified tags from the IAM instance profile. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
 */
public suspend inline fun IamClient.untagInstanceProfile(crossinline block: UntagInstanceProfileRequest.Builder.() -> Unit): UntagInstanceProfileResponse = untagInstanceProfile(UntagInstanceProfileRequest.Builder().apply(block).build())

/**
 * Removes the specified tags from the IAM virtual multi-factor authentication (MFA) device. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
 */
public suspend inline fun IamClient.untagMfaDevice(crossinline block: UntagMfaDeviceRequest.Builder.() -> Unit): UntagMfaDeviceResponse = untagMfaDevice(UntagMfaDeviceRequest.Builder().apply(block).build())

/**
 * Removes the specified tags from the specified OpenID Connect (OIDC)-compatible identity provider in IAM. For more information about OIDC providers, see [About web identity federation](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc.html). For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
 */
public suspend inline fun IamClient.untagOpenIdConnectProvider(crossinline block: UntagOpenIdConnectProviderRequest.Builder.() -> Unit): UntagOpenIdConnectProviderResponse = untagOpenIdConnectProvider(UntagOpenIdConnectProviderRequest.Builder().apply(block).build())

/**
 * Removes the specified tags from the customer managed policy. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
 */
public suspend inline fun IamClient.untagPolicy(crossinline block: UntagPolicyRequest.Builder.() -> Unit): UntagPolicyResponse = untagPolicy(UntagPolicyRequest.Builder().apply(block).build())

/**
 * Removes the specified tags from the role. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.UntagRole.sample
 */
public suspend inline fun IamClient.untagRole(crossinline block: UntagRoleRequest.Builder.() -> Unit): UntagRoleResponse = untagRole(UntagRoleRequest.Builder().apply(block).build())

/**
 * Removes the specified tags from the specified Security Assertion Markup Language (SAML) identity provider in IAM. For more information about these providers, see [About web identity federation](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc.html). For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
 */
public suspend inline fun IamClient.untagSamlProvider(crossinline block: UntagSamlProviderRequest.Builder.() -> Unit): UntagSamlProviderResponse = untagSamlProvider(UntagSamlProviderRequest.Builder().apply(block).build())

/**
 * Removes the specified tags from the IAM server certificate. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
 *
 * For certificates in a Region supported by Certificate Manager (ACM), we recommend that you don't use IAM server certificates. Instead, use ACM to provision, manage, and deploy your server certificates. For more information about IAM server certificates, [Working with server certificates](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html) in the *IAM User Guide*.
 */
public suspend inline fun IamClient.untagServerCertificate(crossinline block: UntagServerCertificateRequest.Builder.() -> Unit): UntagServerCertificateResponse = untagServerCertificate(UntagServerCertificateRequest.Builder().apply(block).build())

/**
 * Removes the specified tags from the user. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.UntagUser.sample
 */
public suspend inline fun IamClient.untagUser(crossinline block: UntagUserRequest.Builder.() -> Unit): UntagUserResponse = untagUser(UntagUserRequest.Builder().apply(block).build())

/**
 * Changes the status of the specified access key from Active to Inactive, or vice versa. This operation can be used to disable a user's key as part of a key rotation workflow.
 *
 * If the `UserName` is not specified, the user name is determined implicitly based on the Amazon Web Services access key ID used to sign the request. If a temporary access key is used, then `UserName` is required. If a long-term key is assigned to the user, then `UserName` is not required. This operation works for access keys under the Amazon Web Services account. Consequently, you can use this operation to manage Amazon Web Services account root user credentials even if the Amazon Web Services account has no associated users.
 *
 * For information about rotating keys, see [Managing keys and certificates](https://docs.aws.amazon.com/IAM/latest/UserGuide/ManagingCredentials.html) in the *IAM User Guide*.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.UpdateAccessKey.sample
 */
public suspend inline fun IamClient.updateAccessKey(crossinline block: UpdateAccessKeyRequest.Builder.() -> Unit): UpdateAccessKeyResponse = updateAccessKey(UpdateAccessKeyRequest.Builder().apply(block).build())

/**
 * Updates the password policy settings for the Amazon Web Services account.
 *
 * This operation does not support partial updates. No parameters are required, but if you do not specify a parameter, that parameter's value reverts to its default value. See the **Request Parameters** section for each parameter's default value. Also note that some parameters do not allow the default parameter to be explicitly set. Instead, to invoke the default value, do not include that parameter when you invoke the operation.
 *
 *  For more information about using a password policy, see [Managing an IAM password policy](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingPasswordPolicies.html) in the *IAM User Guide*.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.UpdateAccountPasswordPolicy.sample
 */
public suspend inline fun IamClient.updateAccountPasswordPolicy(crossinline block: UpdateAccountPasswordPolicyRequest.Builder.() -> Unit): UpdateAccountPasswordPolicyResponse = updateAccountPasswordPolicy(UpdateAccountPasswordPolicyRequest.Builder().apply(block).build())

/**
 * Updates the policy that grants an IAM entity permission to assume a role. This is typically referred to as the "role trust policy". For more information about roles, see [Using roles to delegate permissions and federate identities](https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html).
 *
 * @sample aws.sdk.kotlin.services.iam.samples.UpdateAssumeRolePolicy.sample
 */
public suspend inline fun IamClient.updateAssumeRolePolicy(crossinline block: UpdateAssumeRolePolicyRequest.Builder.() -> Unit): UpdateAssumeRolePolicyResponse = updateAssumeRolePolicy(UpdateAssumeRolePolicyRequest.Builder().apply(block).build())

/**
 * Updates the name and/or the path of the specified IAM group.
 *
 *  You should understand the implications of changing a group's path or name. For more information, see [Renaming users and groups](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_WorkingWithGroupsAndUsers.html) in the *IAM User Guide*.
 *
 * The person making the request (the principal), must have permission to change the role group with the old name and the new name. For example, to change the group named `Managers` to `MGRs`, the principal must have a policy that allows them to update both groups. If the principal has permission to update the `Managers` group, but not the `MGRs` group, then the update fails. For more information about permissions, see [Access management](https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html).
 *
 * @sample aws.sdk.kotlin.services.iam.samples.UpdateGroup.sample
 */
public suspend inline fun IamClient.updateGroup(crossinline block: UpdateGroupRequest.Builder.() -> Unit): UpdateGroupResponse = updateGroup(UpdateGroupRequest.Builder().apply(block).build())

/**
 * Changes the password for the specified IAM user. You can use the CLI, the Amazon Web Services API, or the **Users** page in the IAM console to change the password for any IAM user. Use ChangePassword to change your own password in the **My Security Credentials** page in the Amazon Web Services Management Console.
 *
 * For more information about modifying passwords, see [Managing passwords](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html) in the *IAM User Guide*.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.UpdateLoginProfile.sample
 */
public suspend inline fun IamClient.updateLoginProfile(crossinline block: UpdateLoginProfileRequest.Builder.() -> Unit): UpdateLoginProfileResponse = updateLoginProfile(UpdateLoginProfileRequest.Builder().apply(block).build())

/**
 * Replaces the existing list of server certificate thumbprints associated with an OpenID Connect (OIDC) provider resource object with a new list of thumbprints.
 *
 * The list that you pass with this operation completely replaces the existing list of thumbprints. (The lists are not merged.)
 *
 * Typically, you need to update a thumbprint only when the identity provider certificate changes, which occurs rarely. However, if the provider's certificate *does* change, any attempt to assume an IAM role that specifies the OIDC provider as a principal fails until the certificate thumbprint is updated.
 *
 * Amazon Web Services secures communication with some OIDC identity providers (IdPs) through our library of trusted root certificate authorities (CAs) instead of using a certificate thumbprint to verify your IdP server certificate. In these cases, your legacy thumbprint remains in your configuration, but is no longer used for validation. These OIDC IdPs include Auth0, GitHub, GitLab, Google, and those that use an Amazon S3 bucket to host a JSON Web Key Set (JWKS) endpoint.
 *
 * Trust for the OIDC provider is derived from the provider certificate and is validated by the thumbprint. Therefore, it is best to limit access to the `UpdateOpenIDConnectProviderThumbprint` operation to highly privileged users.
 */
public suspend inline fun IamClient.updateOpenIdConnectProviderThumbprint(crossinline block: UpdateOpenIdConnectProviderThumbprintRequest.Builder.() -> Unit): UpdateOpenIdConnectProviderThumbprintResponse = updateOpenIdConnectProviderThumbprint(UpdateOpenIdConnectProviderThumbprintRequest.Builder().apply(block).build())

/**
 * Updates the description or maximum session duration setting of a role.
 */
public suspend inline fun IamClient.updateRole(crossinline block: UpdateRoleRequest.Builder.() -> Unit): UpdateRoleResponse = updateRole(UpdateRoleRequest.Builder().apply(block).build())

/**
 * Use UpdateRole instead.
 *
 * Modifies only the description of a role. This operation performs the same function as the `Description` parameter in the `UpdateRole` operation.
 */
public suspend inline fun IamClient.updateRoleDescription(crossinline block: UpdateRoleDescriptionRequest.Builder.() -> Unit): UpdateRoleDescriptionResponse = updateRoleDescription(UpdateRoleDescriptionRequest.Builder().apply(block).build())

/**
 * Updates the metadata document for an existing SAML provider resource object.
 *
 * This operation requires [Signature Version 4](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
 */
public suspend inline fun IamClient.updateSamlProvider(crossinline block: UpdateSamlProviderRequest.Builder.() -> Unit): UpdateSamlProviderResponse = updateSamlProvider(UpdateSamlProviderRequest.Builder().apply(block).build())

/**
 * Updates the name and/or the path of the specified server certificate stored in IAM.
 *
 * For more information about working with server certificates, see [Working with server certificates](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html) in the *IAM User Guide*. This topic also includes a list of Amazon Web Services services that can use the server certificates that you manage with IAM.
 *
 * You should understand the implications of changing a server certificate's path or name. For more information, see [Renaming a server certificate](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs_manage.html#RenamingServerCerts) in the *IAM User Guide*.
 *
 * The person making the request (the principal), must have permission to change the server certificate with the old name and the new name. For example, to change the certificate named `ProductionCert` to `ProdCert`, the principal must have a policy that allows them to update both certificates. If the principal has permission to update the `ProductionCert` group, but not the `ProdCert` certificate, then the update fails. For more information about permissions, see [Access management](https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html) in the *IAM User Guide*.
 */
public suspend inline fun IamClient.updateServerCertificate(crossinline block: UpdateServerCertificateRequest.Builder.() -> Unit): UpdateServerCertificateResponse = updateServerCertificate(UpdateServerCertificateRequest.Builder().apply(block).build())

/**
 * Sets the status of a service-specific credential to `Active` or `Inactive`. Service-specific credentials that are inactive cannot be used for authentication to the service. This operation can be used to disable a user's service-specific credential as part of a credential rotation work flow.
 */
public suspend inline fun IamClient.updateServiceSpecificCredential(crossinline block: UpdateServiceSpecificCredentialRequest.Builder.() -> Unit): UpdateServiceSpecificCredentialResponse = updateServiceSpecificCredential(UpdateServiceSpecificCredentialRequest.Builder().apply(block).build())

/**
 * Changes the status of the specified user signing certificate from active to disabled, or vice versa. This operation can be used to disable an IAM user's signing certificate as part of a certificate rotation work flow.
 *
 * If the `UserName` field is not specified, the user name is determined implicitly based on the Amazon Web Services access key ID used to sign the request. This operation works for access keys under the Amazon Web Services account. Consequently, you can use this operation to manage Amazon Web Services account root user credentials even if the Amazon Web Services account has no associated users.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.UpdateSigningCertificate.sample
 */
public suspend inline fun IamClient.updateSigningCertificate(crossinline block: UpdateSigningCertificateRequest.Builder.() -> Unit): UpdateSigningCertificateResponse = updateSigningCertificate(UpdateSigningCertificateRequest.Builder().apply(block).build())

/**
 * Sets the status of an IAM user's SSH public key to active or inactive. SSH public keys that are inactive cannot be used for authentication. This operation can be used to disable a user's SSH public key as part of a key rotation work flow.
 *
 * The SSH public key affected by this operation is used only for authenticating the associated IAM user to an CodeCommit repository. For more information about using SSH keys to authenticate to an CodeCommit repository, see [Set up CodeCommit for SSH connections](https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html) in the *CodeCommit User Guide*.
 */
public suspend inline fun IamClient.updateSshPublicKey(crossinline block: UpdateSshPublicKeyRequest.Builder.() -> Unit): UpdateSshPublicKeyResponse = updateSshPublicKey(UpdateSshPublicKeyRequest.Builder().apply(block).build())

/**
 * Updates the name and/or the path of the specified IAM user.
 *
 *  You should understand the implications of changing an IAM user's path or name. For more information, see [Renaming an IAM user](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users_manage.html#id_users_renaming) and [Renaming an IAM group](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_groups_manage_rename.html) in the *IAM User Guide*.
 *
 *  To change a user name, the requester must have appropriate permissions on both the source object and the target object. For example, to change Bob to Robert, the entity making the request must have permission on Bob and Robert, or must have permission on all (*). For more information about permissions, see [Permissions and policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/PermissionsAndPolicies.html).
 *
 * @sample aws.sdk.kotlin.services.iam.samples.UpdateUser.sample
 */
public suspend inline fun IamClient.updateUser(crossinline block: UpdateUserRequest.Builder.() -> Unit): UpdateUserResponse = updateUser(UpdateUserRequest.Builder().apply(block).build())

/**
 * Uploads a server certificate entity for the Amazon Web Services account. The server certificate entity includes a public key certificate, a private key, and an optional certificate chain, which should all be PEM-encoded.
 *
 * We recommend that you use [Certificate Manager](https://docs.aws.amazon.com/acm/) to provision, manage, and deploy your server certificates. With ACM you can request a certificate, deploy it to Amazon Web Services resources, and let ACM handle certificate renewals for you. Certificates provided by ACM are free. For more information about using ACM, see the [Certificate Manager User Guide](https://docs.aws.amazon.com/acm/latest/userguide/).
 *
 * For more information about working with server certificates, see [Working with server certificates](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html) in the *IAM User Guide*. This topic includes a list of Amazon Web Services services that can use the server certificates that you manage with IAM.
 *
 * For information about the number of server certificates you can upload, see [IAM and STS quotas](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html) in the *IAM User Guide*.
 *
 * Because the body of the public key certificate, private key, and the certificate chain can be large, you should use POST rather than GET when calling `UploadServerCertificate`. For information about setting up signatures and authorization through the API, see [Signing Amazon Web Services API requests](https://docs.aws.amazon.com/general/latest/gr/signing_aws_api_requests.html) in the *Amazon Web Services General Reference*. For general information about using the Query API with IAM, see [Calling the API by making HTTP query requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/programming.html) in the *IAM User Guide*.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.UploadServerCertificate.sample
 */
public suspend inline fun IamClient.uploadServerCertificate(crossinline block: UploadServerCertificateRequest.Builder.() -> Unit): UploadServerCertificateResponse = uploadServerCertificate(UploadServerCertificateRequest.Builder().apply(block).build())

/**
 * Uploads an X.509 signing certificate and associates it with the specified IAM user. Some Amazon Web Services services require you to use certificates to validate requests that are signed with a corresponding private key. When you upload the certificate, its default status is `Active`.
 *
 * For information about when you would use an X.509 signing certificate, see [Managing server certificates in IAM](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html) in the *IAM User Guide*.
 *
 * If the `UserName` is not specified, the IAM user name is determined implicitly based on the Amazon Web Services access key ID used to sign the request. This operation works for access keys under the Amazon Web Services account. Consequently, you can use this operation to manage Amazon Web Services account root user credentials even if the Amazon Web Services account has no associated users.
 *
 * Because the body of an X.509 certificate can be large, you should use POST rather than GET when calling `UploadSigningCertificate`. For information about setting up signatures and authorization through the API, see [Signing Amazon Web Services API requests](https://docs.aws.amazon.com/general/latest/gr/signing_aws_api_requests.html) in the *Amazon Web Services General Reference*. For general information about using the Query API with IAM, see [Making query requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html) in the *IAM User Guide*.
 *
 * @sample aws.sdk.kotlin.services.iam.samples.UploadSigningCertificate.sample
 */
public suspend inline fun IamClient.uploadSigningCertificate(crossinline block: UploadSigningCertificateRequest.Builder.() -> Unit): UploadSigningCertificateResponse = uploadSigningCertificate(UploadSigningCertificateRequest.Builder().apply(block).build())

/**
 * Uploads an SSH public key and associates it with the specified IAM user.
 *
 * The SSH public key uploaded by this operation can be used only for authenticating the associated IAM user to an CodeCommit repository. For more information about using SSH keys to authenticate to an CodeCommit repository, see [Set up CodeCommit for SSH connections](https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html) in the *CodeCommit User Guide*.
 */
public suspend inline fun IamClient.uploadSshPublicKey(crossinline block: UploadSshPublicKeyRequest.Builder.() -> Unit): UploadSshPublicKeyResponse = uploadSshPublicKey(UploadSshPublicKeyRequest.Builder().apply(block).build())
